/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.se.impl.transport;

import com.sun.corba.se.impl.oa.poa.Policies;
import com.sun.corba.se.impl.orbutil.ORBUtility;
import com.sun.corba.se.impl.transport.CorbaInboundConnectionCacheImpl;
import com.sun.corba.se.impl.transport.CorbaOutboundConnectionCacheImpl;
import com.sun.corba.se.impl.transport.SelectorImpl;
import com.sun.corba.se.pept.transport.Acceptor;
import com.sun.corba.se.pept.transport.ByteBufferPool;
import com.sun.corba.se.pept.transport.ConnectionCache;
import com.sun.corba.se.pept.transport.ContactInfo;
import com.sun.corba.se.pept.transport.InboundConnectionCache;
import com.sun.corba.se.pept.transport.OutboundConnectionCache;
import com.sun.corba.se.pept.transport.Selector;
import com.sun.corba.se.spi.ior.IORTemplate;
import com.sun.corba.se.spi.ior.ObjectAdapterId;
import com.sun.corba.se.spi.orb.ORB;
import com.sun.corba.se.spi.transport.CorbaAcceptor;
import com.sun.corba.se.spi.transport.CorbaTransportManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CorbaTransportManagerImpl
implements CorbaTransportManager {
    protected ORB orb;
    protected List acceptors;
    protected Map outboundConnectionCaches;
    protected Map inboundConnectionCaches;
    protected Selector selector;

    public CorbaTransportManagerImpl(ORB oRB) {
        this.orb = oRB;
        this.acceptors = new ArrayList();
        this.outboundConnectionCaches = new HashMap();
        this.inboundConnectionCaches = new HashMap();
        this.selector = new SelectorImpl(oRB);
    }

    @Override
    public ByteBufferPool getByteBufferPool(int n) {
        throw new RuntimeException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OutboundConnectionCache getOutboundConnectionCache(ContactInfo contactInfo) {
        ContactInfo contactInfo2 = contactInfo;
        synchronized (contactInfo2) {
            if (contactInfo.getConnectionCache() == null) {
                OutboundConnectionCache outboundConnectionCache = null;
                Map map = this.outboundConnectionCaches;
                synchronized (map) {
                    outboundConnectionCache = (OutboundConnectionCache)this.outboundConnectionCaches.get(contactInfo.getConnectionCacheType());
                    if (outboundConnectionCache == null) {
                        outboundConnectionCache = new CorbaOutboundConnectionCacheImpl(this.orb, contactInfo);
                        this.outboundConnectionCaches.put(contactInfo.getConnectionCacheType(), outboundConnectionCache);
                    }
                }
                contactInfo.setConnectionCache(outboundConnectionCache);
            }
            return contactInfo.getConnectionCache();
        }
    }

    @Override
    public Collection getOutboundConnectionCaches() {
        return this.outboundConnectionCaches.values();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InboundConnectionCache getInboundConnectionCache(Acceptor acceptor) {
        Acceptor acceptor2 = acceptor;
        synchronized (acceptor2) {
            if (acceptor.getConnectionCache() == null) {
                InboundConnectionCache inboundConnectionCache = null;
                Map map = this.inboundConnectionCaches;
                synchronized (map) {
                    inboundConnectionCache = (InboundConnectionCache)this.inboundConnectionCaches.get(acceptor.getConnectionCacheType());
                    if (inboundConnectionCache == null) {
                        inboundConnectionCache = new CorbaInboundConnectionCacheImpl(this.orb, acceptor);
                        this.inboundConnectionCaches.put(acceptor.getConnectionCacheType(), inboundConnectionCache);
                    }
                }
                acceptor.setConnectionCache(inboundConnectionCache);
            }
            return acceptor.getConnectionCache();
        }
    }

    @Override
    public Collection getInboundConnectionCaches() {
        return this.inboundConnectionCaches.values();
    }

    @Override
    public Selector getSelector(int n) {
        return this.selector;
    }

    @Override
    public synchronized void registerAcceptor(Acceptor acceptor) {
        if (this.orb.transportDebugFlag) {
            this.dprint(".registerAcceptor->: " + acceptor);
        }
        this.acceptors.add(acceptor);
        if (this.orb.transportDebugFlag) {
            this.dprint(".registerAcceptor<-: " + acceptor);
        }
    }

    @Override
    public Collection getAcceptors() {
        return this.getAcceptors(null, null);
    }

    @Override
    public synchronized void unregisterAcceptor(Acceptor acceptor) {
        this.acceptors.remove(acceptor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        try {
            if (this.orb.transportDebugFlag) {
                this.dprint(".close->");
            }
            for (Object v : this.outboundConnectionCaches.values()) {
                ((ConnectionCache)v).close();
            }
            for (Object v : this.inboundConnectionCaches.values()) {
                ((ConnectionCache)v).close();
                this.unregisterAcceptor(((InboundConnectionCache)v).getAcceptor());
            }
            this.getSelector(0).close();
        }
        finally {
            if (this.orb.transportDebugFlag) {
                this.dprint(".close<-");
            }
        }
    }

    @Override
    public Collection getAcceptors(String string, ObjectAdapterId objectAdapterId) {
        for (Acceptor acceptor : this.acceptors) {
            if (!acceptor.initialize() || !acceptor.shouldRegisterAcceptEvent()) continue;
            this.orb.getTransportManager().getSelector(0).registerForEvent(acceptor.getEventHandler());
        }
        return this.acceptors;
    }

    @Override
    public void addToIORTemplate(IORTemplate iORTemplate, Policies policies, String string, String string2, ObjectAdapterId objectAdapterId) {
        for (CorbaAcceptor corbaAcceptor : this.getAcceptors(string2, objectAdapterId)) {
            corbaAcceptor.addToIORTemplate(iORTemplate, policies, string);
        }
    }

    protected void dprint(String string) {
        ORBUtility.dprint("CorbaTransportManagerImpl", string);
    }
}

