/*
 * Decompiled with CFR 0.152.
 */
package sun.font;

import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.util.concurrent.ConcurrentHashMap;
import sun.font.CharToGlyphMapper;
import sun.font.FileFont;
import sun.font.FontScaler;
import sun.font.FontStrikeDesc;
import sun.font.FontStrikeDisposer;
import sun.font.FontUtilities;
import sun.font.NativeStrike;
import sun.font.NullFontScaler;
import sun.font.PhysicalStrike;
import sun.font.StrikeCache;
import sun.font.StrikeMetrics;
import sun.font.SunFontManager;
import sun.font.TrueTypeFont;

public class FileFontStrike
extends PhysicalStrike {
    static final int INVISIBLE_GLYPHS = 65534;
    private FileFont fileFont;
    private static final int UNINITIALISED = 0;
    private static final int INTARRAY = 1;
    private static final int LONGARRAY = 2;
    private static final int SEGINTARRAY = 3;
    private static final int SEGLONGARRAY = 4;
    private volatile int glyphCacheFormat = 0;
    private static final int SEGSHIFT = 5;
    private static final int SEGSIZE = 32;
    private boolean segmentedCache;
    private int[][] segIntGlyphImages;
    private long[][] segLongGlyphImages;
    private float[] horizontalAdvances;
    private float[][] segHorizontalAdvances;
    ConcurrentHashMap<Integer, Rectangle2D.Float> boundsMap;
    SoftReference<ConcurrentHashMap<Integer, Point2D.Float>> glyphMetricsMapRef;
    AffineTransform invertDevTx;
    boolean useNatives;
    NativeStrike[] nativeStrikes;
    private int intPtSize;
    private static boolean isXPorLater = false;
    private static final int SLOTZEROMAX = 0xFFFFFF;
    private WeakReference<ConcurrentHashMap<Integer, GeneralPath>> outlineMapRef;

    private static native boolean initNative();

    FileFontStrike(FileFont fileFont, FontStrikeDesc fontStrikeDesc) {
        super(fileFont, fontStrikeDesc);
        this.fileFont = fileFont;
        if (fontStrikeDesc.style != fileFont.style) {
            if ((fontStrikeDesc.style & 2) == 2 && (fileFont.style & 2) == 0) {
                this.algoStyle = true;
                this.italic = 0.7f;
            }
            if ((fontStrikeDesc.style & 1) == 1 && (fileFont.style & 1) == 0) {
                this.algoStyle = true;
                this.boldness = 1.33f;
            }
        }
        double[] dArray = new double[4];
        AffineTransform affineTransform = fontStrikeDesc.glyphTx;
        affineTransform.getMatrix(dArray);
        if (!fontStrikeDesc.devTx.isIdentity() && fontStrikeDesc.devTx.getType() != 1) {
            try {
                this.invertDevTx = fontStrikeDesc.devTx.createInverse();
            }
            catch (NoninvertibleTransformException noninvertibleTransformException) {
                // empty catch block
            }
        }
        boolean bl = fontStrikeDesc.aaHint != 1 && fileFont.familyName.startsWith("Amble");
        this.pScalerContext = Double.isNaN(dArray[0]) || Double.isNaN(dArray[1]) || Double.isNaN(dArray[2]) || Double.isNaN(dArray[3]) || fileFont.getScaler() == null ? NullFontScaler.getNullScalerContext() : fileFont.getScaler().createScalerContext(dArray, fontStrikeDesc.aaHint, fontStrikeDesc.fmHint, this.boldness, this.italic, bl);
        this.mapper = fileFont.getMapper();
        int n = this.mapper.getNumGlyphs();
        float f = (float)dArray[3];
        int n2 = this.intPtSize = (int)f;
        boolean bl2 = (affineTransform.getType() & 0x7C) == 0;
        boolean bl3 = this.segmentedCache = n > 256 || n > 64 && (!bl2 || f != (float)n2 || n2 < 6 || n2 > 36);
        if (this.pScalerContext == 0L) {
            this.disposer = new FontStrikeDisposer(fileFont, fontStrikeDesc);
            this.initGlyphCache();
            this.pScalerContext = NullFontScaler.getNullScalerContext();
            SunFontManager.getInstance().deRegisterBadFont(fileFont);
            return;
        }
        if (FontUtilities.isWindows && isXPorLater && !FontUtilities.useT2K && !GraphicsEnvironment.isHeadless() && !fileFont.useJavaRasterizer && (fontStrikeDesc.aaHint == 4 || fontStrikeDesc.aaHint == 5) && dArray[1] == 0.0 && dArray[2] == 0.0 && dArray[0] == dArray[3] && dArray[0] >= 3.0 && dArray[0] <= 100.0 && !((TrueTypeFont)fileFont).useEmbeddedBitmapsForSize(this.intPtSize)) {
            this.useNatives = true;
        } else if (fileFont.checkUseNatives() && fontStrikeDesc.aaHint == 0 && !this.algoStyle && dArray[1] == 0.0 && dArray[2] == 0.0 && dArray[0] >= 6.0 && dArray[0] <= 36.0 && dArray[0] == dArray[3]) {
            this.useNatives = true;
            int n3 = fileFont.nativeFonts.length;
            this.nativeStrikes = new NativeStrike[n3];
            for (int i = 0; i < n3; ++i) {
                this.nativeStrikes[i] = new NativeStrike(fileFont.nativeFonts[i], fontStrikeDesc, false);
            }
        }
        if (FontUtilities.isLogging() && FontUtilities.isWindows) {
            FontUtilities.getLogger().info("Strike for " + fileFont + " at size = " + this.intPtSize + " use natives = " + this.useNatives + " useJavaRasteriser = " + fileFont.useJavaRasterizer + " AAHint = " + fontStrikeDesc.aaHint + " Has Embedded bitmaps = " + ((TrueTypeFont)fileFont).useEmbeddedBitmapsForSize(this.intPtSize));
        }
        this.disposer = new FontStrikeDisposer(fileFont, fontStrikeDesc, this.pScalerContext);
        double d = 48.0;
        boolean bl4 = this.getImageWithAdvance = Math.abs(affineTransform.getScaleX()) <= d && Math.abs(affineTransform.getScaleY()) <= d && Math.abs(affineTransform.getShearX()) <= d && Math.abs(affineTransform.getShearY()) <= d;
        if (!this.getImageWithAdvance) {
            if (!this.segmentedCache) {
                this.horizontalAdvances = new float[n];
                for (int i = 0; i < n; ++i) {
                    this.horizontalAdvances[i] = Float.MAX_VALUE;
                }
            } else {
                int n4 = (n + 32 - 1) / 32;
                this.segHorizontalAdvances = new float[n4][];
            }
        }
    }

    @Override
    public int getNumGlyphs() {
        return this.fileFont.getNumGlyphs();
    }

    long getGlyphImageFromNative(int n) {
        if (FontUtilities.isWindows) {
            return this.getGlyphImageFromWindows(n);
        }
        return this.getGlyphImageFromX11(n);
    }

    private native long _getGlyphImageFromWindows(String var1, int var2, int var3, int var4, boolean var5);

    long getGlyphImageFromWindows(int n) {
        int n2;
        int n3;
        String string = this.fileFont.getFamilyName(null);
        long l = this._getGlyphImageFromWindows(string, n3 = this.desc.style & 1 | this.desc.style & 2 | this.fileFont.getStyle(), n2 = this.intPtSize, n, this.desc.fmHint == 2);
        if (l != 0L) {
            float f = this.getGlyphAdvance(n, false);
            StrikeCache.unsafe.putFloat(l + (long)StrikeCache.xAdvanceOffset, f);
            return l;
        }
        return this.fileFont.getGlyphImage(this.pScalerContext, n);
    }

    long getGlyphImageFromX11(int n) {
        char c = this.fileFont.glyphToCharMap[n];
        for (int i = 0; i < this.nativeStrikes.length; ++i) {
            long l;
            CharToGlyphMapper charToGlyphMapper = this.fileFont.nativeFonts[i].getMapper();
            int n2 = charToGlyphMapper.charToGlyph(c) & 0xFFFF;
            if (n2 == charToGlyphMapper.getMissingGlyphCode() || (l = this.nativeStrikes[i].getGlyphImagePtrNoCache(n2)) == 0L) continue;
            return l;
        }
        return this.fileFont.getGlyphImage(this.pScalerContext, n);
    }

    @Override
    long getGlyphImagePtr(int n) {
        if (n >= 65534) {
            return StrikeCache.invisibleGlyphPtr;
        }
        long l = 0L;
        l = this.getCachedGlyphPtr(n);
        if (l != 0L) {
            return l;
        }
        if (this.useNatives && (l = this.getGlyphImageFromNative(n)) == 0L && FontUtilities.isLogging()) {
            FontUtilities.getLogger().info("Strike for " + this.fileFont + " at size = " + this.intPtSize + " couldn't get native glyph for code = " + n);
        }
        if (l == 0L) {
            l = this.fileFont.getGlyphImage(this.pScalerContext, n);
        }
        return this.setCachedGlyphPtr(n, l);
    }

    @Override
    void getGlyphImagePtrs(int[] nArray, long[] lArray, int n) {
        for (int i = 0; i < n; ++i) {
            int n2 = nArray[i];
            if (n2 >= 65534) {
                lArray[i] = StrikeCache.invisibleGlyphPtr;
                continue;
            }
            lArray[i] = this.getCachedGlyphPtr(n2);
            if (lArray[i] != 0L) continue;
            long l = 0L;
            if (this.useNatives) {
                l = this.getGlyphImageFromNative(n2);
            }
            if (l == 0L) {
                l = this.fileFont.getGlyphImage(this.pScalerContext, n2);
            }
            lArray[i] = this.setCachedGlyphPtr(n2, l);
        }
    }

    @Override
    int getSlot0GlyphImagePtrs(int[] nArray, long[] lArray, int n) {
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            int n3 = nArray[i];
            if (n3 >= 0xFFFFFF) {
                return n2;
            }
            ++n2;
            if (n3 >= 65534) {
                lArray[i] = StrikeCache.invisibleGlyphPtr;
                continue;
            }
            lArray[i] = this.getCachedGlyphPtr(n3);
            if (lArray[i] != 0L) continue;
            long l = 0L;
            if (this.useNatives) {
                l = this.getGlyphImageFromNative(n3);
            }
            if (l == 0L) {
                l = this.fileFont.getGlyphImage(this.pScalerContext, n3);
            }
            lArray[i] = this.setCachedGlyphPtr(n3, l);
        }
        return n2;
    }

    long getCachedGlyphPtr(int n) {
        try {
            return this.getCachedGlyphPtrInternal(n);
        }
        catch (Exception exception) {
            NullFontScaler nullFontScaler = (NullFontScaler)FontScaler.getNullScaler();
            long l = NullFontScaler.getNullScalerContext();
            return nullFontScaler.getGlyphImage(l, n);
        }
    }

    private long getCachedGlyphPtrInternal(int n) {
        switch (this.glyphCacheFormat) {
            case 1: {
                return (long)this.intGlyphImages[n] & 0xFFFFFFFFL;
            }
            case 3: {
                int n2 = n >> 5;
                if (this.segIntGlyphImages[n2] != null) {
                    int n3 = n % 32;
                    return (long)this.segIntGlyphImages[n2][n3] & 0xFFFFFFFFL;
                }
                return 0L;
            }
            case 2: {
                return this.longGlyphImages[n];
            }
            case 4: {
                int n4 = n >> 5;
                if (this.segLongGlyphImages[n4] != null) {
                    int n5 = n % 32;
                    return this.segLongGlyphImages[n4][n5];
                }
                return 0L;
            }
        }
        return 0L;
    }

    private synchronized long setCachedGlyphPtr(int n, long l) {
        try {
            return this.setCachedGlyphPtrInternal(n, l);
        }
        catch (Exception exception) {
            switch (this.glyphCacheFormat) {
                case 1: 
                case 3: {
                    StrikeCache.freeIntPointer((int)l);
                    break;
                }
                case 2: 
                case 4: {
                    StrikeCache.freeLongPointer(l);
                }
            }
            NullFontScaler nullFontScaler = (NullFontScaler)FontScaler.getNullScaler();
            long l2 = NullFontScaler.getNullScalerContext();
            return nullFontScaler.getGlyphImage(l2, n);
        }
    }

    private long setCachedGlyphPtrInternal(int n, long l) {
        switch (this.glyphCacheFormat) {
            case 1: {
                if (this.intGlyphImages[n] == 0) {
                    this.intGlyphImages[n] = (int)l;
                    return l;
                }
                StrikeCache.freeIntPointer((int)l);
                return (long)this.intGlyphImages[n] & 0xFFFFFFFFL;
            }
            case 3: {
                int n2 = n >> 5;
                int n3 = n % 32;
                if (this.segIntGlyphImages[n2] == null) {
                    this.segIntGlyphImages[n2] = new int[32];
                }
                if (this.segIntGlyphImages[n2][n3] == 0) {
                    this.segIntGlyphImages[n2][n3] = (int)l;
                    return l;
                }
                StrikeCache.freeIntPointer((int)l);
                return (long)this.segIntGlyphImages[n2][n3] & 0xFFFFFFFFL;
            }
            case 2: {
                if (this.longGlyphImages[n] == 0L) {
                    this.longGlyphImages[n] = l;
                    return l;
                }
                StrikeCache.freeLongPointer(l);
                return this.longGlyphImages[n];
            }
            case 4: {
                int n4 = n >> 5;
                int n5 = n % 32;
                if (this.segLongGlyphImages[n4] == null) {
                    this.segLongGlyphImages[n4] = new long[32];
                }
                if (this.segLongGlyphImages[n4][n5] == 0L) {
                    this.segLongGlyphImages[n4][n5] = l;
                    return l;
                }
                StrikeCache.freeLongPointer(l);
                return this.segLongGlyphImages[n4][n5];
            }
        }
        this.initGlyphCache();
        return this.setCachedGlyphPtr(n, l);
    }

    private synchronized void initGlyphCache() {
        int n = this.mapper.getNumGlyphs();
        int n2 = 0;
        if (this.segmentedCache) {
            int n3 = (n + 32 - 1) / 32;
            if (longAddresses) {
                n2 = 4;
                this.segLongGlyphImages = new long[n3][];
                this.disposer.segLongGlyphImages = this.segLongGlyphImages;
            } else {
                n2 = 3;
                this.segIntGlyphImages = new int[n3][];
                this.disposer.segIntGlyphImages = this.segIntGlyphImages;
            }
        } else if (longAddresses) {
            n2 = 2;
            this.longGlyphImages = new long[n];
            this.disposer.longGlyphImages = this.longGlyphImages;
        } else {
            n2 = 1;
            this.intGlyphImages = new int[n];
            this.disposer.intGlyphImages = this.intGlyphImages;
        }
        this.glyphCacheFormat = n2;
    }

    @Override
    float getGlyphAdvance(int n) {
        return this.getGlyphAdvance(n, true);
    }

    private float getGlyphAdvance(int n, boolean bl) {
        int n2;
        float[] fArray;
        float f;
        if (n >= 65534) {
            return 0.0f;
        }
        if (this.horizontalAdvances != null) {
            f = this.horizontalAdvances[n];
            if (f != Float.MAX_VALUE) {
                if (!bl && this.invertDevTx != null) {
                    Point2D.Float float_ = new Point2D.Float(f, 0.0f);
                    this.desc.devTx.deltaTransform(float_, float_);
                    return float_.x;
                }
                return f;
            }
        } else if (this.segmentedCache && this.segHorizontalAdvances != null && (fArray = this.segHorizontalAdvances[n2 = n >> 5]) != null && (f = fArray[n % 32]) != Float.MAX_VALUE) {
            if (!bl && this.invertDevTx != null) {
                Point2D.Float float_ = new Point2D.Float(f, 0.0f);
                this.desc.devTx.deltaTransform(float_, float_);
                return float_.x;
            }
            return f;
        }
        if (!bl && this.invertDevTx != null) {
            Point2D.Float float_ = new Point2D.Float();
            this.fileFont.getGlyphMetrics(this.pScalerContext, n, float_);
            return float_.x;
        }
        if (this.invertDevTx != null || !bl) {
            f = this.getGlyphMetrics((int)n, (boolean)bl).x;
        } else {
            long l = this.getImageWithAdvance ? this.getGlyphImagePtr(n) : this.getCachedGlyphPtr(n);
            f = l != 0L ? StrikeCache.unsafe.getFloat(l + (long)StrikeCache.xAdvanceOffset) : this.fileFont.getGlyphAdvance(this.pScalerContext, n);
        }
        if (this.horizontalAdvances != null) {
            this.horizontalAdvances[n] = f;
        } else if (this.segmentedCache && this.segHorizontalAdvances != null) {
            int n3 = n >> 5;
            int n4 = n % 32;
            if (this.segHorizontalAdvances[n3] == null) {
                this.segHorizontalAdvances[n3] = new float[32];
                for (int i = 0; i < 32; ++i) {
                    this.segHorizontalAdvances[n3][i] = Float.MAX_VALUE;
                }
            }
            this.segHorizontalAdvances[n3][n4] = f;
        }
        return f;
    }

    @Override
    float getCodePointAdvance(int n) {
        return this.getGlyphAdvance(this.mapper.charToGlyph(n));
    }

    @Override
    void getGlyphImageBounds(int n, Point2D.Float float_, Rectangle rectangle) {
        int n2;
        long l = this.getGlyphImagePtr(n);
        if (l == 0L) {
            rectangle.x = (int)Math.floor(float_.x);
            rectangle.y = (int)Math.floor(float_.y);
            rectangle.height = 0;
            rectangle.width = 0;
            return;
        }
        float f = StrikeCache.unsafe.getFloat(l + (long)StrikeCache.topLeftXOffset);
        float f2 = StrikeCache.unsafe.getFloat(l + (long)StrikeCache.topLeftYOffset);
        rectangle.x = (int)Math.floor(float_.x + f);
        rectangle.y = (int)Math.floor(float_.y + f2);
        rectangle.width = StrikeCache.unsafe.getShort(l + (long)StrikeCache.widthOffset) & 0xFFFF;
        rectangle.height = StrikeCache.unsafe.getShort(l + (long)StrikeCache.heightOffset) & 0xFFFF;
        if ((this.desc.aaHint == 4 || this.desc.aaHint == 5) && f <= -2.0f && (n2 = this.getGlyphImageMinX(l, rectangle.x)) > rectangle.x) {
            ++rectangle.x;
            --rectangle.width;
        }
    }

    private int getGlyphImageMinX(long l, int n) {
        char c = StrikeCache.unsafe.getChar(l + (long)StrikeCache.widthOffset);
        int n2 = StrikeCache.unsafe.getChar(l + (long)StrikeCache.heightOffset);
        char c2 = StrikeCache.unsafe.getChar(l + (long)StrikeCache.rowBytesOffset);
        if (c2 == c) {
            return n;
        }
        long l2 = StrikeCache.unsafe.getAddress(l + (long)StrikeCache.pixelDataOffset);
        if (l2 == 0L) {
            return n;
        }
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < 3; ++j) {
                if (StrikeCache.unsafe.getByte(l2 + (long)(i * c2) + (long)j) == 0) continue;
                return n;
            }
        }
        return n + 1;
    }

    @Override
    StrikeMetrics getFontMetrics() {
        if (this.strikeMetrics == null) {
            this.strikeMetrics = this.fileFont.getFontMetrics(this.pScalerContext);
            if (this.invertDevTx != null) {
                this.strikeMetrics.convertToUserSpace(this.invertDevTx);
            }
        }
        return this.strikeMetrics;
    }

    @Override
    Point2D.Float getGlyphMetrics(int n) {
        return this.getGlyphMetrics(n, true);
    }

    private Point2D.Float getGlyphMetrics(int n, boolean bl) {
        Point2D.Float float_ = new Point2D.Float();
        if (n >= 65534) {
            return float_;
        }
        long l = this.getImageWithAdvance && bl ? this.getGlyphImagePtr(n) : this.getCachedGlyphPtr(n);
        if (l != 0L) {
            float_ = new Point2D.Float();
            float_.x = StrikeCache.unsafe.getFloat(l + (long)StrikeCache.xAdvanceOffset);
            float_.y = StrikeCache.unsafe.getFloat(l + (long)StrikeCache.yAdvanceOffset);
            if (this.invertDevTx != null) {
                this.invertDevTx.deltaTransform(float_, float_);
            }
        } else {
            Integer n2 = n;
            Point2D.Float float_2 = null;
            ConcurrentHashMap<Integer, Point2D.Float> concurrentHashMap = null;
            if (this.glyphMetricsMapRef != null) {
                concurrentHashMap = this.glyphMetricsMapRef.get();
            }
            if (concurrentHashMap != null && (float_2 = concurrentHashMap.get(n2)) != null) {
                float_.x = float_2.x;
                float_.y = float_2.y;
                return float_;
            }
            if (float_2 == null) {
                this.fileFont.getGlyphMetrics(this.pScalerContext, n, float_);
                if (this.invertDevTx != null) {
                    this.invertDevTx.deltaTransform(float_, float_);
                }
                float_2 = new Point2D.Float(float_.x, float_.y);
                if (concurrentHashMap == null) {
                    concurrentHashMap = new ConcurrentHashMap();
                    this.glyphMetricsMapRef = new SoftReference<ConcurrentHashMap<Integer, Point2D.Float>>(concurrentHashMap);
                }
                concurrentHashMap.put(n2, float_2);
            }
        }
        return float_;
    }

    @Override
    Point2D.Float getCharMetrics(char c) {
        return this.getGlyphMetrics(this.mapper.charToGlyph(c));
    }

    @Override
    Rectangle2D.Float getGlyphOutlineBounds(int n) {
        Integer n2;
        Rectangle2D.Float float_;
        if (this.boundsMap == null) {
            this.boundsMap = new ConcurrentHashMap();
        }
        if ((float_ = this.boundsMap.get(n2 = Integer.valueOf(n))) == null) {
            float_ = this.fileFont.getGlyphOutlineBounds(this.pScalerContext, n);
            this.boundsMap.put(n2, float_);
        }
        return float_;
    }

    public Rectangle2D getOutlineBounds(int n) {
        return this.fileFont.getGlyphOutlineBounds(this.pScalerContext, n);
    }

    @Override
    GeneralPath getGlyphOutline(int n, float f, float f2) {
        Path2D.Float float_ = null;
        ConcurrentHashMap<Integer, Path2D.Float> concurrentHashMap = null;
        if (this.outlineMapRef != null && (concurrentHashMap = (ConcurrentHashMap<Integer, Path2D.Float>)this.outlineMapRef.get()) != null) {
            float_ = (GeneralPath)concurrentHashMap.get(n);
        }
        if (float_ == null) {
            float_ = this.fileFont.getGlyphOutline(this.pScalerContext, n, 0.0f, 0.0f);
            if (concurrentHashMap == null) {
                concurrentHashMap = new ConcurrentHashMap<Integer, Path2D.Float>();
                this.outlineMapRef = new WeakReference(concurrentHashMap);
            }
            concurrentHashMap.put(n, float_);
        }
        float_ = (GeneralPath)float_.clone();
        if (f != 0.0f || f2 != 0.0f) {
            float_.transform(AffineTransform.getTranslateInstance(f, f2));
        }
        return float_;
    }

    @Override
    GeneralPath getGlyphVectorOutline(int[] nArray, float f, float f2) {
        return this.fileFont.getGlyphVectorOutline(this.pScalerContext, nArray, nArray.length, f, f2);
    }

    @Override
    protected void adjustPoint(Point2D.Float float_) {
        if (this.invertDevTx != null) {
            this.invertDevTx.deltaTransform(float_, float_);
        }
    }

    static {
        if (FontUtilities.isWindows && !FontUtilities.useT2K && !GraphicsEnvironment.isHeadless()) {
            isXPorLater = FileFontStrike.initNative();
        }
    }
}

