/*
 * Decompiled with CFR 0.152.
 */
package sun.security.pkcs12;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.security.AlgorithmParameters;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyStoreException;
import java.security.KeyStoreSpi;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.Locale;
import javax.crypto.Cipher;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import javax.security.auth.x500.X500Principal;
import sun.security.pkcs.ContentInfo;
import sun.security.pkcs.EncryptedPrivateKeyInfo;
import sun.security.pkcs12.MacData;
import sun.security.util.Debug;
import sun.security.util.DerInputStream;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;
import sun.security.util.ObjectIdentifier;
import sun.security.x509.AlgorithmId;

public final class PKCS12KeyStore
extends KeyStoreSpi {
    public static final int VERSION_3 = 3;
    private static final Debug debug = Debug.getInstance("pkcs12");
    private static final int[] keyBag = new int[]{1, 2, 840, 113549, 1, 12, 10, 1, 2};
    private static final int[] certBag = new int[]{1, 2, 840, 113549, 1, 12, 10, 1, 3};
    private static final int[] pkcs9Name = new int[]{1, 2, 840, 113549, 1, 9, 20};
    private static final int[] pkcs9KeyId = new int[]{1, 2, 840, 113549, 1, 9, 21};
    private static final int[] pkcs9certType = new int[]{1, 2, 840, 113549, 1, 9, 22, 1};
    private static final int[] pbeWithSHAAnd40BitRC2CBC = new int[]{1, 2, 840, 113549, 1, 12, 1, 6};
    private static final int[] pbeWithSHAAnd3KeyTripleDESCBC = new int[]{1, 2, 840, 113549, 1, 12, 1, 3};
    private static ObjectIdentifier PKCS8ShroudedKeyBag_OID;
    private static ObjectIdentifier CertBag_OID;
    private static ObjectIdentifier PKCS9FriendlyName_OID;
    private static ObjectIdentifier PKCS9LocalKeyId_OID;
    private static ObjectIdentifier PKCS9CertType_OID;
    private static ObjectIdentifier pbeWithSHAAnd40BitRC2CBC_OID;
    private static ObjectIdentifier pbeWithSHAAnd3KeyTripleDESCBC_OID;
    private int counter = 0;
    private static final int iterationCount = 1024;
    private static final int SALT_LEN = 20;
    private int privateKeyCount = 0;
    private SecureRandom random;
    private Hashtable<String, KeyEntry> entries = new Hashtable();
    private ArrayList<KeyEntry> keyList = new ArrayList();
    private LinkedHashMap<X500Principal, X509Certificate> certsMap = new LinkedHashMap();
    private ArrayList<CertEntry> certEntries = new ArrayList();

    @Override
    public Key engineGetKey(String string, char[] cArray) throws NoSuchAlgorithmException, UnrecoverableKeyException {
        AlgorithmParameters algorithmParameters;
        ObjectIdentifier objectIdentifier;
        Object object;
        Object object2;
        byte[] byArray;
        Object object3;
        KeyEntry keyEntry = this.entries.get(string.toLowerCase(Locale.ENGLISH));
        PrivateKey privateKey = null;
        if (keyEntry == null) {
            return null;
        }
        byte[] byArray2 = keyEntry.protectedPrivKey;
        try {
            object3 = new EncryptedPrivateKeyInfo(byArray2);
            byArray = ((EncryptedPrivateKeyInfo)object3).getEncryptedData();
            object2 = new DerValue(((EncryptedPrivateKeyInfo)object3).getAlgorithm().encode());
            object = ((DerValue)object2).toDerInputStream();
            objectIdentifier = ((DerInputStream)object).getOID();
            algorithmParameters = this.parseAlgParameters((DerInputStream)object);
        }
        catch (IOException iOException) {
            UnrecoverableKeyException unrecoverableKeyException = new UnrecoverableKeyException("Private key not stored as PKCS#8 EncryptedPrivateKeyInfo: " + iOException);
            unrecoverableKeyException.initCause(iOException);
            throw unrecoverableKeyException;
        }
        try {
            while (true) {
                try {
                    object2 = this.getPBEKey(cArray);
                    object = Cipher.getInstance(objectIdentifier.toString());
                    ((Cipher)object).init(2, (Key)object2, algorithmParameters);
                    object3 = ((Cipher)object).doFinal(byArray);
                }
                catch (Exception exception) {
                    if (cArray.length == 0) {
                        cArray = new char[1];
                        continue;
                    }
                    throw exception;
                }
                break;
            }
            object2 = new PKCS8EncodedKeySpec((byte[])object3);
            object = new DerValue((byte[])object3);
            DerInputStream derInputStream = ((DerValue)object).toDerInputStream();
            int n = derInputStream.getInteger();
            DerValue[] derValueArray = derInputStream.getSequence(2);
            AlgorithmId algorithmId = new AlgorithmId(derValueArray[0].getOID());
            String string2 = algorithmId.getName();
            KeyFactory keyFactory = KeyFactory.getInstance(string2);
            privateKey = keyFactory.generatePrivate((KeySpec)object2);
        }
        catch (Exception exception) {
            object2 = new UnrecoverableKeyException("Get Key failed: " + exception.getMessage());
            ((Throwable)object2).initCause(exception);
            throw object2;
        }
        return privateKey;
    }

    @Override
    public Certificate[] engineGetCertificateChain(String string) {
        KeyEntry keyEntry = this.entries.get(string.toLowerCase(Locale.ENGLISH));
        if (keyEntry != null) {
            if (keyEntry.chain == null) {
                return null;
            }
            return (Certificate[])keyEntry.chain.clone();
        }
        return null;
    }

    @Override
    public Certificate engineGetCertificate(String string) {
        KeyEntry keyEntry = this.entries.get(string.toLowerCase(Locale.ENGLISH));
        if (keyEntry != null) {
            if (keyEntry.chain == null) {
                return null;
            }
            return keyEntry.chain[0];
        }
        return null;
    }

    @Override
    public Date engineGetCreationDate(String string) {
        KeyEntry keyEntry = this.entries.get(string.toLowerCase(Locale.ENGLISH));
        if (keyEntry != null) {
            return new Date(keyEntry.date.getTime());
        }
        return null;
    }

    @Override
    public synchronized void engineSetKeyEntry(String string, Key key, char[] cArray, Certificate[] certificateArray) throws KeyStoreException {
        try {
            KeyEntry keyEntry = new KeyEntry();
            keyEntry.date = new Date();
            if (key instanceof PrivateKey) {
                if (!key.getFormat().equals("PKCS#8") && !key.getFormat().equals("PKCS8")) {
                    throw new KeyStoreException("Private key is not encodedas PKCS#8");
                }
            } else {
                throw new KeyStoreException("Key is not a PrivateKey");
            }
            keyEntry.protectedPrivKey = this.encryptPrivateKey(key.getEncoded(), cArray);
            if (certificateArray != null) {
                if (certificateArray.length > 1 && !this.validateChain(certificateArray)) {
                    throw new KeyStoreException("Certificate chain is not validate");
                }
                keyEntry.chain = (Certificate[])certificateArray.clone();
            }
            keyEntry.keyId = ("Time " + keyEntry.date.getTime()).getBytes("UTF8");
            keyEntry.alias = string.toLowerCase(Locale.ENGLISH);
            this.entries.put(string.toLowerCase(Locale.ENGLISH), keyEntry);
        }
        catch (Exception exception) {
            KeyStoreException keyStoreException = new KeyStoreException("Key protection  algorithm not found: " + exception);
            keyStoreException.initCause(exception);
            throw keyStoreException;
        }
    }

    @Override
    public synchronized void engineSetKeyEntry(String string, byte[] byArray, Certificate[] certificateArray) throws KeyStoreException {
        try {
            new EncryptedPrivateKeyInfo(byArray);
        }
        catch (IOException iOException) {
            KeyStoreException keyStoreException = new KeyStoreException("Private key is not stored as PKCS#8 EncryptedPrivateKeyInfo: " + iOException);
            keyStoreException.initCause(iOException);
            throw keyStoreException;
        }
        KeyEntry keyEntry = new KeyEntry();
        keyEntry.date = new Date();
        try {
            keyEntry.keyId = ("Time " + keyEntry.date.getTime()).getBytes("UTF8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        keyEntry.alias = string.toLowerCase(Locale.ENGLISH);
        keyEntry.protectedPrivKey = (byte[])byArray.clone();
        if (certificateArray != null) {
            if (certificateArray.length > 1 && !this.validateChain(certificateArray)) {
                throw new KeyStoreException("Certificate chain is not valid");
            }
            keyEntry.chain = (Certificate[])certificateArray.clone();
        }
        this.entries.put(string.toLowerCase(Locale.ENGLISH), keyEntry);
    }

    private byte[] getSalt() {
        byte[] byArray = new byte[20];
        if (this.random == null) {
            this.random = new SecureRandom();
        }
        this.random.nextBytes(byArray);
        return byArray;
    }

    private AlgorithmParameters getAlgorithmParameters(String string) throws IOException {
        AlgorithmParameters algorithmParameters = null;
        PBEParameterSpec pBEParameterSpec = new PBEParameterSpec(this.getSalt(), 1024);
        try {
            algorithmParameters = AlgorithmParameters.getInstance(string);
            algorithmParameters.init(pBEParameterSpec);
        }
        catch (Exception exception) {
            IOException iOException = new IOException("getAlgorithmParameters failed: " + exception.getMessage());
            iOException.initCause(exception);
            throw iOException;
        }
        return algorithmParameters;
    }

    private AlgorithmParameters parseAlgParameters(DerInputStream derInputStream) throws IOException {
        AlgorithmParameters algorithmParameters = null;
        try {
            DerValue derValue;
            if (derInputStream.available() == 0) {
                derValue = null;
            } else {
                derValue = derInputStream.getDerValue();
                if (derValue.tag == 5) {
                    derValue = null;
                }
            }
            if (derValue != null) {
                algorithmParameters = AlgorithmParameters.getInstance("PBE");
                algorithmParameters.init(derValue.toByteArray());
            }
        }
        catch (Exception exception) {
            IOException iOException = new IOException("parseAlgParameters failed: " + exception.getMessage());
            iOException.initCause(exception);
            throw iOException;
        }
        return algorithmParameters;
    }

    private SecretKey getPBEKey(char[] cArray) throws IOException {
        SecretKey secretKey = null;
        try {
            PBEKeySpec pBEKeySpec = new PBEKeySpec(cArray);
            SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance("PBE");
            secretKey = secretKeyFactory.generateSecret(pBEKeySpec);
        }
        catch (Exception exception) {
            IOException iOException = new IOException("getSecretKey failed: " + exception.getMessage());
            iOException.initCause(exception);
            throw iOException;
        }
        return secretKey;
    }

    private byte[] encryptPrivateKey(byte[] byArray, char[] cArray) throws IOException, NoSuchAlgorithmException, UnrecoverableKeyException {
        byte[] byArray2 = null;
        try {
            AlgorithmParameters algorithmParameters = this.getAlgorithmParameters("PBEWithSHA1AndDESede");
            SecretKey secretKey = this.getPBEKey(cArray);
            Cipher cipher = Cipher.getInstance("PBEWithSHA1AndDESede");
            cipher.init(1, (Key)secretKey, algorithmParameters);
            byte[] byArray3 = cipher.doFinal(byArray);
            AlgorithmId algorithmId = new AlgorithmId(pbeWithSHAAnd3KeyTripleDESCBC_OID, algorithmParameters);
            EncryptedPrivateKeyInfo encryptedPrivateKeyInfo = new EncryptedPrivateKeyInfo(algorithmId, byArray3);
            byArray2 = encryptedPrivateKeyInfo.getEncoded();
        }
        catch (Exception exception) {
            UnrecoverableKeyException unrecoverableKeyException = new UnrecoverableKeyException("Encrypt Private Key failed: " + exception.getMessage());
            unrecoverableKeyException.initCause(exception);
            throw unrecoverableKeyException;
        }
        return byArray2;
    }

    @Override
    public synchronized void engineSetCertificateEntry(String string, Certificate certificate) throws KeyStoreException {
        KeyEntry keyEntry = this.entries.get(string.toLowerCase(Locale.ENGLISH));
        if (keyEntry != null) {
            throw new KeyStoreException("Cannot overwrite own certificate");
        }
        throw new KeyStoreException("TrustedCertEntry not supported");
    }

    @Override
    public synchronized void engineDeleteEntry(String string) throws KeyStoreException {
        this.entries.remove(string.toLowerCase(Locale.ENGLISH));
    }

    @Override
    public Enumeration<String> engineAliases() {
        return this.entries.keys();
    }

    @Override
    public boolean engineContainsAlias(String string) {
        return this.entries.containsKey(string.toLowerCase(Locale.ENGLISH));
    }

    @Override
    public int engineSize() {
        return this.entries.size();
    }

    @Override
    public boolean engineIsKeyEntry(String string) {
        KeyEntry keyEntry = this.entries.get(string.toLowerCase(Locale.ENGLISH));
        return keyEntry != null;
    }

    @Override
    public boolean engineIsCertificateEntry(String string) {
        return false;
    }

    @Override
    public String engineGetCertificateAlias(Certificate certificate) {
        Certificate certificate2 = null;
        Enumeration<String> enumeration = this.entries.keys();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement();
            KeyEntry keyEntry = this.entries.get(string);
            if (keyEntry.chain != null) {
                certificate2 = keyEntry.chain[0];
            }
            if (!certificate2.equals(certificate)) continue;
            return string;
        }
        return null;
    }

    @Override
    public synchronized void engineStore(OutputStream outputStream, char[] cArray) throws IOException, NoSuchAlgorithmException, CertificateException {
        if (cArray == null) {
            throw new IllegalArgumentException("password can't be null");
        }
        DerOutputStream derOutputStream = new DerOutputStream();
        DerOutputStream derOutputStream2 = new DerOutputStream();
        derOutputStream2.putInteger(3);
        byte[] byArray = derOutputStream2.toByteArray();
        derOutputStream.write(byArray);
        DerOutputStream derOutputStream3 = new DerOutputStream();
        DerOutputStream derOutputStream4 = new DerOutputStream();
        byte[] byArray2 = this.createSafeContent();
        ContentInfo contentInfo = new ContentInfo(byArray2);
        contentInfo.encode(derOutputStream4);
        byte[] byArray3 = this.createEncryptedData(cArray);
        ContentInfo contentInfo2 = new ContentInfo(ContentInfo.ENCRYPTED_DATA_OID, new DerValue(byArray3));
        contentInfo2.encode(derOutputStream4);
        DerOutputStream derOutputStream5 = new DerOutputStream();
        derOutputStream5.write((byte)48, derOutputStream4);
        byte[] byArray4 = derOutputStream5.toByteArray();
        ContentInfo contentInfo3 = new ContentInfo(byArray4);
        contentInfo3.encode(derOutputStream3);
        byte[] byArray5 = derOutputStream3.toByteArray();
        derOutputStream.write(byArray5);
        byte[] byArray6 = this.calculateMac(cArray, byArray4);
        derOutputStream.write(byArray6);
        DerOutputStream derOutputStream6 = new DerOutputStream();
        derOutputStream6.write((byte)48, derOutputStream);
        byte[] byArray7 = derOutputStream6.toByteArray();
        outputStream.write(byArray7);
        outputStream.flush();
    }

    private byte[] generateHash(byte[] byArray) throws IOException {
        byte[] byArray2 = null;
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA1");
            messageDigest.update(byArray);
            byArray2 = messageDigest.digest();
        }
        catch (Exception exception) {
            IOException iOException = new IOException("generateHash failed: " + exception);
            iOException.initCause(exception);
            throw iOException;
        }
        return byArray2;
    }

    private byte[] calculateMac(char[] cArray, byte[] byArray) throws IOException {
        byte[] byArray2 = null;
        String string = "SHA1";
        try {
            byte[] byArray3 = this.getSalt();
            Mac mac = Mac.getInstance("HmacPBESHA1");
            PBEParameterSpec pBEParameterSpec = new PBEParameterSpec(byArray3, 1024);
            SecretKey secretKey = this.getPBEKey(cArray);
            mac.init(secretKey, pBEParameterSpec);
            mac.update(byArray);
            byte[] byArray4 = mac.doFinal();
            MacData macData = new MacData(string, byArray4, byArray3, 1024);
            DerOutputStream derOutputStream = new DerOutputStream();
            derOutputStream.write(macData.getEncoded());
            byArray2 = derOutputStream.toByteArray();
        }
        catch (Exception exception) {
            IOException iOException = new IOException("calculateMac failed: " + exception);
            iOException.initCause(exception);
            throw iOException;
        }
        return byArray2;
    }

    private boolean validateChain(Certificate[] certificateArray) {
        for (int i = 0; i < certificateArray.length - 1; ++i) {
            X500Principal x500Principal;
            X500Principal x500Principal2 = ((X509Certificate)certificateArray[i]).getIssuerX500Principal();
            if (x500Principal2.equals(x500Principal = ((X509Certificate)certificateArray[i + 1]).getSubjectX500Principal())) continue;
            return false;
        }
        HashSet<Certificate> hashSet = new HashSet<Certificate>(Arrays.asList(certificateArray));
        return hashSet.size() == certificateArray.length;
    }

    private byte[] getBagAttributes(String string, byte[] byArray) throws IOException {
        DerOutputStream derOutputStream;
        DerOutputStream derOutputStream2;
        DerOutputStream derOutputStream3;
        byte[] byArray2 = null;
        byte[] byArray3 = null;
        if (string == null && byArray == null) {
            return null;
        }
        DerOutputStream derOutputStream4 = new DerOutputStream();
        if (string != null) {
            derOutputStream3 = new DerOutputStream();
            derOutputStream3.putOID(PKCS9FriendlyName_OID);
            derOutputStream2 = new DerOutputStream();
            derOutputStream = new DerOutputStream();
            derOutputStream2.putBMPString(string);
            derOutputStream3.write((byte)49, derOutputStream2);
            derOutputStream.write((byte)48, derOutputStream3);
            byArray3 = derOutputStream.toByteArray();
        }
        if (byArray != null) {
            derOutputStream3 = new DerOutputStream();
            derOutputStream3.putOID(PKCS9LocalKeyId_OID);
            derOutputStream2 = new DerOutputStream();
            derOutputStream = new DerOutputStream();
            derOutputStream2.putOctetString(byArray);
            derOutputStream3.write((byte)49, derOutputStream2);
            derOutputStream.write((byte)48, derOutputStream3);
            byArray2 = derOutputStream.toByteArray();
        }
        derOutputStream3 = new DerOutputStream();
        if (byArray3 != null) {
            derOutputStream3.write(byArray3);
        }
        if (byArray2 != null) {
            derOutputStream3.write(byArray2);
        }
        derOutputStream4.write((byte)49, derOutputStream3);
        return derOutputStream4.toByteArray();
    }

    private byte[] createEncryptedData(char[] cArray) throws CertificateException, IOException {
        Object object;
        Object object2;
        DerOutputStream derOutputStream = new DerOutputStream();
        Object object3 = this.entries.keys();
        while (object3.hasMoreElements()) {
            object2 = object3.nextElement();
            object = this.entries.get(object2);
            int n = ((KeyEntry)object).chain == null ? 0 : ((KeyEntry)object).chain.length;
            for (int i = 0; i < n; ++i) {
                DerOutputStream derOutputStream2 = new DerOutputStream();
                derOutputStream2.putOID(CertBag_OID);
                DerOutputStream derOutputStream3 = new DerOutputStream();
                derOutputStream3.putOID(PKCS9CertType_OID);
                DerOutputStream derOutputStream4 = new DerOutputStream();
                X509Certificate x509Certificate = (X509Certificate)((KeyEntry)object).chain[i];
                derOutputStream4.putOctetString(x509Certificate.getEncoded());
                derOutputStream3.write(DerValue.createTag((byte)-128, true, (byte)0), derOutputStream4);
                DerOutputStream derOutputStream5 = new DerOutputStream();
                derOutputStream5.write((byte)48, derOutputStream3);
                byte[] byArray = derOutputStream5.toByteArray();
                DerOutputStream derOutputStream6 = new DerOutputStream();
                derOutputStream6.write(byArray);
                derOutputStream2.write(DerValue.createTag((byte)-128, true, (byte)0), derOutputStream6);
                byte[] byArray2 = null;
                byArray2 = i == 0 ? this.getBagAttributes(((KeyEntry)object).alias, ((KeyEntry)object).keyId) : this.getBagAttributes(x509Certificate.getSubjectX500Principal().getName(), null);
                if (byArray2 != null) {
                    derOutputStream2.write(byArray2);
                }
                derOutputStream.write((byte)48, derOutputStream2);
            }
        }
        object3 = new DerOutputStream();
        ((DerOutputStream)object3).write((byte)48, derOutputStream);
        object2 = ((ByteArrayOutputStream)object3).toByteArray();
        object = this.encryptContent((byte[])object2, cArray);
        DerOutputStream derOutputStream7 = new DerOutputStream();
        DerOutputStream derOutputStream8 = new DerOutputStream();
        derOutputStream7.putInteger(0);
        derOutputStream7.write((byte[])object);
        derOutputStream8.write((byte)48, derOutputStream7);
        return derOutputStream8.toByteArray();
    }

    private byte[] createSafeContent() throws CertificateException, IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        Object object = this.entries.keys();
        while (object.hasMoreElements()) {
            String string = object.nextElement();
            KeyEntry keyEntry = this.entries.get(string);
            DerOutputStream derOutputStream2 = new DerOutputStream();
            derOutputStream2.putOID(PKCS8ShroudedKeyBag_OID);
            byte[] byArray = keyEntry.protectedPrivKey;
            EncryptedPrivateKeyInfo encryptedPrivateKeyInfo = null;
            try {
                encryptedPrivateKeyInfo = new EncryptedPrivateKeyInfo(byArray);
            }
            catch (IOException iOException) {
                throw new IOException("Private key not stored as PKCS#8 EncryptedPrivateKeyInfo" + iOException.getMessage());
            }
            DerOutputStream derOutputStream3 = new DerOutputStream();
            derOutputStream3.write(encryptedPrivateKeyInfo.getEncoded());
            derOutputStream2.write(DerValue.createTag((byte)-128, true, (byte)0), derOutputStream3);
            byte[] byArray2 = this.getBagAttributes(string, keyEntry.keyId);
            derOutputStream2.write(byArray2);
            derOutputStream.write((byte)48, derOutputStream2);
        }
        object = new DerOutputStream();
        ((DerOutputStream)object).write((byte)48, derOutputStream);
        return ((ByteArrayOutputStream)object).toByteArray();
    }

    private byte[] encryptContent(byte[] byArray, char[] cArray) throws IOException {
        Object object;
        Object object2;
        byte[] byArray2 = null;
        AlgorithmParameters algorithmParameters = this.getAlgorithmParameters("PBEWithSHA1AndRC2_40");
        DerOutputStream derOutputStream = new DerOutputStream();
        AlgorithmId algorithmId = new AlgorithmId(pbeWithSHAAnd40BitRC2CBC_OID, algorithmParameters);
        algorithmId.encode(derOutputStream);
        byte[] byArray3 = derOutputStream.toByteArray();
        try {
            object2 = this.getPBEKey(cArray);
            object = Cipher.getInstance("PBEWithSHA1AndRC2_40");
            ((Cipher)object).init(1, (Key)object2, algorithmParameters);
            byArray2 = ((Cipher)object).doFinal(byArray);
        }
        catch (Exception exception) {
            IOException iOException = new IOException("Failed to encrypt safe contents entry: " + exception);
            iOException.initCause(exception);
            throw iOException;
        }
        object2 = new DerOutputStream();
        ((DerOutputStream)object2).putOID(ContentInfo.DATA_OID);
        ((OutputStream)object2).write(byArray3);
        object = new DerOutputStream();
        ((DerOutputStream)object).putOctetString(byArray2);
        ((DerOutputStream)object2).writeImplicit(DerValue.createTag((byte)-128, false, (byte)0), (DerOutputStream)object);
        DerOutputStream derOutputStream2 = new DerOutputStream();
        derOutputStream2.write((byte)48, (DerOutputStream)object2);
        return derOutputStream2.toByteArray();
    }

    @Override
    public synchronized void engineLoad(InputStream inputStream, char[] cArray) throws IOException, NoSuchAlgorithmException, CertificateException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        Object var4_3 = null;
        Object var5_4 = null;
        Object var6_5 = null;
        if (inputStream == null) {
            return;
        }
        this.counter = 0;
        DerValue derValue = new DerValue(inputStream);
        DerInputStream derInputStream = derValue.toDerInputStream();
        int n = derInputStream.getInteger();
        if (n != 3) {
            throw new IOException("PKCS12 keystore not in version 3 format");
        }
        this.entries.clear();
        ContentInfo contentInfo = new ContentInfo(derInputStream);
        ObjectIdentifier objectIdentifier = contentInfo.getContentType();
        if (!objectIdentifier.equals(ContentInfo.DATA_OID)) {
            throw new IOException("public key protected PKCS12 not supported");
        }
        byte[] byArray = contentInfo.getData();
        DerInputStream derInputStream2 = new DerInputStream(byArray);
        DerValue[] derValueArray = derInputStream2.getSequence(2);
        int n2 = derValueArray.length;
        this.privateKeyCount = 0;
        for (int i = 0; i < n2; ++i) {
            block22: {
                object5 = null;
                object4 = new DerInputStream(derValueArray[i].toByteArray());
                object3 = new ContentInfo((DerInputStream)object4);
                objectIdentifier = ((ContentInfo)object3).getContentType();
                object2 = null;
                if (objectIdentifier.equals(ContentInfo.DATA_OID)) {
                    object2 = ((ContentInfo)object3).getData();
                } else {
                    if (objectIdentifier.equals(ContentInfo.ENCRYPTED_DATA_OID)) {
                        if (cArray == null) continue;
                        object = ((ContentInfo)object3).getContent().toDerInputStream();
                        int n3 = ((DerInputStream)object).getInteger();
                        DerValue[] derValueArray2 = ((DerInputStream)object).getSequence(2);
                        ObjectIdentifier objectIdentifier2 = derValueArray2[0].getOID();
                        object5 = derValueArray2[1].toByteArray();
                        if (!derValueArray2[2].isContextSpecific((byte)0)) {
                            throw new IOException("encrypted content not present!");
                        }
                        byte by = 4;
                        if (derValueArray2[2].isConstructed()) {
                            by = (byte)(by | 0x20);
                        }
                        derValueArray2[2].resetTag(by);
                        object2 = derValueArray2[2].getOctetString();
                        DerInputStream derInputStream3 = derValueArray2[1].toDerInputStream();
                        ObjectIdentifier objectIdentifier3 = derInputStream3.getOID();
                        AlgorithmParameters algorithmParameters = this.parseAlgParameters(derInputStream3);
                        while (true) {
                            try {
                                SecretKey secretKey = this.getPBEKey(cArray);
                                Cipher cipher = Cipher.getInstance(objectIdentifier3.toString());
                                cipher.init(2, (Key)secretKey, algorithmParameters);
                                object2 = cipher.doFinal((byte[])object2);
                                break block22;
                            }
                            catch (Exception exception) {
                                if (cArray.length == 0) {
                                    cArray = new char[1];
                                    continue;
                                }
                                throw new IOException("failed to decrypt safe contents entry: " + exception, exception);
                            }
                            break;
                        }
                    }
                    throw new IOException("public key protected PKCS12 not supported");
                }
            }
            object = new DerInputStream((byte[])object2);
            this.loadSafeContents((DerInputStream)object, cArray);
        }
        if (cArray != null && derInputStream.available() > 0) {
            MacData macData = new MacData(derInputStream);
            try {
                object2 = macData.getDigestAlgName().toUpperCase(Locale.ENGLISH);
                if (((String)object2).equals("SHA") || ((String)object2).equals("SHA1") || ((String)object2).equals("SHA-1")) {
                    object2 = "SHA1";
                }
                object3 = Mac.getInstance("HmacPBE" + (String)object2);
                object4 = new PBEParameterSpec(macData.getSalt(), macData.getIterations());
                object5 = this.getPBEKey(cArray);
                ((Mac)object3).init((Key)object5, (AlgorithmParameterSpec)object4);
                ((Mac)object3).update(byArray);
                object = ((Mac)object3).doFinal();
                if (!MessageDigest.isEqual(macData.getDigest(), (byte[])object)) {
                    throw new SecurityException("Failed PKCS12 integrity checking");
                }
            }
            catch (Exception exception) {
                object3 = new IOException("Integrity check failed: " + exception);
                ((Throwable)object3).initCause(exception);
                throw object3;
            }
        }
        KeyEntry[] keyEntryArray = this.keyList.toArray(new KeyEntry[this.keyList.size()]);
        for (int i = 0; i < keyEntryArray.length; ++i) {
            object3 = keyEntryArray[i];
            if (((KeyEntry)object3).keyId == null) continue;
            object4 = new ArrayList();
            object5 = this.findMatchedCertificate((KeyEntry)object3);
            block7: while (object5 != null) {
                if (!((ArrayList)object4).isEmpty()) {
                    object = ((ArrayList)object4).iterator();
                    while (object.hasNext()) {
                        X509Certificate x509Certificate = (X509Certificate)object.next();
                        if (!((Certificate)object5).equals(x509Certificate)) continue;
                        if (debug == null) break block7;
                        debug.println("Loop detected in certificate chain. Skip adding repeated cert to chain. Subject: " + ((X509Certificate)object5).getSubjectX500Principal().toString());
                        break block7;
                    }
                }
                ((ArrayList)object4).add(object5);
                object = ((X509Certificate)object5).getIssuerX500Principal();
                if (((X500Principal)object).equals(((X509Certificate)object5).getSubjectX500Principal())) break;
                object5 = this.certsMap.get(object);
            }
            if (((ArrayList)object4).size() <= 0) continue;
            ((KeyEntry)object3).chain = ((ArrayList)object4).toArray(new Certificate[((ArrayList)object4).size()]);
        }
        this.certEntries.clear();
        this.certsMap.clear();
        this.keyList.clear();
    }

    private X509Certificate findMatchedCertificate(KeyEntry keyEntry) {
        CertEntry certEntry = null;
        CertEntry certEntry2 = null;
        for (CertEntry certEntry3 : this.certEntries) {
            if (Arrays.equals(keyEntry.keyId, certEntry3.keyId)) {
                certEntry = certEntry3;
                if (!keyEntry.alias.equalsIgnoreCase(certEntry3.alias)) continue;
                return certEntry3.cert;
            }
            if (!keyEntry.alias.equalsIgnoreCase(certEntry3.alias)) continue;
            certEntry2 = certEntry3;
        }
        if (certEntry != null) {
            return certEntry.cert;
        }
        if (certEntry2 != null) {
            return certEntry2.cert;
        }
        return null;
    }

    private void loadSafeContents(DerInputStream derInputStream, char[] cArray) throws IOException, NoSuchAlgorithmException, CertificateException {
        DerValue[] derValueArray = derInputStream.getSequence(2);
        int n = derValueArray.length;
        for (int i = 0; i < n; ++i) {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            Object object5;
            DerValue[] derValueArray2 = null;
            DerInputStream derInputStream2 = derValueArray[i].toDerInputStream();
            ObjectIdentifier objectIdentifier = derInputStream2.getOID();
            DerValue derValue = derInputStream2.getDerValue();
            if (!derValue.isContextSpecific((byte)0)) {
                throw new IOException("unsupported PKCS12 bag value type " + derValue.tag);
            }
            derValue = derValue.data.getDerValue();
            if (objectIdentifier.equals(PKCS8ShroudedKeyBag_OID)) {
                object5 = new KeyEntry();
                ((KeyEntry)object5).protectedPrivKey = derValue.toByteArray();
                derValueArray2 = object5;
                ++this.privateKeyCount;
            } else if (objectIdentifier.equals(CertBag_OID)) {
                object5 = new DerInputStream(derValue.toByteArray());
                object4 = ((DerInputStream)object5).getSequence(2);
                object3 = object4[0].getOID();
                if (!object4[1].isContextSpecific((byte)0)) {
                    throw new IOException("unsupported PKCS12 cert value type " + object4[1].tag);
                }
                DerValue derValue2 = object4[1].data.getDerValue();
                object2 = CertificateFactory.getInstance("X509");
                object = (X509Certificate)((CertificateFactory)object2).generateCertificate(new ByteArrayInputStream(derValue2.getOctetString()));
                derValueArray2 = object;
            }
            try {
                object5 = derInputStream2.getSet(2);
            }
            catch (IOException iOException) {
                object5 = null;
            }
            object4 = null;
            object3 = null;
            if (object5 != null) {
                for (int j = 0; j < ((Object)object5).length; ++j) {
                    DerValue[] derValueArray3;
                    object2 = new DerInputStream(((DerValue)object5[j]).toByteArray());
                    object = ((DerInputStream)object2).getSequence(2);
                    ObjectIdentifier objectIdentifier2 = object[0].getOID();
                    DerInputStream derInputStream3 = new DerInputStream(object[1].toByteArray());
                    try {
                        derValueArray3 = derInputStream3.getSet(1);
                    }
                    catch (IOException iOException) {
                        throw new IOException("Attribute " + objectIdentifier2 + " should have a value " + iOException.getMessage());
                    }
                    if (objectIdentifier2.equals(PKCS9FriendlyName_OID)) {
                        object4 = derValueArray3[0].getBMPString();
                        continue;
                    }
                    if (!objectIdentifier2.equals(PKCS9LocalKeyId_OID)) continue;
                    object3 = derValueArray3[0].getOctetString();
                }
            }
            if (derValueArray2 instanceof KeyEntry) {
                KeyEntry keyEntry = (KeyEntry)derValueArray2;
                if (object3 == null) {
                    if (this.privateKeyCount != 1) continue;
                    object3 = "01".getBytes("UTF8");
                }
                keyEntry.keyId = (byte[])object3;
                object2 = new String((byte[])object3, "UTF8");
                object = null;
                if (((String)object2).startsWith("Time ")) {
                    try {
                        object = new Date(Long.parseLong(((String)object2).substring(5)));
                    }
                    catch (Exception exception) {
                        object = null;
                    }
                }
                if (object == null) {
                    object = new Date();
                }
                keyEntry.date = object;
                this.keyList.add(keyEntry);
                if (object4 == null) {
                    object4 = this.getUnfriendlyName();
                }
                keyEntry.alias = object4;
                this.entries.put(((String)object4).toLowerCase(Locale.ENGLISH), keyEntry);
                continue;
            }
            if (!(derValueArray2 instanceof X509Certificate)) continue;
            X509Certificate x509Certificate = (X509Certificate)derValueArray2;
            if (object3 == null && this.privateKeyCount == 1 && i == 0) {
                object3 = "01".getBytes("UTF8");
            }
            this.certEntries.add(new CertEntry(x509Certificate, (byte[])object3, (String)object4));
            object2 = x509Certificate.getSubjectX500Principal();
            if (object2 == null || this.certsMap.containsKey(object2)) continue;
            this.certsMap.put((X500Principal)object2, x509Certificate);
        }
    }

    private String getUnfriendlyName() {
        ++this.counter;
        return String.valueOf(this.counter);
    }

    static {
        try {
            PKCS8ShroudedKeyBag_OID = new ObjectIdentifier(keyBag);
            CertBag_OID = new ObjectIdentifier(certBag);
            PKCS9FriendlyName_OID = new ObjectIdentifier(pkcs9Name);
            PKCS9LocalKeyId_OID = new ObjectIdentifier(pkcs9KeyId);
            PKCS9CertType_OID = new ObjectIdentifier(pkcs9certType);
            pbeWithSHAAnd40BitRC2CBC_OID = new ObjectIdentifier(pbeWithSHAAnd40BitRC2CBC);
            pbeWithSHAAnd3KeyTripleDESCBC_OID = new ObjectIdentifier(pbeWithSHAAnd3KeyTripleDESCBC);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static class CertEntry {
        final X509Certificate cert;
        final byte[] keyId;
        final String alias;

        CertEntry(X509Certificate x509Certificate, byte[] byArray, String string) {
            this.cert = x509Certificate;
            this.keyId = byArray;
            this.alias = string;
        }
    }

    private static class KeyEntry {
        Date date;
        byte[] protectedPrivKey;
        Certificate[] chain;
        byte[] keyId;
        String alias;

        private KeyEntry() {
        }
    }
}

