/*
 * Decompiled with CFR 0.152.
 */
package sun.security.provider;

import java.math.BigInteger;
import java.security.AlgorithmParameterGenerator;
import java.security.AlgorithmParameters;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.DSAParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.spec.DHParameterSpec;

public final class ParameterCache {
    private static final Map<Integer, DSAParameterSpec> dsaCache;
    private static final Map<Integer, DHParameterSpec> dhCache;

    private ParameterCache() {
    }

    public static DSAParameterSpec getCachedDSAParameterSpec(int n) {
        return dsaCache.get(n);
    }

    public static DHParameterSpec getCachedDHParameterSpec(int n) {
        return dhCache.get(n);
    }

    public static DSAParameterSpec getDSAParameterSpec(int n, SecureRandom secureRandom) throws NoSuchAlgorithmException, InvalidParameterSpecException {
        DSAParameterSpec dSAParameterSpec = ParameterCache.getCachedDSAParameterSpec(n);
        if (dSAParameterSpec != null) {
            return dSAParameterSpec;
        }
        dSAParameterSpec = ParameterCache.getNewDSAParameterSpec(n, secureRandom);
        dsaCache.put(n, dSAParameterSpec);
        return dSAParameterSpec;
    }

    public static DHParameterSpec getDHParameterSpec(int n, SecureRandom secureRandom) throws NoSuchAlgorithmException, InvalidParameterSpecException {
        DHParameterSpec dHParameterSpec = ParameterCache.getCachedDHParameterSpec(n);
        if (dHParameterSpec != null) {
            return dHParameterSpec;
        }
        AlgorithmParameterGenerator algorithmParameterGenerator = AlgorithmParameterGenerator.getInstance("DH");
        algorithmParameterGenerator.init(n, secureRandom);
        AlgorithmParameters algorithmParameters = algorithmParameterGenerator.generateParameters();
        dHParameterSpec = algorithmParameters.getParameterSpec(DHParameterSpec.class);
        dhCache.put(n, dHParameterSpec);
        return dHParameterSpec;
    }

    public static DSAParameterSpec getNewDSAParameterSpec(int n, SecureRandom secureRandom) throws NoSuchAlgorithmException, InvalidParameterSpecException {
        AlgorithmParameterGenerator algorithmParameterGenerator = AlgorithmParameterGenerator.getInstance("DSA");
        algorithmParameterGenerator.init(n, secureRandom);
        AlgorithmParameters algorithmParameters = algorithmParameterGenerator.generateParameters();
        DSAParameterSpec dSAParameterSpec = algorithmParameters.getParameterSpec(DSAParameterSpec.class);
        return dSAParameterSpec;
    }

    static {
        dhCache = Collections.synchronizedMap(new HashMap());
        dsaCache = Collections.synchronizedMap(new HashMap());
        BigInteger bigInteger = new BigInteger("fca682ce8e12caba26efccf7110e526db078b05edecbcd1eb4a208f3ae1617ae01f35b91a47e6df63413c5e12ed0899bcd132acd50d99151bdc43ee737592e17", 16);
        BigInteger bigInteger2 = new BigInteger("962eddcc369cba8ebb260ee6b6a126d9346e38c5", 16);
        BigInteger bigInteger3 = new BigInteger("678471b27a9cf44ee91a49c5147db1a9aaf244f05a434d6486931d2d14271b9e35030b71fd73da179069b32e2935630e1c2062354d0da20a6c416e50be794ca4", 16);
        BigInteger bigInteger4 = new BigInteger("e9e642599d355f37c97ffd3567120b8e25c9cd43e927b3a9670fbec5d890141922d2c3b3ad2480093799869d1e846aab49fab0ad26d2ce6a22219d470bce7d777d4a21fbe9c270b57f607002f3cef8393694cf45ee3688c11a8c56ab127a3daf", 16);
        BigInteger bigInteger5 = new BigInteger("9cdbd84c9f1ac2f38d0f80f42ab952e7338bf511", 16);
        BigInteger bigInteger6 = new BigInteger("30470ad5a005fb14ce2d9dcd87e38bc7d1b1c5facbaecbe95f190aa7a31d23c4dbbcbe06174544401a5b2c020965d8c2bd2171d3668445771f74ba084d2029d83c1c158547f3a9f1a2715be23d51ae4d3e5a1f6a7064f316933a346d3f529252", 16);
        BigInteger bigInteger7 = new BigInteger("fd7f53811d75122952df4a9c2eece4e7f611b7523cef4400c31e3f80b6512669455d402251fb593d8d58fabfc5f5ba30f6cb9b556cd7813b801d346ff26660b76b9950a5a49f9fe8047b1022c24fbba9d7feb7c61bf83b57e7c6a8a6150f04fb83f6d3c51ec3023554135a169132f675f3ae2b61d72aeff22203199dd14801c7", 16);
        BigInteger bigInteger8 = new BigInteger("9760508f15230bccb292b982a2eb840bf0581cf5", 16);
        BigInteger bigInteger9 = new BigInteger("f7e1a085d69b3ddecbbcab5c36b857b97994afbbfa3aea82f9574c0b3d0782675159578ebad4594fe67107108180b449167123e84c281613b7cf09328cc8a6e13c167a8b547c8d28e0a3ae1e2bb3a675916ea37f0bfa213562f1fb627a01243bcca4f1bea8519089a883dfe15ae59f06928b665e807b552564014c3bfecf492a", 16);
        dsaCache.put(512, new DSAParameterSpec(bigInteger, bigInteger2, bigInteger3));
        dsaCache.put(768, new DSAParameterSpec(bigInteger4, bigInteger5, bigInteger6));
        dsaCache.put(1024, new DSAParameterSpec(bigInteger7, bigInteger8, bigInteger9));
        BigInteger bigInteger10 = new BigInteger("8f7935d9b9aae9bfabed887acf4951b6f32ec59e3baf3718e8eac4961f3efd3606e74351a9c4183339b809e7c2ae1c539ba7475b85d011adb8b47987754984695cac0e8f14b3360828a22ffa27110a3d62a993453409a0fe696c4658f84bdd20819c3709a01057b195adcd00233dba5484b6291f9d648ef883448677979cec04b434a6ac2e75e9985de23db0292fc1118c9ffa9d8181e7338db792b730d7b9e349592f68099872153915ea3d6b8b4653c633458f803b32a4c2e0f27290256e4e3f8a3b0838a1c450e4e18c1a29a37ddf5ea143de4b66ff04903ed5cf1623e158d487c608e97f211cd81dca23cb6e380765f822e342be484c05763939601cd667", 16);
        BigInteger bigInteger11 = new BigInteger("16a65c58204850704e7502a39757040d34da3a3478c154d4e4a5c02d242ee04f96e61e4bd0904abdac8f37eeb1e09f3182d23c9043cb642f88004160edf9ca09b32076a79c32a627f2473e91879ba2c4e744bd2081544cb55b802c368d1fa83ed489e94e0fa0688e32428a5c78c478c68d0527b71c9a3abb0b0be12c44689639e7d3ce74db101a65aa2b87f64c6826db3ec72f4b5599834bb4edb02f7c90e9a496d3a55d535bebfc45d4f619f63f3dedbb873925c2f224e07731296da887ec1e4748f87efb5fdeb75484316b2232dee553ddaf02112b0d1f02da30973224fe27aeda8b9d4b2922d9ba8be39ed9e103a63c52810bc688b7e2ed4316e1ef17dbde", 16);
        dhCache.put(512, new DHParameterSpec(bigInteger, bigInteger3));
        dhCache.put(768, new DHParameterSpec(bigInteger4, bigInteger6));
        dhCache.put(1024, new DHParameterSpec(bigInteger7, bigInteger9));
        dhCache.put(2048, new DHParameterSpec(bigInteger10, bigInteger11));
    }
}

