/*
 * Decompiled with CFR 0.152.
 */
package sun.security.util;

import java.security.AlgorithmParameters;
import java.security.CryptoPrimitive;
import java.security.Key;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import sun.security.util.AbstractAlgorithmConstraints;
import sun.security.util.AlgorithmDecomposer;
import sun.security.util.KeyUtil;

public class DisabledAlgorithmConstraints
extends AbstractAlgorithmConstraints {
    public static final String PROPERTY_CERTPATH_DISABLED_ALGS = "jdk.certpath.disabledAlgorithms";
    public static final String PROPERTY_TLS_DISABLED_ALGS = "jdk.tls.disabledAlgorithms";
    private static Map<String, String[]> disabledAlgorithmsMap = Collections.synchronizedMap(new HashMap());
    private static Map<String, KeySizeConstraints> keySizeConstraintsMap = Collections.synchronizedMap(new HashMap());
    public static final String PROPERTY_JAR_DISABLED_ALGS = "jdk.jar.disabledAlgorithms";
    private final String[] disabledAlgorithms;
    private final KeySizeConstraints keySizeConstraints;

    public DisabledAlgorithmConstraints(String string) {
        this(string, new AlgorithmDecomposer());
    }

    public DisabledAlgorithmConstraints(String string, AlgorithmDecomposer algorithmDecomposer) {
        super(algorithmDecomposer);
        this.disabledAlgorithms = DisabledAlgorithmConstraints.getAlgorithms(disabledAlgorithmsMap, string);
        this.keySizeConstraints = DisabledAlgorithmConstraints.getKeySizeConstraints(this.disabledAlgorithms, string);
    }

    @Override
    public final boolean permits(Set<CryptoPrimitive> set, String string, AlgorithmParameters algorithmParameters) {
        if (set == null || set.isEmpty()) {
            throw new IllegalArgumentException("No cryptographic primitive specified");
        }
        return DisabledAlgorithmConstraints.checkAlgorithm(this.disabledAlgorithms, string, this.decomposer);
    }

    @Override
    public final boolean permits(Set<CryptoPrimitive> set, Key key) {
        return this.checkConstraints(set, "", key, null);
    }

    @Override
    public final boolean permits(Set<CryptoPrimitive> set, String string, Key key, AlgorithmParameters algorithmParameters) {
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException("No algorithm name specified");
        }
        return this.checkConstraints(set, string, key, algorithmParameters);
    }

    private boolean checkConstraints(Set<CryptoPrimitive> set, String string, Key key, AlgorithmParameters algorithmParameters) {
        if (key == null) {
            throw new IllegalArgumentException("The key cannot be null");
        }
        if (string != null && string.length() != 0 && !this.permits(set, string, algorithmParameters)) {
            return false;
        }
        if (!this.permits(set, key.getAlgorithm(), null)) {
            return false;
        }
        return !this.keySizeConstraints.disables(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static KeySizeConstraints getKeySizeConstraints(String[] stringArray, String string) {
        Map<String, KeySizeConstraints> map = keySizeConstraintsMap;
        synchronized (map) {
            if (!keySizeConstraintsMap.containsKey(string)) {
                KeySizeConstraints keySizeConstraints = new KeySizeConstraints(stringArray);
                keySizeConstraintsMap.put(string, keySizeConstraints);
            }
            return keySizeConstraintsMap.get(string);
        }
    }

    private static class KeySizeConstraint {
        private int minSize;
        private int maxSize;
        private int prohibitedSize = -1;

        public KeySizeConstraint(Operator operator, int n) {
            switch (operator) {
                case EQ: {
                    this.minSize = 0;
                    this.maxSize = Integer.MAX_VALUE;
                    this.prohibitedSize = n;
                    break;
                }
                case NE: {
                    this.minSize = n;
                    this.maxSize = n;
                    break;
                }
                case LT: {
                    this.minSize = n;
                    this.maxSize = Integer.MAX_VALUE;
                    break;
                }
                case LE: {
                    this.minSize = n + 1;
                    this.maxSize = Integer.MAX_VALUE;
                    break;
                }
                case GT: {
                    this.minSize = 0;
                    this.maxSize = n;
                    break;
                }
                case GE: {
                    this.minSize = 0;
                    this.maxSize = n > 1 ? n - 1 : 0;
                    break;
                }
                default: {
                    this.minSize = Integer.MAX_VALUE;
                    this.maxSize = -1;
                }
            }
        }

        public boolean disables(Key key) {
            int n = KeyUtil.getKeySize(key);
            if (n == 0) {
                return true;
            }
            if (n > 0) {
                return n < this.minSize || n > this.maxSize || this.prohibitedSize == n;
            }
            return false;
        }

        static enum Operator {
            EQ,
            NE,
            LT,
            LE,
            GT,
            GE;


            static Operator of(String string) {
                switch (string) {
                    case "==": {
                        return EQ;
                    }
                    case "!=": {
                        return NE;
                    }
                    case "<": {
                        return LT;
                    }
                    case "<=": {
                        return LE;
                    }
                    case ">": {
                        return GT;
                    }
                    case ">=": {
                        return GE;
                    }
                }
                throw new IllegalArgumentException(string + " is not a legal Operator");
            }
        }
    }

    private static class KeySizeConstraints {
        private static final Pattern pattern = Pattern.compile("(\\S+)\\s+keySize\\s*(<=|<|==|!=|>|>=)\\s*(\\d+)");
        private Map<String, Set<KeySizeConstraint>> constraintsMap = Collections.synchronizedMap(new HashMap());

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public KeySizeConstraints(String[] stringArray) {
            for (String string : stringArray) {
                Matcher matcher;
                if (string == null || string.isEmpty() || !(matcher = pattern.matcher(string)).matches()) continue;
                String string2 = matcher.group(1);
                KeySizeConstraint.Operator operator = KeySizeConstraint.Operator.of(matcher.group(2));
                int n = Integer.parseInt(matcher.group(3));
                string2 = string2.toLowerCase(Locale.ENGLISH);
                Map<String, Set<KeySizeConstraint>> map = this.constraintsMap;
                synchronized (map) {
                    if (!this.constraintsMap.containsKey(string2)) {
                        this.constraintsMap.put(string2, new HashSet());
                    }
                    Set<KeySizeConstraint> set = this.constraintsMap.get(string2);
                    KeySizeConstraint keySizeConstraint = new KeySizeConstraint(operator, n);
                    set.add(keySizeConstraint);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean disables(Key key) {
            String string = key.getAlgorithm().toLowerCase(Locale.ENGLISH);
            Map<String, Set<KeySizeConstraint>> map = this.constraintsMap;
            synchronized (map) {
                if (this.constraintsMap.containsKey(string)) {
                    Set<KeySizeConstraint> set = this.constraintsMap.get(string);
                    for (KeySizeConstraint keySizeConstraint : set) {
                        if (!keySizeConstraint.disables(key)) continue;
                        return true;
                    }
                }
            }
            return false;
        }
    }
}

