/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.provider;

import com.jrockit.mc.flightrecorder.provider.SimpleFieldValueIterator;
import com.jrockit.mc.flightrecorder.provider.SingleFieldIterator;
import com.jrockit.mc.flightrecorder.spi.FieldType;
import com.jrockit.mc.flightrecorder.spi.IEvent;
import com.jrockit.mc.flightrecorder.spi.IEventType;
import com.jrockit.mc.flightrecorder.spi.IValues;
import com.jrockit.mc.flightrecorder.spi.IView;
import com.jrockit.mc.flightrecorder.util.EmptyIterator;
import com.jrockit.mc.flightrecorder.util.EventValueLookup;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;

public final class Values
implements IValues<Object> {
    private final IView m_view;
    private Collection<FieldType> m_fieldTypes;
    private Collection<String> m_attributes;

    public Values(IView view) {
        this.m_view = view;
        this.m_attributes = new ArrayList<String>();
        this.m_fieldTypes = Arrays.asList(FieldType.values());
    }

    @Override
    public void setAttribute(Collection<String> attributes) {
        this.m_attributes = attributes;
    }

    @Override
    public Collection<String> getAttributes() {
        return this.m_attributes;
    }

    @Override
    public void setFieldTypes(Collection<FieldType> fieldTypes) {
        this.m_fieldTypes = fieldTypes;
    }

    @Override
    public Collection<FieldType> getFieldTypes() {
        return this.m_fieldTypes;
    }

    @Override
    public Iterator<Object> iterator() {
        EventValueLookup evl = new EventValueLookup(this.m_fieldTypes);
        for (IEventType type : this.m_view.getEventTypes()) {
            for (String attribute : this.getAttributes()) {
                evl.add(type, attribute);
            }
        }
        Collection<IEventType> types = evl.getEventTypes();
        if (types.size() == 0) {
            return new SingleFieldIterator(null, new EmptyIterator<IEvent>());
        }
        if (types.size() == 1) {
            IEventType theType = types.iterator().next();
            IView view = this.m_view.copy();
            view.setEventTypes(types);
            return new SingleFieldIterator(evl.getField(theType), view.iterator());
        }
        return new SimpleFieldValueIterator(evl, this.m_view);
    }
}

