/*
 * Decompiled with CFR 0.152.
 */
package com.javafx.tools.doclets.formats.html;

import com.javafx.tools.doclets.formats.html.AbstractExecutableMemberWriter;
import com.javafx.tools.doclets.formats.html.SubWriterHolderWriter;
import com.javafx.tools.doclets.formats.html.markup.HtmlConstants;
import com.javafx.tools.doclets.formats.html.markup.HtmlStyle;
import com.javafx.tools.doclets.formats.html.markup.HtmlTag;
import com.javafx.tools.doclets.formats.html.markup.HtmlTree;
import com.javafx.tools.doclets.formats.html.markup.StringContent;
import com.javafx.tools.doclets.internal.toolkit.ConstructorWriter;
import com.javafx.tools.doclets.internal.toolkit.Content;
import com.javafx.tools.doclets.internal.toolkit.MemberSummaryWriter;
import com.javafx.tools.doclets.internal.toolkit.util.VisibleMemberMap;
import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.ConstructorDoc;
import com.sun.javadoc.Doc;
import com.sun.javadoc.ExecutableMemberDoc;
import com.sun.javadoc.MemberDoc;
import com.sun.javadoc.ProgramElementDoc;
import java.io.IOException;
import java.util.ArrayList;

public class ConstructorWriterImpl
extends AbstractExecutableMemberWriter
implements ConstructorWriter,
MemberSummaryWriter {
    private boolean foundNonPubConstructor = false;

    public ConstructorWriterImpl(SubWriterHolderWriter writer, ClassDoc classDoc) {
        super(writer, classDoc);
        VisibleMemberMap visibleMemberMap = new VisibleMemberMap(classDoc, 3, this.configuration().nodeprecated);
        ArrayList<ProgramElementDoc> constructors = new ArrayList<ProgramElementDoc>(visibleMemberMap.getMembersFor(classDoc));
        for (int i = 0; i < constructors.size(); ++i) {
            if (!((ProgramElementDoc)constructors.get(i)).isProtected() && !((ProgramElementDoc)constructors.get(i)).isPrivate()) continue;
            this.setFoundNonPubConstructor(true);
        }
    }

    public ConstructorWriterImpl(SubWriterHolderWriter writer) {
        super(writer);
    }

    public Content getMemberSummaryHeader(ClassDoc classDoc, Content memberSummaryTree) {
        memberSummaryTree.addContent(HtmlConstants.START_OF_CONSTRUCTOR_SUMMARY);
        Content memberTree = this.writer.getMemberTreeHeader();
        this.writer.addSummaryHeader(this, classDoc, memberTree);
        return memberTree;
    }

    public Content getConstructorDetailsTreeHeader(ClassDoc classDoc, Content memberDetailsTree) {
        memberDetailsTree.addContent(HtmlConstants.START_OF_CONSTRUCTOR_DETAILS);
        Content constructorDetailsTree = this.writer.getMemberTreeHeader();
        constructorDetailsTree.addContent(this.writer.getMarkerAnchor("constructor_detail"));
        HtmlTree heading = HtmlTree.HEADING(HtmlConstants.DETAILS_HEADING, this.writer.constructorDetailsLabel);
        constructorDetailsTree.addContent(heading);
        return constructorDetailsTree;
    }

    public Content getConstructorDocTreeHeader(ConstructorDoc constructor, Content constructorDetailsTree) {
        String erasureAnchor = this.getErasureAnchor((ExecutableMemberDoc)constructor);
        if (erasureAnchor != null) {
            constructorDetailsTree.addContent(this.writer.getMarkerAnchor(erasureAnchor));
        }
        constructorDetailsTree.addContent(this.writer.getMarkerAnchor(this.writer.getAnchor((ExecutableMemberDoc)constructor)));
        Content constructorDocTree = this.writer.getMemberTreeHeader();
        HtmlTree heading = new HtmlTree(HtmlConstants.MEMBER_HEADING);
        ((Content)heading).addContent(constructor.name());
        constructorDocTree.addContent(heading);
        return constructorDocTree;
    }

    public Content getSignature(ConstructorDoc constructor) {
        this.writer.displayLength = 0;
        HtmlTree pre = new HtmlTree(HtmlTag.PRE);
        this.writer.addAnnotationInfo((ProgramElementDoc)constructor, (Content)pre);
        this.addModifiers((MemberDoc)constructor, pre);
        if (this.configuration().linksource) {
            StringContent constructorName = new StringContent(constructor.name());
            this.writer.addSrcLink((ProgramElementDoc)constructor, constructorName, pre);
        } else {
            this.addName(constructor.name(), pre);
        }
        this.addParameters((ExecutableMemberDoc)constructor, pre);
        this.addExceptions((ExecutableMemberDoc)constructor, pre);
        return pre;
    }

    public void setSummaryColumnStyle(HtmlTree tdTree) {
        if (this.foundNonPubConstructor) {
            tdTree.addStyle(HtmlStyle.colLast);
        } else {
            tdTree.addStyle(HtmlStyle.colOne);
        }
    }

    public void addDeprecated(ConstructorDoc constructor, Content constructorDocTree) {
        this.addDeprecatedInfo((ProgramElementDoc)constructor, constructorDocTree);
    }

    public void addComments(ConstructorDoc constructor, Content constructorDocTree) {
        this.addComment((ProgramElementDoc)constructor, constructorDocTree);
    }

    public void addTags(ConstructorDoc constructor, Content constructorDocTree) {
        this.writer.addTagsInfo((Doc)constructor, constructorDocTree);
    }

    public Content getConstructorDetails(Content constructorDetailsTree) {
        return this.getMemberTree(constructorDetailsTree);
    }

    public Content getConstructorDoc(Content constructorDocTree, boolean isLastContent) {
        return this.getMemberTree(constructorDocTree, isLastContent);
    }

    public void close() throws IOException {
        this.writer.close();
    }

    public void setFoundNonPubConstructor(boolean foundNonPubConstructor) {
        this.foundNonPubConstructor = foundNonPubConstructor;
    }

    public void addSummaryLabel(Content memberTree) {
        HtmlTree label = HtmlTree.HEADING(HtmlConstants.SUMMARY_HEADING, this.writer.getResource("doclet.Constructor_Summary"));
        memberTree.addContent(label);
    }

    public String getTableSummary() {
        return this.configuration().getText("doclet.Member_Table_Summary", this.configuration().getText("doclet.Constructor_Summary"), this.configuration().getText("doclet.constructors"));
    }

    public String getCaption() {
        return this.configuration().getText("doclet.Constructors");
    }

    public String[] getSummaryTableHeader(ProgramElementDoc member) {
        String[] header = this.foundNonPubConstructor ? new String[]{this.configuration().getText("doclet.Modifier"), this.configuration().getText("doclet.0_and_1", this.configuration().getText("doclet.Constructor"), this.configuration().getText("doclet.Description"))} : new String[]{this.configuration().getText("doclet.0_and_1", this.configuration().getText("doclet.Constructor"), this.configuration().getText("doclet.Description"))};
        return header;
    }

    public void addSummaryAnchor(ClassDoc cd, Content memberTree) {
        memberTree.addContent(this.writer.getMarkerAnchor("constructor_summary"));
    }

    public void addInheritedSummaryAnchor(ClassDoc cd, Content inheritedTree) {
    }

    public void addInheritedSummaryLabel(ClassDoc cd, Content inheritedTree) {
    }

    public int getMemberKind() {
        return 3;
    }

    protected Content getNavSummaryLink(ClassDoc cd, boolean link) {
        if (link) {
            return this.writer.getHyperLink("", "constructor_summary", this.writer.getResource("doclet.navConstructor"));
        }
        return this.writer.getResource("doclet.navConstructor");
    }

    protected void addNavDetailLink(boolean link, Content liNav) {
        if (link) {
            liNav.addContent(this.writer.getHyperLink("", "constructor_detail", this.writer.getResource("doclet.navConstructor")));
        } else {
            liNav.addContent(this.writer.getResource("doclet.navConstructor"));
        }
    }

    protected void addSummaryType(ProgramElementDoc member, Content tdSummaryType) {
        if (this.foundNonPubConstructor) {
            HtmlTree code = new HtmlTree(HtmlTag.CODE);
            if (member.isProtected()) {
                ((Content)code).addContent("protected ");
            } else if (member.isPrivate()) {
                ((Content)code).addContent("private ");
            } else if (member.isPublic()) {
                ((Content)code).addContent(this.writer.getSpace());
            } else {
                ((Content)code).addContent(this.configuration().getText("doclet.Package_private"));
            }
            tdSummaryType.addContent(code);
        }
    }
}

