/*
 * Decompiled with CFR 0.152.
 */
package com.javafx.tools.doclets.formats.html;

import com.javafx.tools.doclets.formats.html.ConfigurationImpl;
import com.javafx.tools.doclets.formats.html.HtmlDocletWriter;
import com.javafx.tools.doclets.formats.html.markup.HtmlConstants;
import com.javafx.tools.doclets.formats.html.markup.HtmlTag;
import com.javafx.tools.doclets.formats.html.markup.HtmlTree;
import com.javafx.tools.doclets.internal.toolkit.Content;
import com.javafx.tools.doclets.internal.toolkit.util.DocletAbortException;
import java.io.IOException;

public class FrameOutputWriter
extends HtmlDocletWriter {
    int noOfPackages;
    private final String SCROLL_YES = "yes";

    public FrameOutputWriter(ConfigurationImpl configuration, String filename) throws IOException {
        super(configuration, filename);
        this.noOfPackages = configuration.packages.length;
    }

    public static void generate(ConfigurationImpl configuration) {
        String filename = "";
        try {
            filename = "index.html";
            FrameOutputWriter framegen = new FrameOutputWriter(configuration, filename);
            framegen.generateFrameFile();
            framegen.close();
        }
        catch (IOException exc) {
            configuration.standardmessage.error("doclet.exception_encountered", exc.toString(), filename);
            throw new DocletAbortException();
        }
    }

    protected void generateFrameFile() {
        Content frameset = this.getFrameDetails();
        if (this.configuration.windowtitle.length() > 0) {
            this.printFramesetDocument(this.configuration.windowtitle, this.configuration.notimestamp, frameset);
        } else {
            this.printFramesetDocument(this.configuration.getText("doclet.Generated_Docs_Untitled"), this.configuration.notimestamp, frameset);
        }
    }

    protected void addFrameWarning(Content contentTree) {
        HtmlTree noframes = new HtmlTree(HtmlTag.NOFRAMES);
        HtmlTree noScript = HtmlTree.NOSCRIPT(HtmlTree.DIV(this.getResource("doclet.No_Script_Message")));
        ((Content)noframes).addContent(noScript);
        HtmlTree noframesHead = HtmlTree.HEADING(HtmlConstants.CONTENT_HEADING, this.getResource("doclet.Frame_Alert"));
        ((Content)noframes).addContent(noframesHead);
        HtmlTree p = HtmlTree.P(this.getResource("doclet.Frame_Warning_Message", this.getHyperLinkString(this.configuration.topFile, this.configuration.getText("doclet.Non_Frame_Version"))));
        ((Content)noframes).addContent(p);
        contentTree.addContent(noframes);
    }

    protected Content getFrameDetails() {
        HtmlTree frameset = HtmlTree.FRAMESET("20%,80%", null, "Documentation frame", "top.loadFrames()");
        if (this.noOfPackages <= 1) {
            this.addAllClassesFrameTag(frameset);
        } else if (this.noOfPackages > 1) {
            HtmlTree leftFrameset = HtmlTree.FRAMESET(null, "30%,70%", "Left frames", "top.loadFrames()");
            this.addAllPackagesFrameTag(leftFrameset);
            this.addAllClassesFrameTag(leftFrameset);
            frameset.addContent(leftFrameset);
        }
        this.addClassFrameTag(frameset);
        this.addFrameWarning(frameset);
        return frameset;
    }

    private void addAllPackagesFrameTag(Content contentTree) {
        HtmlTree frame = HtmlTree.FRAME("overview-frame.html", "packageListFrame", this.configuration.getText("doclet.All_Packages"));
        contentTree.addContent(frame);
    }

    private void addAllClassesFrameTag(Content contentTree) {
        HtmlTree frame = HtmlTree.FRAME("allclasses-frame.html", "packageFrame", this.configuration.getText("doclet.All_classes_and_interfaces"));
        contentTree.addContent(frame);
    }

    private void addClassFrameTag(Content contentTree) {
        HtmlTree frame = HtmlTree.FRAME(this.configuration.topFile, "classFrame", this.configuration.getText("doclet.Package_class_and_interface_descriptions"), "yes");
        contentTree.addContent(frame);
    }
}

