/*
 * Decompiled with CFR 0.152.
 */
package com.javafx.tools.doclets.formats.html;

import com.javafx.tools.doclets.formats.html.AbstractTreeWriter;
import com.javafx.tools.doclets.formats.html.ConfigurationImpl;
import com.javafx.tools.doclets.formats.html.markup.HtmlConstants;
import com.javafx.tools.doclets.formats.html.markup.HtmlStyle;
import com.javafx.tools.doclets.formats.html.markup.HtmlTag;
import com.javafx.tools.doclets.formats.html.markup.HtmlTree;
import com.javafx.tools.doclets.internal.toolkit.Configuration;
import com.javafx.tools.doclets.internal.toolkit.Content;
import com.javafx.tools.doclets.internal.toolkit.util.ClassTree;
import com.javafx.tools.doclets.internal.toolkit.util.DirectoryManager;
import com.javafx.tools.doclets.internal.toolkit.util.DocletAbortException;
import com.javafx.tools.doclets.internal.toolkit.util.Util;
import com.sun.javadoc.PackageDoc;
import java.io.IOException;

public class PackageTreeWriter
extends AbstractTreeWriter {
    protected PackageDoc packagedoc;
    protected PackageDoc prev;
    protected PackageDoc next;

    public PackageTreeWriter(ConfigurationImpl configuration, String path, String filename, PackageDoc packagedoc, PackageDoc prev, PackageDoc next) throws IOException {
        super(configuration, path, filename, new ClassTree(configuration.classDocCatalog.allClasses(packagedoc), (Configuration)configuration), packagedoc);
        this.packagedoc = packagedoc;
        this.prev = prev;
        this.next = next;
    }

    public static void generate(ConfigurationImpl configuration, PackageDoc pkg, PackageDoc prev, PackageDoc next, boolean noDeprecated) {
        String path = DirectoryManager.getDirectoryPath(pkg);
        String filename = "package-tree.html";
        try {
            PackageTreeWriter packgen = new PackageTreeWriter(configuration, path, filename, pkg, prev, next);
            packgen.generatePackageTreeFile();
            packgen.close();
        }
        catch (IOException exc) {
            configuration.standardmessage.error("doclet.exception_encountered", exc.toString(), filename);
            throw new DocletAbortException();
        }
    }

    protected void generatePackageTreeFile() throws IOException {
        Content body = this.getPackageTreeHeader();
        Content headContent = this.getResource("doclet.Hierarchy_For_Package", Util.getPackageName(this.packagedoc));
        HtmlTree heading = HtmlTree.HEADING(HtmlConstants.TITLE_HEADING, false, HtmlStyle.title, headContent);
        HtmlTree div = HtmlTree.DIV(HtmlStyle.header, heading);
        if (this.configuration.packages.length > 1) {
            this.addLinkToMainTree(div);
        }
        body.addContent(div);
        HtmlTree divTree = new HtmlTree(HtmlTag.DIV);
        divTree.addStyle(HtmlStyle.contentContainer);
        this.addTree(this.classtree.baseclasses(), "doclet.Class_Hierarchy", divTree);
        this.addTree(this.classtree.baseinterfaces(), "doclet.Interface_Hierarchy", divTree);
        this.addTree(this.classtree.baseAnnotationTypes(), "doclet.Annotation_Type_Hierarchy", divTree);
        this.addTree(this.classtree.baseEnums(), "doclet.Enum_Hierarchy", divTree);
        body.addContent(divTree);
        this.addNavLinks(false, body);
        this.addBottom(body);
        this.printHtmlDocument(null, true, body);
    }

    protected Content getPackageTreeHeader() {
        String title = this.packagedoc.name() + " " + this.configuration.getText("doclet.Window_Class_Hierarchy");
        HtmlTree bodyTree = this.getBody(true, this.getWindowTitle(title));
        this.addTop(bodyTree);
        this.addNavLinks(true, bodyTree);
        return bodyTree;
    }

    protected void addLinkToMainTree(Content div) {
        HtmlTree span = HtmlTree.SPAN(HtmlStyle.strong, this.getResource("doclet.Package_Hierarchies"));
        div.addContent(span);
        HtmlTree ul = new HtmlTree(HtmlTag.UL);
        ul.addStyle(HtmlStyle.horizontal);
        ul.addContent(this.getNavLinkMainTree(this.configuration.getText("doclet.All_Packages")));
        div.addContent(ul);
    }

    protected Content getNavLinkPrevious() {
        if (this.prev == null) {
            return this.getNavLinkPrevious(null);
        }
        String path = DirectoryManager.getRelativePath(this.packagedoc.name(), this.prev.name());
        return this.getNavLinkPrevious(path + "package-tree.html");
    }

    protected Content getNavLinkNext() {
        if (this.next == null) {
            return this.getNavLinkNext(null);
        }
        String path = DirectoryManager.getRelativePath(this.packagedoc.name(), this.next.name());
        return this.getNavLinkNext(path + "package-tree.html");
    }

    protected Content getNavLinkPackage() {
        Content linkContent = this.getHyperLink("package-summary.html", "", this.packageLabel);
        HtmlTree li = HtmlTree.LI(linkContent);
        return li;
    }
}

