/*
 * Decompiled with CFR 0.152.
 */
package com.javafx.tools.doclets.internal.toolkit.builders;

import com.javafx.tools.doclets.internal.toolkit.AnnotationTypeWriter;
import com.javafx.tools.doclets.internal.toolkit.ClassWriter;
import com.javafx.tools.doclets.internal.toolkit.Configuration;
import com.javafx.tools.doclets.internal.toolkit.Content;
import com.javafx.tools.doclets.internal.toolkit.MemberSummaryWriter;
import com.javafx.tools.doclets.internal.toolkit.builders.AbstractMemberBuilder;
import com.javafx.tools.doclets.internal.toolkit.builders.XMLNode;
import com.javafx.tools.doclets.internal.toolkit.util.DocFinder;
import com.javafx.tools.doclets.internal.toolkit.util.Util;
import com.javafx.tools.doclets.internal.toolkit.util.VisibleMemberMap;
import com.sun.javadoc.AnnotationTypeDoc;
import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.MethodDoc;
import com.sun.javadoc.ProgramElementDoc;
import com.sun.javadoc.Tag;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MemberSummaryBuilder
extends AbstractMemberBuilder {
    public static final String NAME = "MemberSummary";
    private VisibleMemberMap[] visibleMemberMaps;
    private MemberSummaryWriter[] memberSummaryWriters;
    private ClassDoc classDoc;

    private MemberSummaryBuilder(Configuration configuration) {
        super(configuration);
    }

    public static MemberSummaryBuilder getInstance(ClassWriter classWriter, Configuration configuration) throws Exception {
        MemberSummaryBuilder builder = new MemberSummaryBuilder(configuration);
        builder.classDoc = classWriter.getClassDoc();
        builder.init(classWriter);
        return builder;
    }

    public static MemberSummaryBuilder getInstance(AnnotationTypeWriter annotationTypeWriter, Configuration configuration) throws Exception {
        MemberSummaryBuilder builder = new MemberSummaryBuilder(configuration);
        builder.classDoc = annotationTypeWriter.getAnnotationTypeDoc();
        builder.init(annotationTypeWriter);
        return builder;
    }

    private void init(Object writer) throws Exception {
        int i;
        this.visibleMemberMaps = new VisibleMemberMap[8];
        for (i = 0; i < 8; ++i) {
            this.visibleMemberMaps[i] = new VisibleMemberMap(this.classDoc, i, this.configuration.nodeprecated);
        }
        this.memberSummaryWriters = new MemberSummaryWriter[8];
        for (i = 0; i < 8; ++i) {
            this.memberSummaryWriters[i] = this.classDoc.isAnnotationType() ? (this.visibleMemberMaps[i].noVisibleMembers() ? null : this.configuration.getWriterFactory().getMemberSummaryWriter((AnnotationTypeWriter)writer, i)) : (this.visibleMemberMaps[i].noVisibleMembers() ? null : this.configuration.getWriterFactory().getMemberSummaryWriter((ClassWriter)writer, i));
        }
    }

    @Override
    public String getName() {
        return NAME;
    }

    public VisibleMemberMap getVisibleMemberMap(int type) {
        return this.visibleMemberMaps[type];
    }

    public MemberSummaryWriter getMemberSummaryWriter(int type) {
        return this.memberSummaryWriters[type];
    }

    public List<ProgramElementDoc> members(int type) {
        return this.visibleMemberMaps[type].getLeafClassMembers(this.configuration);
    }

    @Override
    public boolean hasMembersToDocument() {
        if (this.classDoc instanceof AnnotationTypeDoc) {
            return ((AnnotationTypeDoc)this.classDoc).elements().length > 0;
        }
        for (int i = 0; i < 8; ++i) {
            VisibleMemberMap members = this.visibleMemberMaps[i];
            if (members.noVisibleMembers()) continue;
            return true;
        }
        return false;
    }

    public void buildEnumConstantsSummary(XMLNode node, Content memberSummaryTree) {
        MemberSummaryWriter writer = this.memberSummaryWriters[1];
        VisibleMemberMap visibleMemberMap = this.visibleMemberMaps[1];
        this.addSummary(writer, visibleMemberMap, false, memberSummaryTree);
    }

    public void buildAnnotationTypeOptionalMemberSummary(XMLNode node, Content memberSummaryTree) {
        MemberSummaryWriter writer = this.memberSummaryWriters[5];
        VisibleMemberMap visibleMemberMap = this.visibleMemberMaps[5];
        this.addSummary(writer, visibleMemberMap, false, memberSummaryTree);
    }

    public void buildAnnotationTypeRequiredMemberSummary(XMLNode node, Content memberSummaryTree) {
        MemberSummaryWriter writer = this.memberSummaryWriters[6];
        VisibleMemberMap visibleMemberMap = this.visibleMemberMaps[6];
        this.addSummary(writer, visibleMemberMap, false, memberSummaryTree);
    }

    public void buildFieldsSummary(XMLNode node, Content memberSummaryTree) {
        MemberSummaryWriter writer = this.memberSummaryWriters[2];
        VisibleMemberMap visibleMemberMap = this.visibleMemberMaps[2];
        this.addSummary(writer, visibleMemberMap, true, memberSummaryTree);
    }

    public void buildPropertiesSummary(XMLNode node, Content memberSummaryTree) {
        MemberSummaryWriter writer = this.memberSummaryWriters[7];
        VisibleMemberMap visibleMemberMap = this.visibleMemberMaps[7];
        this.addSummary(writer, visibleMemberMap, true, memberSummaryTree);
    }

    public void buildNestedClassesSummary(XMLNode node, Content memberSummaryTree) {
        MemberSummaryWriter writer = this.memberSummaryWriters[0];
        VisibleMemberMap visibleMemberMap = this.visibleMemberMaps[0];
        this.addSummary(writer, visibleMemberMap, true, memberSummaryTree);
    }

    public void buildMethodsSummary(XMLNode node, Content memberSummaryTree) {
        MemberSummaryWriter writer = this.memberSummaryWriters[4];
        VisibleMemberMap visibleMemberMap = this.visibleMemberMaps[4];
        this.addSummary(writer, visibleMemberMap, true, memberSummaryTree);
    }

    public void buildConstructorsSummary(XMLNode node, Content memberSummaryTree) {
        MemberSummaryWriter writer = this.memberSummaryWriters[3];
        VisibleMemberMap visibleMemberMap = this.visibleMemberMaps[3];
        this.addSummary(writer, visibleMemberMap, false, memberSummaryTree);
    }

    private void buildSummary(MemberSummaryWriter writer, VisibleMemberMap visibleMemberMap, LinkedList<Content> summaryTreeList) {
        ArrayList<ProgramElementDoc> members = new ArrayList<ProgramElementDoc>(visibleMemberMap.getLeafClassMembers(this.configuration));
        if (members.size() > 0) {
            Collections.sort(members);
            Content tableTree = writer.getSummaryTableTree(this.classDoc);
            for (int i = 0; i < members.size(); ++i) {
                ProgramElementDoc member = (ProgramElementDoc)members.get(i);
                Tag[] firstSentenceTags = member.firstSentenceTags();
                if (member instanceof MethodDoc && firstSentenceTags.length == 0) {
                    DocFinder.Output inheritedDoc = DocFinder.search(new DocFinder.Input((MethodDoc)member));
                    if (inheritedDoc.holder != null && inheritedDoc.holder.firstSentenceTags().length > 0) {
                        firstSentenceTags = inheritedDoc.holder.firstSentenceTags();
                    }
                }
                writer.addMemberSummary(this.classDoc, member, firstSentenceTags, tableTree, i);
            }
            summaryTreeList.add(tableTree);
        }
    }

    private void buildInheritedSummary(MemberSummaryWriter writer, VisibleMemberMap visibleMemberMap, LinkedList<Content> summaryTreeList) {
        for (ClassDoc inhclass : visibleMemberMap.getVisibleClassesList()) {
            List<ProgramElementDoc> inhmembers;
            if (!inhclass.isPublic() && !Util.isLinkable(inhclass, this.configuration) || inhclass == this.classDoc || (inhmembers = visibleMemberMap.getMembersFor(inhclass)).size() <= 0) continue;
            Collections.sort(inhmembers);
            Content inheritedTree = writer.getInheritedSummaryHeader(inhclass);
            Content linksTree = writer.getInheritedSummaryLinksTree();
            for (int j = 0; j < inhmembers.size(); ++j) {
                writer.addInheritedMemberSummary(inhclass.isPackagePrivate() && !Util.isLinkable(inhclass, this.configuration) ? this.classDoc : inhclass, inhmembers.get(j), j == 0, j == inhmembers.size() - 1, linksTree);
            }
            inheritedTree.addContent(linksTree);
            summaryTreeList.add(writer.getMemberTree(inheritedTree));
        }
    }

    private void addSummary(MemberSummaryWriter writer, VisibleMemberMap visibleMemberMap, boolean showInheritedSummary, Content memberSummaryTree) {
        LinkedList<Content> summaryTreeList = new LinkedList<Content>();
        this.buildSummary(writer, visibleMemberMap, summaryTreeList);
        if (showInheritedSummary) {
            this.buildInheritedSummary(writer, visibleMemberMap, summaryTreeList);
        }
        if (!summaryTreeList.isEmpty()) {
            Content memberTree = writer.getMemberSummaryHeader(this.classDoc, memberSummaryTree);
            for (int i = 0; i < summaryTreeList.size(); ++i) {
                memberTree.addContent(summaryTreeList.get(i));
            }
            memberSummaryTree.addContent(writer.getMemberTree(memberTree));
        }
    }
}

