/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.console.ui.notification.action;

import com.jrockit.mc.console.ui.notification.action.Messages;
import com.jrockit.mc.console.ui.notification.action.WriteAndOpenRecordingJob;
import com.jrockit.mc.core.MCFile;
import com.jrockit.mc.core.idesupport.IDESupportToolkit;
import com.jrockit.mc.rjmx.IConnectionHandle;
import com.jrockit.mc.rjmx.RJMXPlugin;
import com.jrockit.mc.rjmx.services.flr.FlightRecorderException;
import com.jrockit.mc.rjmx.services.flr.FlightRecorderToolkit;
import com.jrockit.mc.rjmx.services.flr.IFlightRecorderService;
import com.jrockit.mc.rjmx.triggers.TriggerAction;
import com.jrockit.mc.rjmx.triggers.TriggerEvent;
import com.jrockit.mc.ui.misc.DisplayToolkit;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.osgi.util.NLS;

public class TriggerActionDumpJFR
extends TriggerAction {
    public void handleNotificationEvent(final TriggerEvent event) {
        final IFlightRecorderService service = (IFlightRecorderService)event.getSource().getServiceOrNull(IFlightRecorderService.class);
        if (service == null) {
            RJMXPlugin.getDefault().getLogger().severe("There is no flight recorder available on the " + event.getSource() + " JVM");
            return;
        }
        DisplayToolkit.safeAsyncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                Job job = TriggerActionDumpJFR.this.createDumpFlightRecordingJob(event, service);
                job.schedule();
            }
        });
    }

    protected Job createDumpFlightRecordingJob(TriggerEvent event, IFlightRecorderService service) {
        MCFile path = IDESupportToolkit.createFileResource((String)this.getSetting("file").getFileName());
        Long timerange = this.getSetting("timerange").getLong();
        Boolean open = this.getSetting("open").getBoolean();
        return new WriteAndOpenRecordingJob(NLS.bind((String)Messages.TriggerActionJFR_DUMPING_JOB_NAME, (Object)event.getRule().getName()), event.getSource().getServerDescriptor().getDisplayName(), service, path, timerange, open, event);
    }

    public boolean supportsAction(IConnectionHandle handle) {
        IFlightRecorderService jfrService = (IFlightRecorderService)handle.getServiceOrNull(IFlightRecorderService.class);
        try {
            return jfrService != null && jfrService.isEnabled() && FlightRecorderToolkit.getDescriptorByTimerange((List)jfrService.getAvailableRecordings(), (Long)0L) != null;
        }
        catch (FlightRecorderException e) {
            RJMXPlugin.getDefault().getLogger().log(Level.SEVERE, "Got exception when checking for available recordings in JVM", e);
            return false;
        }
    }
}

