/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.ArrayList;
import java.util.Vector;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.sql.compile.NodeFactory;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.util.JBitSet;
import org.apache.derby.impl.sql.compile.AndNode;
import org.apache.derby.impl.sql.compile.BinaryComparisonOperatorNode;
import org.apache.derby.impl.sql.compile.BooleanConstantNode;
import org.apache.derby.impl.sql.compile.ConstantNode;
import org.apache.derby.impl.sql.compile.ExpressionClassBuilder;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.FromTable;
import org.apache.derby.impl.sql.compile.PredicateList;
import org.apache.derby.impl.sql.compile.ResultColumn;
import org.apache.derby.impl.sql.compile.ResultColumnList;
import org.apache.derby.impl.sql.compile.ResultSetNode;
import org.apache.derby.impl.sql.compile.SubqueryList;
import org.apache.derby.impl.sql.compile.TableName;
import org.apache.derby.impl.sql.compile.ValueNode;
import org.apache.derby.impl.sql.compile.VirtualColumnNode;

public class ColumnReference
extends ValueNode {
    String columnName;
    TableName tableName;
    private int tableNumber;
    private int columnNumber;
    private ResultColumn source;
    ResultColumn origSource;
    private String origName;
    int origTableNumber = -1;
    int origColumnNumber = -1;
    private int tableNumberBeforeFlattening = -1;
    private int columnNumberBeforeFlattening = -1;
    private boolean replacesAggregate;
    private boolean replacesWindowFunctionCall;
    private int nestingLevel = -1;
    private int sourceLevel = -1;
    private boolean scoped;
    private ArrayList remaps;

    public void init(Object object, Object object2, Object object3, Object object4) {
        this.columnName = (String)object;
        this.tableName = (TableName)object2;
        this.setBeginOffset((Integer)object3);
        this.setEndOffset((Integer)object4);
        this.tableNumber = -1;
        this.remaps = null;
    }

    public void init(Object object, Object object2) {
        this.columnName = (String)object;
        this.tableName = (TableName)object2;
        this.tableNumber = -1;
        this.remaps = null;
    }

    public String toString() {
        return "";
    }

    public void printSubNodes(int n) {
    }

    boolean getCorrelated() {
        return this.sourceLevel != this.nestingLevel;
    }

    void setNestingLevel(int n) {
        this.nestingLevel = n;
    }

    private int getNestingLevel() {
        return this.nestingLevel;
    }

    void setSourceLevel(int n) {
        this.sourceLevel = n;
    }

    int getSourceLevel() {
        return this.sourceLevel;
    }

    public void markGeneratedToReplaceAggregate() {
        this.replacesAggregate = true;
    }

    public void markGeneratedToReplaceWindowFunctionCall() {
        this.replacesWindowFunctionCall = true;
    }

    public boolean getGeneratedToReplaceAggregate() {
        return this.replacesAggregate;
    }

    public boolean getGeneratedToReplaceWindowFunctionCall() {
        return this.replacesWindowFunctionCall;
    }

    public ValueNode getClone() throws StandardException {
        ColumnReference columnReference = (ColumnReference)this.getNodeFactory().getNode(62, this.columnName, this.tableName, this.getContextManager());
        columnReference.copyFields(this);
        return columnReference;
    }

    public void copyFields(ColumnReference columnReference) throws StandardException {
        super.copyFields(columnReference);
        this.tableName = columnReference.getTableNameNode();
        this.tableNumber = columnReference.getTableNumber();
        this.columnNumber = columnReference.getColumnNumber();
        this.source = columnReference.getSource();
        this.nestingLevel = columnReference.getNestingLevel();
        this.sourceLevel = columnReference.getSourceLevel();
        this.replacesAggregate = columnReference.getGeneratedToReplaceAggregate();
        this.replacesWindowFunctionCall = columnReference.getGeneratedToReplaceWindowFunctionCall();
        this.scoped = columnReference.isScoped();
    }

    public ValueNode bindExpression(FromList fromList, SubqueryList subqueryList, Vector vector) throws StandardException {
        if (fromList.size() == 0) {
            throw StandardException.newException("42X15", this.columnName);
        }
        ResultColumn resultColumn = fromList.bindColumnReference(this);
        if (resultColumn == null) {
            throw StandardException.newException("42X04", this.getSQLColumnName());
        }
        return this;
    }

    public String getSQLColumnName() {
        if (this.tableName == null) {
            return this.columnName;
        }
        return this.tableName.toString() + "." + this.columnName;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public int getTableNumber() {
        return this.tableNumber;
    }

    public void setTableNumber(int n) {
        this.tableNumber = n;
    }

    public String getTableName() {
        return this.tableName != null ? this.tableName.getTableName() : null;
    }

    public String getSourceTableName() {
        return this.source != null ? this.source.getTableName() : null;
    }

    public String getSourceSchemaName() throws StandardException {
        return this.source != null ? this.source.getSchemaName() : null;
    }

    public boolean updatableByCursor() {
        return this.source != null ? this.source.updatableByCursor() : false;
    }

    public TableName getTableNameNode() {
        return this.tableName;
    }

    public void setTableNameNode(TableName tableName) {
        this.tableName = tableName;
    }

    public int getColumnNumber() {
        return this.columnNumber;
    }

    public void setColumnNumber(int n) {
        this.columnNumber = n;
    }

    public ResultColumn getSource() {
        return this.source;
    }

    public void setSource(ResultColumn resultColumn) {
        this.source = resultColumn;
    }

    public ValueNode putAndsOnTop() throws StandardException {
        NodeFactory nodeFactory = this.getNodeFactory();
        BooleanConstantNode booleanConstantNode = (BooleanConstantNode)nodeFactory.getNode(38, Boolean.TRUE, this.getContextManager());
        BinaryComparisonOperatorNode binaryComparisonOperatorNode = (BinaryComparisonOperatorNode)nodeFactory.getNode(41, this, booleanConstantNode, Boolean.FALSE, this.getContextManager());
        binaryComparisonOperatorNode.bindComparisonOperator();
        ValueNode valueNode = (ValueNode)nodeFactory.getNode(39, binaryComparisonOperatorNode, booleanConstantNode, this.getContextManager());
        ((AndNode)valueNode).postBindFixup();
        return valueNode;
    }

    public boolean categorize(JBitSet jBitSet, boolean bl) {
        jBitSet.set(this.tableNumber);
        return !this.replacesAggregate && !this.replacesWindowFunctionCall && (this.source.getExpression() instanceof ColumnReference || this.source.getExpression() instanceof VirtualColumnNode || this.source.getExpression() instanceof ConstantNode);
    }

    public void remapColumnReferences() {
        ValueNode valueNode = this.source.getExpression();
        if (!(valueNode instanceof VirtualColumnNode) && !(valueNode instanceof ColumnReference)) {
            return;
        }
        if (this.scoped && this.origSource != null) {
            if (this.remaps == null) {
                this.remaps = new ArrayList();
            }
            this.remaps.add(new RemapInfo(this.columnNumber, this.tableNumber, this.columnName, this.source));
        } else {
            this.origSource = this.source;
            this.origName = this.columnName;
            this.origColumnNumber = this.columnNumber;
            this.origTableNumber = this.tableNumber;
        }
        this.source = this.getSourceResultColumn();
        this.columnName = this.source.getName();
        int n = this.columnNumber = this.source.getExpression() instanceof VirtualColumnNode ? this.source.getVirtualColumnId() : this.source.getColumnPosition();
        if (this.source.getExpression() instanceof ColumnReference) {
            ColumnReference columnReference = (ColumnReference)this.source.getExpression();
            this.tableNumber = columnReference.getTableNumber();
        }
    }

    public void unRemapColumnReferences() {
        if (this.origSource == null) {
            return;
        }
        if (this.remaps == null || this.remaps.size() == 0) {
            this.source = this.origSource;
            this.origSource = null;
            this.columnName = this.origName;
            this.origName = null;
            this.tableNumber = this.origTableNumber;
            this.columnNumber = this.origColumnNumber;
        } else {
            RemapInfo remapInfo = (RemapInfo)this.remaps.remove(this.remaps.size() - 1);
            this.source = remapInfo.getSource();
            this.columnName = remapInfo.getColumnName();
            this.tableNumber = remapInfo.getTableNumber();
            this.columnNumber = remapInfo.getColumnNumber();
            remapInfo = null;
            if (this.remaps.size() == 0) {
                this.remaps = null;
            }
        }
    }

    protected boolean hasBeenRemapped() {
        return this.origSource != null;
    }

    public ResultColumn getSourceResultColumn() {
        return this.source.getExpression().getSourceResultColumn();
    }

    public ValueNode remapColumnReferencesToExpressions() throws StandardException {
        ValueNode valueNode;
        ValueNode valueNode2 = this.source;
        if (!this.source.isRedundant()) {
            return this;
        }
        ValueNode valueNode3 = this.source;
        while (valueNode3 != null && valueNode3.isRedundant()) {
            valueNode = valueNode3.getExpression().getSourceResultColumn();
            if (valueNode != null && ((ResultColumn)valueNode).isRedundant()) {
                valueNode2 = valueNode;
            }
            valueNode3 = valueNode;
        }
        if (((ResultColumn)valueNode2).getExpression() instanceof VirtualColumnNode) {
            valueNode = (VirtualColumnNode)((ResultColumn)valueNode2).getExpression();
            ResultSetNode resultSetNode = ((VirtualColumnNode)valueNode).getSourceResultSet();
            if (resultSetNode instanceof FromTable) {
                FromTable fromTable = (FromTable)resultSetNode;
                ResultColumnList resultColumnList = fromTable.getResultColumns();
                ResultColumn resultColumn = null;
                if (this.tableNumberBeforeFlattening == -1) {
                    this.tableNumberBeforeFlattening = this.tableNumber;
                    this.columnNumberBeforeFlattening = this.columnNumber;
                }
                if ((resultColumn = resultColumnList.getResultColumn(this.tableNumberBeforeFlattening, this.columnNumberBeforeFlattening, this.columnName)) == null) {
                    resultColumn = resultColumnList.getResultColumn(this.columnName);
                }
                this.tableNumber = fromTable.getTableNumber();
                this.columnNumber = resultColumn.getExpression() instanceof VirtualColumnNode ? resultColumn.getVirtualColumnId() : resultColumn.getColumnPosition();
            }
            this.source = ((ResultColumn)valueNode2).getExpression().getSourceResultColumn();
            return this;
        }
        return ((ResultColumn)valueNode2).getExpression().getClone();
    }

    void getTablesReferenced(JBitSet jBitSet) {
        if (jBitSet.size() < this.tableNumber) {
            jBitSet.grow(this.tableNumber);
        }
        if (this.tableNumber != -1) {
            jBitSet.set(this.tableNumber);
        }
    }

    public boolean isCloneable() {
        return true;
    }

    public boolean constantExpression(PredicateList predicateList) {
        return predicateList.constantColumn(this);
    }

    public void generateExpression(ExpressionClassBuilder expressionClassBuilder, MethodBuilder methodBuilder) throws StandardException {
        int n = this.source.getResultSetNumber();
        if (this.source.isRedundant()) {
            this.source.generateExpression(expressionClassBuilder, methodBuilder);
            return;
        }
        expressionClassBuilder.pushColumnReference(methodBuilder, n, this.source.getVirtualColumnId());
        methodBuilder.cast(this.getTypeCompiler().interfaceName());
    }

    public String getSchemaName() {
        return this.tableName != null ? this.tableName.getSchemaName() : null;
    }

    protected int getOrderableVariantType() {
        return 1;
    }

    boolean pointsToColumnReference() {
        return this.source.getExpression() instanceof ColumnReference;
    }

    public DataTypeDescriptor getTypeServices() {
        if (this.source == null) {
            return super.getTypeServices();
        }
        return this.source.getTypeServices();
    }

    protected ResultSetNode getSourceResultSet(int[] nArray) throws StandardException {
        if (this.source == null) {
            return null;
        }
        ValueNode valueNode = null;
        ResultColumn resultColumn = this.getSource();
        valueNode = resultColumn.getExpression();
        nArray[0] = this.getColumnNumber();
        while (valueNode != null && (resultColumn.isRedundant() || valueNode instanceof ColumnReference)) {
            if (valueNode instanceof ColumnReference) {
                nArray[0] = ((ColumnReference)valueNode).getColumnNumber();
                resultColumn = ((ColumnReference)valueNode).getSource();
            }
            while (resultColumn.isRedundant()) {
                valueNode = resultColumn.getExpression();
                if (valueNode instanceof VirtualColumnNode) {
                    resultColumn = valueNode.getSourceResultColumn();
                    continue;
                }
                if (valueNode instanceof ColumnReference) {
                    nArray[0] = ((ColumnReference)valueNode).getColumnNumber();
                    resultColumn = ((ColumnReference)valueNode).getSource();
                    continue;
                }
                valueNode = null;
                break;
            }
            valueNode = resultColumn.getExpression();
        }
        if (valueNode != null && valueNode instanceof VirtualColumnNode) {
            return ((VirtualColumnNode)valueNode).getSourceResultSet();
        }
        nArray[0] = -1;
        return null;
    }

    protected boolean isEquivalent(ValueNode valueNode) throws StandardException {
        if (!this.isSameNodeType(valueNode)) {
            return false;
        }
        ColumnReference columnReference = (ColumnReference)valueNode;
        return this.tableNumber == columnReference.tableNumber && this.columnName.equals(columnReference.getColumnName());
    }

    protected void markAsScoped() {
        this.scoped = true;
    }

    protected boolean isScoped() {
        return this.scoped;
    }

    private class RemapInfo {
        int colNum;
        int tableNum;
        String colName;
        ResultColumn source;

        RemapInfo(int n, int n2, String string, ResultColumn resultColumn) {
            this.colNum = n;
            this.tableNum = n2;
            this.colName = string;
            this.source = resultColumn;
        }

        int getColumnNumber() {
            return this.colNum;
        }

        int getTableNumber() {
            return this.tableNum;
        }

        String getColumnName() {
            return this.colName;
        }

        ResultColumn getSource() {
            return this.source;
        }

        void setColNumber(int n) {
            this.colNum = n;
        }

        void setTableNumber(int n) {
            this.tableNum = n;
        }

        void setColName(String string) {
            this.colName = string;
        }

        void setSource(ResultColumn resultColumn) {
            this.source = resultColumn;
        }
    }
}

