/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Vector;
import org.apache.derby.catalog.DefaultInfo;
import org.apache.derby.catalog.TypeDescriptor;
import org.apache.derby.catalog.UUID;
import org.apache.derby.catalog.types.RoutineAliasInfo;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.compiler.LocalField;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.services.io.FormatableHashtable;
import org.apache.derby.iapi.services.loader.ClassInspector;
import org.apache.derby.iapi.sql.compile.CostEstimate;
import org.apache.derby.iapi.sql.compile.Optimizable;
import org.apache.derby.iapi.sql.compile.OptimizablePredicate;
import org.apache.derby.iapi.sql.compile.OptimizablePredicateList;
import org.apache.derby.iapi.sql.compile.Optimizer;
import org.apache.derby.iapi.sql.compile.RowOrdering;
import org.apache.derby.iapi.sql.compile.Visitor;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.dictionary.ColumnDescriptor;
import org.apache.derby.iapi.sql.dictionary.ColumnDescriptorList;
import org.apache.derby.iapi.sql.dictionary.ConglomerateDescriptor;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.sql.execute.ExecutionContext;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.util.JBitSet;
import org.apache.derby.impl.sql.compile.ActivationClassBuilder;
import org.apache.derby.impl.sql.compile.AndNode;
import org.apache.derby.impl.sql.compile.BinaryRelationalOperatorNode;
import org.apache.derby.impl.sql.compile.CollectNodesVisitor;
import org.apache.derby.impl.sql.compile.ColumnReference;
import org.apache.derby.impl.sql.compile.ConstantNode;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.FromTable;
import org.apache.derby.impl.sql.compile.GroupByList;
import org.apache.derby.impl.sql.compile.IsNullNode;
import org.apache.derby.impl.sql.compile.JavaValueNode;
import org.apache.derby.impl.sql.compile.MethodCallNode;
import org.apache.derby.impl.sql.compile.NewInvocationNode;
import org.apache.derby.impl.sql.compile.OrNode;
import org.apache.derby.impl.sql.compile.ParameterNode;
import org.apache.derby.impl.sql.compile.Predicate;
import org.apache.derby.impl.sql.compile.PredicateList;
import org.apache.derby.impl.sql.compile.RemapCRsVisitor;
import org.apache.derby.impl.sql.compile.ResultColumn;
import org.apache.derby.impl.sql.compile.ResultColumnList;
import org.apache.derby.impl.sql.compile.ResultSetNode;
import org.apache.derby.impl.sql.compile.SubqueryList;
import org.apache.derby.impl.sql.compile.TableName;
import org.apache.derby.impl.sql.compile.ValueNode;
import org.apache.derby.vti.DeferModification;
import org.apache.derby.vti.RestrictedVTI;
import org.apache.derby.vti.Restriction;
import org.apache.derby.vti.VTICosting;
import org.apache.derby.vti.VTIEnvironment;

public class FromVTI
extends FromTable
implements VTIEnvironment {
    JBitSet correlationMap;
    JBitSet dependencyMap;
    MethodCallNode methodCall;
    TableName exposedName;
    SubqueryList subqueryList;
    boolean implementsVTICosting;
    boolean optimized;
    boolean materializable;
    boolean isTarget;
    boolean isDerbyStyleTableFunction;
    boolean isRestrictedTableFunction;
    ResultSet rs;
    private FormatableHashtable compileTimeConstants;
    protected int numVTICols;
    private PredicateList restrictionList;
    private boolean forUpdatePresent;
    private boolean emptyForUpdate;
    double estimatedCost = 100000.0;
    double estimatedRowCount = 10000.0;
    boolean supportsMultipleInstantiations = true;
    boolean vtiCosted;
    protected boolean version2;
    private boolean implementsPushable;
    private PreparedStatement ps;
    private JavaValueNode[] methodParms;
    private boolean controlsDeferral;
    private boolean isInsensitive;
    private int resultSetType = 1003;
    private String[] projectedColumnNames;
    private Restriction vtiRestriction;

    public void init(Object object, Object object2, Object object3, Object object4) throws StandardException {
        this.init(object, object2, object3, object4, this.makeTableName(null, (String)object2));
    }

    public void init(Object object, Object object2, Object object3, Object object4, Object object5) throws StandardException {
        super.init(object2, object4);
        this.methodCall = (MethodCallNode)object;
        this.resultColumns = (ResultColumnList)object3;
        this.subqueryList = (SubqueryList)this.getNodeFactory().getNode(11, this.getContextManager());
        this.exposedName = (TableName)object5;
    }

    public CostEstimate estimateCost(OptimizablePredicateList optimizablePredicateList, ConglomerateDescriptor conglomerateDescriptor, CostEstimate costEstimate, Optimizer optimizer, RowOrdering rowOrdering) throws StandardException {
        this.costEstimate = this.getCostEstimate(optimizer);
        if (this.implementsVTICosting && !this.vtiCosted) {
            try {
                VTICosting vTICosting = this.getVTICosting();
                this.estimatedCost = vTICosting.getEstimatedCostPerInstantiation(this);
                this.estimatedRowCount = vTICosting.getEstimatedRowCount(this);
                this.supportsMultipleInstantiations = vTICosting.supportsMultipleInstantiations(this);
                if (this.ps != null) {
                    this.ps.close();
                    this.ps = null;
                }
                if (this.rs != null) {
                    this.rs.close();
                    this.rs = null;
                }
            }
            catch (SQLException sQLException) {
                throw StandardException.unexpectedUserException(sQLException);
            }
            this.vtiCosted = true;
        }
        this.costEstimate.setCost(this.estimatedCost, this.estimatedRowCount, this.estimatedRowCount);
        if (this.getCurrentAccessPath().getJoinStrategy().multiplyBaseCostByOuterRows()) {
            this.costEstimate.multiply(costEstimate.rowCount(), this.costEstimate);
        }
        if (!this.optimized) {
            this.subqueryList.optimize(optimizer.getDataDictionary(), this.costEstimate.rowCount());
            this.subqueryList.modifyAccessPaths();
        }
        this.optimized = true;
        return this.costEstimate;
    }

    public boolean legalJoinOrder(JBitSet jBitSet) {
        JBitSet jBitSet2 = jBitSet;
        jBitSet2.or(this.correlationMap);
        return jBitSet2.contains(this.dependencyMap);
    }

    public boolean isMaterializable() {
        return this.materializable;
    }

    public boolean supportsMultipleInstantiations() {
        return this.supportsMultipleInstantiations;
    }

    public boolean isDerbyStyleTableFunction() {
        return this.isDerbyStyleTableFunction;
    }

    public void adjustForSortElimination() {
    }

    public Optimizable modifyAccessPath(JBitSet jBitSet) throws StandardException {
        if (this.rs != null) {
            try {
                this.rs.close();
                this.rs = null;
            }
            catch (Throwable throwable) {
                throw StandardException.unexpectedUserException(throwable);
            }
        }
        return super.modifyAccessPath(jBitSet);
    }

    public boolean pushOptPredicate(OptimizablePredicate optimizablePredicate) throws StandardException {
        if (!this.implementsPushable) {
            return false;
        }
        if (!optimizablePredicate.getReferencedMap().hasSingleBitSet()) {
            return false;
        }
        if (this.restrictionList == null) {
            this.restrictionList = (PredicateList)this.getNodeFactory().getNode(8, this.getContextManager());
        }
        this.restrictionList.addPredicate((Predicate)optimizablePredicate);
        return true;
    }

    public String toString() {
        return "";
    }

    public void printSubNodes(int n) {
    }

    public boolean isConstructor() {
        return this.methodCall instanceof NewInvocationNode;
    }

    public MethodCallNode getMethodCall() {
        return this.methodCall;
    }

    public String getExposedName() {
        return this.correlationName;
    }

    public TableName getExposedTableName() {
        return this.exposedName;
    }

    void setTarget() {
        this.isTarget = true;
        this.version2 = true;
    }

    public ResultSetNode bindNonVTITables(DataDictionary dataDictionary, FromList fromList) throws StandardException {
        if (this.tableNumber == -1) {
            this.tableNumber = this.getCompilerContext().getNextTableNumber();
        }
        return this;
    }

    String getVTIName() {
        return this.methodCall.getJavaClassName();
    }

    public ResultSetNode bindVTITables(FromList fromList) throws StandardException {
        Object object;
        ResultColumnList resultColumnList = this.resultColumns;
        LanguageConnectionContext languageConnectionContext = this.getLanguageConnectionContext();
        Vector vector = new Vector();
        this.methodCall.bindExpression(fromList, this.subqueryList, vector);
        this.methodParms = this.methodCall.getMethodParms();
        RoutineAliasInfo routineAliasInfo = this.methodCall.getRoutineInfo();
        if (routineAliasInfo != null && routineAliasInfo.getReturnType().isRowMultiSet() && routineAliasInfo.getParameterStyle() == 1) {
            this.isDerbyStyleTableFunction = true;
        }
        if (this.isDerbyStyleTableFunction) {
            object = (Method)this.methodCall.getResolvedMethod();
            this.isRestrictedTableFunction = RestrictedVTI.class.isAssignableFrom(((Method)object).getReturnType());
        }
        if (this.isConstructor()) {
            object = (NewInvocationNode)this.methodCall;
            if (!((NewInvocationNode)object).assignableTo("java.sql.PreparedStatement")) {
                if (this.version2) {
                    throw StandardException.newException("42X08", (Object)this.getVTIName(), (Object)"java.sql.PreparedStatement");
                }
                if (!((NewInvocationNode)object).assignableTo("java.sql.ResultSet")) {
                    throw StandardException.newException("42X08", (Object)this.getVTIName(), (Object)"java.sql.ResultSet");
                }
            } else {
                this.version2 = true;
            }
            if (this.version2) {
                this.implementsPushable = ((NewInvocationNode)object).assignableTo("org.apache.derby.vti.IQualifyable");
            }
            this.implementsVTICosting = ((NewInvocationNode)object).assignableTo("org.apache.derby.vti.VTICosting");
        }
        if (this.isDerbyStyleTableFunction) {
            this.implementsVTICosting = this.implementsDerbyStyleVTICosting(this.methodCall.getJavaClassName());
        }
        if (this.isConstructor() && (object = this.getSpecialTriggerVTITableName(languageConnectionContext, this.methodCall.getJavaClassName())) != null) {
            TableDescriptor tableDescriptor = this.getDataDictionary().getTableDescriptor((UUID)object);
            this.resultColumns = this.genResultColList(tableDescriptor);
            this.vtiCosted = true;
            this.estimatedCost = 50.0;
            this.estimatedRowCount = 5.0;
            this.supportsMultipleInstantiations = true;
        } else {
            this.resultColumns = (ResultColumnList)this.getNodeFactory().getNode(9, this.getContextManager());
            if (this.isDerbyStyleTableFunction) {
                this.createResultColumnsForTableFunction(routineAliasInfo.getReturnType());
            } else {
                ResultSetMetaData resultSetMetaData = this.getResultSetMetaData();
                if (resultSetMetaData == null) {
                    throw StandardException.newException("42X43", this.getVTIName());
                }
                try {
                    this.numVTICols = resultSetMetaData.getColumnCount();
                }
                catch (SQLException sQLException) {
                    this.numVTICols = 0;
                }
                this.resultColumns.createListFromResultSetMetaData(resultSetMetaData, this.exposedName, this.getVTIName());
            }
        }
        this.numVTICols = this.resultColumns.size();
        if (resultColumnList != null) {
            this.resultColumns.propagateDCLInfo(resultColumnList, this.correlationName);
        }
        return this;
    }

    public ResultSetMetaData getResultSetMetaData() throws StandardException {
        ResultSetMetaData resultSetMetaData;
        block10: {
            resultSetMetaData = null;
            try {
                if (this.version2) {
                    this.ps = (PreparedStatement)this.getNewInstance();
                    if (this.ps.getResultSetConcurrency() != 1008) {
                        throw StandardException.newException("42Z90", this.getVTIName());
                    }
                    resultSetMetaData = this.ps.getMetaData();
                    this.controlsDeferral = this.ps instanceof DeferModification;
                    try {
                        this.resultSetType = this.ps.getResultSetType();
                    }
                    catch (SQLException sQLException) {
                    }
                    catch (AbstractMethodError abstractMethodError) {
                    }
                    catch (NoSuchMethodError noSuchMethodError) {
                        // empty catch block
                    }
                    boolean bl = this.isInsensitive = this.resultSetType == 1004;
                    if (!this.implementsVTICosting) {
                        this.ps.close();
                        this.ps = null;
                    }
                    break block10;
                }
                this.rs = (ResultSet)this.getNewInstance();
                resultSetMetaData = this.rs.getMetaData();
                if (!this.implementsVTICosting) {
                    this.rs.close();
                    this.rs = null;
                }
            }
            catch (Throwable throwable) {
                throw StandardException.unexpectedUserException(throwable);
            }
        }
        return resultSetMetaData;
    }

    private Object getNewInstance() throws StandardException {
        Object object;
        NewInvocationNode newInvocationNode = (NewInvocationNode)this.methodCall;
        Class[] classArray = newInvocationNode.getMethodParameterClasses();
        Object[] objectArray = null;
        if (classArray != null) {
            objectArray = new Object[classArray.length];
            for (int i = 0; i < classArray.length; ++i) {
                object = classArray[i];
                objectArray[i] = this.methodParms[i].getConstantValueAsObject();
                if (objectArray[i] != null && ((Class)object).isPrimitive()) {
                    if (object.equals(Short.TYPE)) {
                        objectArray[i] = new Short(((Integer)objectArray[i]).shortValue());
                    } else if (object.equals(Byte.TYPE)) {
                        objectArray[i] = new Byte(((Integer)objectArray[i]).byteValue());
                    }
                }
                if (objectArray[i] != null || !((Class)object).isPrimitive()) continue;
                if (object.equals(Integer.TYPE)) {
                    objectArray[i] = new Integer(0);
                    continue;
                }
                if (object.equals(Short.TYPE)) {
                    objectArray[i] = new Short(0);
                    continue;
                }
                if (object.equals(Byte.TYPE)) {
                    objectArray[i] = new Byte(0);
                    continue;
                }
                if (object.equals(Long.TYPE)) {
                    objectArray[i] = new Long(0L);
                    continue;
                }
                if (object.equals(Float.TYPE)) {
                    objectArray[i] = new Float(0.0f);
                    continue;
                }
                if (object.equals(Double.TYPE)) {
                    objectArray[i] = new Double(0.0);
                    continue;
                }
                if (object.equals(Boolean.TYPE)) {
                    objectArray[i] = Boolean.FALSE;
                    continue;
                }
                if (!object.equals(Character.TYPE)) continue;
                objectArray[i] = new Character('\u0000');
            }
        } else {
            classArray = new Class[]{};
            objectArray = new Object[]{};
        }
        try {
            ClassInspector classInspector = this.getClassFactory().getClassInspector();
            object = this.methodCall.getJavaClassName();
            Constructor constructor = classInspector.getClass((String)object).getConstructor(classArray);
            return constructor.newInstance(objectArray);
        }
        catch (Throwable throwable) {
            Throwable throwable2;
            if (throwable instanceof InvocationTargetException && (throwable2 = ((InvocationTargetException)(object = (InvocationTargetException)throwable)).getTargetException()) instanceof StandardException) {
                throw (StandardException)throwable2;
            }
            throw StandardException.unexpectedUserException(throwable);
        }
    }

    public DeferModification getDeferralControl() throws StandardException {
        if (!this.controlsDeferral) {
            return null;
        }
        try {
            return (DeferModification)this.getNewInstance();
        }
        catch (Throwable throwable) {
            throw StandardException.unexpectedUserException(throwable);
        }
    }

    public int getResultSetType() {
        return this.resultSetType;
    }

    public void bindExpressions(FromList fromList) throws StandardException {
        ResultColumnList resultColumnList = this.resultColumns;
        this.materializable = this.methodCall.areParametersQueryInvariant();
        Vector vector = this.getNodesFromParameters(ColumnReference.class);
        Vector vector2 = null;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            ColumnReference columnReference = (ColumnReference)enumeration.nextElement();
            if (columnReference.getTableNumber() != -1) continue;
            if (vector2 == null) {
                vector2 = new Vector();
            }
            columnReference.bindExpression(fromList, this.subqueryList, vector2);
        }
    }

    Vector getNodesFromParameters(Class clazz) throws StandardException {
        CollectNodesVisitor collectNodesVisitor = new CollectNodesVisitor(clazz);
        this.methodCall.accept(collectNodesVisitor);
        return collectNodesVisitor.getList();
    }

    public ResultColumnList getAllResultColumns(TableName tableName) throws StandardException {
        ResultColumnList resultColumnList = null;
        TableName tableName2 = tableName != null ? this.makeTableName(tableName.getSchemaName(), this.correlationName) : this.makeTableName(null, this.correlationName);
        if (tableName != null && !tableName.equals(tableName2)) {
            return null;
        }
        resultColumnList = (ResultColumnList)this.getNodeFactory().getNode(9, this.getContextManager());
        int n = this.resultColumns.size();
        for (int i = 0; i < n; ++i) {
            ResultColumn resultColumn = (ResultColumn)this.resultColumns.elementAt(i);
            if (resultColumn.isGenerated()) continue;
            String string = resultColumn.getName();
            ValueNode valueNode = (ValueNode)this.getNodeFactory().getNode(62, string, this.exposedName, this.getContextManager());
            resultColumn = (ResultColumn)this.getNodeFactory().getNode(80, string, valueNode, this.getContextManager());
            resultColumnList.addResultColumn(resultColumn);
        }
        return resultColumnList;
    }

    public ResultColumn getMatchingColumn(ColumnReference columnReference) throws StandardException {
        if (this.resultColumns == null) {
            return null;
        }
        ResultColumn resultColumn = null;
        TableName tableName = columnReference.getTableNameNode();
        if ((tableName == null || tableName.equals(this.exposedName)) && (resultColumn = this.resultColumns.getResultColumn(columnReference.getColumnName())) != null) {
            columnReference.setTableNumber(this.tableNumber);
            columnReference.setColumnNumber(resultColumn.getColumnPosition());
        }
        return resultColumn;
    }

    public ResultSetNode preprocess(int n, GroupByList groupByList, FromList fromList) throws StandardException {
        this.methodCall.preprocess(n, (FromList)this.getNodeFactory().getNode(37, this.getNodeFactory().doJoinOrderOptimization(), this.getContextManager()), (SubqueryList)this.getNodeFactory().getNode(11, this.getContextManager()), (PredicateList)this.getNodeFactory().getNode(8, this.getContextManager()));
        this.referencedTableMap = new JBitSet(n);
        this.referencedTableMap.set(this.tableNumber);
        this.dependencyMap = new JBitSet(n);
        this.methodCall.categorize(this.dependencyMap, false);
        this.dependencyMap.clear(this.tableNumber);
        this.correlationMap = new JBitSet(n);
        this.methodCall.getCorrelationTables(this.correlationMap);
        return this.genProjectRestrict(n);
    }

    protected ResultSetNode genProjectRestrict(int n) throws StandardException {
        ResultColumnList resultColumnList = this.resultColumns;
        this.resultColumns = this.resultColumns.copyListAndObjects();
        resultColumnList.genVirtualColumnNodes(this, this.resultColumns, false);
        resultColumnList.doProjection();
        return (ResultSetNode)this.getNodeFactory().getNode(151, this, resultColumnList, null, null, null, null, this.tableProperties, this.getContextManager());
    }

    public boolean performMaterialization(JBitSet jBitSet) throws StandardException {
        return jBitSet.getFirstSetBit() != -1 && !jBitSet.hasSingleBitSet() && !this.getTrulyTheBestAccessPath().getJoinStrategy().doesMaterialization() && this.isMaterializable() && !this.supportsMultipleInstantiations;
    }

    void computeProjectionAndRestriction(PredicateList predicateList) throws StandardException {
        if (!this.isRestrictedTableFunction) {
            return;
        }
        this.computeRestriction(predicateList, this.computeProjection());
    }

    private HashMap computeProjection() throws StandardException {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        ResultColumnList resultColumnList = this.getResultColumns();
        int n = resultColumnList.size();
        this.projectedColumnNames = new String[n];
        for (int i = 0; i < n; ++i) {
            String string;
            ResultColumn resultColumn = resultColumnList.getResultColumn(i + 1);
            String string2 = resultColumn.getName();
            if (!resultColumn.isReferenced()) continue;
            this.projectedColumnNames[i] = string = resultColumn.getBaseColumnNode().getColumnName();
            hashMap.put(string2, string);
        }
        return hashMap;
    }

    private void computeRestriction(PredicateList predicateList, HashMap hashMap) throws StandardException {
        if (predicateList == null) {
            return;
        }
        int n = predicateList.size();
        for (int i = 0; i < n; ++i) {
            Predicate predicate = (Predicate)predicateList.elementAt(i);
            if (!this.canBePushedDown(predicate)) continue;
            Restriction restriction = this.makeRestriction(predicate.getAndNode(), hashMap);
            if (restriction == null) {
                this.vtiRestriction = null;
                return;
            }
            this.vtiRestriction = this.vtiRestriction == null ? restriction : new Restriction.AND(this.vtiRestriction, restriction);
        }
    }

    private boolean canBePushedDown(Predicate predicate) throws StandardException {
        JBitSet jBitSet = predicate.getReferencedSet();
        return predicate.isQualifier() && jBitSet != null && jBitSet.hasSingleBitSet() && jBitSet.get(this.getTableNumber());
    }

    private Restriction makeRestriction(ValueNode valueNode, HashMap hashMap) throws StandardException {
        if (valueNode instanceof AndNode) {
            AndNode andNode = (AndNode)valueNode;
            if (andNode.getRightOperand().isBooleanTrue()) {
                return this.makeRestriction(andNode.getLeftOperand(), hashMap);
            }
            Restriction restriction = this.makeRestriction(andNode.getLeftOperand(), hashMap);
            Restriction restriction2 = this.makeRestriction(andNode.getRightOperand(), hashMap);
            if (restriction == null || restriction2 == null) {
                return null;
            }
            return new Restriction.AND(restriction, restriction2);
        }
        if (valueNode instanceof OrNode) {
            OrNode orNode = (OrNode)valueNode;
            if (orNode.getRightOperand().isBooleanFalse()) {
                return this.makeRestriction(orNode.getLeftOperand(), hashMap);
            }
            Restriction restriction = this.makeRestriction(orNode.getLeftOperand(), hashMap);
            Restriction restriction3 = this.makeRestriction(orNode.getRightOperand(), hashMap);
            if (restriction == null || restriction3 == null) {
                return null;
            }
            return new Restriction.OR(restriction, restriction3);
        }
        if (valueNode instanceof BinaryRelationalOperatorNode) {
            return this.makeLeafRestriction((BinaryRelationalOperatorNode)valueNode, hashMap);
        }
        if (valueNode instanceof IsNullNode) {
            return this.makeIsNullRestriction((IsNullNode)valueNode, hashMap);
        }
        return this.iAmConfused(valueNode);
    }

    private Restriction makeLeafRestriction(BinaryRelationalOperatorNode binaryRelationalOperatorNode, HashMap hashMap) throws StandardException {
        ValueNode valueNode;
        ColumnReference columnReference;
        int n = binaryRelationalOperatorNode.getOperator();
        if (binaryRelationalOperatorNode.getLeftOperand() instanceof ColumnReference) {
            columnReference = (ColumnReference)binaryRelationalOperatorNode.getLeftOperand();
            valueNode = binaryRelationalOperatorNode.getRightOperand();
        } else if (binaryRelationalOperatorNode.getRightOperand() instanceof ColumnReference) {
            columnReference = (ColumnReference)binaryRelationalOperatorNode.getRightOperand();
            valueNode = binaryRelationalOperatorNode.getLeftOperand();
            n = this.flipOperator(n);
        } else {
            return this.iAmConfused(binaryRelationalOperatorNode);
        }
        int n2 = this.mapOperator(n);
        if (n2 < 0) {
            return this.iAmConfused(binaryRelationalOperatorNode);
        }
        String string = (String)hashMap.get(columnReference.getColumnName());
        Object object = this.squeezeConstantValue(valueNode);
        if (string == null || object == null) {
            return this.iAmConfused(binaryRelationalOperatorNode);
        }
        return new Restriction.ColumnQualifier(string, n2, object);
    }

    private Restriction makeIsNullRestriction(IsNullNode isNullNode, HashMap hashMap) throws StandardException {
        ColumnReference columnReference = (ColumnReference)isNullNode.getOperand();
        int n = this.mapOperator(isNullNode.getOperator());
        if (n < 0) {
            return this.iAmConfused(isNullNode);
        }
        if (n != 5 && n != 6) {
            return this.iAmConfused(isNullNode);
        }
        String string = (String)hashMap.get(columnReference.getColumnName());
        if (string == null) {
            return this.iAmConfused(isNullNode);
        }
        return new Restriction.ColumnQualifier(string, n, null);
    }

    private Restriction iAmConfused(ValueNode valueNode) throws StandardException {
        return null;
    }

    private int flipOperator(int n) throws StandardException {
        switch (n) {
            case 1: {
                return 1;
            }
            case 4: {
                return 6;
            }
            case 3: {
                return 5;
            }
            case 6: {
                return 4;
            }
            case 5: {
                return 3;
            }
            case 2: {
                return 2;
            }
        }
        return -1;
    }

    private int mapOperator(int n) throws StandardException {
        switch (n) {
            case 1: {
                return 1;
            }
            case 4: {
                return 4;
            }
            case 3: {
                return 3;
            }
            case 6: {
                return 2;
            }
            case 5: {
                return 0;
            }
            case 7: {
                return 5;
            }
            case 8: {
                return 6;
            }
            case 2: {
                return 7;
            }
        }
        return -1;
    }

    private Object squeezeConstantValue(ValueNode valueNode) throws StandardException {
        if (valueNode instanceof ParameterNode) {
            return new int[]{((ParameterNode)valueNode).getParameterNumber()};
        }
        if (valueNode instanceof ConstantNode) {
            return ((ConstantNode)valueNode).getValue().getObject();
        }
        return this.iAmConfused(valueNode);
    }

    public void generate(ActivationClassBuilder activationClassBuilder, MethodBuilder methodBuilder) throws StandardException {
        if (this.isRestrictedTableFunction && this.projectedColumnNames == null) {
            this.computeProjection();
        }
        RemapCRsVisitor remapCRsVisitor = new RemapCRsVisitor(true);
        this.methodCall.accept(remapCRsVisitor);
        this.assignResultSetNumber();
        activationClassBuilder.pushGetResultSetFactoryExpression(methodBuilder);
        int n = this.getScanArguments(activationClassBuilder, methodBuilder);
        methodBuilder.callMethod((short)185, null, "getVTIResultSet", "org.apache.derby.iapi.sql.execute.NoPutResultSet", n);
    }

    private int getScanArguments(ActivationClassBuilder activationClassBuilder, MethodBuilder methodBuilder) throws StandardException {
        int n;
        int n2 = this.resultColumns.size();
        FormatableBitSet formatableBitSet = new FormatableBitSet(n2);
        int n3 = -1;
        int n4 = 0;
        this.costEstimate = this.getFinalCostEstimate();
        for (n = 0; n < n2; ++n) {
            ResultColumn resultColumn = (ResultColumn)this.resultColumns.elementAt(n);
            if (!resultColumn.isReferenced()) continue;
            formatableBitSet.set(n);
            ++n4;
        }
        if (n4 != this.numVTICols) {
            n3 = activationClassBuilder.addItem(formatableBitSet);
        }
        n = activationClassBuilder.addItem(this.compileTimeConstants);
        activationClassBuilder.pushThisAsActivation(methodBuilder);
        this.resultColumns.generateHolder(activationClassBuilder, methodBuilder);
        boolean bl = this.version2 && this.getNodesFromParameters(ParameterNode.class).size() == 0 && this.getNodesFromParameters(ColumnReference.class).size() == 0;
        methodBuilder.push(this.resultSetNumber);
        this.generateConstructor(activationClassBuilder, methodBuilder, bl);
        methodBuilder.push(this.methodCall.getJavaClassName());
        if (this.restrictionList != null) {
            this.restrictionList.generateQualifiers(activationClassBuilder, methodBuilder, this, true);
        } else {
            methodBuilder.pushNull("org.apache.derby.iapi.store.access.Qualifier[][]");
        }
        methodBuilder.push(n3);
        methodBuilder.push(this.version2);
        methodBuilder.push(bl);
        methodBuilder.push(n);
        methodBuilder.push(this.isTarget);
        methodBuilder.push(this.getCompilerContext().getScanIsolationLevel());
        methodBuilder.push(this.costEstimate.rowCount());
        methodBuilder.push(this.costEstimate.getEstimatedCost());
        methodBuilder.push(this.isDerbyStyleTableFunction);
        int n5 = -1;
        if (this.isDerbyStyleTableFunction) {
            n5 = activationClassBuilder.addItem(this.methodCall.getRoutineInfo().getReturnType());
        }
        methodBuilder.push(n5);
        methodBuilder.push(this.storeObjectInPS(activationClassBuilder, this.projectedColumnNames));
        methodBuilder.push(this.storeObjectInPS(activationClassBuilder, this.vtiRestriction));
        return 18;
    }

    private int storeObjectInPS(ActivationClassBuilder activationClassBuilder, Object object) throws StandardException {
        if (object == null) {
            return -1;
        }
        return activationClassBuilder.addItem(object);
    }

    private void generateConstructor(ActivationClassBuilder activationClassBuilder, MethodBuilder methodBuilder, boolean bl) throws StandardException {
        LocalField localField;
        String string = this.version2 ? "java.sql.PreparedStatement" : "java.sql.ResultSet";
        MethodBuilder methodBuilder2 = activationClassBuilder.newGeneratedFun(string, 1);
        methodBuilder2.addThrownException("java.lang.Exception");
        LocalField localField2 = localField = bl ? activationClassBuilder.newFieldDeclaration(2, "java.sql.PreparedStatement") : null;
        if (bl) {
            methodBuilder2.getField(localField);
            methodBuilder2.conditionalIfNull();
        }
        this.methodCall.generateExpression(activationClassBuilder, methodBuilder2);
        methodBuilder2.upCast(string);
        if (bl) {
            methodBuilder2.putField(localField);
            methodBuilder2.startElseCode();
            methodBuilder2.getField(localField);
            methodBuilder2.completeConditional();
        }
        methodBuilder2.methodReturn();
        methodBuilder2.complete();
        activationClassBuilder.pushMethodReference(methodBuilder, methodBuilder2);
        if (bl) {
            MethodBuilder methodBuilder3 = activationClassBuilder.getCloseActivationMethod();
            methodBuilder3.getField(localField);
            methodBuilder3.conditionalIfNull();
            methodBuilder3.push(0);
            methodBuilder3.startElseCode();
            methodBuilder3.getField(localField);
            methodBuilder3.callMethod((short)185, "java.sql.Statement", "close", "void", 0);
            methodBuilder3.push(0);
            methodBuilder3.completeConditional();
            methodBuilder3.endStatement();
        }
    }

    public boolean referencesTarget(String string, boolean bl) throws StandardException {
        return !bl && string.equals(this.methodCall.getJavaClassName());
    }

    void acceptChildren(Visitor visitor) throws StandardException {
        super.acceptChildren(visitor);
        if (this.methodCall != null) {
            this.methodCall = (MethodCallNode)this.methodCall.accept(visitor);
        }
    }

    private UUID getSpecialTriggerVTITableName(LanguageConnectionContext languageConnectionContext, String string) throws StandardException {
        if (string.equals("org.apache.derby.catalog.TriggerNewTransitionRows") || string.equals("org.apache.derby.catalog.TriggerOldTransitionRows")) {
            if (languageConnectionContext.getTriggerTable() != null) {
                return languageConnectionContext.getTriggerTable().getUUID();
            }
            if (languageConnectionContext.getTriggerExecutionContext() != null) {
                return languageConnectionContext.getTriggerExecutionContext().getTargetTableId();
            }
            throw StandardException.newException("42Y45", string);
        }
        return null;
    }

    private ResultColumnList genResultColList(TableDescriptor tableDescriptor) throws StandardException {
        ResultColumnList resultColumnList = null;
        ColumnDescriptor columnDescriptor = null;
        TableName tableName = this.makeTableName(tableDescriptor.getSchemaName(), tableDescriptor.getName());
        resultColumnList = (ResultColumnList)this.getNodeFactory().getNode(9, this.getContextManager());
        ColumnDescriptorList columnDescriptorList = tableDescriptor.getColumnDescriptorList();
        int n = columnDescriptorList.size();
        for (int i = 0; i < n; ++i) {
            columnDescriptor = columnDescriptorList.elementAt(i);
            ValueNode valueNode = (ValueNode)this.getNodeFactory().getNode(94, columnDescriptor.getColumnName(), this.exposedName, columnDescriptor.getType(), this.getContextManager());
            ResultColumn resultColumn = (ResultColumn)this.getNodeFactory().getNode(80, columnDescriptor, valueNode, this.getContextManager());
            resultColumnList.addResultColumn(resultColumn);
        }
        return resultColumnList;
    }

    public boolean needsSpecialRCLBinding() {
        return true;
    }

    boolean isUpdatableCursor() throws StandardException {
        return true;
    }

    protected void markUpdatableByCursor(Vector vector) {
        super.markUpdatableByCursor(vector);
        this.forUpdatePresent = true;
        this.emptyForUpdate = vector == null || vector.size() == 0;
    }

    private int[] getForUpdateColumnList() {
        int[] nArray;
        int[] nArray2 = new int[this.getNumColumnsReturned()];
        int n = 0;
        for (int i = 0; i < nArray2.length; ++i) {
            if (!this.resultColumns.updatableByCursor(i)) continue;
            nArray2[n++] = i + 1;
        }
        if (n == nArray2.length) {
            nArray = nArray2;
        } else {
            nArray = new int[n];
            System.arraycopy(nArray2, 0, nArray, 0, n);
        }
        return nArray;
    }

    public final boolean isCompileTime() {
        return true;
    }

    public String getOriginalSQL() {
        return this.getCompilerContext().getParser().getSQLtext();
    }

    public final int getStatementIsolationLevel() {
        return ExecutionContext.CS_TO_JDBC_ISOLATION_LEVEL_MAP[this.getCompilerContext().getScanIsolationLevel()];
    }

    public void setSharedState(String string, Serializable serializable) {
        if (string == null) {
            return;
        }
        if (this.compileTimeConstants == null) {
            this.compileTimeConstants = new FormatableHashtable();
        }
        this.compileTimeConstants.put(string, serializable);
    }

    public Object getSharedState(String string) {
        if (string == null || this.compileTimeConstants == null) {
            return null;
        }
        return this.compileTimeConstants.get(string);
    }

    private void createResultColumnsForTableFunction(TypeDescriptor typeDescriptor) throws StandardException {
        String[] stringArray = typeDescriptor.getRowColumnNames();
        TypeDescriptor[] typeDescriptorArray = typeDescriptor.getRowTypes();
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            DataTypeDescriptor dataTypeDescriptor = DataTypeDescriptor.getType(typeDescriptorArray[i]);
            ResultColumn resultColumn = this.resultColumns.addColumn(this.exposedName, string, dataTypeDescriptor);
            ColumnDescriptor columnDescriptor = new ColumnDescriptor(string, i + 1, dataTypeDescriptor, (DataValueDescriptor)null, (DefaultInfo)null, (UUID)null, (UUID)null, 0L, 0L, 0L);
            resultColumn.setColumnDescriptor(null, columnDescriptor);
        }
    }

    private boolean implementsDerbyStyleVTICosting(String string) throws StandardException {
        Constructor constructor = null;
        Class clazz = this.lookupClass(string);
        Class clazz2 = this.lookupClass(VTICosting.class.getName());
        try {
            if (!clazz2.isAssignableFrom(clazz)) {
                return false;
            }
        }
        catch (Throwable throwable) {
            throw StandardException.unexpectedUserException(throwable);
        }
        try {
            constructor = clazz.getConstructor(new Class[0]);
        }
        catch (Throwable throwable) {
            throw StandardException.newException("42ZB5", throwable, (Object)string);
        }
        if (Modifier.isPublic(constructor.getModifiers())) {
            return true;
        }
        throw StandardException.newException("42ZB5", string);
    }

    private VTICosting getVTICosting() throws StandardException {
        if (!this.isDerbyStyleTableFunction) {
            return this.version2 ? (VTICosting)((Object)this.ps) : (VTICosting)((Object)this.rs);
        }
        String string = this.methodCall.getJavaClassName();
        Class clazz = this.lookupClass(string);
        try {
            Constructor constructor = clazz.getConstructor(new Class[0]);
            VTICosting vTICosting = (VTICosting)constructor.newInstance(null);
            return vTICosting;
        }
        catch (Throwable throwable) {
            throw StandardException.unexpectedUserException(throwable);
        }
    }

    private Class lookupClass(String string) throws StandardException {
        try {
            return this.getClassFactory().getClassInspector().getClass(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw StandardException.unexpectedUserException(classNotFoundException);
        }
    }
}

