/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.client.am;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import org.apache.derby.client.am.Clob;
import org.apache.derby.client.am.ClobLocatorReader;
import org.apache.derby.client.am.Connection;
import org.apache.derby.client.am.SqlException;

public class UpdateSensitiveClobLocatorReader
extends Reader {
    private BufferedReader r = null;
    private Connection con = null;
    private Clob clob = null;
    private long updateCount;
    private long currentPos;
    private long length;

    protected UpdateSensitiveClobLocatorReader(Connection connection, Clob clob) throws SqlException {
        clob.checkForLocatorValidity();
        this.r = new BufferedReader(new ClobLocatorReader(connection, clob));
        this.currentPos = 1L;
        this.con = connection;
        this.clob = clob;
        this.updateCount = clob.getUpdateCount();
        this.length = -1L;
    }

    protected UpdateSensitiveClobLocatorReader(Connection connection, Clob clob, long l, long l2) throws SqlException {
        clob.checkForLocatorValidity();
        this.r = new BufferedReader(new ClobLocatorReader(connection, clob, l, l2));
        this.con = connection;
        this.clob = clob;
        this.currentPos = l;
        this.length = l2;
        this.updateCount = clob.getUpdateCount();
    }

    public int read() throws IOException {
        this.identifyAndReplaceObseleteStream();
        int n = this.r.read();
        if (n == -1) {
            return n;
        }
        ++this.currentPos;
        return n;
    }

    public int read(char[] cArray, int n, int n2) throws IOException {
        this.identifyAndReplaceObseleteStream();
        int n3 = this.r.read(cArray, n, n2);
        if (n3 == -1) {
            return n3;
        }
        this.currentPos += (long)n3;
        return n3;
    }

    public void close() throws IOException {
        this.r.close();
    }

    private void identifyAndReplaceObseleteStream() throws IOException {
        long l = this.clob.getUpdateCount();
        if (this.updateCount != l) {
            try {
                this.r = new BufferedReader(this.reCreateStream());
            }
            catch (SqlException sqlException) {
                IOException iOException = new IOException();
                iOException.initCause(sqlException);
                throw iOException;
            }
        } else {
            return;
        }
        this.updateCount = l;
    }

    protected Reader reCreateStream() throws SqlException {
        ClobLocatorReader clobLocatorReader = null;
        clobLocatorReader = this.length != -1L ? new ClobLocatorReader(this.con, this.clob, this.currentPos, this.length - this.currentPos + 1L) : new ClobLocatorReader(this.con, this.clob, this.currentPos, -1L);
        return clobLocatorReader;
    }
}

