/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.bugspot;

import java.rmi.RemoteException;
import sun.jvm.hotspot.BsdVtblAccess;
import sun.jvm.hotspot.HotSpotSolarisVtblAccess;
import sun.jvm.hotspot.HotSpotTypeDataBase;
import sun.jvm.hotspot.LinuxVtblAccess;
import sun.jvm.hotspot.RMIHelper;
import sun.jvm.hotspot.Win32VtblAccess;
import sun.jvm.hotspot.debugger.Debugger;
import sun.jvm.hotspot.debugger.DebuggerException;
import sun.jvm.hotspot.debugger.JVMDebugger;
import sun.jvm.hotspot.debugger.MachineDescription;
import sun.jvm.hotspot.debugger.MachineDescriptionAMD64;
import sun.jvm.hotspot.debugger.MachineDescriptionIA64;
import sun.jvm.hotspot.debugger.MachineDescriptionIntelX86;
import sun.jvm.hotspot.debugger.MachineDescriptionSPARC32Bit;
import sun.jvm.hotspot.debugger.MachineDescriptionSPARC64Bit;
import sun.jvm.hotspot.debugger.NoSuchSymbolException;
import sun.jvm.hotspot.debugger.bsd.BsdDebuggerLocal;
import sun.jvm.hotspot.debugger.cdbg.CDebugger;
import sun.jvm.hotspot.debugger.cdbg.ProcessControl;
import sun.jvm.hotspot.debugger.linux.LinuxDebuggerLocal;
import sun.jvm.hotspot.debugger.proc.ProcDebuggerLocal;
import sun.jvm.hotspot.debugger.remote.RemoteDebugger;
import sun.jvm.hotspot.debugger.remote.RemoteDebuggerClient;
import sun.jvm.hotspot.debugger.remote.RemoteDebuggerServer;
import sun.jvm.hotspot.debugger.windbg.WindbgDebuggerLocal;
import sun.jvm.hotspot.livejvm.Event;
import sun.jvm.hotspot.livejvm.ServiceabilityAgentJVMDIModule;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.types.TypeDataBase;
import sun.jvm.hotspot.utilities.PlatformInfo;
import sun.jvm.hotspot.utilities.UnsupportedPlatformException;

public class BugSpotAgent {
    private JVMDebugger debugger;
    private MachineDescription machDesc;
    private TypeDataBase db;
    private String os;
    private String cpu;
    private String fileSep;
    private static final int PROCESS_MODE = 0;
    private static final int CORE_FILE_MODE = 1;
    private static final int REMOTE_MODE = 2;
    private int startupMode;
    private boolean isServer;
    private int pid;
    private String executableName;
    private String coreFileName;
    private String debugServerID;
    private String serverID;
    private boolean javaMode;
    private ServiceabilityAgentJVMDIModule jvmdi;
    private boolean javaInteractionDisabled;
    private String[] jvmLibNames;
    private String[] saLibNames;
    private static final String defaultDbxPathPrefix = "/net/jano.eng/export/disk05/hotspot/sa";
    private static final String defaultDbxSvcAgentDSOPathPrefix = "/net/jano.eng/export/disk05/hotspot/sa";
    private static final boolean DEBUG = System.getProperty("sun.jvm.hotspot.bugspot.BugSpotAgent.DEBUG") != null;

    static void debugPrintln(String str) {
        if (DEBUG) {
            System.err.println(str);
        }
    }

    static void showUsage() {
        System.out.println("    You can also pass these -D options to java to specify where to find dbx and the \n    Serviceability Agent plugin for dbx:");
        System.out.println("       -DdbxPathName=<path-to-dbx-executable>\n             Default is derived from dbxPathPrefix");
        System.out.println("    or");
        System.out.println("       -DdbxPathPrefix=<xxx>\n             where xxx is the path name of a dir structure that contains:\n                   <os>/<arch>/bin/dbx\n             The default is /net/jano.eng/export/disk05/hotspot/sa");
        System.out.println("    and");
        System.out.println("       -DdbxSvcAgentDSOPathName=<path-to-dbx-serviceability-agent-module>\n             Default is determined from dbxSvcAgentDSOPathPrefix");
        System.out.println("    or");
        System.out.println("       -DdbxSvcAgentDSOPathPrefix=<xxx>\n             where xxx is the pathname of a dir structure that contains:\n                   <os>/<arch>/bin/lib/libsvc_agent_dbx.so\n             The default is /net/jano.eng/export/disk05/hotspot/sa");
    }

    public BugSpotAgent() {
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                BugSpotAgent bugSpotAgent = BugSpotAgent.this;
                synchronized (bugSpotAgent) {
                    if (!BugSpotAgent.this.isServer) {
                        BugSpotAgent.this.detach();
                    }
                }
            }
        }));
    }

    public synchronized Debugger getDebugger() {
        return this.debugger;
    }

    public synchronized CDebugger getCDebugger() {
        return this.getDebugger().getCDebugger();
    }

    public synchronized ProcessControl getProcessControl() {
        return this.getCDebugger().getProcessControl();
    }

    public synchronized TypeDataBase getTypeDataBase() {
        return this.db;
    }

    public synchronized boolean isSuspended() throws DebuggerException {
        return this.getProcessControl().isSuspended();
    }

    public synchronized void suspend() throws DebuggerException {
        this.getProcessControl().suspend();
    }

    public synchronized void resume() throws DebuggerException {
        this.getProcessControl().resume();
    }

    public synchronized boolean isJavaMode() {
        return this.javaMode;
    }

    public synchronized void disableJavaInteraction() {
        this.javaInteractionDisabled = true;
    }

    public synchronized void enableJavaInteraction() {
        this.javaInteractionDisabled = false;
    }

    public synchronized boolean isJavaInteractionDisabled() {
        return this.javaInteractionDisabled;
    }

    public synchronized boolean canInteractWithJava() {
        return this.jvmdi != null && !this.javaInteractionDisabled;
    }

    public synchronized void suspendJava() throws DebuggerException {
        if (!this.canInteractWithJava()) {
            throw new DebuggerException("Could not connect to SA's JVMDI module");
        }
        if (this.jvmdi.isSuspended()) {
            throw new DebuggerException("Target process already suspended via JVMDI");
        }
        this.jvmdi.suspend();
    }

    public synchronized void resumeJava() throws DebuggerException {
        if (!this.canInteractWithJava()) {
            throw new DebuggerException("Could not connect to SA's JVMDI module");
        }
        if (!this.jvmdi.isSuspended()) {
            throw new DebuggerException("Target process already resumed via JVMDI");
        }
        this.jvmdi.resume();
    }

    public synchronized boolean isJavaSuspended() throws DebuggerException {
        return this.jvmdi.isSuspended();
    }

    public synchronized ServiceabilityAgentJVMDIModule.BreakpointToggleResult toggleJavaBreakpoint(String srcFileName, String pkgName, int lineNo) {
        if (!this.canInteractWithJava()) {
            throw new DebuggerException("Could not connect to SA's JVMDI module; can not toggle Java breakpoints");
        }
        return this.jvmdi.toggleBreakpoint(srcFileName, pkgName, lineNo);
    }

    public synchronized boolean javaEventPending() throws DebuggerException {
        if (!this.canInteractWithJava()) {
            throw new DebuggerException("Could not connect to SA's JVMDI module; can not poll for Java debug events");
        }
        return this.jvmdi.eventPending();
    }

    public synchronized Event javaEventPoll() throws DebuggerException {
        if (!this.canInteractWithJava()) {
            throw new DebuggerException("Could not connect to SA's JVMDI module; can not poll for Java debug events");
        }
        return this.jvmdi.eventPoll();
    }

    public synchronized void javaEventContinue() throws DebuggerException {
        if (!this.canInteractWithJava()) {
            throw new DebuggerException("Could not connect to SA's JVMDI module; can not continue past Java debug events");
        }
        this.jvmdi.eventContinue();
    }

    public synchronized void attach(int processID) throws DebuggerException {
        if (this.debugger != null) {
            throw new DebuggerException("Already attached");
        }
        this.pid = processID;
        this.startupMode = 0;
        this.isServer = false;
        this.go();
    }

    public synchronized void attach(String executableName, String coreFileName) throws DebuggerException {
        if (this.debugger != null) {
            throw new DebuggerException("Already attached");
        }
        if (executableName == null || coreFileName == null) {
            throw new DebuggerException("Both the core file name and executable name must be specified");
        }
        this.executableName = executableName;
        this.coreFileName = coreFileName;
        this.startupMode = 1;
        this.isServer = false;
        this.go();
    }

    public synchronized void attach(String remoteServerID) throws DebuggerException {
        if (this.debugger != null) {
            throw new DebuggerException("Already attached to a process");
        }
        if (remoteServerID == null) {
            throw new DebuggerException("Debug server id must be specified");
        }
        this.debugServerID = remoteServerID;
        this.startupMode = 2;
        this.isServer = false;
        this.go();
    }

    public synchronized boolean detach() throws DebuggerException {
        if (this.isServer) {
            throw new DebuggerException("Should not call detach() for server configuration");
        }
        return this.detachInternal();
    }

    public synchronized void startServer(int processID, String uniqueID) throws DebuggerException {
        if (this.debugger != null) {
            throw new DebuggerException("Already attached");
        }
        this.pid = processID;
        this.startupMode = 0;
        this.isServer = true;
        this.serverID = uniqueID;
        this.go();
    }

    public synchronized void startServer(int processID) throws DebuggerException {
        this.startServer(processID, null);
    }

    public synchronized void startServer(String executableName, String coreFileName, String uniqueID) throws DebuggerException {
        if (this.debugger != null) {
            throw new DebuggerException("Already attached");
        }
        if (executableName == null || coreFileName == null) {
            throw new DebuggerException("Both the core file name and Java executable name must be specified");
        }
        this.executableName = executableName;
        this.coreFileName = coreFileName;
        this.startupMode = 1;
        this.isServer = true;
        this.serverID = uniqueID;
        this.go();
    }

    public synchronized void startServer(String executableName, String coreFileName) throws DebuggerException {
        this.startServer(executableName, coreFileName, null);
    }

    public synchronized boolean shutdownServer() throws DebuggerException {
        if (!this.isServer) {
            throw new DebuggerException("Should not call shutdownServer() for client configuration");
        }
        return this.detachInternal();
    }

    private boolean detachInternal() {
        if (this.debugger == null) {
            return false;
        }
        if (this.canInteractWithJava()) {
            this.jvmdi.detach();
            this.jvmdi = null;
        }
        boolean retval = true;
        if (!this.isServer) {
            VM.shutdown();
        }
        JVMDebugger dbg = null;
        DebuggerException ex = null;
        if (this.isServer) {
            try {
                RMIHelper.unbind(this.serverID);
            }
            catch (DebuggerException de) {
                ex = de;
            }
            dbg = this.debugger;
        } else if (this.startupMode != 2) {
            dbg = this.debugger;
        }
        if (dbg != null) {
            retval = dbg.detach();
        }
        this.debugger = null;
        this.machDesc = null;
        this.db = null;
        if (ex != null) {
            throw ex;
        }
        return retval;
    }

    private void go() {
        this.setupDebugger();
        this.javaMode = this.setupVM();
    }

    private void setupDebugger() {
        if (this.startupMode != 2) {
            try {
                this.os = PlatformInfo.getOS();
                this.cpu = PlatformInfo.getCPU();
            }
            catch (UnsupportedPlatformException e) {
                throw new DebuggerException(e);
            }
            this.fileSep = System.getProperty("file.separator");
            if (this.os.equals("solaris")) {
                this.setupDebuggerSolaris();
            } else if (this.os.equals("win32")) {
                this.setupDebuggerWin32();
            } else if (this.os.equals("linux")) {
                this.setupDebuggerLinux();
            } else if (this.os.equals("bsd")) {
                this.setupDebuggerBsd();
            } else if (this.os.equals("darwin")) {
                this.setupDebuggerDarwin();
            } else {
                throw new DebuggerException("Operating system " + this.os + " not yet supported");
            }
            if (this.isServer) {
                RemoteDebuggerServer remote = null;
                try {
                    remote = new RemoteDebuggerServer(this.debugger);
                }
                catch (RemoteException rem) {
                    throw new DebuggerException(rem);
                }
                RMIHelper.rebind(this.serverID, remote);
            }
        } else {
            this.connectRemoteDebugger();
        }
    }

    private boolean setupVM() {
        block13: {
            try {
                if (this.os.equals("solaris")) {
                    this.db = new HotSpotTypeDataBase(this.machDesc, new HotSpotSolarisVtblAccess(this.debugger, this.jvmLibNames), this.debugger, this.jvmLibNames);
                    break block13;
                }
                if (this.os.equals("win32")) {
                    this.db = new HotSpotTypeDataBase(this.machDesc, new Win32VtblAccess(this.debugger, this.jvmLibNames), this.debugger, this.jvmLibNames);
                    break block13;
                }
                if (this.os.equals("linux")) {
                    this.db = new HotSpotTypeDataBase(this.machDesc, new LinuxVtblAccess(this.debugger, this.jvmLibNames), this.debugger, this.jvmLibNames);
                    break block13;
                }
                if (this.os.equals("bsd")) {
                    this.db = new HotSpotTypeDataBase(this.machDesc, new BsdVtblAccess(this.debugger, this.jvmLibNames), this.debugger, this.jvmLibNames);
                    break block13;
                }
                if (this.os.equals("darwin")) {
                    this.db = new HotSpotTypeDataBase(this.machDesc, new BsdVtblAccess(this.debugger, this.jvmLibNames), this.debugger, this.jvmLibNames);
                    break block13;
                }
                throw new DebuggerException("OS \"" + this.os + "\" not yet supported (no VtblAccess implemented yet)");
            }
            catch (NoSuchSymbolException e) {
                e.printStackTrace();
                return false;
            }
        }
        if (this.startupMode != 2) {
            this.debugger.configureJavaPrimitiveTypeSizes(this.db.getJBooleanType().getSize(), this.db.getJByteType().getSize(), this.db.getJCharType().getSize(), this.db.getJDoubleType().getSize(), this.db.getJFloatType().getSize(), this.db.getJIntType().getSize(), this.db.getJLongType().getSize(), this.db.getJShortType().getSize());
        }
        if (!this.isServer) {
            VM.initialize(this.db, this.debugger);
        }
        try {
            this.jvmdi = new ServiceabilityAgentJVMDIModule(this.debugger, this.saLibNames);
            if (this.jvmdi.canAttach()) {
                this.jvmdi.attach();
                this.jvmdi.setCommandTimeout(6000L);
                BugSpotAgent.debugPrintln("Attached to Serviceability Agent's JVMDI module.");
                this.resume();
                this.suspendJava();
                this.suspend();
                BugSpotAgent.debugPrintln("Suspended all Java threads.");
            } else {
                BugSpotAgent.debugPrintln("Could not locate SA's JVMDI module; skipping attachment");
                this.jvmdi = null;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.jvmdi = null;
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void setupDebuggerSolaris() {
        this.setupJVMLibNamesSolaris();
        ProcDebuggerLocal dbg = new ProcDebuggerLocal(null, true);
        this.debugger = dbg;
        this.attachDebugger();
        if (this.cpu.equals("x86")) {
            this.machDesc = new MachineDescriptionIntelX86();
        } else if (this.cpu.equals("sparc")) {
            int addressSize = dbg.getRemoteProcessAddressSize();
            if (addressSize == -1) {
                throw new DebuggerException("Error occurred while trying to determine the remote process's address size");
            }
            if (addressSize == 32) {
                this.machDesc = new MachineDescriptionSPARC32Bit();
            } else {
                if (addressSize != 64) throw new DebuggerException("Address size " + addressSize + " is not supported on SPARC");
                this.machDesc = new MachineDescriptionSPARC64Bit();
            }
        } else {
            if (!this.cpu.equals("amd64")) throw new DebuggerException("Solaris only supported on sparc/sparcv9/x86/amd64");
            this.machDesc = new MachineDescriptionAMD64();
        }
        dbg.setMachineDescription(this.machDesc);
    }

    private void connectRemoteDebugger() throws DebuggerException {
        RemoteDebugger remote = (RemoteDebugger)RMIHelper.lookup(this.debugServerID);
        this.debugger = new RemoteDebuggerClient(remote);
        this.machDesc = ((RemoteDebuggerClient)this.debugger).getMachineDescription();
        this.os = this.debugger.getOS();
        if (this.os.equals("solaris")) {
            this.setupJVMLibNamesSolaris();
        } else if (this.os.equals("win32")) {
            this.setupJVMLibNamesWin32();
        } else if (this.os.equals("linux")) {
            this.setupJVMLibNamesLinux();
        } else if (this.os.equals("bsd")) {
            this.setupJVMLibNamesBsd();
        } else {
            throw new RuntimeException("Unknown OS type");
        }
        this.cpu = this.debugger.getCPU();
    }

    private void setupJVMLibNamesSolaris() {
        this.jvmLibNames = new String[]{"libjvm.so", "libjvm_g.so", "gamma_g"};
        this.saLibNames = new String[]{"libsa.so", "libsa_g.so"};
    }

    private void setupDebuggerWin32() {
        this.setupJVMLibNamesWin32();
        if (this.cpu.equals("x86")) {
            this.machDesc = new MachineDescriptionIntelX86();
        } else if (this.cpu.equals("amd64")) {
            this.machDesc = new MachineDescriptionAMD64();
        } else if (this.cpu.equals("ia64")) {
            this.machDesc = new MachineDescriptionIA64();
        } else {
            throw new DebuggerException("Win32 supported under x86, amd64 and ia64 only");
        }
        this.debugger = new WindbgDebuggerLocal(this.machDesc, !this.isServer);
        this.attachDebugger();
    }

    private void setupJVMLibNamesWin32() {
        this.jvmLibNames = new String[]{"jvm.dll", "jvm_g.dll"};
        this.saLibNames = new String[]{"sa.dll", "sa_g.dll"};
    }

    private void setupDebuggerLinux() {
        this.setupJVMLibNamesLinux();
        if (this.cpu.equals("x86")) {
            this.machDesc = new MachineDescriptionIntelX86();
        } else if (this.cpu.equals("ia64")) {
            this.machDesc = new MachineDescriptionIA64();
        } else if (this.cpu.equals("amd64")) {
            this.machDesc = new MachineDescriptionAMD64();
        } else if (this.cpu.equals("sparc")) {
            this.machDesc = LinuxDebuggerLocal.getAddressSize() == 8 ? new MachineDescriptionSPARC64Bit() : new MachineDescriptionSPARC32Bit();
        } else {
            try {
                this.machDesc = (MachineDescription)Class.forName("sun.jvm.hotspot.debugger.MachineDescription" + this.cpu.toUpperCase()).newInstance();
            }
            catch (Exception e) {
                throw new DebuggerException("unsupported machine type");
            }
        }
        this.debugger = new LinuxDebuggerLocal(this.machDesc, !this.isServer);
        this.attachDebugger();
    }

    private void setupJVMLibNamesLinux() {
        this.setupJVMLibNamesSolaris();
    }

    private void setupDebuggerBsd() {
        this.setupJVMLibNamesBsd();
        if (this.cpu.equals("x86")) {
            this.machDesc = new MachineDescriptionIntelX86();
        } else if (this.cpu.equals("amd64") || this.cpu.equals("x86_64")) {
            this.machDesc = new MachineDescriptionAMD64();
        } else {
            throw new DebuggerException("Bsd only supported on x86/x86_64. Current arch: " + this.cpu);
        }
        this.debugger = new BsdDebuggerLocal(this.machDesc, !this.isServer);
        this.attachDebugger();
    }

    private void setupJVMLibNamesBsd() {
        this.setupJVMLibNamesSolaris();
    }

    private void setupDebuggerDarwin() {
        this.setupJVMLibNamesDarwin();
        if (!this.cpu.equals("amd64") && !this.cpu.equals("x86_64")) {
            throw new DebuggerException("Darwin only supported on x86_64. Current arch: " + this.cpu);
        }
        this.machDesc = new MachineDescriptionAMD64();
        BsdDebuggerLocal dbg = new BsdDebuggerLocal(this.machDesc, !this.isServer);
        this.debugger = dbg;
        this.attachDebugger();
    }

    private void setupJVMLibNamesDarwin() {
        this.jvmLibNames = new String[]{"libjvm.dylib"};
    }

    private void attachDebugger() {
        if (this.startupMode == 0) {
            this.debugger.attach(this.pid);
        } else if (this.startupMode == 1) {
            this.debugger.attach(this.executableName, this.coreFileName);
        } else {
            throw new DebuggerException("Should not call attach() for startupMode == " + this.startupMode);
        }
    }
}

