/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.tools.soql;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.StringTokenizer;
import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.debugger.JVMDebugger;
import sun.jvm.hotspot.debugger.OopHandle;
import sun.jvm.hotspot.oops.ConstantPool;
import sun.jvm.hotspot.oops.InstanceKlass;
import sun.jvm.hotspot.oops.Oop;
import sun.jvm.hotspot.oops.OopPrinter;
import sun.jvm.hotspot.oops.Symbol;
import sun.jvm.hotspot.runtime.SignatureConverter;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.tools.Tool;
import sun.jvm.hotspot.utilities.SystemDictionaryHelper;
import sun.jvm.hotspot.utilities.soql.JSJavaObject;
import sun.jvm.hotspot.utilities.soql.ObjectVisitor;
import sun.jvm.hotspot.utilities.soql.SOQLEngine;
import sun.jvm.hotspot.utilities.soql.SOQLException;

public class SOQL
extends Tool {
    protected SOQLEngine soqlEngine;
    protected BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
    protected PrintStream out = System.out;
    protected static String prompt = "soql> ";
    protected static String secondPrompt = "> ";

    public static void main(String[] args) {
        SOQL soql = new SOQL();
        soql.execute(args);
    }

    @Override
    public void run() {
        this.soqlEngine = SOQLEngine.getEngine();
        try {
            while (true) {
                this.out.print(prompt);
                String line = this.in.readLine();
                if (line == null) {
                    return;
                }
                StringTokenizer st = new StringTokenizer(line);
                if (!st.hasMoreTokens()) continue;
                String cmd = st.nextToken();
                if (cmd.equals("select")) {
                    this.handleSelect(line);
                    continue;
                }
                if (cmd.equals("classes")) {
                    this.handleClasses(line);
                    continue;
                }
                if (cmd.equals("class")) {
                    this.handleClass(line);
                    continue;
                }
                if (cmd.equals("object")) {
                    this.handleObject(line);
                    continue;
                }
                if (cmd.equals("quit")) {
                    this.out.println("Bye!");
                    return;
                }
                if (cmd.equals("")) continue;
                this.handleUnknown(line);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
    }

    protected void handleSelect(String query) {
        StringBuffer buf = new StringBuffer(query);
        String tmp = null;
        while (true) {
            this.out.print(secondPrompt);
            try {
                tmp = this.in.readLine();
            }
            catch (IOException ioe) {
                break;
            }
            if (tmp.equals("") || tmp.equals("go")) break;
            buf.append('\n');
            buf.append(tmp);
        }
        query = buf.toString();
        try {
            this.soqlEngine.executeQuery(query, new ObjectVisitor(){

                @Override
                public void visit(Object o) {
                    if (o != null && o instanceof JSJavaObject) {
                        String oopAddr = ((JSJavaObject)o).getOop().getHandle().toString();
                        SOQL.this.out.println(oopAddr);
                    } else {
                        SOQL.this.out.println(o == null ? "null" : o.toString());
                    }
                }
            });
        }
        catch (SOQLException se) {
            se.printStackTrace();
        }
    }

    protected void handleClasses(String line) {
        InstanceKlass[] klasses = SystemDictionaryHelper.getAllInstanceKlasses();
        for (int i = 0; i < klasses.length; ++i) {
            this.out.print(klasses[i].getName().asString().replace('/', '.'));
            this.out.print(" @");
            this.out.println(klasses[i].getHandle());
        }
    }

    protected void handleClass(String line) {
        StringTokenizer st = new StringTokenizer(line);
        st.nextToken();
        if (st.hasMoreTokens()) {
            String className = st.nextToken();
            InstanceKlass klass = SystemDictionaryHelper.findInstanceKlass(className);
            if (klass == null) {
                this.out.println("class " + className + " not found");
            } else {
                InstanceKlass base = (InstanceKlass)klass.getSuper();
                if (base != null) {
                    this.out.println("super");
                    this.out.print("\t");
                    this.out.println(base.getName().asString().replace('/', '.'));
                }
                int numFields = klass.getJavaFieldsCount();
                ConstantPool cp = klass.getConstants();
                this.out.println("fields");
                if (numFields != 0) {
                    for (int f = 0; f < numFields; ++f) {
                        Symbol f_name = klass.getFieldName(f);
                        Symbol f_sig = klass.getFieldSignature(f);
                        StringBuffer sigBuf = new StringBuffer();
                        new SignatureConverter(f_sig, sigBuf).dispatchField();
                        this.out.print('\t');
                        this.out.print(sigBuf.toString().replace('/', '.'));
                        this.out.print(' ');
                        this.out.println(f_name.asString());
                    }
                } else {
                    this.out.println("\tno fields in this class");
                }
            }
        } else {
            this.out.println("usage: class <name of the class>");
        }
    }

    protected Oop getOopAtAddress(Address addr) {
        OopHandle oopHandle = addr.addOffsetToAsOopHandle(0L);
        return VM.getVM().getObjectHeap().newOop(oopHandle);
    }

    protected void handleObject(String line) {
        StringTokenizer st = new StringTokenizer(line);
        st.nextToken();
        if (st.hasMoreTokens()) {
            String addrStr = st.nextToken();
            Address addr = null;
            JVMDebugger dbg = VM.getVM().getDebugger();
            try {
                addr = dbg.parseAddress(addrStr);
            }
            catch (Exception e) {
                this.out.println("invalid address : " + e.getMessage());
                return;
            }
            Oop oop = null;
            try {
                oop = this.getOopAtAddress(addr);
            }
            catch (Exception e) {
                this.out.println("invalid object : " + e.getMessage());
            }
            if (oop != null) {
                oop.iterate(new OopPrinter(this.out), true);
            } else {
                this.out.println("null object!");
            }
        } else {
            this.out.println("usage: object <address>");
        }
    }

    protected void handleUnknown(String line) {
        this.out.println("Unknown command!");
    }
}

