/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.utilities;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.EmptyStackException;
import java.util.Stack;
import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.debugger.AddressException;
import sun.jvm.hotspot.debugger.OopHandle;
import sun.jvm.hotspot.gc_interface.CollectedHeap;
import sun.jvm.hotspot.memory.Universe;
import sun.jvm.hotspot.oops.DefaultHeapVisitor;
import sun.jvm.hotspot.oops.DefaultOopVisitor;
import sun.jvm.hotspot.oops.InstanceKlass;
import sun.jvm.hotspot.oops.NamedFieldIdentifier;
import sun.jvm.hotspot.oops.ObjectHeap;
import sun.jvm.hotspot.oops.Oop;
import sun.jvm.hotspot.oops.OopField;
import sun.jvm.hotspot.oops.UnknownOopException;
import sun.jvm.hotspot.runtime.AddressVisitor;
import sun.jvm.hotspot.runtime.JNIHandleBlock;
import sun.jvm.hotspot.runtime.JNIHandles;
import sun.jvm.hotspot.runtime.JavaThread;
import sun.jvm.hotspot.runtime.StackFrameStream;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.utilities.HeapProgressThunk;
import sun.jvm.hotspot.utilities.LivenessPathElement;
import sun.jvm.hotspot.utilities.MarkBits;
import sun.jvm.hotspot.utilities.ReversePtrs;

public class ReversePtrsAnalysis {
    private static final boolean DEBUG = false;
    private HeapProgressThunk progressThunk;
    private long usedSize;
    private long visitedSize;
    private double lastNotificationFraction;
    private static final double MINIMUM_NOTIFICATION_FRACTION = 0.01;
    private ObjectHeap heap;
    private MarkBits markBits;
    private int depth;
    private ReversePtrs rp;

    public void setHeapProgressThunk(HeapProgressThunk thunk) {
        this.progressThunk = thunk;
    }

    public void run() {
        if (VM.getVM().getRevPtrs() != null) {
            return;
        }
        VM vm = VM.getVM();
        this.rp = new ReversePtrs();
        vm.setRevPtrs(this.rp);
        Universe universe = vm.getUniverse();
        CollectedHeap collHeap = universe.heap();
        this.usedSize = collHeap.used();
        this.visitedSize = 0L;
        if (this.progressThunk != null) {
            this.progressThunk.heapIterationFractionUpdate(0.0);
        }
        this.markBits = new MarkBits(collHeap);
        this.heap = vm.getObjectHeap();
        for (JavaThread thread = VM.getVM().getThreads().first(); thread != null; thread = thread.next()) {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            thread.printThreadIDOn(new PrintStream(bos));
            String threadDesc = " in thread \"" + thread.getThreadName() + "\" (id " + bos.toString() + ")";
            this.doStack(thread, new RootVisitor("Stack root" + threadDesc));
            this.doJNIHandleBlock(thread.activeHandles(), new RootVisitor("JNI handle root" + threadDesc));
        }
        JNIHandles handles = VM.getVM().getJNIHandles();
        this.doJNIHandleBlock(handles.globalHandles(), new RootVisitor("Global JNI handle root"));
        this.doJNIHandleBlock(handles.weakGlobalHandles(), new RootVisitor("Weak global JNI handle root"));
        this.heap.iteratePerm(new DefaultHeapVisitor(){

            @Override
            public boolean doObj(Oop obj) {
                if (obj instanceof InstanceKlass) {
                    final InstanceKlass ik = (InstanceKlass)obj;
                    ik.iterateStaticFields(new DefaultOopVisitor(){

                        @Override
                        public void doOop(OopField field, boolean isVMField) {
                            Oop next = field.getValue(this.getObj());
                            LivenessPathElement lp = new LivenessPathElement(null, new NamedFieldIdentifier("Static field \"" + field.getID().getName() + "\" in class \"" + ik.getName().asString() + "\""));
                            ReversePtrsAnalysis.this.rp.put(lp, next);
                            try {
                                ReversePtrsAnalysis.this.markAndTraverse(next);
                            }
                            catch (AddressException e) {
                                System.err.print("RevPtrs analysis: WARNING: AddressException at 0x" + Long.toHexString(e.getAddress()) + " while traversing static fields of InstanceKlass ");
                                ik.printValueOn(System.err);
                                System.err.println();
                            }
                            catch (UnknownOopException e) {
                                System.err.println("RevPtrs analysis: WARNING: UnknownOopException while traversing static fields of InstanceKlass ");
                                ik.printValueOn(System.err);
                                System.err.println();
                            }
                        }
                    });
                }
                return false;
            }
        });
        if (this.progressThunk != null) {
            this.progressThunk.heapIterationComplete();
        }
        this.markBits = null;
    }

    private void markAndTraverse(OopHandle handle) {
        try {
            this.markAndTraverse(this.heap.newOop(handle));
        }
        catch (AddressException e) {
            System.err.println("RevPtrs analysis: WARNING: AddressException at 0x" + Long.toHexString(e.getAddress()) + " while traversing oop at " + handle);
        }
        catch (UnknownOopException e) {
            System.err.println("RevPtrs analysis: WARNING: UnknownOopException for oop at " + handle);
        }
    }

    private void printHeader() {
        for (int i = 0; i < this.depth; ++i) {
            System.err.print(" ");
        }
    }

    private void markAndTraverse(Oop obj) {
        if (obj == null) {
            return;
        }
        if (!this.markBits.mark(obj)) {
            return;
        }
        final Stack workList = new Stack();
        Oop next = obj;
        try {
            while (true) {
                final Oop currObj = next;
                if (this.progressThunk != null) {
                    this.visitedSize += currObj.getObjectSize();
                    double curFrac = (double)this.visitedSize / (double)this.usedSize;
                    if (curFrac > this.lastNotificationFraction + 0.01) {
                        this.progressThunk.heapIterationFractionUpdate(curFrac);
                        this.lastNotificationFraction = curFrac;
                    }
                }
                currObj.iterate(new DefaultOopVisitor(){

                    @Override
                    public void doOop(OopField field, boolean isVMField) {
                        Oop next = field.getValue(currObj);
                        ReversePtrsAnalysis.this.rp.put(new LivenessPathElement(currObj, field.getID()), next);
                        if (next != null && ReversePtrsAnalysis.this.markBits.mark(next)) {
                            workList.push(next);
                        }
                    }
                }, false);
                next = (Oop)workList.pop();
            }
        }
        catch (EmptyStackException e) {
        }
        catch (NullPointerException e) {
            System.err.println("ReversePtrs: WARNING: " + e + " during traversal");
        }
        catch (Exception e) {
            System.err.println("ReversePtrs: WARNING: " + e + " during traversal");
        }
    }

    private void doStack(JavaThread thread, AddressVisitor oopVisitor) {
        StackFrameStream fst = new StackFrameStream(thread);
        while (!fst.isDone()) {
            fst.getCurrent().oopsDo(oopVisitor, fst.getRegisterMap());
            fst.next();
        }
    }

    private void doJNIHandleBlock(JNIHandleBlock handles, AddressVisitor oopVisitor) {
        handles.oopsDo(oopVisitor);
    }

    class RootVisitor
    implements AddressVisitor {
        private String baseRootDescription;

        RootVisitor(String baseRootDescription) {
            this.baseRootDescription = baseRootDescription;
        }

        @Override
        public void visitAddress(Address addr) {
            Oop next = ReversePtrsAnalysis.this.heap.newOop(addr.getOopHandleAt(0L));
            LivenessPathElement lp = new LivenessPathElement(null, new NamedFieldIdentifier(this.baseRootDescription + " @ " + addr));
            ReversePtrsAnalysis.this.rp.put(lp, next);
            ReversePtrsAnalysis.this.markAndTraverse(next);
        }

        @Override
        public void visitCompOopAddress(Address addr) {
            Oop next = ReversePtrsAnalysis.this.heap.newOop(addr.getCompOopHandleAt(0L));
            LivenessPathElement lp = new LivenessPathElement(null, new NamedFieldIdentifier(this.baseRootDescription + " @ " + addr));
            ReversePtrsAnalysis.this.rp.put(lp, next);
            ReversePtrsAnalysis.this.markAndTraverse(next);
        }
    }
}

