/*
 * Decompiled with CFR 0.152.
 */
package oracle.jrockit.jfr;

import com.oracle.jrockit.jfr.InvalidEventDefinitionException;
import com.oracle.jrockit.jfr.InvalidValueException;
import com.oracle.jrockit.jfr.NoSuchEventException;
import com.oracle.jrockit.jfr.Producer;
import com.oracle.jrockit.jfr.management.NoSuchRecordingException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import javax.management.openmbean.OpenDataException;
import oracle.jrockit.jfr.FlightRecorder;
import oracle.jrockit.jfr.FlightRecording;
import oracle.jrockit.jfr.JFR;
import oracle.jrockit.jfr.JFRStats;
import oracle.jrockit.jfr.Logger;
import oracle.jrockit.jfr.MetaProducer;
import oracle.jrockit.jfr.MsgLevel;
import oracle.jrockit.jfr.NativeOptions;
import oracle.jrockit.jfr.NoSuchProducerException;
import oracle.jrockit.jfr.ProducerDescriptor;
import oracle.jrockit.jfr.Recording;
import oracle.jrockit.jfr.RecordingOptions;
import oracle.jrockit.jfr.RecordingOptionsImpl;
import oracle.jrockit.jfr.Repository;
import oracle.jrockit.jfr.RepositoryChunk;
import oracle.jrockit.jfr.Settings;
import oracle.jrockit.jfr.StringConstantPool;
import oracle.jrockit.jfr.events.EventControl;
import oracle.jrockit.jfr.events.EventDescriptor;
import oracle.jrockit.jfr.events.EventHandler;
import oracle.jrockit.jfr.events.EventHandlerCreator;
import oracle.jrockit.jfr.events.JavaEventDescriptor;
import oracle.jrockit.jfr.events.JavaProducerDescriptor;
import oracle.jrockit.jfr.events.RequestableEventEnvironment;
import oracle.jrockit.jfr.settings.EventDefaultSet;
import oracle.jrockit.jfr.settings.EventSetting;
import oracle.jrockit.jfr.settings.EventSettings;
import oracle.jrockit.jfr.settings.PresetFile;

@Deprecated
public abstract class JFRImpl
extends JFR {
    protected final Logger logger = Logger.loggerFor("jfr");
    private final AtomicInteger idCounter = new AtomicInteger(4096);
    private final AtomicLong recordingCounter = new AtomicLong();
    private final HashMap<Integer, ProducerDescriptor> producerMap = new HashMap();
    private final HashMap<Integer, EventControl> eventsControls = new HashMap();
    private final Object eventLock = new Object();
    private final Object mbeanLock = new Object();
    private final Timer timer = new Timer("JFR request timer", true);
    private final HashMap<Long, Recording> recordings = new HashMap();
    private final Repository repository;
    private final Object startBarrier = new Object();
    private int numRealRecordings;
    private final FlightRecorder mbeanObject;
    private final NativeOptions options;
    private final MetaProducer metaProducer = new MetaProducer(this);
    private final Settings settings = new Settings(this.eventLock, this.eventsControls, this.recordings.values(), this.metaProducer);
    private Recording defaultRecording;
    private List<MBeanServer> mbeanServers = Collections.emptyList();
    private boolean active = true;

    JFRImpl(NativeOptions nativeOptions) throws Exception {
        this.options = nativeOptions;
        this.repository = new Repository(this, nativeOptions, this.logger);
        try {
            this.mbeanObject = new FlightRecorder(nativeOptions, this.logger, this);
        }
        catch (Exception exception) {
            this.logger.error("Could not create Flight Recorder MBean", exception);
            throw exception;
        }
        PresetFile.loadKnownPresets();
        for (String string : nativeOptions.settingsFiles()) {
            try {
                this.settings.addEventDefaultSet(this.findEventDefaultSet(string));
            }
            catch (Exception exception) {
                this.logger.log(MsgLevel.TRACE, "Unable to load and apply settings from file: " + string, new Object[0]);
                throw exception;
            }
        }
        this.logger.trace("Default settings loaded.");
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            @Override
            public void run() {
                JFRImpl.this.logger.debug("Shutdown hook: destroy java");
                JFRImpl.this.destroy();
                JFRImpl.this.logger.debug("Shutdown hook: shutdown native");
                JFRImpl.this.shutdown();
            }
        }));
        this.logger.trace("Shutdown hook registered");
    }

    @Override
    final void createMetaProducer() throws InvalidEventDefinitionException, InvalidValueException, URISyntaxException {
        this.metaProducer.createProducer();
    }

    @Override
    public final boolean active() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void bind(MBeanServer mBeanServer) {
        JFRImpl.checkControl();
        Object object = this.mbeanLock;
        synchronized (object) {
            ArrayList<MBeanServer> arrayList = new ArrayList<MBeanServer>(this.mbeanServers.size() + 1);
            arrayList.addAll(this.mbeanServers);
            arrayList.add(mBeanServer);
            this.mbeanServers = arrayList;
        }
        try {
            mBeanServer.registerMBean(this.getMBean(), new ObjectName("com.oracle.jrockit:type=FlightRecorder"));
        }
        catch (InstanceAlreadyExistsException | MBeanRegistrationException | MalformedObjectNameException | NotCompliantMBeanException jMException) {
            // empty catch block
        }
        object = this.eventLock;
        synchronized (object) {
            for (Recording recording : this.recordings.values()) {
                if (recording.objectName == null) continue;
                this.bind(recording, mBeanServer);
            }
        }
    }

    private void bind(Recording recording, MBeanServer mBeanServer) {
        try {
            FlightRecording flightRecording = new FlightRecording(recording, this.mbeanObject);
            mBeanServer.registerMBean(flightRecording, recording.objectName);
        }
        catch (InstanceAlreadyExistsException | MBeanRegistrationException | NotCompliantMBeanException | OpenDataException jMException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final ObjectName bind(Recording recording) {
        try {
            Object object = this.eventLock;
            synchronized (object) {
                if (recording.objectName == null) {
                    this.logger.log(MsgLevel.TRACE, "Binding recording %s", recording);
                    recording.objectName = new ObjectName("com.oracle.jrockit:type=FlightRecording,id=" + recording.getId() + ",name=" + recording.getName());
                    if (recording.isReleased()) {
                        return null;
                    }
                    for (MBeanServer mBeanServer : this.mbeanServers) {
                        this.bind(recording, mBeanServer);
                    }
                }
            }
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            // empty catch block
        }
        return recording.objectName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void unbind(MBeanServer mBeanServer) {
        JFRImpl.checkControl();
        Object object = this.mbeanLock;
        synchronized (object) {
            ArrayList<MBeanServer> arrayList = new ArrayList<MBeanServer>(this.mbeanServers.size());
            for (MBeanServer mBeanServer2 : this.mbeanServers) {
                if (mBeanServer2 == mBeanServer) continue;
                arrayList.add(mBeanServer2);
            }
            this.mbeanServers = arrayList;
        }
        try {
            mBeanServer.unregisterMBean(new ObjectName("com.oracle.jrockit:type=FlightRecorder"));
        }
        catch (InstanceNotFoundException | MBeanRegistrationException | MalformedObjectNameException jMException) {
            // empty catch block
        }
        object = this.eventLock;
        synchronized (object) {
            for (Recording recording : this.recordings.values()) {
                this.unbind(recording, mBeanServer);
            }
        }
    }

    private void unbind(Recording recording, MBeanServer mBeanServer) {
        if (recording.objectName == null) {
            return;
        }
        ObjectName objectName = recording.objectName;
        try {
            mBeanServer.unregisterMBean(objectName);
        }
        catch (InstanceNotFoundException | MBeanRegistrationException jMException) {
            // empty catch block
        }
    }

    private void unbind(Recording recording) {
        assert (Thread.holdsLock(this.eventLock));
        for (MBeanServer mBeanServer : this.mbeanServers) {
            this.unbind(recording, mBeanServer);
        }
    }

    final EventSettings getEventSettings() {
        return this.settings;
    }

    @Override
    public final void addProducer(Producer producer, int n, List<EventHandler> list, Map<String, StringConstantPool> map) {
        ArrayList<JavaEventDescriptor> arrayList = new ArrayList<JavaEventDescriptor>();
        for (EventHandler eventHandler : list) {
            arrayList.add(eventHandler.getDescriptor());
        }
        JavaProducerDescriptor javaProducerDescriptor = new JavaProducerDescriptor(n, producer.getName(), producer.getDescription(), producer.getURI(), arrayList, map);
        this.addProducer(javaProducerDescriptor, list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void addEventsToRegisteredProducer(Producer producer, int n, List<EventHandler> list, Map<String, StringConstantPool> map) {
        ProducerDescriptor producerDescriptor;
        Object object = this.eventLock;
        synchronized (object) {
            producerDescriptor = this.producerMap.get(n);
            if (producerDescriptor == null) {
                throw new IllegalStateException("Not a registered producer " + producer);
            }
            if (!producerDescriptor.getURI().equals(producer.getURI())) {
                throw new IllegalStateException(n + " already registered as other producer" + producerDescriptor);
            }
            if (!(producerDescriptor instanceof JavaProducerDescriptor)) {
                throw new InternalError();
            }
        }
        object = (JavaProducerDescriptor)producerDescriptor;
        ArrayList<JavaEventDescriptor> arrayList = new ArrayList<JavaEventDescriptor>();
        for (EventDescriptor object2 : ((JavaProducerDescriptor)object).getEvents()) {
            arrayList.add((JavaEventDescriptor)object2);
        }
        for (EventHandler eventHandler : list) {
            arrayList.add(eventHandler.getDescriptor());
        }
        object = new JavaProducerDescriptor(n, producer.getName(), producer.getDescription(), producer.getURI(), arrayList, map);
        this.addProducer((ProducerDescriptor)object, list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void addProducer(ProducerDescriptor producerDescriptor, Collection<? extends EventControl> collection) {
        this.add(producerDescriptor);
        Object object = this.eventLock;
        synchronized (object) {
            this.producerMap.put(producerDescriptor.getId(), producerDescriptor);
            for (EventControl eventControl : collection) {
                this.eventsControls.put(eventControl.getId(), eventControl);
            }
            this.settings.addEvents(collection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void removeProducer(int n) {
        ProducerDescriptor producerDescriptor = null;
        Object object = this.eventLock;
        synchronized (object) {
            producerDescriptor = this.producerMap.get(n);
            if (producerDescriptor == null) {
                return;
            }
            ArrayList<EventControl> arrayList = new ArrayList<EventControl>();
            EventSetting eventSetting = new EventSetting(0);
            for (EventDescriptor eventDescriptor : producerDescriptor.getEvents()) {
                EventControl eventControl = this.eventsControls.remove(eventDescriptor.getId());
                eventControl.apply(eventSetting);
                arrayList.add(eventControl);
            }
            this.settings.removeEvents(arrayList);
        }
        this.rotate();
        this.remove(producerDescriptor);
        object = this.eventLock;
        synchronized (object) {
            this.producerMap.remove(n);
        }
    }

    final EventDefaultSet findEventDefaultSet(String string) throws Exception {
        try {
            return PresetFile.createFromName(string).getSettings();
        }
        catch (FileNotFoundException fileNotFoundException) {
            String string2 = "Could not find jfc file in JDK_HOME/lib/jfr for configuration '" + string + "'. " + fileNotFoundException.getMessage();
            this.logger.log(MsgLevel.WARN, fileNotFoundException, string2, new Object[0]);
            throw new IOException(string2, fileNotFoundException);
        }
        catch (IOException iOException) {
            String string3 = "Could not read configuration '" + string + "'. " + iOException.getMessage();
            this.logger.log(MsgLevel.WARN, iOException, string3, new Object[0]);
            throw new IOException(string3, iOException);
        }
        catch (ParseException parseException) {
            String string4 = "Parse error in configuration '" + string + "'. " + parseException.getMessage();
            this.logger.log(MsgLevel.WARN, parseException, string4, new Object[0]);
            throw new ParseException(string4, parseException.getErrorOffset());
        }
        catch (Exception exception) {
            String string5 = "Error when looking for configuration '" + string + "'";
            this.logger.log(MsgLevel.WARN, exception, string5, new Object[0]);
            throw new Exception(string5, exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final EventDescriptor getEvent(int n) throws NoSuchEventException {
        Object object = this.eventLock;
        synchronized (object) {
            EventControl eventControl = this.eventsControls.get(n);
            if (eventControl == null) {
                throw new NoSuchEventException(String.valueOf(n));
            }
            return eventControl.getDescriptor();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final ProducerDescriptor getProducer(int n) throws NoSuchProducerException {
        Object object = this.eventLock;
        synchronized (object) {
            ProducerDescriptor producerDescriptor = this.producerMap.get(n);
            if (producerDescriptor == null) {
                throw new NoSuchProducerException(String.valueOf(n));
            }
            return producerDescriptor;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Collection<ProducerDescriptor> getProducers() {
        Object object = this.eventLock;
        synchronized (object) {
            return new ArrayList<ProducerDescriptor>(this.producerMap.values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Collection<EventDescriptor> getEvents() {
        ArrayList<EventDescriptor> arrayList = new ArrayList<EventDescriptor>();
        Object object = this.eventLock;
        synchronized (object) {
            for (EventControl eventControl : this.eventsControls.values()) {
                arrayList.add(eventControl.getDescriptor());
            }
        }
        return arrayList;
    }

    @Override
    public final EventHandler createHandler(JavaEventDescriptor javaEventDescriptor, Class<?> clazz, Map<String, StringConstantPool> map, RequestableEventEnvironment requestableEventEnvironment) throws InvalidEventDefinitionException {
        EventHandlerCreator eventHandlerCreator = new EventHandlerCreator(this, javaEventDescriptor, clazz, map, requestableEventEnvironment);
        return eventHandlerCreator.createHandler();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void started(Recording recording) {
        this.settings.update();
        assert (!Thread.holdsLock(this.eventLock));
        Object object = this.startBarrier;
        synchronized (object) {
            if (recording.isToDisk()) {
                int n = ++this.numRealRecordings;
                assert (n >= 1);
                if (n == 1) {
                    this.logger.debug("First recording starting...");
                    this.start(recording.isClone());
                }
                if (n > 1) {
                    this.logger.debug("Recording starting, issuing buffer rotation...");
                    this.rotate();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void stopping(Recording recording) {
        assert (!Thread.holdsLock(this.eventLock));
        Object object = this.startBarrier;
        synchronized (object) {
            if (recording.isToDisk()) {
                int n = --this.numRealRecordings;
                assert (n >= 0);
                if (n == 0) {
                    this.logger.debug("Last recording stopping...");
                    this.stop();
                }
                if (n > 0) {
                    this.logger.debug("Recording stopping, issuing buffer rotation...");
                    this.rotate();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void stopped(Recording recording) {
        boolean bl;
        assert (!Thread.holdsLock(this.eventLock));
        assert (recording.isStoppingDone());
        Object object = this.eventLock;
        synchronized (object) {
            bl = this.defaultRecording == recording;
        }
        this.settings.update();
        if (bl) {
            this.disableDefaultRecording();
        }
    }

    @Override
    public final FlightRecorder getMBean() {
        return this.mbeanObject;
    }

    protected abstract void add(ProducerDescriptor var1);

    protected abstract void remove(ProducerDescriptor var1);

    protected abstract void rotate();

    protected abstract void start(boolean var1);

    protected abstract void stop();

    protected abstract void shutdown();

    public abstract ByteBuffer getThreadBuffer(int var1);

    public abstract void releaseThreadBuffer(ByteBuffer var1, boolean var2);

    public abstract long counterTime();

    public abstract long nanoToCounter(long var1);

    public abstract long stackTraceID(int var1);

    public abstract long classID(Class<?> var1);

    public abstract int threadID();

    public abstract JFRStats getJFRStats();

    @Override
    public final int nextID() {
        return this.idCounter.incrementAndGet();
    }

    @Override
    public final Timer getTimer() {
        return this.timer;
    }

    final void onNewChunk() {
        this.metaProducer.onNewChunk();
    }

    final void chunkDone() {
        this.metaProducer.chunkDone();
    }

    final Repository getRepository() {
        return this.repository;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void addChunk(RepositoryChunk repositoryChunk) {
        Object object = this.eventLock;
        synchronized (object) {
            for (Recording recording : this.recordings.values()) {
                recording.addChunk(repositoryChunk);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final Recording getRecording(long l) throws NoSuchRecordingException {
        Object object = this.eventLock;
        synchronized (object) {
            Recording recording = this.recordings.get(l);
            if (recording == null) {
                throw new NoSuchRecordingException();
            }
            return recording;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final Collection<Recording> getRecordings() {
        Object object = this.eventLock;
        synchronized (object) {
            return new ArrayList<Recording>(this.recordings.values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Recording createRecording(String string, long l, boolean bl) throws InstanceAlreadyExistsException {
        if (string == null) {
            string = "Recording " + l;
        }
        Object object = this.eventLock;
        synchronized (object) {
            if (!this.active) {
                throw new UnsupportedOperationException("Shutdown");
            }
            if (this.recordings.containsKey(l)) {
                throw new InstanceAlreadyExistsException(string);
            }
            Recording recording = new Recording(this.logger, this.timer, string, l, this.settings.subAggregator(), bl, this);
            this.recordings.put(l, recording);
            return recording;
        }
    }

    final Recording createRecording(String string) {
        try {
            return this.createRecording(string, this.recordingCounter.incrementAndGet(), false);
        }
        catch (InstanceAlreadyExistsException instanceAlreadyExistsException) {
            throw JFRImpl.cannotHappen(instanceAlreadyExistsException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final Recording cloneRecording(Recording recording, String string, boolean bl) throws IOException {
        Recording recording2 = null;
        try {
            Object object = this.eventLock;
            synchronized (object) {
                try {
                    recording2 = this.createRecording(string, this.recordingCounter.incrementAndGet(), true);
                }
                catch (InstanceAlreadyExistsException instanceAlreadyExistsException) {
                    throw JFRImpl.cannotHappen(instanceAlreadyExistsException);
                }
            }
            recording2.settingsAggregator.copy(recording.settingsAggregator);
            object = new RecordingOptionsImpl(recording);
            ((RecordingOptionsImpl)object).setMaxAge(0L, TimeUnit.NANOSECONDS);
            ((RecordingOptionsImpl)object).setMaxSize(0L);
            recording2.setOptions((RecordingOptions)object);
            if (recording.isStarted()) {
                recording2.start();
            }
            Object object2 = this.eventLock;
            synchronized (object2) {
                recording2.copyChunks(recording);
            }
            if (bl) {
                recording2.stop();
            }
            recording2.setMaxAge(recording.getMaxAge(TimeUnit.NANOSECONDS), TimeUnit.NANOSECONDS);
            recording2.setMaxSize(recording.getMaxSize());
            return recording2;
        }
        catch (Exception exception) {
            if (recording2 != null) {
                Object object = this.eventLock;
                synchronized (object) {
                    this.recordings.remove(recording2.getId());
                }
                recording2.release();
            }
            throw exception;
        }
    }

    final void enableDefaultRecording() {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.options.settingsFiles().isEmpty()) {
            arrayList.add("default");
        }
        this.enableDefaultRecording(arrayList, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void enableDefaultRecording(List<String> list, boolean bl) {
        Recording recording = null;
        ArrayList<EventDefaultSet> arrayList = new ArrayList<EventDefaultSet>();
        for (String object : list) {
            try {
                arrayList.add(this.findEventDefaultSet(object));
            }
            catch (Exception eventDefaultSet) {}
        }
        Object object = this.eventLock;
        synchronized (object) {
            if (this.defaultRecording == null) {
                try {
                    this.defaultRecording = this.createRecording("HotSpot default", 0L, false);
                }
                catch (InstanceAlreadyExistsException instanceAlreadyExistsException) {
                    throw JFRImpl.cannotHappen(instanceAlreadyExistsException);
                }
                this.defaultRecording.setDumpOnExit(this.options.defaultDumpOnExit() || bl);
                this.defaultRecording.setToDisk(this.options.defaultRecordingToDisk());
                this.defaultRecording.setMaxAge(this.options.defaultRecordingMaxAge(), TimeUnit.NANOSECONDS);
                this.defaultRecording.setMaxSize(this.options.defaultRecordingMaxSize());
                for (EventDefaultSet eventDefaultSet : arrayList) {
                    this.defaultRecording.getEventSettings().addEventDefaultSet(eventDefaultSet);
                }
                recording = this.defaultRecording;
            }
        }
        if (recording != null) {
            recording.start();
            this.bind(recording);
            this.logger.trace("Default recording started");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void disableDefaultRecording() {
        Recording recording = null;
        Object object = this.eventLock;
        synchronized (object) {
            recording = this.defaultRecording;
            this.defaultRecording = null;
        }
        if (recording != null) {
            this.release(recording);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void release(Recording recording) {
        if (recording.isRunning()) {
            try {
                recording.stop();
            }
            catch (IllegalStateException illegalStateException) {
            }
            catch (IOException iOException) {
                this.logger.log(MsgLevel.WARN, iOException, "Exception while stopping %s", recording);
            }
        }
        recording.release();
        Object object = this.eventLock;
        synchronized (object) {
            this.recordings.remove(recording.getId());
            this.unbind(recording);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final boolean isContinuousModeRunning() {
        Object object = this.eventLock;
        synchronized (object) {
            return this.recordings.containsKey(DEFAULT_RECORDING_ID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void destroy() {
        ArrayList<Recording> arrayList;
        try {
            for (MBeanServer iterator2 : this.mbeanServers) {
                iterator2.unregisterMBean(new ObjectName("com.oracle.jrockit:type=FlightRecorder"));
            }
        }
        catch (InstanceNotFoundException | MBeanRegistrationException | MalformedObjectNameException jMException) {
            // empty catch block
        }
        this.timer.cancel();
        this.dumpOnExit();
        Object object = this.eventLock;
        synchronized (object) {
            this.active = false;
            arrayList = new ArrayList<Recording>(this.recordings.values());
        }
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            Recording recording = (Recording)iterator.next();
            this.release(recording);
        }
        this.mbeanObject.destroy();
        this.repository.destroy();
    }

    private void dumpOnExit() {
        for (Recording recording : this.getRecordings()) {
            if (!recording.getDumpOnExit() || recording.getStartTime() == null || recording.getDestination() != null) continue;
            this.dumpOnExit(recording);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dumpOnExit(Recording recording) {
        this.logger.log(MsgLevel.INFO, "Dump on exit: recording %d '%s'", recording.getId(), recording.getName());
        long l = recording.getId();
        Recording recording2 = null;
        try {
            recording2 = this.cloneRecording(recording, "dump-on-exit-clone-of-" + l, true);
            String string = this.makeDumpPath(l);
            recording2.copyTo(string, false);
            this.safeClose(recording2);
        }
        catch (Exception exception) {
            try {
                String string = "Could not dump recording %d '%s' on exit";
                this.logger.log(MsgLevel.DEBUG, exception, string, l, recording.getName());
                this.safeClose(recording2);
            }
            catch (Throwable throwable) {
                this.safeClose(recording2);
                throw throwable;
            }
        }
    }

    private void safeClose(Recording recording) {
        if (recording != null) {
            try {
                this.release(recording);
            }
            catch (Exception exception) {
                this.logger.log(MsgLevel.DEBUG, exception, "Problem releasing recording %d '%s'", recording.getId(), recording.getName());
            }
        }
    }

    private String makeDumpPath(long l) {
        String string = this.options.dumpOnExitPath();
        if (string != null) {
            File file = new File(string);
            if (file.isDirectory()) {
                return new File(file, this.makeDumpName(l)).getAbsolutePath();
            }
            return file.getAbsolutePath();
        }
        return this.makeDumpName(l);
    }

    private String makeDumpName(long l) {
        String string = Integer.toString(this.getpid());
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy_MM_dd_HH_mm_ss");
        String string2 = simpleDateFormat.format(new Date());
        return "hotspot-pid-" + string + "-id-" + l + "-" + string2 + ".jfr";
    }

    public final void logWarn(String string, Throwable throwable) {
        this.logger.warn(string, throwable);
    }
}

