/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jnlp;

import com.sun.deploy.config.Platform;
import com.sun.deploy.resources.ResourceManager;
import com.sun.javaws.JnlpxArgs;
import com.sun.jnlp.ApiDialog;
import com.sun.jnlp.CheckServicePermission;
import com.sun.jnlp.ExtendedServiceNSBImpl;
import com.sun.jnlp.FileContentsImpl;
import java.io.File;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.jnlp.ExtendedService;
import javax.jnlp.FileContents;

public final class ExtendedServiceImpl
implements ExtendedService {
    private static ExtendedService _sharedInstance = null;
    static int DEFAULT_FILESIZE = Integer.MAX_VALUE;

    private ExtendedServiceImpl() {
    }

    public static synchronized ExtendedService getInstance() {
        if (_sharedInstance == null) {
            _sharedInstance = Platform.get().isNativeSandbox() ? new ExtendedServiceNSBImpl(new ExtendedServiceImpl()) : new ExtendedServiceImpl();
        }
        return _sharedInstance;
    }

    public FileContents openFile(File file) throws IOException {
        if (file == null) {
            return null;
        }
        final File file2 = new File(file.getPath());
        if (!(CheckServicePermission.hasFileAccessPermissions(file2.toString()) || JnlpxArgs.getFileReadWriteList().contains(file2.toString()) || this.askUser(file2.getPath(), false))) {
            return null;
        }
        Object t = AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    return new FileContentsImpl(file2, DEFAULT_FILESIZE);
                }
                catch (IOException iOException) {
                    return iOException;
                }
            }
        });
        if (t instanceof IOException) {
            throw (IOException)t;
        }
        return (FileContents)t;
    }

    boolean openFile(String string) {
        if (string == null) {
            return false;
        }
        return JnlpxArgs.getFileReadWriteList().contains(string) || this.askUser(string, true);
    }

    synchronized boolean askUser(String string, boolean bl) {
        if (!bl && CheckServicePermission.hasFileAccessPermissions()) {
            return true;
        }
        ApiDialog apiDialog = new ApiDialog();
        String string2 = ResourceManager.getString((String)"api.extended.open.title");
        String string3 = ResourceManager.getString((String)"api.extended.open.message");
        String string4 = ResourceManager.getString((String)"api.extended.open.label");
        return apiDialog.askUser(string2, string3, null, string4, string, false);
    }

    public FileContents[] openFiles(File[] fileArray) throws IOException {
        int n;
        if (fileArray == null || fileArray.length <= 0) {
            return null;
        }
        final File[] fileArray2 = new File[fileArray.length];
        for (n = 0; n < fileArray.length; ++n) {
            fileArray2[n] = new File(fileArray[n].getPath());
        }
        n = 1;
        for (int i = 0; i < fileArray2.length; ++i) {
            if (CheckServicePermission.hasFileAccessPermissions(fileArray2[i].toString())) continue;
            n = 0;
            break;
        }
        String string = "";
        for (int i = 0; i < fileArray2.length; ++i) {
            string = string + fileArray2[i].getPath() + "\n";
        }
        if (n == 0 && !this.askUser(string, false)) {
            return null;
        }
        Object[] objectArray = (Object[])AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                FileContents[] fileContentsArray = new FileContents[fileArray2.length];
                try {
                    for (int i = 0; i < fileArray2.length; ++i) {
                        fileContentsArray[i] = new FileContentsImpl(fileArray2[i], DEFAULT_FILESIZE);
                    }
                }
                catch (IOException iOException) {
                    fileContentsArray[0] = iOException;
                }
                return fileContentsArray;
            }
        });
        if (objectArray[0] instanceof IOException) {
            throw (IOException)objectArray[0];
        }
        return (FileContents[])objectArray;
    }

    boolean openFiles(String[] stringArray) {
        if (stringArray == null || stringArray.length <= 0) {
            return false;
        }
        String string = "";
        for (int i = 0; i < stringArray.length; ++i) {
            string = string + stringArray[i] + "\n";
        }
        return this.askUser(string, true);
    }
}

