/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.rcp.application.scripting;

import com.jrockit.mc.rcp.application.scripting.ControlContentAdapter;
import com.jrockit.mc.rcp.application.scripting.MarkerPainter;
import com.jrockit.mc.rcp.application.scripting.ProgramUpdater;
import com.jrockit.mc.rcp.application.scripting.ProposalProvider;
import com.jrockit.mc.rcp.application.scripting.ScriptLineStyleListener;
import com.jrockit.mc.rcp.application.scripting.actions.LoadAction;
import com.jrockit.mc.rcp.application.scripting.actions.RepeatToggleAction;
import com.jrockit.mc.rcp.application.scripting.actions.RunAction;
import com.jrockit.mc.rcp.application.scripting.actions.SaveAction;
import com.jrockit.mc.rcp.application.scripting.actions.StepAction;
import com.jrockit.mc.rcp.application.scripting.actions.SuspendAction;
import com.jrockit.mc.rcp.application.scripting.actions.TerminateAction;
import com.jrockit.mc.rcp.application.scripting.model.OperatingSystem;
import com.jrockit.mc.rcp.application.scripting.model.Process;
import java.util.ArrayList;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.bindings.keys.ParseException;
import org.eclipse.jface.fieldassist.ContentProposalAdapter;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.swt.custom.LineStyleListener;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.part.ViewPart;

public final class ScriptView
extends ViewPart {
    public static final String ID = "com.jrockit.mc.rcp.application.commands.CommandView";
    private Control m_focusControl;

    public void createPartControl(Composite parent) {
        OperatingSystem os = new OperatingSystem(parent.getDisplay(), new Process());
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.horizontalSpacing = 0;
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)layout);
        GridData gd1 = new GridData(4, 4, false, true);
        gd1.widthHint = 15;
        Canvas markerArea = new Canvas(container, 0);
        markerArea.setLayoutData((Object)gd1);
        GridData gd2 = new GridData(4, 4, true, true);
        StyledText control = this.createEditor(container, os);
        control.setLayoutData((Object)gd2);
        control.addModifyListener((ModifyListener)new ProgramUpdater(os, control));
        new MarkerPainter(markerArea, os, control);
        this.createToolbar(control, os, this.getViewSite().getActionBars().getToolBarManager());
        this.m_focusControl = control;
    }

    private StyledText createEditor(Composite parent, final OperatingSystem os) {
        final StyledText control = new StyledText(parent, 514);
        control.addLineStyleListener((LineStyleListener)new ScriptLineStyleListener((Control)control, os));
        os.getProcessInFocus().addObserver(new Observer(){

            @Override
            public void update(Observable arg0, Object arg1) {
                control.setEditable(!os.getProcessInFocus().isRunning());
            }
        });
        KeyStroke key = this.createKeyStroke("CTRL+SPACE");
        new ContentProposalAdapter((Control)control, (IControlContentAdapter)new ControlContentAdapter(), (IContentProposalProvider)new ProposalProvider(), key, this.createJavaCompatibleCharacterArray());
        return control;
    }

    private char[] createJavaCompatibleCharacterArray() {
        ArrayList<Character> chars = new ArrayList<Character>();
        char c = '\u001f';
        while (c < '\u00ff') {
            if (Character.isJavaIdentifierStart(c) || Character.isJavaIdentifierPart(c)) {
                chars.add(Character.valueOf(c));
            }
            c = (char)(c + '\u0001');
        }
        char[] charArray = new char[chars.size()];
        int n = 0;
        while (n < charArray.length) {
            charArray[n] = ((Character)chars.get(n)).charValue();
            ++n;
        }
        return charArray;
    }

    private KeyStroke createKeyStroke(String text) {
        try {
            return KeyStroke.getInstance((String)text);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    private void createToolbar(StyledText st, OperatingSystem os, IToolBarManager tb) {
        tb.add((IAction)new RepeatToggleAction(os));
        tb.add((IContributionItem)new Separator());
        tb.add((IAction)new RunAction(os));
        tb.add((IAction)new SuspendAction(os));
        tb.add((IAction)new StepAction(os));
        tb.add((IAction)new TerminateAction(os));
        tb.add((IContributionItem)new Separator());
        tb.add((IAction)new LoadAction(st, os));
        tb.add((IAction)new SaveAction(st.getShell(), os));
    }

    public void setFocus() {
        if (this.m_focusControl != null && this.m_focusControl.isDisposed()) {
            this.m_focusControl.setFocus();
        }
    }
}

