/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.ui.fields;

import com.jrockit.mc.common.environment.OS;
import com.jrockit.mc.ui.UIPlugin;
import com.jrockit.mc.ui.fields.CommonLabelProvider;
import com.jrockit.mc.ui.fields.FieldLabelProvider;
import com.jrockit.mc.ui.fields.FieldViewerComparator;
import com.jrockit.mc.ui.fields.IFieldCellLabelProviderFactory;
import com.jrockit.mc.ui.handlers.CopySelectionHandler;
import com.jrockit.mc.ui.handlers.InFocusHandlerActivator;
import com.jrockit.mc.ui.misc.TreeLayout;
import com.jrockit.mc.ui.model.fields.Field;
import com.jrockit.mc.ui.model.fields.IFieldListener;
import com.jrockit.mc.ui.model.fields.IRowTreeSelection;
import com.jrockit.mc.ui.model.fields.NumberField;
import com.jrockit.mc.ui.model.fields.RowTreeSelection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import org.eclipse.core.commands.IHandler;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.TreeEvent;
import org.eclipse.swt.events.TreeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.actions.ActionFactory;

public class FieldTreeViewer
extends TreeViewer {
    protected final Field[] m_fields;
    protected boolean m_noRefresh = false;
    private ResourceManager rsrcManager;

    public FieldTreeViewer(Tree tree, Field[] fields) {
        this(tree, fields, (IBaseLabelProvider)new FieldLabelProvider(fields, (IBaseLabelProvider)new CommonLabelProvider()));
    }

    public FieldTreeViewer(Tree tree, Field[] fields, IBaseLabelProvider labelProvider) {
        super(tree);
        this.m_fields = fields;
        this.setUseHashlookup(true);
        tree.setHeaderVisible(this.m_fields.length > 1);
        tree.setLinesVisible(true);
        this.setLabelProvider(labelProvider);
        this.getTree().addControlListener((ControlListener)new ResizeListener());
        this.getTree().addKeyListener((KeyListener)new KeyExpander(this));
        CopySelectionHandler copyhandler = new CopySelectionHandler((ISelectionProvider)this);
        InFocusHandlerActivator.install((Control)this.getTree(), ActionFactory.COPY.getCommandId(), (IHandler)copyhandler);
        this.hookVisibilityListeners();
        if (OS.couldBeUsingGTK()) {
            this.hookExpandCollapseListener();
        }
    }

    public static FieldTreeViewer createWithStandardTree(Composite parent, Field[] fields) {
        Tree tree = new Tree(parent, 65794);
        return new FieldTreeViewer(tree, fields);
    }

    public void setLabelProvider(IBaseLabelProvider labelProvider) {
        super.setLabelProvider(labelProvider);
        this.refreshLayout(true);
    }

    protected void hookVisibilityListeners() {
        class RefreshColumnVisibilityListener
        implements IFieldListener {
            RefreshColumnVisibilityListener() {
            }

            @Override
            public void changed(Field field, Object property) {
                if ("visibility.change".equals(property)) {
                    FieldTreeViewer.this.refreshLayout(true);
                }
                if ("content.change".equals(property)) {
                    Object[] exp = FieldTreeViewer.this.getExpandedElements();
                    FieldTreeViewer.this.refresh(true);
                    FieldTreeViewer.this.setExpandedElements(exp);
                }
                if ("SET_SORT_ORDER_ASCENDING".equals(property)) {
                    FieldTreeViewer.this.setComparator(new FieldViewerComparator((StructuredViewer)FieldTreeViewer.this, field, true));
                }
                if ("SET_SORT_ORDER_DESCENDING".equals(property)) {
                    FieldTreeViewer.this.setComparator(new FieldViewerComparator((StructuredViewer)FieldTreeViewer.this, field, false));
                }
            }
        }
        RefreshColumnVisibilityListener listener = new RefreshColumnVisibilityListener();
        Field[] fieldArray = this.m_fields;
        int n = this.m_fields.length;
        int n2 = 0;
        while (n2 < n) {
            Field m_field = fieldArray[n2];
            m_field.addListener(listener);
            ++n2;
        }
    }

    private void hookExpandCollapseListener() {
        this.getTree().addTreeListener(new TreeListener(){

            public void treeExpanded(TreeEvent e) {
                FieldTreeViewer.this.ensureRowHeight();
            }

            public void treeCollapsed(TreeEvent e) {
                FieldTreeViewer.this.ensureRowHeight();
            }
        });
    }

    protected void setSelectionToWidget(ISelection selection, boolean reveal) {
        if (selection instanceof IRowTreeSelection) {
            IRowTreeSelection treeSelection = (IRowTreeSelection)selection;
            this.setSelectionToWidget(Arrays.asList(treeSelection.getRowPaths()), reveal);
        } else {
            super.setSelectionToWidget(selection, reveal);
        }
    }

    private Set<TreePath> getSelectedTreePaths() {
        HashSet<TreePath> paths = new HashSet<TreePath>();
        Item[] itemArray = this.getSelection(this.getControl());
        int n = itemArray.length;
        int n2 = 0;
        while (n2 < n) {
            Item item = itemArray[n2];
            paths.add(this.getTreePathFromItem(item));
            ++n2;
        }
        return paths;
    }

    public void expandSelectedPaths(int level) {
        for (TreePath path : this.getSelectedTreePaths()) {
            this.expandToLevel(path, level);
        }
    }

    public void expandSelectedPaths() {
        this.expandSelectedPaths(-1);
    }

    public void collapseSelectedPaths(int level) {
        for (TreePath path : this.getSelectedTreePaths()) {
            this.collapseToLevel(path, level);
        }
    }

    public void collapseSelectedPaths() {
        this.collapseSelectedPaths(-1);
    }

    public ISelection getSelection() {
        Item[] items = this.getSelection(this.getControl());
        ArrayList<TreePath> list = new ArrayList<TreePath>(items.length);
        Item[] itemArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            Item item = itemArray[n2];
            if (item.getData() != null) {
                list.add(this.getTreePathFromItem(item));
            }
            ++n2;
        }
        return new RowTreeSelection(list.toArray(new TreePath[list.size()]), this.getComparer(), this.getFields());
    }

    public Field[] getFields() {
        return this.m_fields;
    }

    protected void updateLabels(TreeItem[] items) {
        if (items.length == 0) {
            return;
        }
        TreeItem[] treeItemArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem item = treeItemArray[n2];
            this.updateItem((Widget)item, item.getData());
            this.updateLabels(item.getItems());
            ++n2;
        }
    }

    public void updateAllLabels() {
        this.updateLabels(this.getTree().getItems());
    }

    public void refresh(Object element) {
        try {
            this.getTree().setRedraw(false);
            super.refresh(element);
        }
        finally {
            this.getTree().setRedraw(true);
        }
    }

    public void updateLabelsOnlyFor(Object[] elements) {
        Object[] objectArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            this.updateLabelsOnlyFor(element);
            ++n2;
        }
    }

    public void updateLabelsOnlyFor(Object element) {
        Widget[] items;
        Widget[] widgetArray = items = this.findItems(element);
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            Widget item = widgetArray[n2];
            this.updateItem(item, item.getData());
            ++n2;
        }
    }

    public int getVisibleFieldCount() {
        int count = 0;
        Field[] fieldArray = this.m_fields;
        int n = this.m_fields.length;
        int n2 = 0;
        while (n2 < n) {
            Field m_field = fieldArray[n2];
            count += m_field.isVisible() ? 1 : 0;
            ++n2;
        }
        return count;
    }

    private boolean isSingleColumnTree() {
        return this.m_fields.length == 1 && !this.getTree().getHeaderVisible();
    }

    public void refreshLayout(boolean rebuild) {
        if (!this.m_noRefresh && !this.isSingleColumnTree()) {
            this.m_noRefresh = true;
            try {
                if (this.getVisibleFieldCount() != this.getTree().getColumnCount() || rebuild) {
                    this.rebuildTable();
                    this.getTree().getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (!FieldTreeViewer.this.getTree().isDisposed()) {
                                FieldTreeViewer.this.refresh();
                            }
                        }
                    });
                } else {
                    this.layoutColumns();
                }
            }
            finally {
                this.m_noRefresh = false;
            }
        }
    }

    public void setComparator(ViewerComparator comparator) {
        if (this.getComparator() == comparator) {
            this.refresh();
        } else {
            super.setComparator(comparator);
        }
        if (OS.couldBeUsingGTK()) {
            this.ensureRowHeight();
        }
    }

    private void ensureRowHeight() {
        Tree tree = this.getTree();
        tree.setFont(tree.getFont());
    }

    private void rebuildTable() {
        try {
            try {
                this.getTree().setRedraw(false);
                Object[] expanded = this.getExpandedElements();
                this.detroyColumns();
                this.addColumns();
                this.setExpandedElements(expanded);
                this.layoutColumns();
            }
            catch (Exception t) {
                UIPlugin.getDefault().getLogger().log(Level.SEVERE, "Could not refresh table column layout", t);
                this.getTree().setRedraw(true);
            }
        }
        finally {
            this.getTree().setRedraw(true);
        }
    }

    private void detroyColumns() {
        int i = this.getTree().getColumnCount() - 1;
        while (i >= 0) {
            this.getTree().getColumn(i).dispose();
            --i;
        }
    }

    private void layoutColumns() {
        TreeLayout layout = new TreeLayout();
        Field[] fieldArray = this.m_fields;
        int n = this.m_fields.length;
        int n2 = 0;
        while (n2 < n) {
            Field m_field = fieldArray[n2];
            if (m_field.isVisible()) {
                layout.addColumnData((ColumnLayoutData)new ColumnWeightData(m_field.getWidthWeight(), m_field.getMinWidth(), true));
            }
            ++n2;
        }
        this.getTree().setLayout((Layout)layout);
        this.getTree().layout();
    }

    public List<?> getVisibleElements() {
        ArrayList<Object> elements = new ArrayList<Object>(this.getTree().getItemCount());
        FieldTreeViewer.collectElements(elements, this.getTree().getItems());
        return elements;
    }

    public void selectAll() {
        this.setSelection((ISelection)new StructuredSelection(this.getVisibleElements()));
    }

    private static void collectElements(List<Object> list, TreeItem[] parents) {
        TreeItem[] treeItemArray = parents;
        int n = parents.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem parent = treeItemArray[n2];
            if (parent.getExpanded()) {
                FieldTreeViewer.collectElements(list, parent.getItems());
            }
            list.add(parent.getData());
            ++n2;
        }
    }

    private void addColumns() {
        IBaseLabelProvider treeLP = this.getLabelProvider();
        IFieldCellLabelProviderFactory factory = treeLP instanceof IFieldCellLabelProviderFactory ? (IFieldCellLabelProviderFactory)treeLP : null;
        Field[] fieldArray = this.m_fields;
        int n = this.m_fields.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            if (field.isVisible()) {
                TreeColumn treeColumn;
                int style;
                int n3 = style = field instanceof NumberField ? 131072 : 0;
                if (factory != null) {
                    TreeViewerColumn viewerColumn = new TreeViewerColumn((TreeViewer)this, style);
                    viewerColumn.setLabelProvider(factory.createCellLabelProvider(field, this.getResourceManager()));
                    treeColumn = viewerColumn.getColumn();
                } else {
                    treeColumn = new TreeColumn(this.getTree(), style);
                }
                treeColumn.setText(field.getName());
                treeColumn.setMoveable(true);
                treeColumn.addListener(13, (Listener)new FieldViewerComparator((StructuredViewer)this, field));
                treeColumn.setToolTipText(field.getDescription());
            }
            ++n2;
        }
    }

    protected ResourceManager getResourceManager() {
        if (this.rsrcManager == null) {
            this.rsrcManager = new LocalResourceManager(JFaceResources.getResources(), (Control)this.getTree());
        }
        return this.rsrcManager;
    }

    public static class KeyExpander
    implements KeyListener {
        private final FieldTreeViewer m_viewer;

        public KeyExpander(FieldTreeViewer viewer) {
            this.m_viewer = viewer;
        }

        public void keyPressed(KeyEvent e) {
            if (KeyExpander.isExpandKey(e.keyCode)) {
                this.m_viewer.expandSelectedPaths(1);
            } else if (KeyExpander.isExpandAllKey(e.keyCode)) {
                this.m_viewer.expandSelectedPaths();
            } else if (KeyExpander.isCollapseAllKey(e.keyCode)) {
                this.m_viewer.collapseSelectedPaths();
            }
        }

        private static boolean isCollapseAllKey(int keyCode) {
            return keyCode == 111;
        }

        private static boolean isExpandKey(int keyCode) {
            return keyCode == 13;
        }

        private static boolean isExpandAllKey(int keyCode) {
            return keyCode == 101;
        }

        public void keyReleased(KeyEvent e) {
        }
    }

    public class ResizeListener
    implements ControlListener {
        private int m_lastWidth;

        public void controlMoved(ControlEvent e) {
        }

        public void controlResized(ControlEvent e) {
            int width = ((Tree)e.getSource()).getClientArea().width;
            if (width != this.m_lastWidth) {
                FieldTreeViewer.this.refreshLayout(false);
                this.m_lastWidth = width;
            }
        }
    }
}

