/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.ui.formpage.commands.internal;

import com.jrockit.mc.commands.IExecute;
import com.jrockit.mc.commands.Statement;
import com.jrockit.mc.ui.dial.DialViewer;
import com.jrockit.mc.ui.formpage.commands.internal.ContextLookup;
import com.jrockit.mc.ui.formpage.commands.internal.IVisitor;
import com.jrockit.mc.ui.formpage.commands.internal.Traverser;
import java.io.PrintStream;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.Hyperlink;

public class PrintUI
implements IExecute {
    private static final int MAX_TABLE_ITEMS = 50;

    public boolean execute(Statement statement, final PrintStream out) {
        Object o = ContextLookup.getContext(out);
        if (o != null) {
            Traverser.visit(o, new IVisitor(){

                @Override
                public void visit(Object node, String text, String name) {
                    if (node instanceof Table) {
                        PrintUI.this.printTable(out, (Table)node);
                    }
                    if (node instanceof Tree) {
                        PrintUI.this.printTree(out, (Tree)node);
                    }
                    if (text != null) {
                        if (node instanceof Hyperlink || node instanceof Label || node instanceof CLabel || node instanceof FormText || node instanceof DialViewer) {
                            PrintUI.this.printValue(out, "Label", text);
                        }
                        if (node instanceof Text || node instanceof StyledText) {
                            PrintUI.this.printValue(out, "Text", text);
                        }
                        if (node instanceof Button) {
                            PrintUI.this.printButton(out, (Button)node, text);
                        }
                        if (node instanceof Combo || node instanceof CCombo) {
                            PrintUI.this.printValue(out, "Combo", text);
                        }
                    }
                }
            });
        }
        return true;
    }

    private void printValue(PrintStream out, String widgetType, String value) {
        out.println(String.valueOf(widgetType) + ": " + value);
    }

    private void printButton(PrintStream out, Button button, String text) {
        if (!this.isPushButton(button)) {
            text = String.valueOf(text) + (button.getSelection() ? " (selected)" : " (not selected)");
        }
        this.printValue(out, "Button", text);
    }

    private boolean isPushButton(Button button) {
        return (button.getStyle() & 0x32) == 0;
    }

    private void printTree(PrintStream out, Tree tree) {
        TreeColumn[] treeColumnArray = tree.getColumns();
        int n = treeColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeColumn tc = treeColumnArray[n2];
            out.println("Tree Column: " + tc.getText());
            ++n2;
        }
        int itemCount = Math.min(tree.getItemCount(), 50);
        int columnCount = tree.getColumnCount();
        int n3 = 0;
        while (n3 < itemCount) {
            TreeItem ti = tree.getItem(n3);
            out.print("Tree Item " + n3 + ": ");
            int m = 0;
            while (m < columnCount) {
                out.print(String.valueOf(ti.getText(m)) + ' ');
                ++m;
            }
            out.println();
            ++n3;
        }
    }

    private void printTable(PrintStream out, Table t) {
        TableColumn[] tableColumnArray = t.getColumns();
        int n = tableColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableColumn tc = tableColumnArray[n2];
            out.println("Table Column: " + tc.getText());
            ++n2;
        }
        int itemCount = Math.min(t.getItemCount(), 50);
        int columnCount = t.getColumnCount();
        int n3 = 0;
        while (n3 < itemCount) {
            TableItem ti = t.getItem(n3);
            out.print("Table Item " + n3 + ": ");
            int m = 0;
            while (m < columnCount) {
                out.print(String.valueOf(ti.getText(m)) + ' ');
                ++m;
            }
            out.println();
            ++n3;
        }
        if (t.getItemCount() > itemCount) {
            out.println("...");
        }
    }
}

