/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.ui.misc;

import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;

public class DateTimeChooser
extends Composite {
    private final ArrayList<SelectionListener> m_listeners = new ArrayList();
    private DateTime m_dateWidget;
    private DateTime m_timeWidget;
    private Date m_maxTime;
    private Date m_minTime;
    private DateTimeChooser m_largerChooser;
    private DateTimeChooser m_smallerChooser;

    public DateTimeChooser(Composite parent, int style) {
        super(parent, style);
        this.initWidgets();
    }

    private void initWidgets() {
        FillLayout layout = new FillLayout();
        layout.type = 256;
        this.setLayout((Layout)layout);
        SelectionListener selectionListener = this.createSelectionListener();
        this.m_dateWidget = new DateTime((Composite)this, 65572);
        this.m_dateWidget.addSelectionListener(selectionListener);
        this.m_timeWidget = new DateTime((Composite)this, 0x10000080);
        this.m_timeWidget.addSelectionListener(selectionListener);
    }

    public void setEnabled(boolean enabled) {
        this.m_dateWidget.setEnabled(enabled);
        this.m_timeWidget.setEnabled(enabled);
        super.setEnabled(enabled);
    }

    private SelectionListener createSelectionListener() {
        return new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                DateTimeChooser.this.constrainValue();
                DateTimeChooser.this.fireWidgetSelectedEvent(e);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                DateTimeChooser.this.constrainValue();
                DateTimeChooser.this.fireWidgetDefaultSelectedEvent(e);
            }
        };
    }

    private void constrainValue() {
        Date currentTime;
        Date constrainedTime = currentTime = this.getTime();
        constrainedTime = this.constrainMinimumValue(constrainedTime);
        constrainedTime = this.constrainMaximumValue(constrainedTime);
        constrainedTime = this.constrainGreaterValue(constrainedTime);
        if ((constrainedTime = this.constrainSmallerValue(constrainedTime)).compareTo(currentTime) != 0) {
            this.setTime(constrainedTime);
        }
    }

    private Date constrainMinimumValue(Date constrainedTime) {
        if (this.m_minTime != null) {
            constrainedTime = DateTimeChooser.maxDate(constrainedTime, this.m_minTime);
        }
        return constrainedTime;
    }

    private Date constrainMaximumValue(Date constrainedTime) {
        if (this.m_maxTime != null) {
            constrainedTime = DateTimeChooser.minDate(constrainedTime, this.m_maxTime);
        }
        return constrainedTime;
    }

    private Date constrainGreaterValue(Date constrainedTime) {
        if (this.m_smallerChooser != null) {
            constrainedTime = DateTimeChooser.maxDate(constrainedTime, this.m_smallerChooser.getTime());
        }
        return constrainedTime;
    }

    private Date constrainSmallerValue(Date constrainedTime) {
        if (this.m_largerChooser != null) {
            constrainedTime = DateTimeChooser.minDate(constrainedTime, this.m_largerChooser.getTime());
        }
        return constrainedTime;
    }

    private static Date minDate(Date d1, Date d2) {
        return d1.compareTo(d2) <= 0 ? d1 : d2;
    }

    private static Date maxDate(Date d1, Date d2) {
        return d1.compareTo(d2) >= 0 ? d1 : d2;
    }

    public void addSelectionListener(SelectionListener listener) {
        this.m_listeners.add(listener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.m_listeners.remove(listener);
    }

    protected void fireWidgetSelectedEvent(SelectionEvent e) {
        if (this.m_listeners.isEmpty()) {
            return;
        }
        SelectionEvent selectionEvent = this.createSelectionEvent(e);
        SelectionListener[] selectionListenerArray = this.m_listeners.toArray(new SelectionListener[this.m_listeners.size()]);
        int n = selectionListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            SelectionListener listener = selectionListenerArray[n2];
            listener.widgetSelected(selectionEvent);
            ++n2;
        }
    }

    protected void fireWidgetDefaultSelectedEvent(SelectionEvent se) {
        if (this.m_listeners.isEmpty()) {
            return;
        }
        SelectionEvent selectionEvent = this.createSelectionEvent(se);
        SelectionListener[] selectionListenerArray = this.m_listeners.toArray(new SelectionListener[this.m_listeners.size()]);
        int n = selectionListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            SelectionListener listener = selectionListenerArray[n2];
            listener.widgetDefaultSelected(selectionEvent);
            ++n2;
        }
    }

    private SelectionEvent createSelectionEvent(SelectionEvent se) {
        Event e = new Event();
        e.display = se.display;
        e.time = se.time;
        e.type = 13;
        e.widget = this;
        return new SelectionEvent(e);
    }

    public Date getTime() {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.set(this.getYear(), this.getMonth(), this.getDay(), this.getHours(), this.getMinutes(), this.getSeconds());
        return calendar.getTime();
    }

    public int getYear() {
        return this.m_dateWidget.getYear();
    }

    public int getMonth() {
        return this.m_dateWidget.getMonth();
    }

    public int getDay() {
        return this.m_dateWidget.getDay();
    }

    public int getHours() {
        return this.m_timeWidget.getHours();
    }

    public int getMinutes() {
        return this.m_timeWidget.getMinutes();
    }

    public int getSeconds() {
        return this.m_timeWidget.getSeconds();
    }

    public void setTime(Date time) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(time);
        this.m_dateWidget.setDate(calendar.get(1), calendar.get(2), calendar.get(5));
        this.m_timeWidget.setTime(calendar.get(11), calendar.get(12), calendar.get(13));
    }

    public void setTime(long time) {
        this.setTime(new Date(time));
    }

    public void setYear(int year) {
        this.m_dateWidget.setYear(year);
    }

    public void setMonth(int month) {
        this.m_dateWidget.setMonth(month);
    }

    public void setDay(int day) {
        this.m_dateWidget.setDay(day);
    }

    public void setHours(int hours) {
        this.m_timeWidget.setHours(hours);
    }

    public void setMinutes(int minutes) {
        this.m_timeWidget.setMinutes(minutes);
    }

    public void setSeconds(int seconds) {
        this.m_timeWidget.setSeconds(seconds);
    }

    public void setMaximumTime(Date maxTime) {
        this.m_maxTime = maxTime;
    }

    public void setMinimumTime(Date minTime) {
        this.m_minTime = minTime;
    }

    public void setLessThan(DateTimeChooser largerChooser) {
        this.m_largerChooser = largerChooser;
    }

    public void setGreaterThan(DateTimeChooser smallerChooser) {
        this.m_smallerChooser = smallerChooser;
    }

    public String toString() {
        return "DateTimeComposite { " + (this.getMonth() + 1) + '/' + this.getDay() + '/' + this.getYear() + ' ' + this.getHours() + ':' + this.getMinutes() + ':' + this.getSeconds() + '}';
    }
}

