/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.ui.misc;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import javax.swing.JComponent;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;

public class SwingComponentWrapperCanvas
extends Canvas {
    private final JComponent swingComponent;
    private ImageData imageDataSWT;
    private BufferedImage imageAWT;
    private Graphics2D graphicsAWT;
    private int lastDesiredWidth;

    public SwingComponentWrapperCanvas(Composite parent, JComponent swingComponent) {
        this(parent, swingComponent, 262144);
    }

    public SwingComponentWrapperCanvas(Composite parent, JComponent swingComponent, int style) {
        super(parent, style);
        this.swingComponent = swingComponent;
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                SwingComponentWrapperCanvas.this.paint(e);
            }
        });
    }

    public void paint(PaintEvent e) {
        Rectangle rect = this.getClientArea();
        if (this.imageDataSWT == null || this.lastDesiredWidth != rect.width || this.imageDataSWT.height != rect.height) {
            this.lastDesiredWidth = rect.width;
            int width = rect.width;
            while (((width * 24 + 7) / 8 + 2) / 3 * 3 % 4 != 0) {
                ++width;
            }
            this.imageAWT = new BufferedImage(width, rect.height, 5);
            PaletteData vpPalette = new PaletteData(255, 65280, 0xFF0000);
            int scanlinePad = 3;
            byte[] byteData = ((DataBufferByte)this.imageAWT.getRaster().getDataBuffer()).getData();
            this.graphicsAWT = this.imageAWT.createGraphics();
            this.imageDataSWT = new ImageData(width, rect.height, 24, vpPalette, scanlinePad, byteData);
        }
        this.swingComponent.setSize(rect.width, rect.height);
        this.swingComponent.paint(this.graphicsAWT);
        Rectangle selectedRegion = this.getSelectedArea();
        if (selectedRegion != null) {
            this.drawSelection(this.graphicsAWT, selectedRegion);
        }
        try {
            Image img = new Image((Device)e.display, this.imageDataSWT);
            e.gc.drawImage(img, rect.x, rect.y);
            img.dispose();
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
    }

    private void drawSelection(Graphics2D g, Rectangle selectedRegion) {
        g.setXORMode(Color.black);
        g.fillRect(selectedRegion.x, selectedRegion.y, selectedRegion.width, selectedRegion.height);
        g.setPaintMode();
    }

    protected Rectangle getSelectedArea() {
        return null;
    }
}

