/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.ui.misc;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.SubActionBars;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.PropertySheetPage;

public class WorkbenchPartPropertySheets
implements IPropertySheetPage {
    private final ArrayList<PropertySheetProxyPage> m_properyInfos = new ArrayList();
    private final StackLayout m_stackLayout = new StackLayout();
    private PropertySheetProxyPage m_activeInfo;
    private IActionBars m_actionBars;
    private Composite m_client;

    public WorkbenchPartPropertySheets(List<IWorkbenchPart> workbenchParts, IWorkbenchPart initialPart) {
        for (IWorkbenchPart p : workbenchParts) {
            this.m_properyInfos.add(new PropertySheetProxyPage(p));
        }
        this.m_activeInfo = this.getPropertySheetProxyPage(initialPart);
    }

    public void createControl(Composite parent) {
        this.m_client = new Composite(parent, 0);
        this.m_client.setLayout((Layout)this.m_stackLayout);
        if (this.m_activeInfo != null) {
            this.setActive(this.m_activeInfo);
        } else if (this.m_properyInfos.size() > 0) {
            this.setActive(this.m_properyInfos.get(0));
        }
    }

    public void dispose() {
        for (PropertySheetProxyPage info : this.m_properyInfos) {
            info.dispose();
        }
        this.m_properyInfos.clear();
    }

    public Control getControl() {
        return this.m_client;
    }

    private void setActive(PropertySheetProxyPage info) {
        if (info.getControl() == null) {
            info.createControl((Composite)this.getControl());
        }
        this.m_stackLayout.topControl = info.getControl();
        info.setActionBars(this.m_actionBars);
        info.getControl().getParent().getParent().layout(true, true);
        this.m_activeInfo = info;
    }

    public void setActionBars(IActionBars actionBars) {
        this.m_actionBars = actionBars;
        PropertySheetProxyPage active = this.getActive();
        if (active != null) {
            active.setActionBars(this.m_actionBars);
        }
    }

    private PropertySheetProxyPage getActive() {
        return this.m_activeInfo;
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        PropertySheetProxyPage active = this.getActive();
        if (active != null) {
            active.selectionChanged(part, selection);
        }
    }

    public void setFocus() {
        PropertySheetProxyPage active = this.getActive();
        if (active != null) {
            active.setFocus();
        }
    }

    private PropertySheetProxyPage getPropertySheetProxyPage(Object page) {
        for (PropertySheetProxyPage info : this.m_properyInfos) {
            if (!info.workbenchPart.equals(page)) continue;
            return info;
        }
        return null;
    }

    public void setActivePart(IWorkbenchPart workbenchPart) {
        PropertySheetProxyPage info = this.getPropertySheetProxyPage(workbenchPart);
        if (info != null) {
            this.setActive(info);
        }
    }

    static class PropertySheetProxyPage
    implements ISelectionChangedListener,
    IPropertySheetPage {
        IWorkbenchPart workbenchPart;
        IPropertySheetPage sheet;
        Composite container;
        SubActionBars subActionBars;

        PropertySheetProxyPage(IWorkbenchPart part) {
            this.workbenchPart = part;
        }

        public void createControl(Composite parent) {
            Object sheetCandidate = this.workbenchPart.getAdapter(IPropertySheetPage.class);
            this.sheet = sheetCandidate instanceof IPropertySheetPage ? (IPropertySheetPage)sheetCandidate : new PropertySheetPage();
            this.container = new Composite(parent, 0);
            this.container.setLayout((Layout)new FillLayout());
            this.sheet.createControl(this.container);
            if (this.workbenchPart.getSite() != null && this.workbenchPart.getSite().getSelectionProvider() != null) {
                this.workbenchPart.getSite().getSelectionProvider().addSelectionChangedListener((ISelectionChangedListener)this);
                this.selectionChanged(this.workbenchPart, this.workbenchPart.getSite().getSelectionProvider().getSelection());
            }
        }

        public void selectionChanged(SelectionChangedEvent event) {
            if (this.sheet.getControl() != null && !this.sheet.getControl().isDisposed()) {
                this.sheet.selectionChanged(this.workbenchPart, event.getSelection());
            }
        }

        public void dispose() {
            if (this.workbenchPart.getSite() != null && this.workbenchPart.getSite().getSelectionProvider() != null) {
                this.workbenchPart.getSite().getSelectionProvider().removeSelectionChangedListener((ISelectionChangedListener)this);
            }
        }

        public Control getControl() {
            return this.container;
        }

        public void setActionBars(IActionBars parentActionBars) {
            if (parentActionBars == null) {
                return;
            }
            if (this.subActionBars == null) {
                this.subActionBars = new SubActionBars(parentActionBars);
                this.sheet.setActionBars((IActionBars)this.subActionBars);
            }
            this.fillContributionManager((IContributionManager)parentActionBars.getToolBarManager(), (IContributionManager)this.subActionBars.getToolBarManager());
            this.fillContributionManager((IContributionManager)parentActionBars.getMenuManager(), (IContributionManager)this.subActionBars.getMenuManager());
            this.fillContributionManager((IContributionManager)parentActionBars.getStatusLineManager(), (IContributionManager)this.subActionBars.getStatusLineManager());
        }

        private void fillContributionManager(IContributionManager parent, IContributionManager child) {
            if (parent != null) {
                parent.removeAll();
                for (IContributionItem item : this.getItemsSortedById(child)) {
                    parent.add(item);
                }
                parent.update(true);
            }
        }

        private List<IContributionItem> getItemsSortedById(IContributionManager child) {
            ArrayList<IContributionItem> list = new ArrayList<IContributionItem>();
            list.addAll(Arrays.asList(child.getItems()));
            Collections.sort(list, new Comparator<IContributionItem>(){

                @Override
                public int compare(IContributionItem a, IContributionItem b) {
                    return a.getId() != null && b.getId() != null ? a.getId().compareTo(b.getId()) : 0;
                }
            });
            return list;
        }

        public void setFocus() {
            this.sheet.setFocus();
        }

        public void selectionChanged(IWorkbenchPart part, ISelection selection) {
            this.sheet.selectionChanged(part, selection);
        }
    }
}

