/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.ui.model.fields;

import com.jrockit.mc.common.parsing.Tokenizer;
import com.jrockit.mc.ui.model.fields.Field;
import com.jrockit.mc.ui.model.fields.Messages;

public class BooleanField
extends Field {
    public static final String CLIPBOARD_VALUE_TRUE = "1";
    public static final String CLIPBOARD_VALUE_FALSE = "0";

    public BooleanField(int id) {
        super(id);
    }

    @Override
    public String formatObject(Object object) {
        if (object instanceof Boolean) {
            if (((Boolean)object).booleanValue()) {
                return Messages.BooleanField_STRING_VALUE_TRUE;
            }
            return Messages.BooleanField_STRING_VALUE_FALSE;
        }
        return super.formatObject(object);
    }

    @Override
    public String formatForClipboard(Object object) {
        if (object instanceof Boolean) {
            if (((Boolean)object).booleanValue()) {
                return CLIPBOARD_VALUE_TRUE;
            }
            return CLIPBOARD_VALUE_FALSE;
        }
        return super.formatForClipboard(object);
    }

    @Override
    public Object parse(Tokenizer tokenizer) {
        String text = tokenizer.peek().text;
        if (Boolean.TRUE.toString().equalsIgnoreCase(text) || text.equals(Messages.BooleanField_STRING_VALUE_TRUE)) {
            tokenizer.next();
            return Boolean.TRUE;
        }
        if (Boolean.FALSE.toString().equalsIgnoreCase(text) || text.equals(Messages.BooleanField_STRING_VALUE_FALSE)) {
            tokenizer.next();
            return Boolean.FALSE;
        }
        return null;
    }

    @Override
    public int compare(Object a, Object b, boolean ascendingOrder) {
        if (a instanceof Boolean && b instanceof Boolean) {
            return ascendingOrder ? ((Boolean)a).compareTo((Boolean)b) : ((Boolean)b).compareTo((Boolean)a);
        }
        return 0;
    }
}

