/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.ui.model.fields;

import com.jrockit.mc.common.parsing.Tokenizer;
import com.jrockit.mc.ui.model.fields.NumberField;
import java.text.ParseException;

public class HexField
extends NumberField {
    public HexField(int id) {
        super(id);
    }

    @Override
    public String formatObject(Object object) {
        if (object instanceof Long) {
            Long l = (Long)object;
            return "0x" + Long.toHexString(l).toUpperCase();
        }
        return super.formatObject(object);
    }

    @Override
    public String formatForClipboard(Object object) {
        return this.formatObject(object);
    }

    @Override
    public Object parse(Tokenizer tokenizer) throws ParseException {
        String text = tokenizer.peek().text;
        if (text.startsWith("0x") || text.startsWith("0X")) {
            try {
                long l = Long.parseLong(text.substring(2), 16);
                tokenizer.next();
                return l;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return super.parse(tokenizer);
    }
}

