/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.ui.model.fields;

import com.jrockit.mc.common.parsing.Tokenizer;
import com.jrockit.mc.common.util.Messages;
import com.jrockit.mc.ui.model.fields.NumberField;
import com.jrockit.mc.ui.model.fields.TimespanParser;
import java.text.NumberFormat;
import java.text.ParseException;

public class SecondsField
extends NumberField {
    private static NumberFormat secondsFormat = NumberFormat.getInstance();

    static {
        secondsFormat.setMaximumFractionDigits(3);
        secondsFormat.setMinimumFractionDigits(3);
    }

    public SecondsField(int id) {
        super(id);
    }

    @Override
    public String formatObject(Object object) {
        if (object instanceof Number && SecondsField.isValid((Number)object)) {
            return String.valueOf(SecondsField.formatSeconds((Number)object)) + ' ' + Messages.getString((String)"TimeRangeToolkit_SECONDS_SHORT", (String)"s");
        }
        return super.formatObject(object);
    }

    @Override
    public String formatForClipboard(Object object) {
        if (object instanceof Number && SecondsField.isValid((Number)object)) {
            return SecondsField.formatSeconds((Number)object);
        }
        return super.formatObject(object);
    }

    private static String formatSeconds(Number millis) {
        return secondsFormat.format(millis.doubleValue() / 1000.0);
    }

    @Override
    public String getUnit() {
        return "s";
    }

    @Override
    public Object parse(Tokenizer tokenizer) throws ParseException {
        return (double)TimespanParser.parse(tokenizer).longValue() / 1.0E9;
    }
}

