/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.rjmx.subscription.internal;

import com.jrockit.mc.common.xml.XmlEnabled;
import com.jrockit.mc.common.xml.XmlToolkit;
import com.jrockit.mc.rjmx.subscription.IMRIMetaData;
import com.jrockit.mc.rjmx.subscription.MRI;
import com.jrockit.mc.rjmx.subscription.MRIMetaDataToolkit;
import com.jrockit.mc.rjmx.subscription.internal.UpdatePolicyToolkit;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class FileMRIMetaData
implements XmlEnabled,
IMRIMetaData {
    public static final String XML_COMPONENT_TAG = "metadata";
    public static final String ATTRIBUTE_VALUE_TRUE = "true";
    public static final String ATTRIBUTE_VALUE_FALSE = "false";
    protected static final String ELEMENT_NAME_MRI_DATA_PATH = "mri.dataPath";
    private static final String ELEMENT_NAME_MRI_OBJECT_NAME = "mri.objectName";
    private static final String ELEMENT_NAME_MRI_TYPE = "mri.type";
    private static final String ELEMENT_NAME_MRI_QUALIFIED_NAME = "mri.qualifiedName";
    public static final String ELEMENT_NAME_DISPLAY_NAME = "displayname";
    public static final String ELEMENT_NAME_DESCRIPTION = "description";
    public static final String ELEMENT_NAME_UPDATE_TIME = "updatetime";
    public static final String ELEMENT_NAME_UNIT_STRING = "unitstring";
    public static final String ELEMENT_NAME_COMPOSITE = "composite";
    public static final String ELEMENT_NAME_TYPE = "type";
    public static final String ELEMENT_NAME_ARGUMENTS = "arguments";
    public static final String ELEMENT_NAME_PERSISTENT = "persistent";
    public static final String DEFAULT_DISPLAY_NAME = "No name";
    public static final String DEFAULT_DESCRIPTION = "This attribute have no extended description";
    public static final int DEFAULT_UPDATE_TIME = -1;
    private static final Logger LOGGER = Logger.getLogger("com.jrockit.mc.rjmx");
    private MRI m_attributeDescriptor;
    private String m_attributeType;
    private String m_displayName;
    private String m_description;
    private String m_unitString;
    private int m_updateTime;
    private final Properties m_defaultValues = new Properties();

    public FileMRIMetaData() {
    }

    public FileMRIMetaData(MRI descriptor) {
        this.m_attributeDescriptor = descriptor;
    }

    @Override
    public MRI getMRI() {
        return this.m_attributeDescriptor;
    }

    public void setAttributeDescriptor(MRI attributeDescriptor) {
        this.m_attributeDescriptor = attributeDescriptor;
    }

    @Override
    public String getDescription() {
        return this.m_description;
    }

    public void setDescription(String description) {
        this.m_description = description;
    }

    @Override
    public String getDisplayName() {
        try {
            if (this.m_displayName == null) {
                return this.m_attributeDescriptor.getDataPath();
            }
        }
        catch (NullPointerException npe) {
            npe.printStackTrace();
        }
        return this.m_displayName;
    }

    public void setDisplayName(String displayName) {
        this.m_displayName = displayName;
    }

    @Override
    public int getUpdateTime() {
        return this.m_updateTime;
    }

    public void setUpdateTime(int updateTime) {
        this.m_updateTime = updateTime;
    }

    public void initializeFromXml(Element node) {
        String mriType = XmlToolkit.getSetting((Element)node, (String)ELEMENT_NAME_MRI_TYPE, (String)MRI.Type.ATTRIBUTE.getTypeName());
        String mriDataPath = XmlToolkit.getSetting((Element)node, (String)ELEMENT_NAME_MRI_DATA_PATH, null);
        String mriObjectName = XmlToolkit.getSetting((Element)node, (String)ELEMENT_NAME_MRI_OBJECT_NAME, null);
        String mriQualifiedName = XmlToolkit.getSetting((Element)node, (String)ELEMENT_NAME_MRI_QUALIFIED_NAME, null);
        if ((mriDataPath == null || mriObjectName == null) && mriQualifiedName == null) {
            LOGGER.warning("Could not read meta data information properly. [dataPath=" + mriDataPath + ",objectName=" + mriObjectName + "|qualifiedName=null] will not be properly configured.");
            return;
        }
        this.m_attributeDescriptor = mriQualifiedName != null ? MRI.createFromQualifiedName(mriQualifiedName) : new MRI(MRI.Type.fromString(mriType), mriObjectName.intern(), mriDataPath.intern());
        try {
            this.m_updateTime = Integer.parseInt(XmlToolkit.getSetting((Element)node, (String)ELEMENT_NAME_UPDATE_TIME, (String)Integer.toString(-1)));
        }
        catch (NumberFormatException e) {
            LOGGER.log(Level.WARNING, "Warning: The update_interval specified for attribute " + this.m_attributeDescriptor + " is malformed. The default update time (" + Integer.toString(UpdatePolicyToolkit.getDefaultUpdateInterval()) + " will be used instead.", e);
            this.m_updateTime = -1;
        }
        this.m_displayName = XmlToolkit.getSetting((Element)node, (String)ELEMENT_NAME_DISPLAY_NAME, (String)DEFAULT_DISPLAY_NAME);
        this.m_description = XmlToolkit.getSetting((Element)node, (String)ELEMENT_NAME_DESCRIPTION, (String)DEFAULT_DESCRIPTION);
        this.m_unitString = XmlToolkit.getSetting((Element)node, (String)ELEMENT_NAME_UNIT_STRING, null);
        this.setAttributeType(XmlToolkit.getSetting((Element)node, (String)ELEMENT_NAME_TYPE, null));
        this.initializeArgument(this.getMRI(), node);
    }

    protected void initializeArgument(MRI attributeDescriptor, Element node) {
        List propsList = XmlToolkit.getChildElementsByTag((Node)node, (String)ELEMENT_NAME_ARGUMENTS);
        if (propsList.size() != 0) {
            if (propsList.size() != 1) {
                LOGGER.warning("Warning: Found several arguments listings for attribute " + this.m_attributeDescriptor.toString() + ". Will use only first.");
            }
            NodeList arguments = ((Element)propsList.get(0)).getChildNodes();
            int i = 0;
            int length = arguments.getLength();
            while (i < length) {
                if (arguments.item(i) instanceof Element) {
                    Element argument = (Element)arguments.item(i);
                    this.m_defaultValues.put(argument.getNodeName(), XmlToolkit.getStringValue((Element)argument));
                }
                ++i;
            }
        }
    }

    public void exportToXml(Element parentNode) {
        XmlToolkit.setSetting((Element)parentNode, (String)ELEMENT_NAME_MRI_TYPE, (String)this.getMRI().getType().getTypeName());
        XmlToolkit.setSetting((Element)parentNode, (String)ELEMENT_NAME_MRI_DATA_PATH, (String)this.getMRI().getDataPath());
        XmlToolkit.setSetting((Element)parentNode, (String)ELEMENT_NAME_MRI_OBJECT_NAME, (String)this.getMRI().getObjectName().getCanonicalName());
        XmlToolkit.setSetting((Element)parentNode, (String)ELEMENT_NAME_DISPLAY_NAME, (String)this.getDisplayName());
        XmlToolkit.setSetting((Element)parentNode, (String)ELEMENT_NAME_DESCRIPTION, (String)this.getDescription());
        XmlToolkit.setSetting((Element)parentNode, (String)ELEMENT_NAME_UPDATE_TIME, (String)Integer.valueOf(this.getUpdateTime()).toString());
        XmlToolkit.setSetting((Element)parentNode, (String)ELEMENT_NAME_UNIT_STRING, (String)this.getUnitString());
        XmlToolkit.setSetting((Element)parentNode, (String)ELEMENT_NAME_TYPE, (String)this.getValueType());
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + '[' + this.getMRI() + ",update time=" + this.getUpdateTime() + ']';
    }

    @Override
    public String getValueType() {
        return this.m_attributeType;
    }

    public void setAttributeType(String attributeType) {
        if (attributeType != null) {
            this.m_attributeType = attributeType.intern();
        }
        if (this.isComposite() && this.getClass().equals(FileMRIMetaData.class)) {
            throw new RuntimeException("Composites must be of type CompositeAttributeInfo");
        }
    }

    @Override
    public String getUnitString() {
        return this.m_unitString;
    }

    public void setUnitString(String unitString) {
        this.m_unitString = unitString;
    }

    @Override
    public Object getMetaData(String property) {
        return null;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FileMRIMetaData)) {
            return false;
        }
        return this.toString().equals(obj.toString());
    }

    public int hashCode() {
        return this.getMRI().hashCode();
    }

    public boolean isComposite() {
        return MRIMetaDataToolkit.isCompositeType(this.getValueType());
    }

    public boolean isNumerical() {
        return MRIMetaDataToolkit.isNumerical(this);
    }

    public String getComponentTag() {
        return XML_COMPONENT_TAG;
    }

    Properties getDefaultValues() {
        return this.m_defaultValues;
    }
}

