/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.rjmx.subscription.internal;

import com.jrockit.mc.common.util.ColorToolkit;
import com.jrockit.mc.rjmx.IConnectionHandle;
import com.jrockit.mc.rjmx.subscription.IMRIMetaData;
import com.jrockit.mc.rjmx.subscription.IMRIMetaDataService;
import com.jrockit.mc.rjmx.subscription.IMRITransformation;
import com.jrockit.mc.rjmx.subscription.IMRIValueListener;
import com.jrockit.mc.rjmx.subscription.ISubscriptionService;
import com.jrockit.mc.rjmx.subscription.MRI;
import com.jrockit.mc.rjmx.subscription.MRIValueEvent;
import com.jrockit.mc.rjmx.subscription.internal.AbstractAttributeSubscription;
import java.awt.Color;

public class TransformationSubscription
extends AbstractAttributeSubscription {
    private final IMRITransformation m_transformation;
    private final IMRIValueListener m_mriListener;
    private final ISubscriptionService m_subscriptionService;

    protected static String getDistinguishableColorString(MRI mri) {
        return ColorToolkit.encode((Color)ColorToolkit.getDistinguishableColor((Object)mri));
    }

    public TransformationSubscription(IConnectionHandle connectionHandle, IMRIMetaData info, IMRITransformation transformation) {
        super(connectionHandle, info);
        this.m_transformation = transformation;
        this.m_mriListener = this.createListener();
        this.m_subscriptionService = this.getConnectionHandle().getServiceOrDummy(ISubscriptionService.class);
        MRI[] mRIArray = transformation.getAttributes();
        int n = mRIArray.length;
        int n2 = 0;
        while (n2 < n) {
            MRI mri = mRIArray[n2];
            this.m_subscriptionService.addMRIValueListener(mri, this.m_mriListener);
            ++n2;
        }
        transformation.extendMetaData(connectionHandle.getServiceOrDummy(IMRIMetaDataService.class), info);
    }

    private IMRIValueListener createListener() {
        return new IMRIValueListener(){

            @Override
            public void valueChanged(MRIValueEvent event) {
                Object eventValue = TransformationSubscription.this.m_transformation.createSubscriptionValue(event);
                if (eventValue != IMRITransformation.NO_VALUE) {
                    MRIValueEvent newEvent = new MRIValueEvent(TransformationSubscription.this.getMRIMetaData().getMRI(), TransformationSubscription.this.getConnectionHandle(), event.getTimestamp(), eventValue);
                    TransformationSubscription.this.fireAttributeChange(newEvent);
                }
            }
        };
    }

    public void unregisterSubscription() {
        this.m_subscriptionService.removeMRIValueListener(this.m_mriListener);
    }
}

