/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.rjmx.triggers;

import com.jrockit.mc.rjmx.IConnectionHandle;
import com.jrockit.mc.rjmx.triggers.TriggerRule;
import java.util.Date;

public class TriggerEvent {
    private TriggerRule m_rule;
    private IConnectionHandle m_source;
    private Object m_value;
    private Date m_creationTime = new Date();
    private int m_sustainTime;
    private boolean m_wasTriggered;

    TriggerEvent(Date creationTime) {
        this.m_creationTime = creationTime;
    }

    public TriggerEvent(IConnectionHandle source, TriggerRule rule, Object triggerValue, boolean wasTriggered) {
        this(source, rule, triggerValue, wasTriggered, 0);
    }

    public TriggerEvent(IConnectionHandle source, TriggerRule rule, Object triggerValue, boolean wasTriggered, int sustainTime) {
        this.m_source = source;
        this.m_value = triggerValue;
        this.m_rule = rule;
        this.m_wasTriggered = wasTriggered;
        this.m_sustainTime = sustainTime;
    }

    public Object getTriggerValue() {
        return this.m_value;
    }

    public Date getCreationTime() {
        return this.m_creationTime;
    }

    public TriggerRule getRule() {
        return this.m_rule;
    }

    public boolean wasTriggered() {
        return this.m_wasTriggered;
    }

    public boolean wasRecovered() {
        return !this.m_wasTriggered;
    }

    public String getConnectorSourceDescription() {
        return this.m_source.getServerDescriptor().getDisplayName();
    }

    public String toString() {
        return String.valueOf(this.getConnectorSourceDescription()) + '/' + this.getRule().getName() + " - " + this.getCreationTime();
    }

    public int getSustainTime() {
        return this.m_sustainTime;
    }

    public IConnectionHandle getSource() {
        return this.m_source;
    }
}

