/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.rjmx.triggers.internal;

import java.util.Date;
import java.util.GregorianCalendar;

public class TimeEntry {
    private final int m_hour;
    private final int m_minute;

    public TimeEntry(int hour, int minute) {
        this.m_hour = hour;
        this.m_minute = minute;
    }

    public TimeEntry(String hourMinute) {
        String hour = hourMinute.substring(0, hourMinute.indexOf(58));
        String minute = hourMinute.substring(hourMinute.indexOf(58) + 1);
        this.m_hour = Integer.parseInt(hour);
        this.m_minute = Integer.parseInt(minute);
    }

    public TimeEntry(Date time) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(time);
        this.m_hour = cal.get(11);
        this.m_minute = cal.get(12);
    }

    public static TimeEntry createRoundedTimeEntry(Date time) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(time);
        int hour = cal.get(11);
        int minute = cal.get(12);
        int minuteDiff = minute % 5;
        if (minuteDiff != 0) {
            int minutesToAdd = 5 - minuteDiff;
            return new TimeEntry(new Date(time.getTime() + (long)minutesToAdd * 60L * 1000L));
        }
        return new TimeEntry(hour, minute);
    }

    public int getHour() {
        return this.m_hour;
    }

    public int getMinute() {
        return this.m_minute;
    }

    public boolean afterOrEquals(TimeEntry time) {
        return !this.before(time);
    }

    public boolean before(TimeEntry time) {
        if (this.m_hour < time.m_hour) {
            return true;
        }
        return this.m_hour == time.m_hour && this.m_minute < time.m_minute;
    }

    public boolean equalsTime(TimeEntry time) {
        return this.m_hour == time.m_hour && this.m_minute == time.m_minute;
    }

    public boolean beforeOrEquals(TimeEntry time) {
        return this.before(time) || this.equalsTime(time);
    }

    public String toString() {
        return "" + this.m_hour + ':' + TimeEntry.padInt(this.m_minute);
    }

    private static String padInt(int i) {
        String tmp = String.valueOf(i);
        if (tmp.length() == 1) {
            return String.valueOf('0') + tmp;
        }
        return tmp;
    }
}

