/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.tools.ant;

import com.sun.javafx.tools.packager.DeployParams;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.types.DataType;

public class Info
extends DataType {
    String title;
    String vendor;
    String appDescription;
    String category;
    String licenseType;
    String copyright;
    List<Icon> icons = new LinkedList<Icon>();
    static final Set<String> iconTypes = new HashSet<String>(){
        {
            this.add("default");
            this.add("selected");
            this.add("disabled");
            this.add("rollover");
            this.add("splash");
            this.add("shortcut");
        }
    };

    public void setCategory(String v) {
        this.category = v;
    }

    public void setLicense(String v) {
        this.licenseType = v;
    }

    public void setCopyright(String v) {
        this.copyright = v;
    }

    public void setTitle(String v) {
        this.title = v;
    }

    public void setVendor(String v) {
        this.vendor = v;
    }

    public void setDescription(String v) {
        this.appDescription = v;
    }

    public Icon createIcon() {
        Icon ic = new Icon();
        this.icons.add(ic);
        return ic;
    }

    public Splash createSplash() {
        Splash s = new Splash();
        this.icons.add(s);
        return s;
    }

    public class Splash
    extends Icon {
        DeployParams.RunMode mode;

        public Splash() {
            this.kind = "splash";
        }

        public void setKind() {
            throw new BuildException("Can not change kind of splash. Use icon instead.");
        }

        public void setMode(String v) {
            String l = v.toLowerCase();
            if ("webstart".equals(l)) {
                this.mode = DeployParams.RunMode.WEBSTART;
            } else if ("embedded".equals(l)) {
                this.mode = DeployParams.RunMode.EMBEDDED;
            } else if ("standalone".equals(l)) {
                this.mode = DeployParams.RunMode.STANDALONE;
            } else if ("any".equals(l)) {
                this.mode = DeployParams.RunMode.ALL;
            } else {
                throw new BuildException("Unsupported run mode: [" + v + "].");
            }
        }
    }

    public class Icon
    extends DataType {
        String href;
        String kind;
        int width = -1;
        int height = -1;
        int depth = -1;
        static final int UNDEFINED = -1;

        public void setHref(String v) {
            this.href = v;
        }

        public void setKind(String v) {
            if (!iconTypes.contains(v.toLowerCase())) {
                StringBuffer msg = new StringBuffer("Usupported type of icon [");
                msg.append(v.toLowerCase());
                msg.append("]. Supported types: ");
                for (String s : iconTypes) {
                    msg.append("\"" + s + "\" ");
                }
                throw new BuildException(msg.toString());
            }
            this.kind = v.toLowerCase();
        }

        public void setWidth(int v) {
            if (v <= 0) {
                throw new BuildException("Width must be positive number");
            }
            this.width = v;
        }

        public void setHeight(int v) {
            if (v <= 0) {
                throw new BuildException("Height must be positive number");
            }
            this.height = v;
        }

        public void setDepth(int v) {
            if (v <= 0) {
                throw new BuildException("Depth must be positive number");
            }
            this.depth = v;
        }
    }
}

