/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.tools.resource;

import com.sun.javafx.tools.resource.PackagerResource;
import com.sun.javafx.tools.resource.ResourceFilter;
import com.sun.javafx.tools.resource.ResourceTraversal;
import java.io.File;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;

public final class ConsolidatedResources {
    private final SortedMap<ResourceKey, ResourceRecord> resourceMap = new TreeMap<ResourceKey, ResourceRecord>();

    public void addResource(PackagerResource resource) {
        this.addResource(resource, null);
    }

    public void addResource(PackagerResource resource, ResourceFilter resourceFilter) {
        resource.traverse(new ResourceRegistration(this.resourceMap), resourceFilter);
    }

    public boolean traverse(ResourceTraversal resourceTraversal) {
        for (Map.Entry<ResourceKey, ResourceRecord> mapEntry : this.resourceMap.entrySet()) {
            ResourceRecord resourceRecord = mapEntry.getValue();
            if (resourceTraversal.traverse(resourceRecord.getRootResource(), resourceRecord.getFile(), resourceRecord.getRelativePath())) continue;
            return false;
        }
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ResourceKey
    implements Comparable<ResourceKey> {
        private final String directory;
        private final String fileName;

        private ResourceKey(String directory, String fileName) {
            this.directory = directory;
            this.fileName = fileName;
        }

        public static ResourceKey forFile(String relPath) {
            int lastSlashIndex = relPath.lastIndexOf(47);
            if (lastSlashIndex == -1) {
                return new ResourceKey("", relPath);
            }
            return new ResourceKey(relPath.substring(0, lastSlashIndex), relPath.substring(lastSlashIndex + 1));
        }

        public static ResourceKey forDirectory(String relPath) {
            return new ResourceKey(relPath, "");
        }

        public String getDirectory() {
            return this.directory;
        }

        public String getFileName() {
            return this.fileName;
        }

        @Override
        public int compareTo(ResourceKey otherKey) {
            int dirResult = this.directory.compareTo(otherKey.directory);
            return dirResult != 0 ? dirResult : this.fileName.compareTo(otherKey.fileName);
        }

        public boolean equals(Object other) {
            if (other == this) {
                return true;
            }
            if (!(other instanceof ResourceKey)) {
                return false;
            }
            return this.compareTo((ResourceKey)other) == 0;
        }

        public int hashCode() {
            int hash = 7;
            hash = 97 * hash + this.directory.hashCode();
            hash = 97 * hash + this.fileName.hashCode();
            return hash;
        }
    }

    private static final class ResourceRecord {
        private final PackagerResource rootResource;
        private final File file;
        private final String relativePath;

        public ResourceRecord(PackagerResource rootResource, File file, String relativePath) {
            this.rootResource = rootResource;
            this.file = file;
            this.relativePath = relativePath;
        }

        public PackagerResource getRootResource() {
            return this.rootResource;
        }

        public File getFile() {
            return this.file;
        }

        public String getRelativePath() {
            return this.relativePath;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ResourceRegistration
    implements ResourceTraversal {
        private final Map<ResourceKey, ResourceRecord> resourceMap;

        public ResourceRegistration(Map<ResourceKey, ResourceRecord> resourceMap) {
            this.resourceMap = resourceMap;
        }

        @Override
        public boolean traverse(PackagerResource rootResource, File file, String relativePath) {
            this.resourceMap.put(file.isDirectory() ? ResourceKey.forDirectory(relativePath) : ResourceKey.forFile(relativePath), new ResourceRecord(rootResource, file, relativePath));
            return true;
        }
    }
}

