/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.ui.components.aggregators;

import com.jrockit.mc.flightrecorder.ui.components.aggregators.AggregatorDescriptor;
import com.jrockit.mc.flightrecorder.ui.components.aggregators.Average;
import com.jrockit.mc.flightrecorder.ui.components.aggregators.Count;
import com.jrockit.mc.flightrecorder.ui.components.aggregators.Exists;
import com.jrockit.mc.flightrecorder.ui.components.aggregators.FirstValue;
import com.jrockit.mc.flightrecorder.ui.components.aggregators.IAggregator;
import com.jrockit.mc.flightrecorder.ui.components.aggregators.LastMinusFirst;
import com.jrockit.mc.flightrecorder.ui.components.aggregators.LastValue;
import com.jrockit.mc.flightrecorder.ui.components.aggregators.Maximum;
import com.jrockit.mc.flightrecorder.ui.components.aggregators.Minimum;
import com.jrockit.mc.flightrecorder.ui.components.aggregators.MissingAggregator;
import com.jrockit.mc.flightrecorder.ui.components.aggregators.NumberOfUniqueValues;
import com.jrockit.mc.flightrecorder.ui.components.aggregators.Sigma;
import com.jrockit.mc.flightrecorder.ui.components.aggregators.Sum;
import com.jrockit.mc.flightrecorder.ui.components.aggregators.UniqueValues;
import com.jrockit.mc.flightrecorder.ui.components.aggregators.Variance;
import com.jrockit.mc.flightrecorder.ui.messages.internal.Messages;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class AggregatorFactory {
    private static final Map<String, AggregatorDescriptor> s_aggregators = new LinkedHashMap<String, AggregatorDescriptor>();
    public static final AggregatorDescriptor MAXIMUM = new AggregatorDescriptor(Messages.AGGREGATORS_MAXIMUM_NAME_TEXT, "maximumAggregator", Maximum.class);
    public static final AggregatorDescriptor MINUMUM = new AggregatorDescriptor(Messages.AGGREGATORS_MINIMUM_NAME_TEXT, "minimumAggregator", Minimum.class);
    public static final AggregatorDescriptor AVERAGE = new AggregatorDescriptor(Messages.AGGREGATORS_AVERAGE_NAME_TEXT, "averageAggregator", Average.class);
    public static final AggregatorDescriptor SUMMATION = new AggregatorDescriptor(Messages.AGGREGATORS_SUM_NAME_TEXT, "sumAggregator", Sum.class);
    public static final AggregatorDescriptor FIRST_VALUE = new AggregatorDescriptor(Messages.AGGREGATORS_FIRST_VALUE_NAME_TEXT, "firstValueAggregator", FirstValue.class);
    public static final AggregatorDescriptor LAST_VALUE_MINUS_FIRST = new AggregatorDescriptor(Messages.AGGREGATORS_LAST_VALUE_MINUS_FIRST_VALUE_NAME_TEXT, "lastMinuFirstAggregator", LastMinusFirst.class);
    public static final AggregatorDescriptor LAST_VALUE = new AggregatorDescriptor(Messages.AGGREGATORS_LAST_VALUE_NAME_TEXT, "lastValueAggregator", LastValue.class);
    public static final AggregatorDescriptor COUNT = new AggregatorDescriptor(Messages.AGGREGATORS_COUNT_NAME_TEXT, "countAggregator", Count.class);
    public static final AggregatorDescriptor MISSING_VALUE = new AggregatorDescriptor(Messages.AGGREGATORS_NOT_AVAILABLE_TEXT, "missingAggregator", MissingAggregator.class);
    public static final AggregatorDescriptor VARIANCE = new AggregatorDescriptor(Messages.AGGREGATORS_VARIANCE_TEXT, "varianceAggregator", Variance.class);
    public static final AggregatorDescriptor SIGMA = new AggregatorDescriptor(Messages.AGGREGATORS_SIGMA_TEXT, "sigmaAggregator", Sigma.class);
    public static final AggregatorDescriptor NUMBER_OF_UNIQUE_VALUES = new AggregatorDescriptor(Messages.AGGREGATORS_NUMBER_OF_UNIQUE_VALUES_TEXT, "uniqueAggregator", NumberOfUniqueValues.class);
    public static final AggregatorDescriptor UNIQUE_VALUES = new AggregatorDescriptor(Messages.AGGREGATORS_UNIQUE_VALUES_TEXT, "uniqueValuesAggregator", UniqueValues.class);
    public static final AggregatorDescriptor EXISTS = new AggregatorDescriptor(Messages.AGGREGATORS_EXISTS_TEXT, "existsAggregator", Exists.class);

    static {
        AggregatorFactory.register(AVERAGE);
        AggregatorFactory.register(MAXIMUM);
        AggregatorFactory.register(MINUMUM);
        AggregatorFactory.register(SUMMATION);
        AggregatorFactory.register(SUMMATION);
        AggregatorFactory.register(FIRST_VALUE);
        AggregatorFactory.register(LAST_VALUE_MINUS_FIRST);
        AggregatorFactory.register(LAST_VALUE);
        AggregatorFactory.register(COUNT);
        AggregatorFactory.register(MISSING_VALUE);
        AggregatorFactory.register(VARIANCE);
        AggregatorFactory.register(SIGMA);
        AggregatorFactory.register(NUMBER_OF_UNIQUE_VALUES);
        AggregatorFactory.register(UNIQUE_VALUES);
        AggregatorFactory.register(EXISTS);
    }

    public static AggregatorDescriptor getDefaultAggregatorDescriptor() {
        return FIRST_VALUE;
    }

    private AggregatorFactory() {
    }

    public static AggregatorDescriptor createAggregatorDescriptor(String identifier) {
        AggregatorDescriptor o = s_aggregators.get(identifier);
        if (o == null) {
            o = s_aggregators.get(MISSING_VALUE.getIdentifier());
        }
        return o;
    }

    public static List<AggregatorDescriptor> getAggregators() {
        return new ArrayList<AggregatorDescriptor>(s_aggregators.values());
    }

    public static void register(String name, String identifier, Class<? extends IAggregator> clazz) {
        s_aggregators.put(identifier, new AggregatorDescriptor(name, identifier, clazz));
    }

    private static void register(AggregatorDescriptor ad) {
        s_aggregators.put(ad.getIdentifier(), ad);
    }

    public static IAggregator createAggregator(String aggregatoridentifier) {
        AggregatorDescriptor ad = s_aggregators.get(aggregatoridentifier);
        if (ad != null) {
            return AggregatorFactory.createAggregator(ad);
        }
        return null;
    }

    public static IAggregator createAggregator(AggregatorDescriptor aggregatorDescriptor) {
        try {
            return aggregatorDescriptor.getAggregatorClass().newInstance();
        }
        catch (IllegalAccessException iae) {
            throw new IllegalStateException(iae);
        }
        catch (InstantiationException ie) {
            throw new IllegalStateException(ie);
        }
    }
}

