/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.ui.components.custom;

import com.jrockit.mc.components.ui.services.IServiceLocator;
import com.jrockit.mc.flightrecorder.spi.IEvent;
import com.jrockit.mc.flightrecorder.spi.IView;
import com.jrockit.mc.flightrecorder.ui.ViewModelBuilder;
import com.jrockit.mc.flightrecorder.ui.components.custom.EventTableDescriptor;
import com.jrockit.mc.flightrecorder.ui.components.custom.EventTableProviderRepository;
import com.jrockit.mc.flightrecorder.ui.components.custom.IEventRow;
import com.jrockit.mc.flightrecorder.ui.components.custom.IEventTable;
import com.jrockit.mc.flightrecorder.ui.messages.internal.Messages;
import org.eclipse.core.runtime.IProgressMonitor;

public final class CustomBuilder
extends ViewModelBuilder<IEventRow[]> {
    private final EventTableDescriptor m_eventTableDescriptor;

    public CustomBuilder(IServiceLocator serviceLocator, EventTableDescriptor descriptor) {
        super(serviceLocator, Messages.CUSTOM_TABLE_BUILDER_BUILDING_TEXT);
        this.m_eventTableDescriptor = descriptor;
    }

    @Override
    protected IEventRow[] buildModel(IView view, IProgressMonitor monitor) {
        try {
            if (this.m_eventTableDescriptor != null) {
                IEventTable table = EventTableProviderRepository.create(this.m_eventTableDescriptor);
                if (table != null) {
                    return table.createRows((Iterable<IEvent>)view, view.getRange());
                }
                this.setLastBuildMessage(Messages.CUSTOM_TABLE_BUILDER_ERROR_CREATING_PROVIDER);
            } else {
                this.setLastBuildMessage(Messages.CUSTOM_TABLE_BUILDER_NO_PROVIDER_FOUND);
            }
        }
        catch (Exception e) {
            this.setLastBuildMessage(String.valueOf(Messages.CUSTOM_TABLE_BUILDER_ERROR_BUILDING_TABLE) + e.getMessage());
        }
        return new IEventRow[0];
    }
}

