/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.ui.components.custom;

import com.jrockit.mc.flightrecorder.ui.FlightRecorderUI;
import com.jrockit.mc.flightrecorder.ui.components.custom.EventTableDescriptor;
import com.jrockit.mc.flightrecorder.ui.components.custom.IEventTable;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;

public final class EventTableProviderRepository {
    private static final String NAME_ATTRIBUTE = "name";
    private static final String CLASS_ATTRIBUTE = "class";
    private static final String EVENT_TABLE_PROVIDER_EXTENSION_ID = "com.jrockit.mc.flightrecorder.ui.eventTableProvider";
    private static final String IDENTIFIER_ATTRIBUTE = "id";

    public static List<EventTableDescriptor> getProviderDescriptors() {
        ArrayList<EventTableDescriptor> list = new ArrayList<EventTableDescriptor>();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint exPoint = registry.getExtensionPoint(EVENT_TABLE_PROVIDER_EXTENSION_ID);
        IExtension[] iExtensionArray = exPoint.getExtensions();
        int n = iExtensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension ext = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = ext.getConfigurationElements();
            int n3 = iConfigurationElementArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement element = iConfigurationElementArray[n4];
                String name = element.getAttribute(NAME_ATTRIBUTE);
                String description = element.getAttribute(NAME_ATTRIBUTE);
                String identifier = element.getAttribute(IDENTIFIER_ATTRIBUTE);
                list.add(new EventTableDescriptor(identifier, name, description, element));
                ++n4;
            }
            ++n2;
        }
        return list;
    }

    public static IEventTable create(EventTableDescriptor eventTableDescriptor) {
        return EventTableProviderRepository.createInstance(eventTableDescriptor.getConfigurationElement());
    }

    public static EventTableDescriptor findEventTableDescriptor(String dataProviderIdentifier) {
        for (EventTableDescriptor etd : EventTableProviderRepository.getProviderDescriptors()) {
            if (!dataProviderIdentifier.equals(etd.getIdentifier())) continue;
            return etd;
        }
        return null;
    }

    private static IEventTable createInstance(IConfigurationElement element) {
        try {
            Object object = element.createExecutableExtension(CLASS_ATTRIBUTE);
            if (object instanceof IEventTable) {
                return (IEventTable)object;
            }
        }
        catch (CoreException e) {
            FlightRecorderUI.getDefault().getLogger().log(Level.SEVERE, "Error trying to instantiate IEventTable for event table provider");
        }
        return null;
    }
}

