/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.ui.components.multichart;

import com.jrockit.mc.flightrecorder.ui.components.multichart.ChartRow;
import com.jrockit.mc.flightrecorder.ui.components.multichart.IChartLabelProvider;
import com.jrockit.mc.flightrecorder.ui.components.multichart.MultiChartJComponent;
import com.jrockit.mc.flightrecorder.ui.components.range.SwingComponentCanvas;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.widgets.FormToolkit;

public final class ChartTableViewer
extends StructuredViewer {
    private final Canvas m_chartCanvas;
    private final MultiChartJComponent m_multiChart;
    private final Map<Integer, Object> m_indexMap = new HashMap<Integer, Object>();
    private final int m_itemHeight;
    private ViewerComparator m_comparator;

    ChartTableViewer(FormToolkit toolkit, Composite parent, int itemHeight, int textWidth) {
        this.m_itemHeight = itemHeight;
        this.m_multiChart = new MultiChartJComponent();
        this.m_multiChart.setTextWidth(textWidth);
        this.m_chartCanvas = new SwingComponentCanvas(parent, this.m_multiChart, 0x20000200);
        this.m_chartCanvas.setData("FormWidgetFactory.drawBorder", (Object)"textBorder");
        toolkit.adapt((Composite)this.m_chartCanvas);
        toolkit.paintBordersFor(parent);
        this.hookScrollListener(this.m_chartCanvas);
        this.updateImages();
    }

    private void hookScrollListener(Canvas chartCanvas) {
        chartCanvas.getVerticalBar().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ChartTableViewer.this.update();
            }
        });
    }

    private void updateImages() {
        int position = this.m_chartCanvas.getVerticalBar().getSelection();
        int startIndex = position / this.getItemHeight();
        IChartLabelProvider p = this.getChartLabelProvider();
        if (p != null) {
            ArrayList<ChartRow> rows = new ArrayList<ChartRow>();
            int height = Math.min(this.m_chartCanvas.getClientArea().height, this.m_indexMap.size() * this.getItemHeight());
            int endIndex = (position + height) / this.getItemHeight() + 1;
            int n = startIndex;
            while (n < endIndex) {
                Object element = this.m_indexMap.get(n);
                rows.add(new ChartRow(p.getText(element), p.getImage(element)));
                ++n;
            }
            this.m_multiChart.setRows(rows);
            this.m_multiChart.setOffset(-(position % this.getItemHeight()));
        }
    }

    private IChartLabelProvider getChartLabelProvider() {
        if (this.getLabelProvider() instanceof IChartLabelProvider) {
            return (IChartLabelProvider)this.getLabelProvider();
        }
        return null;
    }

    int getItemHeight() {
        return this.m_itemHeight;
    }

    private void rebuildIndexMap(Object[] elements) {
        this.m_indexMap.clear();
        if (this.getInput() != null) {
            ArrayList<Object> list = new ArrayList<Object>();
            list.addAll(Arrays.asList(elements));
            if (this.m_comparator != null) {
                this.m_comparator.sort((Viewer)this, elements);
            }
            int index = 0;
            for (Object e : list) {
                this.m_indexMap.put(index, e);
                ++index;
            }
        }
    }

    protected void labelProviderChanged() {
    }

    public void refresh() {
        this.m_indexMap.clear();
        IStructuredContentProvider provider = this.getStructuredContentProvider();
        if (provider == null) {
            throw new RuntimeException("Missing content provider");
        }
        Object[] elements = provider.getElements(this.getInput());
        if (this.getInput() == null) {
            this.m_chartCanvas.getVerticalBar().setVisible(false);
        } else {
            this.m_chartCanvas.getVerticalBar().setVisible(true);
            this.m_chartCanvas.getVerticalBar().setMinimum(0);
            this.m_chartCanvas.getVerticalBar().setMaximum(elements.length * this.m_itemHeight);
            this.m_chartCanvas.getVerticalBar().setSelection(0);
            this.m_chartCanvas.getVerticalBar().setPageIncrement(this.m_itemHeight);
            this.m_chartCanvas.getVerticalBar().setThumb(this.m_itemHeight);
            this.rebuildIndexMap(elements);
            this.updateImages();
            this.m_chartCanvas.redraw();
        }
    }

    private IStructuredContentProvider getStructuredContentProvider() {
        return (IStructuredContentProvider)this.getContentProvider();
    }

    public Control getControl() {
        return this.m_chartCanvas;
    }

    public ISelection getSelection() {
        return new StructuredSelection();
    }

    public void setSelection(ISelection selection, boolean reveal) {
    }

    public void setComparator(ViewerComparator comparator) {
        this.m_comparator = comparator;
    }

    public void update() {
        this.updateImages();
        this.m_chartCanvas.redraw();
    }

    protected Widget doFindInputItem(Object element) {
        return null;
    }

    protected Widget doFindItem(Object element) {
        return null;
    }

    protected void doUpdateItem(Widget item, Object element, boolean fullMap) {
    }

    protected List getSelectionFromWidget() {
        return null;
    }

    protected void internalRefresh(Object element) {
    }

    public void reveal(Object element) {
    }

    protected void setSelectionToWidget(List l, boolean reveal) {
    }
}

