/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.ui.components.range;

import com.jrockit.mc.flightrecorder.ui.components.range.CoordinateSystem;
import com.jrockit.mc.flightrecorder.ui.components.range.NavigatorListener;
import com.jrockit.mc.flightrecorder.ui.components.range.SwingComponentCanvas;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import javax.swing.JComponent;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class JComponentNavigator
extends SwingComponentCanvas
implements ControlListener,
MouseListener,
MouseMoveListener,
MouseTrackListener {
    private static final int NONE = 0;
    private static final int FIRST_EDGE = 1;
    private static final int SECOND_EDGE = 2;
    private static final int GRABBER_RADIUS_Y = 6;
    private static final int GRABBER_RADIUS_X = 3;
    private final double[] DEFAULT_NORMALIZED_COORDINATES = new double[]{0.0, 0.0, 1.0};
    private final Cursor m_handCursor;
    private final Cursor m_sizeCursor;
    private final Cursor m_arrowCursor;
    private final ListenerList m_selectionListeners = new ListenerList();
    private final ListenerList m_viewportListeners = new ListenerList();
    private final FormToolkit m_toolkit;
    private final CoordinateSystem m_coordinateSystem;
    private int m_dragObject = 0;
    private int m_lastDragPosition = -1;
    private boolean m_showGrabbers = false;
    private Image m_coloredImage;
    private Image m_greyImage;
    private volatile boolean m_invalidateNavigator;
    private double m_oldMin = 1.0;
    private double m_oldMax = -1.0;
    private final Cursor m_waitCursor;
    private double m_worldMin;
    private double m_worldMax;
    private double m_viewportMin = Double.NaN;
    private double m_viewportMax = Double.NaN;

    public JComponentNavigator(Composite parent, FormToolkit toolkit, JComponent jcomponent) {
        super(parent, jcomponent, 0x20000000);
        this.m_toolkit = toolkit;
        this.m_arrowCursor = new Cursor((Device)parent.getDisplay(), 0);
        this.m_handCursor = new Cursor((Device)parent.getDisplay(), 21);
        this.m_sizeCursor = new Cursor((Device)parent.getDisplay(), 13);
        this.m_waitCursor = new Cursor((Device)parent.getDisplay(), 1);
        this.m_coordinateSystem = new CoordinateSystem(0.0, 1.0, 0, 0, this.DEFAULT_NORMALIZED_COORDINATES);
        this.addListeners();
    }

    public double getSelectedMin() {
        double l = this.getLeftWorld();
        return this.m_viewportMin + l * (this.m_viewportMax - this.m_viewportMin);
    }

    public double getSelectedMax() {
        return this.m_viewportMin + this.getRightWorld() * (this.m_viewportMax - this.m_viewportMin);
    }

    public void setNavigatorRange(double minX, double maxX) {
        this.m_worldMin = minX;
        this.m_worldMax = maxX;
        if (Double.isNaN(this.m_viewportMin)) {
            this.m_viewportMin = this.m_worldMin;
        }
        if (Double.isNaN(this.m_viewportMax)) {
            this.m_viewportMax = this.m_worldMax;
        }
        this.setViewport(Math.max(this.m_worldMin, this.m_viewportMin), Math.min(this.m_worldMax, this.m_viewportMax));
    }

    public void setViewport(double min, double max) {
        double newViewportMin = Math.max(this.m_worldMin, min);
        double newViewportMax = Math.min(this.m_worldMax, max);
        this.m_viewportMin = newViewportMin;
        this.m_viewportMax = newViewportMax;
        this.notifyViewportListener(newViewportMin, newViewportMax);
        double selectionWidth = this.getRightWorld() - this.getLeftWorld();
        this.setSelectedArea(0.5 - selectionWidth / 2.0, 0.5 + selectionWidth / 2.0);
    }

    public void setSelectedArea(double a, double b) {
        this.getCoordinateSystem().setWorld(1, a);
        this.getCoordinateSystem().setWorld(2, b);
    }

    public void setSelectedAreaInWorldCoordinates(double a, double b) {
        double viewPortWidth = this.m_viewportMax - this.m_viewportMin;
        double nStart = Math.max(0.0, a - this.m_viewportMin) / viewPortWidth;
        double nEnd = Math.min(1.0, (b - this.m_viewportMin) / viewPortWidth);
        this.setSelectedArea(nStart, nEnd);
    }

    public void addSelectionListener(NavigatorListener listener) {
        this.m_selectionListeners.add((Object)listener);
    }

    public void addViewportListener(NavigatorListener listener) {
        this.m_viewportListeners.add((Object)listener);
    }

    private final void addListeners() {
        this.addMouseListener(this);
        this.addMouseMoveListener(this);
        this.addControlListener(this);
        this.addMouseTrackListener(this);
        this.addPaintListener(this);
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                JComponentNavigator.this.disposeResources();
            }
        });
    }

    public void expandFullyOrRestore() {
        CoordinateSystem cs = this.getCoordinateSystem();
        if (cs.getDeviceSpan() == this.getRightWindowEdge() - this.getLeftWindowEdge()) {
            if (this.m_oldMin > this.m_oldMax) {
                this.setSelectedArea(cs.getWorldMin() + cs.getWorldSpan() * 0.45, cs.getWorldMin() + cs.getWorldSpan() * 0.55);
            } else {
                this.setSelectedArea(this.m_oldMin, this.m_oldMax);
            }
        } else {
            this.m_oldMin = Math.min(cs.getWorld(1), cs.getWorld(2));
            this.m_oldMax = Math.max(cs.getWorld(1), cs.getWorld(2));
            this.setSelectedArea(cs.getWorldMin(), cs.getWorldMax());
        }
        this.redraw();
    }

    void setDragObject(int dragObject) {
        this.m_dragObject = dragObject;
    }

    public int getDragObject() {
        return this.m_dragObject;
    }

    public void setLastDragPosition(int position) {
        this.m_lastDragPosition = position;
    }

    public int getLastDragPosition() {
        return this.m_lastDragPosition;
    }

    public void controlMoved(ControlEvent e) {
    }

    public CoordinateSystem getCoordinateSystem() {
        return this.m_coordinateSystem;
    }

    public void controlResized(ControlEvent e) {
        this.setDeviceRange();
        this.layoutJComponent(this.m_jcomponent);
    }

    public void mouseDoubleClick(MouseEvent e) {
        this.expandFullyOrRestore();
    }

    protected void layoutJComponent(JComponent component) {
        component.doLayout();
    }

    public boolean hitTestGrabber(int grabberX, int x, int y) {
        return Math.abs(x - grabberX) <= 3 && Math.abs(y - this.getClientArea().height / 2) <= 6;
    }

    public void mouseDown(MouseEvent e) {
        if (e.button != 1 || (e.stateMask & SWT.MOD4) != 0) {
            return;
        }
        if (this.hitTestGrabber(this.getCoordinateSystem().getDevice(1), e.x, e.y)) {
            this.setDragObject(1);
        } else if (this.hitTestGrabber(this.getCoordinateSystem().getDevice(2), e.x, e.y)) {
            this.setDragObject(2);
        } else if (e.x > this.getLeftWindowEdge() && e.x < this.getRightWindowEdge()) {
            this.setDragObject(3);
        } else {
            this.setDragObject(0);
        }
        this.setLastDragPosition(e.x);
    }

    public void updateCursor(int x, int y) {
        CoordinateSystem cs = this.getCoordinateSystem();
        if (this.hitTestGrabber(cs.getDevice(1), x, y) || this.hitTestGrabber(cs.getDevice(2), x, y)) {
            this.setCursor(this.m_sizeCursor);
        } else if (x > this.getLeftWindowEdge() && x < this.getRightWindowEdge()) {
            this.setCursor(this.m_handCursor);
        } else {
            this.setCursor(this.m_arrowCursor);
        }
    }

    public void mouseUp(MouseEvent e) {
        this.setDragObject(0);
        double a = this.getCoordinateSystem().getWorld(1);
        double b = this.getCoordinateSystem().getWorld(2);
        if (a < b) {
            this.notifySelectionListener(a, b);
        } else {
            this.notifySelectionListener(b, a);
        }
    }

    public void notifyViewportListener(double min, double max) {
        this.notifyListener(this.m_viewportListeners.getListeners(), min, max);
    }

    public void notifySelectionListener(double normalizedMin, double normalizedMax) {
        double viewPortWidth = this.m_viewportMax - this.m_viewportMin;
        double start = this.m_viewportMin + viewPortWidth * normalizedMin;
        double end = this.m_viewportMin + viewPortWidth * normalizedMax;
        this.notifyListener(this.m_selectionListeners.getListeners(), start, end);
    }

    private void notifyListener(Object[] listeners, double start, double end) {
        if (listeners.length > 0) {
            this.setCursor(this.m_waitCursor);
            try {
                Object[] objectArray = listeners;
                int n = listeners.length;
                int n2 = 0;
                while (n2 < n) {
                    Object listener = objectArray[n2];
                    ((NavigatorListener)listener).onNavigatorChange((Object)this, start, end);
                    ++n2;
                }
            }
            finally {
                this.setCursor(null);
            }
        }
    }

    protected void setDeviceRange() {
        this.getCoordinateSystem().setDeviceRange(0, this.getClientArea().width - 1);
    }

    public void mouseMove(MouseEvent e) {
        int dragObject = this.getDragObject();
        if (dragObject != 0) {
            this.updateDeviceCoordinates(dragObject, e.x - this.getLastDragPosition());
            this.setLastDragPosition(e.x);
            this.redraw();
        } else {
            this.updateCursor(e.x, e.y);
        }
    }

    private void updateDeviceCoordinates(int dragObject, int deltaMoveX) {
        this.moveObject(dragObject, deltaMoveX);
        this.trimEdges();
    }

    private void moveObject(int dragObject, int deltaMoveX) {
        CoordinateSystem cs = this.getCoordinateSystem();
        if ((dragObject & 1) != 0) {
            cs.setDevice(1, cs.getDevice(1) + deltaMoveX);
        }
        if ((dragObject & 2) != 0) {
            cs.setDevice(2, cs.getDevice(2) + deltaMoveX);
        }
    }

    private void trimEdges() {
        CoordinateSystem cs = this.getCoordinateSystem();
        int n = 1;
        while (n <= 2) {
            if (cs.getDevice(n) < cs.getMinDevice()) {
                cs.setDevice(n, cs.getMinDevice());
            }
            if (cs.getDevice(n) > cs.getMaxDevice()) {
                cs.setDevice(n, cs.getMaxDevice());
            }
            ++n;
        }
    }

    public int getLeftWindowEdge() {
        CoordinateSystem cs = this.getCoordinateSystem();
        return Math.max(Math.min(cs.getDevice(1), cs.getDevice(2)), cs.getMinDevice());
    }

    public int getRightWindowEdge() {
        CoordinateSystem cs = this.getCoordinateSystem();
        return Math.min(Math.max(cs.getDevice(1), cs.getDevice(2)), cs.getMaxDevice());
    }

    public double getLeftWorld() {
        CoordinateSystem cs = this.getCoordinateSystem();
        return Math.max(Math.min(cs.getWorld(1), cs.getWorld(2)), cs.getWorldMin());
    }

    public double getRightWorld() {
        CoordinateSystem cs = this.getCoordinateSystem();
        return Math.min(Math.max(cs.getWorld(1), cs.getWorld(2)), cs.getWorldMax());
    }

    @Override
    public void paintControl(PaintEvent e) {
        Rectangle clientArea = this.getClientArea();
        GC gc = e.gc;
        if (this.isChartImagesInvalid(clientArea)) {
            this.redrawChartImages(e);
        }
        this.drawBackground(gc, clientArea);
        this.drawSlider(gc, clientArea);
    }

    private boolean isChartImagesInvalid(Rectangle clientArea) {
        return this.m_invalidateNavigator || this.m_coloredImage == null || this.m_coloredImage.getBounds().width != clientArea.width || this.m_coloredImage.getBounds().height != clientArea.height;
    }

    private void drawBackground(GC gc, Rectangle clientArea) {
        int height = clientArea.height;
        int l = this.getLeftWindowEdge();
        int w = this.getRightWindowEdge() - this.getLeftWindowEdge();
        int r = this.m_coloredImage.getBounds().width - this.getRightWindowEdge();
        gc.drawImage(this.m_greyImage, 0, 0, l, height, clientArea.x, clientArea.y, l, height);
        gc.drawImage(this.m_coloredImage, this.getLeftWindowEdge(), 0, w, height, clientArea.x + this.getLeftWindowEdge(), clientArea.y, w, height);
        gc.drawImage(this.m_greyImage, this.getRightWindowEdge(), 0, r, height, clientArea.x + this.getRightWindowEdge(), clientArea.y, r, height);
    }

    private void drawSlider(GC gc, Rectangle clientArea) {
        int top = 1;
        int bottom = clientArea.height - 2;
        int windowLeft = this.getLeftWindowEdge();
        int windowRight = this.getRightWindowEdge();
        gc.setForeground(this.m_toolkit.getColors().getBorderColor());
        Rectangle rect = this.getClientArea();
        gc.drawRectangle(0, 0, rect.width - 1, rect.height - 1);
        gc.setForeground(this.m_toolkit.getColors().getForeground());
        this.drawEdge(gc, windowLeft, bottom, top - bottom);
        int oldAlpha = gc.getAlpha();
        gc.setAlpha(128);
        gc.drawLine(windowLeft, top, windowRight, top);
        gc.drawLine(windowLeft, bottom, windowRight, bottom);
        gc.setAlpha(oldAlpha);
        this.drawEdge(gc, windowRight, bottom, top - bottom);
    }

    private void redrawChartImages(PaintEvent e) {
        Rectangle rect = this.getClientArea();
        if (this.m_coloredImage != null && !this.m_coloredImage.isDisposed()) {
            this.m_coloredImage.dispose();
        }
        if (this.m_greyImage != null && !this.m_greyImage.isDisposed()) {
            this.m_greyImage.dispose();
        }
        BufferedImage imageAWT = new BufferedImage(rect.width, rect.height, 5);
        PaletteData vpPalette = new PaletteData(255, 65280, 0xFF0000);
        byte[] byteData = ((DataBufferByte)imageAWT.getRaster().getDataBuffer()).getData();
        Graphics2D graphicsAWT = imageAWT.createGraphics();
        ImageData coloredImageData = new ImageData(rect.width, rect.height, 24, vpPalette, 3 * rect.width, byteData);
        this.getJComponent().setBounds(rect.x + 1, rect.y + 1, Math.max(rect.width - 2, 0), Math.max(rect.height - 2, 0));
        this.getJComponent().doLayout();
        this.paintRecursive(this.getJComponent(), graphicsAWT);
        this.m_coloredImage = new Image((Device)e.display, coloredImageData);
        int x = 0;
        while (x < rect.width) {
            int y = 0;
            while (y < rect.height) {
                int value;
                RGB rgb = vpPalette.getRGB(coloredImageData.getPixel(x, y));
                rgb.red = value = (int)(192.0 + 0.2 * (0.3 * (double)rgb.red + 0.59 * (double)rgb.green + 0.11 * (double)rgb.blue));
                rgb.green = value;
                rgb.blue = value;
                coloredImageData.setPixel(x, y, vpPalette.getPixel(rgb));
                ++y;
            }
            ++x;
        }
        this.m_greyImage = new Image((Device)e.display, coloredImageData);
        this.m_invalidateNavigator = false;
    }

    private void drawEdge(GC gc, int x, int y, int height) {
        int grabber_bottom = y + height / 2 + 6;
        int grabber_top = y + height / 2 - 6;
        if (this.getShowGrabbers()) {
            gc.drawLine(x, y, x, grabber_bottom);
            gc.fillRoundRectangle(x - 3, grabber_top, 6, 12, 2, 6);
            gc.drawRoundRectangle(x - 3, grabber_top, 6, 12, 2, 6);
            gc.drawLine(x, grabber_top, x, y + height);
            gc.drawLine(x - 1, grabber_top + 3, x - 1, grabber_bottom - 3);
            gc.drawLine(x + 1, grabber_top + 3, x + 1, grabber_bottom - 3);
        } else {
            gc.drawLine(x, y, x, y + height);
        }
    }

    public void invalidateNavigator(boolean invalidateNavigator) {
        this.m_invalidateNavigator = invalidateNavigator;
    }

    private boolean getShowGrabbers() {
        return this.m_showGrabbers;
    }

    private void setShowGrabbers(boolean showGrabbers) {
        this.m_showGrabbers = showGrabbers;
        this.redraw();
    }

    public void disposeResources() {
        if (this.m_coloredImage != null && !this.m_coloredImage.isDisposed()) {
            this.m_coloredImage.dispose();
        }
        if (this.m_greyImage != null && !this.m_greyImage.isDisposed()) {
            this.m_greyImage.dispose();
        }
        this.m_handCursor.dispose();
        this.m_sizeCursor.dispose();
        this.m_arrowCursor.dispose();
        this.m_waitCursor.dispose();
    }

    public void mouseEnter(MouseEvent e) {
        this.setShowGrabbers(true);
    }

    public void mouseExit(MouseEvent e) {
        this.setShowGrabbers(false);
    }

    public void mouseHover(MouseEvent e) {
    }

    public double getWorldMin() {
        return this.m_worldMin;
    }

    public double getWorldMax() {
        return this.m_worldMax;
    }

    public double getViewportMin() {
        return this.m_viewportMin;
    }

    public double getViewportMax() {
        return this.m_viewportMax;
    }
}

