/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.ui.filtering;

import com.jrockit.mc.flightrecorder.FlightRecording;
import com.jrockit.mc.flightrecorder.spi.ITimeRange;
import com.jrockit.mc.flightrecorder.ui.filtering.EventFilter;
import com.jrockit.mc.flightrecorder.ui.filtering.EventFilterFactory;
import com.jrockit.mc.flightrecorder.ui.filtering.FilterPart;
import com.jrockit.mc.flightrecorder.ui.messages.internal.Messages;
import com.jrockit.mc.flightrecorder.util.TimeRange;
import com.jrockit.mc.ui.UIPlugin;
import com.jrockit.mc.ui.misc.IntFieldEditor;
import java.text.MessageFormat;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Label;

public class TimeSpanFilterPart
extends FilterPart {
    private IntFieldEditor m_startTime;
    private IntFieldEditor m_endTime;
    private final FlightRecording m_recording;
    private Label m_description;
    private int m_length;

    protected TimeSpanFilterPart(FlightRecording recording) {
        super(Messages.PREFILTER_WIZARD_TIMESPAN_FILTER_NAME_TEXT, Messages.PREFILTER_WIZARD_TIMESPAN_KEEP_EVENTS_IN_TIME_SPAN_TEXT, 1);
        this.m_recording = recording;
    }

    protected void createFieldEditors() {
        GridData gd1 = new GridData(4, 4, true, false);
        gd1.horizontalSpan = 2;
        Label label = new Label(this.getFieldEditorParent(), 64);
        label.setText(this.getDescription());
        label.setLayoutData((Object)gd1);
        GridData gd2 = new GridData(4, 4, true, false);
        gd2.horizontalSpan = 2;
        this.m_description = new Label(this.getFieldEditorParent(), 64);
        this.m_description.setText("");
        this.m_description.setLayoutData((Object)gd2);
        this.m_startTime = new IntFieldEditor("filter.time.span.start", Messages.PREFILTER_WIZARD_TIMESPAN_START_SECOND_TEXT, this.getFieldEditorParent());
        this.m_startTime.setValidRange(0, 100);
        this.m_startTime.setPage((DialogPage)this);
        this.addField((FieldEditor)this.m_startTime);
        this.m_endTime = new IntFieldEditor("filter.time.span.end", Messages.PREFILTER_WIZARD_TIMESPAN_END_SECOND_TEXT, this.getFieldEditorParent());
        this.m_endTime.setPage((DialogPage)this);
        this.addField((FieldEditor)this.m_endTime);
    }

    @Override
    public EventFilter createFilter() {
        if (this.m_startTime.isValid() && this.m_endTime.isValid()) {
            long recStart = this.m_recording.getTimeRange().getStartTimestamp();
            long start = (long)this.m_startTime.getIntValue() * 1000L * 1000L * 1000L + recStart;
            long end = (long)(this.m_endTime.getIntValue() + 1) * 1000L * 1000L * 1000L + recStart;
            TimeRange range = new TimeRange(start, end);
            return EventFilterFactory.createTimeFilter((ITimeRange)range);
        }
        return null;
    }

    @Override
    public Image getImage() {
        return UIPlugin.getDefault().getImage("clock16.gif");
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (this.m_length == 0) {
            this.m_length = (int)(this.m_recording.getTimeRange().getDuration() / 1000000000L);
            this.m_description.setText(MessageFormat.format(Messages.PREFILTER_WIZARD_TIMESPAN_RECORDING_LENGTH_INFO_TEXT, this.m_length));
            this.m_startTime.setValidRange(0, this.m_length);
            this.m_startTime.setStringValue("0");
            this.m_endTime.setValidRange(0, this.m_length);
            this.m_endTime.setStringValue(Integer.toString(this.m_length));
        }
    }
}

