/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.rjmx.ui.internal;

import com.jrockit.mc.rjmx.subscription.MRI;
import com.jrockit.mc.rjmx.ui.column.TableColumnComposite;
import com.jrockit.mc.rjmx.ui.internal.AttributeConfiguratorTableFactory;
import com.jrockit.mc.rjmx.ui.internal.AttributeLabelProvider;
import com.jrockit.mc.rjmx.ui.internal.AttributeSelectionContentModel;
import com.jrockit.mc.rjmx.ui.internal.AttributeSelectionViewModel;
import org.eclipse.jface.dialogs.DialogSettings;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class AttributeConfiguratorWizardPage
extends WizardPage {
    public static final String PAGE_NAME = "com.jrockit.mc.rjmx.attribute.configuration";
    private final AttributeSelectionViewModel m_viewModel;
    private final AttributeSelectionContentModel m_selectorModel;

    private static AttributeLabelProvider createNameLabelProvider(AttributeSelectionContentModel selectorModel) {
        return new AttributeLabelProvider(selectorModel.getMetaDataService(), selectorModel.getMRIService());
    }

    public AttributeConfiguratorWizardPage(AttributeSelectionViewModel viewModel, AttributeSelectionContentModel selectorModel) {
        super(PAGE_NAME, viewModel.getConfigureAttributePageTitle(), null);
        this.setDescription(viewModel.getConfigureAttributePageDescription());
        this.m_viewModel = viewModel;
        this.m_selectorModel = selectorModel;
    }

    public void createControl(Composite parent) {
        IDialogSettings settings = DialogSettings.getOrCreateSection((IDialogSettings)this.getWizard().getDialogSettings(), (String)PAGE_NAME);
        TableColumnComposite table = AttributeConfiguratorTableFactory.createAttributeConfiguratorTable(parent, AttributeConfiguratorWizardPage.createNameLabelProvider(this.m_selectorModel), this.m_viewModel, this.m_selectorModel, settings, new Runnable(){

            @Override
            public void run() {
                AttributeConfiguratorWizardPage.this.setPageComplete(AttributeConfiguratorWizardPage.this.isPageComplete());
            }
        });
        this.setControl((Control)table);
    }

    public void setVisible(boolean visible) {
        if (visible) {
            ((TableColumnComposite)this.getControl()).getViewer().setInput((Object)this.m_selectorModel.getSelectedAttributes());
        }
        super.setVisible(visible);
    }

    public boolean isPageComplete() {
        MRI[] selectedAttributes = this.m_selectorModel.getSelectedAttributes();
        if (selectedAttributes.length == 0) {
            return false;
        }
        if (this.m_viewModel.isNumericalOnly()) {
            MRI[] mRIArray = selectedAttributes;
            int n = selectedAttributes.length;
            int n2 = 0;
            while (n2 < n) {
                MRI attribute = mRIArray[n2];
                if (this.m_selectorModel.getAttributeUnit(attribute) == null) {
                    return false;
                }
                ++n2;
            }
        }
        return true;
    }
}

