/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.uitoolkit.impl.fx.ui;

import com.sun.deploy.security.CredentialInfo;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.ui.AppInfo;
import com.sun.deploy.uitoolkit.impl.fx.FXPluginToolkit;
import com.sun.deploy.uitoolkit.impl.fx.ui.DialogTemplate;
import com.sun.deploy.uitoolkit.impl.fx.ui.FXAboutDialog;
import com.sun.deploy.uitoolkit.impl.fx.ui.FXConsole;
import com.sun.deploy.uitoolkit.impl.fx.ui.FXModalityHelper;
import com.sun.deploy.uitoolkit.impl.fx.ui.FXSSV3Dialog;
import com.sun.deploy.uitoolkit.impl.fx.ui.MixedCodeInSwing;
import com.sun.deploy.uitoolkit.impl.fx.ui.UITextArea;
import com.sun.deploy.uitoolkit.impl.fx.ui.resources.ResourceManager;
import com.sun.deploy.uitoolkit.ui.ConsoleController;
import com.sun.deploy.uitoolkit.ui.ConsoleWindow;
import com.sun.deploy.uitoolkit.ui.DialogHook;
import com.sun.deploy.uitoolkit.ui.ModalityHelper;
import com.sun.deploy.uitoolkit.ui.NativeMixedCodeDialog;
import com.sun.deploy.uitoolkit.ui.PluginUIFactory;
import com.sun.deploy.util.DeploySysAction;
import com.sun.deploy.util.DeploySysRun;
import com.sun.javafx.application.PlatformImpl;
import java.io.File;
import java.lang.reflect.Method;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.TreeMap;
import java.util.Vector;
import java.util.concurrent.Callable;
import javafx.application.Platform;
import javafx.collections.FXCollections;
import javafx.geometry.Pos;
import javafx.scene.control.Label;
import javafx.scene.control.ListView;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import javafx.stage.Window;

public class FXUIFactory
extends PluginUIFactory {
    public int showMessageDialog(Object owner, AppInfo ainfo, int messageType, String title, String masthead, String message, String MoreInfo, String btnString1, String btnString2, String btnString3, String showAlways) {
        switch (messageType) {
            default: {
                return FXUIFactory.showContentDialog(owner, ainfo, title, message, true, btnString1, btnString2);
            }
            case 0: {
                if (MoreInfo != null) {
                    return FXUIFactory.showErrorDialog(owner, ainfo, title, message, null, btnString1, btnString2, null, FXUIFactory.getDetailPanel(MoreInfo), null);
                }
                return FXUIFactory.showErrorDialog(owner, ainfo, title, masthead, message, btnString1, btnString2, btnString3);
            }
            case 1: {
                FXUIFactory.showInformationDialog(owner, title, masthead, message);
                return -1;
            }
            case 2: {
                return FXUIFactory.showWarningDialog(owner, ainfo, title, masthead, message, btnString1, btnString2);
            }
            case 3: {
                return FXUIFactory.showConfirmDialog(owner, ainfo, title, masthead, MoreInfo, btnString1, btnString2, true);
            }
            case 5: {
                return FXUIFactory.showIntegrationDialog(owner, ainfo);
            }
            case 7: {
                return FXUIFactory.showApiDialog(null, ainfo, title, message, masthead, btnString1, btnString2, false);
            }
            case 4: 
        }
        return FXUIFactory.showMixedCodeDialog(owner, ainfo, title, masthead, message, MoreInfo, btnString1, btnString2, true, showAlways);
    }

    public void showExceptionDialog(Object owner, AppInfo appInfo, Throwable throwable, String title, String masthead, String message, Certificate[] certs) {
        if (certs == null) {
            FXUIFactory.showExceptionDialog(owner, throwable, masthead, message, title);
        } else {
            FXUIFactory.showCertificateExceptionDialog(owner, appInfo, throwable, message, title, certs);
        }
    }

    public CredentialInfo showPasswordDialog(Object owner, String title, String notes, boolean showUsername, boolean showDomain, CredentialInfo info, boolean saveEnabled, String scheme, String warning) {
        return FXUIFactory.showPasswordDialog0(owner, title, notes, showUsername, showDomain, info, saveEnabled, scheme, warning);
    }

    public int showSecurityDialog(AppInfo ainfo, String title, String topText, String publisher, URL appFrom, boolean showAlways, boolean checkAlways, String okBtnStr, String cancelBtnStr, String[] securityAlerts, String[] securityInfo, boolean showMoreInfo, Certificate[] certs, int start, int end, boolean majorWarning) {
        return FXUIFactory.showSecurityDialog0(ainfo, title, topText, publisher, appFrom, showAlways, checkAlways, okBtnStr, cancelBtnStr, securityAlerts, securityInfo, showMoreInfo, certs, start, end, majorWarning, false, false, false);
    }

    public int showSecurityDialog(AppInfo ainfo, String title, String topText, String publisher, URL appFrom, boolean showAlways, boolean checkAlways, String okBtnStr, String cancelBtnStr, String[] securityAlerts, String[] securityInfo, boolean showMoreInfo, Certificate[] certs, int start, int end, boolean majorWarning, boolean httpsDialog, boolean selfSigned) {
        return FXUIFactory.showSecurityDialog0(ainfo, title, topText, publisher, appFrom, showAlways, checkAlways, okBtnStr, cancelBtnStr, securityAlerts, securityInfo, showMoreInfo, certs, start, end, majorWarning, httpsDialog, false, selfSigned);
    }

    public int showSandboxSecurityDialog(AppInfo ainfo, String title, String topText, String publisher, URL appFrom, boolean showAlways, boolean checkAlways, String okBtnStr, String cancelBtnStr, String[] securityAlerts, String[] securityInfo, boolean showMoreInfo, Certificate[] certs, int start, int end, boolean majorWarning, boolean selfSigned) {
        return FXUIFactory.showSecurityDialog0(ainfo, title, topText, publisher, appFrom, showAlways, checkAlways, okBtnStr, cancelBtnStr, securityAlerts, securityInfo, showMoreInfo, certs, start, end, majorWarning, false, true, selfSigned);
    }

    public void showAboutJavaDialog() {
        Platform.runLater(new Runnable(){

            public void run() {
                FXAboutDialog.showAboutJavaDialog();
            }
        });
    }

    public int showListDialog(Object owner, String title, String message, String label, boolean details, Vector certs, TreeMap clientAuthCertsMap) {
        ListView certList = new ListView();
        certList.getSelectionModel().setSelectionMode(SelectionMode.SINGLE);
        certList.setItems(FXCollections.observableList(certs));
        if (certs.size() > 0) {
            certList.getSelectionModel().select(0);
        }
        return FXUIFactory.showListDialog0(owner, title, message, label, details, certList, clientAuthCertsMap);
    }

    public int showUpdateCheckDialog() {
        return FXUIFactory.showUpdateCheckDialog0();
    }

    public ConsoleWindow getConsole(ConsoleController cc) {
        return new FXConsole(cc);
    }

    public void setDialogHook(DialogHook dh) {
    }

    public ModalityHelper getModalityHelper() {
        return new FXModalityHelper();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int showErrorDialog(Object owner, final AppInfo ainfo, final String title, final String masthead, final String message, final String okBtnStr, final String detailBtnStr, final Throwable throwable, final Object detailPanel, final Certificate[] certs) {
        final Stage fOwner = FXUIFactory.beforeDialog((Stage)owner);
        try {
            int rval = FXPluginToolkit.callAndWait(new Callable<Integer>(){

                @Override
                public Integer call() {
                    DialogTemplate template = new DialogTemplate(ainfo, fOwner, title, masthead);
                    template.setErrorContent(message, okBtnStr, detailBtnStr, throwable, detailPanel, certs, false);
                    FXUIFactory.placeWindow(template.getDialog());
                    template.setVisible(true);
                    int userAnswer = template.getUserAnswer();
                    return new Integer(userAnswer);
                }
            });
            System.err.println("FXUIFactory.showErrorDialog: shutting down the FX toolkit");
            try {
                PlatformImpl.tkExit();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            int n = rval;
            return n;
        }
        catch (Throwable e) {
            int n = -1;
            return n;
        }
        finally {
            FXUIFactory.afterDialog();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int showErrorDialog(Object owner, final AppInfo ainfo, String titleStr, final String masthead, final String message, String btnOneKey, final String btnTwoKey, final String btnThreeKey) {
        final String btnString1 = btnOneKey == null ? ResourceManager.getString("common.ok_btn") : btnOneKey;
        String title = titleStr == null ? ResourceManager.getString("error.default.title") : titleStr;
        final Stage fOwner = FXUIFactory.beforeDialog((Stage)owner);
        try {
            int n = FXPluginToolkit.callAndWait(new Callable<Integer>(){

                @Override
                public Integer call() {
                    String title = ResourceManager.getString("error.default.title");
                    DialogTemplate template = new DialogTemplate(ainfo, fOwner, title, masthead);
                    template.setMultiButtonErrorContent(message, btnString1, btnTwoKey, btnThreeKey);
                    FXUIFactory.placeWindow(template.getDialog());
                    template.setVisible(true);
                    int userAnswer = template.getUserAnswer();
                    return new Integer(userAnswer);
                }
            });
            return n;
        }
        catch (Throwable e) {
            int n = -1;
            return n;
        }
        finally {
            FXUIFactory.afterDialog();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int showContentDialog(Object owner, final AppInfo ainfo, final String title, final String content, final boolean scroll, final String okBtnStr, final String cancelBtnStr) {
        final Stage fOwner = FXUIFactory.beforeDialog((Stage)owner);
        try {
            int n = FXPluginToolkit.callAndWait(new Callable<Integer>(){

                @Override
                public Integer call() {
                    DialogTemplate template = new DialogTemplate(ainfo, fOwner, title, null);
                    template.setSimpleContent(content, scroll, null, okBtnStr, cancelBtnStr, false, false);
                    FXUIFactory.placeWindow(template.getDialog());
                    template.setVisible(true);
                    int userAnswer = template.getUserAnswer();
                    return new Integer(userAnswer);
                }
            });
            return n;
        }
        catch (Throwable e) {
            int n = -1;
            return n;
        }
        finally {
            FXUIFactory.afterDialog();
        }
    }

    public static void showInformationDialog(final Object parent, final String masthead, final String text, final String title) {
        final String okBtnStr = ResourceManager.getString("common.ok_btn");
        final AppInfo ainfo = new AppInfo();
        try {
            FXUIFactory.invokeLater(new Runnable(){

                public void run() {
                    DialogTemplate template = new DialogTemplate(ainfo, (Stage)parent, title, masthead);
                    template.setInfoContent(text, okBtnStr);
                    FXUIFactory.placeWindow(template.getDialog());
                    template.setVisible(true);
                }
            }, null);
        }
        catch (Throwable e) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int showWarningDialog(Object owner, AppInfo appInfo, final String title, final String masthead, final String message, String okBtnString, String cancelBtnString) {
        final AppInfo ainfo = appInfo == null ? new AppInfo() : appInfo;
        final String okBtnStr = okBtnString == null ? ResourceManager.getString("common.ok_btn") : okBtnString;
        final String cancelBtnStr = cancelBtnString == null ? ResourceManager.getString("common.cancel_btn") : cancelBtnString;
        final Stage fOwner = FXUIFactory.beforeDialog((Stage)owner);
        try {
            int n = FXPluginToolkit.callAndWait(new Callable<Integer>(){

                @Override
                public Integer call() {
                    DialogTemplate template = new DialogTemplate(ainfo, fOwner, title, masthead);
                    template.setSimpleContent(message, false, null, okBtnStr, cancelBtnStr, true, true);
                    FXUIFactory.placeWindow(template.getDialog());
                    template.setVisible(true);
                    int userAnswer = template.getUserAnswer();
                    return new Integer(userAnswer);
                }
            });
            return n;
        }
        catch (Throwable e) {
            int n = -1;
            return n;
        }
        finally {
            FXUIFactory.afterDialog();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int showConfirmDialog(Object owner, AppInfo appInfo, final String message, final String info, final String title, final String okBtnStr, final String cancelBtnStr, final boolean useWarning) {
        final AppInfo ainfo = appInfo == null ? new AppInfo() : appInfo;
        final Stage fOwner = FXUIFactory.beforeDialog((Stage)owner);
        try {
            int n = FXPluginToolkit.callAndWait(new Callable<Integer>(){

                @Override
                public Integer call() {
                    DialogTemplate template = new DialogTemplate(ainfo, fOwner, title, message);
                    template.setSimpleContent(null, false, info, okBtnStr, cancelBtnStr, true, useWarning);
                    FXUIFactory.placeWindow(template.getDialog());
                    template.setVisible(true);
                    int userAnswer = template.getUserAnswer();
                    return new Integer(userAnswer);
                }
            });
            return n;
        }
        catch (Throwable e) {
            int n = -1;
            return n;
        }
        finally {
            FXUIFactory.afterDialog();
        }
    }

    public static int showMixedCodeDialog(Object owner, AppInfo appInfo, String title, String masthead, String message, String info, String okBtnStr, String cancelBtnStr, boolean useWarning, String showAlways) {
        boolean isJsDialog = appInfo != null;
        String appPublisherText = "";
        String appTitleText = "";
        if (isJsDialog) {
            appPublisherText = appInfo.getVendor();
            appTitleText = appInfo.getTitle();
        }
        String prefix = "security.dialog.nativemixcode." + (isJsDialog ? "js." : "");
        String appLabelWebsite = isJsDialog ? com.sun.deploy.resources.ResourceManager.getString((String)(prefix + "appLabelWebsite")) : "";
        String appLabelPublisher = isJsDialog ? com.sun.deploy.resources.ResourceManager.getString((String)(prefix + "appLabelPublisher")) : "";
        String appWebsiteText = isJsDialog ? appInfo.getDisplayFrom() : "";
        try {
            if (NativeMixedCodeDialog.isSupported()) {
                String helpBtnStr = com.sun.deploy.resources.ResourceManager.getString((String)"dialog.template.more.info");
                String closeBtnStr = com.sun.deploy.resources.ResourceManager.getString((String)"common.close_btn");
                String helpTitle = com.sun.deploy.resources.ResourceManager.getString((String)"security.more.info.title");
                String helpMessage = com.sun.deploy.resources.ResourceManager.getString((String)"security.dialog.mixcode.info1") + "\n\n" + com.sun.deploy.resources.ResourceManager.getString((String)"security.dialog.mixcode.info2") + "\n\n" + com.sun.deploy.resources.ResourceManager.getString((String)"security.dialog.mixcode.info3");
                String appLabelStr = com.sun.deploy.resources.ResourceManager.getString((String)"dialog.template.name");
                appInfo = appInfo == null ? new AppInfo() : appInfo;
                return NativeMixedCodeDialog.show((String)title, (String)masthead, (String)message, (String)info, (String)okBtnStr, (String)cancelBtnStr, (String)helpBtnStr, (String)closeBtnStr, (String)helpTitle, (String)helpMessage, (String)appLabelStr, (String)appTitleText, (String)appLabelWebsite, (String)appWebsiteText, (String)appLabelPublisher, (String)appPublisherText, (String)showAlways);
            }
            return MixedCodeInSwing.show(owner, appInfo, title, masthead, message, info, okBtnStr, cancelBtnStr, useWarning, isJsDialog, showAlways);
        }
        catch (Throwable t) {
            Trace.ignored((Throwable)t);
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int showSecurityDialog0(final AppInfo ainfo, final String title, final String topText, final String publisher, final URL appFrom, final boolean showAlways, final boolean checkAlways, final String okBtnStr, final String cancelBtnStr, final String[] securityAlerts, final String[] securityInfo, final boolean showMoreInfo, final Certificate[] certs, final int start, final int end, final boolean majorWarning, final boolean httpsDialog, final boolean sandboxApp, final boolean selfSigned) {
        int result;
        final Stage parent = FXUIFactory.beforeDialog(null);
        try {
            result = FXPluginToolkit.callAndWait(new Callable<Integer>(){

                @Override
                public Integer call() {
                    String[] info = new String[]{};
                    if (securityInfo != null) {
                        info = securityInfo;
                    }
                    int securityInfoCount = info.length;
                    info = FXUIFactory.addDetail(info, ainfo, true, true);
                    ainfo.setVendor(publisher);
                    ainfo.setFrom(appFrom);
                    DialogTemplate template = new DialogTemplate(ainfo, parent, title, topText);
                    if (ainfo.getType() == 3 && securityAlerts == null) {
                        template.setSecurityContent(false, checkAlways, okBtnStr, cancelBtnStr, securityAlerts, info, securityInfoCount, showMoreInfo, certs, start, end, majorWarning);
                    } else if (!httpsDialog) {
                        template.setNewSecurityContent(showAlways, checkAlways, okBtnStr, cancelBtnStr, securityAlerts, info, securityInfoCount, showMoreInfo, certs, start, end, majorWarning, sandboxApp, selfSigned);
                    } else {
                        template.setSecurityContent(showAlways, checkAlways, okBtnStr, cancelBtnStr, securityAlerts, info, securityInfoCount, showMoreInfo, certs, start, end, majorWarning);
                    }
                    FXUIFactory.placeWindow(template.getDialog());
                    template.setVisible(true);
                    int userAnswer = template.getUserAnswer();
                    return new Integer(userAnswer);
                }
            });
        }
        catch (Throwable e) {
            int n = -1;
            return n;
        }
        finally {
            FXUIFactory.afterDialog();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int showIntegrationDialog(Object owner, final AppInfo ainfo) {
        final Stage fOwner = FXUIFactory.beforeDialog((Stage)owner);
        try {
            int n = FXPluginToolkit.callAndWait(new Callable<Integer>(){

                @Override
                public Integer call() {
                    String title = ResourceManager.getString("integration.title");
                    boolean doShortcut = ainfo.getDesktopHint() || ainfo.getMenuHint();
                    String key = "integration.text.shortcut";
                    key = doShortcut ? "integration.text.both" : "integration.text.association";
                    String topText = ResourceManager.getString(key);
                    String[] security = new String[]{};
                    String[] alerts = new String[]{};
                    alerts = FXUIFactory.addDetail(alerts, ainfo, false, true);
                    String[] info = new String[]{};
                    info = FXUIFactory.addDetail(info, ainfo, true, false);
                    boolean showMoreInfo = alerts.length + info.length > 1;
                    String okBtnStr = ResourceManager.getString("common.ok_btn");
                    String cancelBtnStr = ResourceManager.getString("integration.skip.button");
                    DialogTemplate template = new DialogTemplate(ainfo, fOwner, title, topText);
                    template.setSecurityContent(false, false, okBtnStr, cancelBtnStr, alerts, info, 0, showMoreInfo, null, 0, 0, false);
                    FXUIFactory.placeWindow(template.getDialog());
                    template.setVisible(true);
                    int userAnswer = template.getUserAnswer();
                    return new Integer(userAnswer);
                }
            });
            return n;
        }
        catch (Throwable e) {
            int n = -1;
            return n;
        }
        finally {
            FXUIFactory.afterDialog();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int showUpdateCheckDialog0() {
        String yesBtnKey = "autoupdatecheck.buttonYes";
        String noBtnKey = "autoupdatecheck.buttonNo";
        String askBtnKey = "autoupdatecheck.buttonAskLater";
        final String title = ResourceManager.getMessage("autoupdatecheck.caption");
        final String infoStr = ResourceManager.getMessage("autoupdatecheck.message");
        final String masthead = ResourceManager.getMessage("autoupdatecheck.masthead");
        final AppInfo ainfo = new AppInfo();
        final Stage owner = FXUIFactory.beforeDialog(null);
        try {
            int n = FXPluginToolkit.callAndWait(new Callable<Integer>(){

                @Override
                public Integer call() {
                    DialogTemplate template = new DialogTemplate(ainfo, owner, title, masthead);
                    template.setUpdateCheckContent(infoStr, "autoupdatecheck.buttonYes", "autoupdatecheck.buttonNo", "autoupdatecheck.buttonAskLater");
                    FXUIFactory.placeWindow(template.getDialog());
                    template.setVisible(true);
                    int userAnswer = template.getUserAnswer();
                    return new Integer(userAnswer);
                }
            });
            return n;
        }
        catch (Throwable e) {
            int n = 3;
            return n;
        }
        finally {
            FXUIFactory.afterDialog();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int showListDialog0(Object owner, final String title, final String message, final String label, final boolean details, final ListView scrollList, final TreeMap clientAuthCertsMap) {
        final String okBtnStr = ResourceManager.getString("common.ok_btn");
        final String cancelBtnStr = ResourceManager.getString("common.cancel_btn");
        final Stage fOwner = FXUIFactory.beforeDialog((Stage)owner);
        try {
            int n = FXPluginToolkit.callAndWait(new Callable<Integer>(){

                @Override
                public Integer call() {
                    DialogTemplate template = new DialogTemplate(new AppInfo(), fOwner, title, message);
                    template.setListContent(label, scrollList, details, okBtnStr, cancelBtnStr, clientAuthCertsMap);
                    FXUIFactory.placeWindow(template.getDialog());
                    template.setVisible(true);
                    int userAnswer = template.getUserAnswer();
                    return new Integer(userAnswer);
                }
            });
            return n;
        }
        catch (Throwable e) {
            int n = -1;
            return n;
        }
        finally {
            FXUIFactory.afterDialog();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int showApiDialog(Object owner, AppInfo appInfo, final String title, final String message, final String label, final String files, final String always, final boolean checked) {
        final String okBtnStr = ResourceManager.getString("common.ok_btn");
        final String cancelBtnStr = ResourceManager.getString("common.cancel_btn");
        final AppInfo ainfo = appInfo == null ? new AppInfo() : appInfo;
        final Stage fOwner = FXUIFactory.beforeDialog((Stage)owner);
        try {
            int n = FXPluginToolkit.callAndWait(new Callable<Integer>(){

                @Override
                public Integer call() {
                    DialogTemplate template = new DialogTemplate(ainfo, fOwner, title, message);
                    template.setApiContent(files, label, always, checked, okBtnStr, cancelBtnStr);
                    FXUIFactory.placeWindow(template.getDialog());
                    template.setVisible(true);
                    int userAnswer = template.getUserAnswer();
                    return new Integer(userAnswer);
                }
            });
            return n;
        }
        catch (Throwable e) {
            int n = -1;
            return n;
        }
        finally {
            FXUIFactory.afterDialog();
        }
    }

    public static void showExceptionDialog(Object owner, Throwable throwable, String masthead, String msg, String title) {
        String okBtnStr = ResourceManager.getString("common.ok_btn");
        String detailBtnStr = ResourceManager.getString("common.detail.button");
        if (msg == null) {
            msg = throwable.toString();
        }
        if (title == null) {
            title = ResourceManager.getString("error.default.title");
        }
        FXUIFactory.showErrorDialog(owner, new AppInfo(), title, masthead, msg, okBtnStr, detailBtnStr, throwable, null, null);
    }

    public static void showCertificateExceptionDialog(Object owner, AppInfo ainfo, Throwable throwable, String msg, String title, Certificate[] certs) {
        String okBtnStr = ResourceManager.getString("common.ok_btn");
        String detailBtnStr = ResourceManager.getString("common.detail.button");
        if (msg == null) {
            msg = throwable.toString();
        }
        if (title == null) {
            title = ResourceManager.getString("error.default.title");
        }
        FXUIFactory.showErrorDialog(owner, ainfo, title, msg, null, okBtnStr, detailBtnStr, throwable, null, certs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CredentialInfo showPasswordDialog0(Object parent, final String title, final String notes, final boolean showUsername, final boolean showDomain, final CredentialInfo info, final boolean saveEnabled, final String scheme, final String warning) {
        final Stage fParent = FXUIFactory.beforeDialog((Stage)parent);
        try {
            CredentialInfo credentialInfo = FXPluginToolkit.callAndWait(new Callable<CredentialInfo>(){

                @Override
                public CredentialInfo call() {
                    CredentialInfo result = null;
                    CredentialInfo input = info;
                    DialogTemplate template = new DialogTemplate(new AppInfo(), fParent, title, "");
                    if (input == null) {
                        input = new CredentialInfo();
                    }
                    template.setPasswordContent(notes, showUsername, showDomain, input.getUserName(), input.getDomain(), saveEnabled, input.getPassword(), scheme, warning);
                    FXUIFactory.placeWindow(template.getDialog());
                    template.setVisible(true);
                    int answer = template.getUserAnswer();
                    if (answer == 0 || answer == 2) {
                        result = new CredentialInfo();
                        result.setUserName(template.getUserName());
                        result.setDomain(template.getDomain());
                        result.setPassword(template.getPassword());
                        result.setPasswordSaveApproval(template.isPasswordSaved());
                    }
                    return result;
                }
            });
            return credentialInfo;
        }
        catch (Throwable e) {
            CredentialInfo credentialInfo = null;
            return credentialInfo;
        }
        finally {
            FXUIFactory.afterDialog();
        }
    }

    public int showSSVDialog(Object owner, AppInfo ainfo, String title, String masthead, String message, String moreInfoText, URL moreInfoURL, String choiceText, String choice1Label, String choice2Label, String btnOneLabel, String btnTwoLabel) {
        return FXUIFactory.showSSVDialog0(owner, ainfo, title, masthead, message, moreInfoText, moreInfoURL, choiceText, choice1Label, choice2Label, btnOneLabel, btnTwoLabel);
    }

    private File[] showFileChooser_priv(final String initDir, final String[] extensions, final int mode, final boolean showMultiple, String filename) {
        return (File[])AccessController.doPrivileged(new PrivilegedAction(){

            public File[] run() {
                File f;
                FileChooser fileChooser = new FileChooser();
                File file = f = initDir == null ? null : new File(initDir);
                if (f != null && !f.isDirectory()) {
                    f = f.getParentFile();
                }
                fileChooser.setInitialDirectory(f);
                if (extensions != null) {
                    String[] fxExtensions = new String[extensions.length];
                    for (int i = 0; i < extensions.length; ++i) {
                        if (extensions[i] == null) continue;
                        fxExtensions[i] = "*." + extensions[i];
                    }
                    fileChooser.getExtensionFilters().setAll((FileChooser.ExtensionFilter[])new FileChooser.ExtensionFilter[]{new FileChooser.ExtensionFilter(Arrays.toString(extensions), Arrays.asList(fxExtensions))});
                }
                if (showMultiple) {
                    return fileChooser.showOpenMultipleDialog(null).toArray(new File[0]);
                }
                if (mode == 8) {
                    return new File[]{fileChooser.showOpenDialog(null)};
                }
                return new File[]{fileChooser.showSaveDialog(null)};
            }
        });
    }

    public File[] showFileChooser(final String initDir, final String[] extensions, final int mode, final boolean showMultiple, final String filename) {
        try {
            return FXPluginToolkit.callAndWait(new Callable<File[]>(){

                @Override
                public File[] call() {
                    return FXUIFactory.this.showFileChooser_priv(initDir, extensions, mode, showMultiple, filename);
                }
            });
        }
        catch (Throwable e) {
            Trace.ignored((Throwable)e);
            return null;
        }
    }

    public static Pane getDetailPanel(String MoreInfo) {
        BorderPane detailPanel = new BorderPane(){
            {
                this.setId("detail-panel");
                this.setPrefWidth(480.0);
                this.setPrefHeight(300.0);
            }
        };
        TabPane tabPane = new TabPane();
        tabPane.setId("detail-panel-tab-pane");
        tabPane.getStyleClass().add("floating");
        detailPanel.setCenter(tabPane);
        HBox intro = new HBox();
        intro.setId("detail-panel-top-pane");
        intro.setAlignment(Pos.BASELINE_LEFT);
        Label label = new Label(ResourceManager.getString("launcherrordialog.error.label"));
        label.setId("error-dialog-error-label");
        label.setMinWidth(Double.NEGATIVE_INFINITY);
        intro.getChildren().add(label);
        String[] msg = MoreInfo.split("<split>");
        UITextArea ta = new UITextArea(msg[0]);
        ta.setId("detail-panel-msg0");
        ta.setPrefWidth(-1.0);
        intro.getChildren().add(ta);
        detailPanel.setTop(intro);
        int i = 1;
        while (i + 1 < msg.length) {
            Label tp12 = new Label();
            tp12.getStyleClass().add("multiline-text");
            tp12.setWrapText(true);
            tp12.setText(msg[i + 1]);
            Tab tab = new Tab();
            tab.setText(msg[i]);
            ScrollPane scrollPane = new ScrollPane();
            scrollPane.setContent(tp12);
            scrollPane.setFitToWidth(true);
            tab.setContent(scrollPane);
            tabPane.getTabs().add(tab);
            i += 2;
        }
        return detailPanel;
    }

    private static Stage beforeDialog(Stage component) {
        return component;
    }

    private static void afterDialog() {
    }

    public static String[] addDetail(String[] list, AppInfo ainfo, boolean doShortcut, boolean doAssociation) {
        String title = ainfo.getTitle();
        if (title == null) {
            title = "";
        }
        ArrayList<String> al = new ArrayList<String>();
        for (int i = 0; i < list.length; ++i) {
            al.add(list[i]);
        }
        if (doShortcut) {
            String message = null;
            if (ainfo.getDesktopHint() && ainfo.getMenuHint()) {
                message = ResourceManager.getString("install.windows.both.message");
            } else if (ainfo.getDesktopHint()) {
                message = ResourceManager.getString("install.desktop.message");
            } else if (ainfo.getMenuHint()) {
                message = ResourceManager.getString("install.windows.menu.message");
            }
            if (message != null) {
                al.add(message);
            }
        }
        return al.toArray(list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int showSSVDialog0(Object owner, final AppInfo ainfo, final String title, final String masthead, final String message, final String moreInfoText, final URL moreInfoURL, final String choiceText, final String choice1Label, final String choice2Label, final String btnOneLabel, final String btnTwoLabel) {
        final Stage fOwner = FXUIFactory.beforeDialog((Stage)owner);
        try {
            int n = FXPluginToolkit.callAndWait(new Callable<Integer>(){

                @Override
                public Integer call() {
                    DialogTemplate template = new DialogTemplate(ainfo, fOwner, title, masthead);
                    template.setSSVContent(message, moreInfoText, moreInfoURL, choiceText, choice1Label, choice2Label, btnOneLabel, btnTwoLabel);
                    FXUIFactory.placeWindow(template.getDialog());
                    template.setVisible(true);
                    int userAnswer = template.getUserAnswer();
                    return new Integer(userAnswer);
                }
            });
            return n;
        }
        catch (Throwable e) {
            int n = -1;
            return n;
        }
        finally {
            FXUIFactory.afterDialog();
        }
    }

    public static void placeWindow(Window window) {
        window.centerOnScreen();
    }

    private static Object invokeLater(final Runnable r, Integer dummy) throws Exception {
        if (r != null) {
            return (Integer)DeploySysRun.executePrivileged((DeploySysAction)new DeploySysAction(){

                public Object execute() {
                    Platform.runLater(r);
                    return null;
                }
            }, (Object)new Integer(-1));
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int showSSV3Dialog(final Object owner, final AppInfo ainfo, final int messageType, final String title, final String masthead, final String mainText, final String location, final String prompt, final String multiPrompt, final String multiText, final String run, final String update, final String cancel, final String always, final URL updateURL) {
        try {
            Class<?> configClass = Class.forName("com.sun.deploy.config.Config", false, Thread.currentThread().getContextClassLoader());
            Method getStringPropertyMethod = configClass.getDeclaredMethod("getStringProperty", String.class);
            Object obj = getStringPropertyMethod.invoke(configClass, "deployment.sqe.automation.run");
            if (obj instanceof String && "true".equals((String)obj)) {
                return 0;
            }
        }
        catch (Exception e) {
            Trace.ignoredException((Exception)e);
        }
        Stage fOwner = FXUIFactory.beforeDialog((Stage)owner);
        try {
            int getStringPropertyMethod = FXPluginToolkit.callAndWait(new Callable<Integer>(){

                @Override
                public Integer call() {
                    return FXSSV3Dialog.showSSV3Dialog(owner, ainfo, messageType, title, masthead, mainText, location, prompt, multiPrompt, multiText, run, update, cancel, always, updateURL);
                }
            });
            return getStringPropertyMethod;
        }
        catch (Throwable e) {
            int n = -1;
            return n;
        }
        finally {
            FXUIFactory.afterDialog();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int showPublisherInfo(Object owner, final AppInfo ainfo, final String title, final String masthead, final String message, final String okBtnStr, final String detailBtnStr, final String moreInfo) {
        final Stage fOwner = FXUIFactory.beforeDialog((Stage)owner);
        try {
            int n = FXPluginToolkit.callAndWait(new Callable<Integer>(){

                @Override
                public Integer call() {
                    DialogTemplate template = new DialogTemplate(ainfo, fOwner, title, masthead);
                    Pane detailPanel = null;
                    if (moreInfo != null) {
                        detailPanel = FXUIFactory.getDetailPanel(moreInfo);
                    }
                    template.setPublisherInfo(message, okBtnStr, detailBtnStr, detailPanel, false);
                    FXUIFactory.placeWindow(template.getDialog());
                    template.setVisible(true);
                    int userAnswer = template.getUserAnswer();
                    return new Integer(userAnswer);
                }
            });
            return n;
        }
        catch (Throwable e) {
            int n = -1;
            return n;
        }
        finally {
            FXUIFactory.afterDialog();
        }
    }
}

