/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control.behavior;

import com.sun.javafx.scene.control.behavior.BehaviorBase;
import com.sun.javafx.scene.control.behavior.KeyBinding;
import com.sun.javafx.scene.control.skin.TabPaneSkin;
import java.util.ArrayList;
import java.util.List;
import javafx.collections.ObservableList;
import javafx.event.Event;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.SingleSelectionModel;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.input.KeyCode;
import javafx.scene.input.MouseEvent;

public class TabPaneBehavior
extends BehaviorBase<TabPane> {
    private static final String HOME = "Home";
    private static final String END = "End";
    private static final String CTRL_PAGE_UP = "Ctrl_Page_Up";
    private static final String CTRL_PAGE_DOWN = "Ctrl_Page_Down";
    private static final String CTRL_TAB = "Ctrl_Tab";
    private static final String CTRL_SHIFT_TAB = "Ctrl_Shift_Tab";
    protected static final List<KeyBinding> TABPANE_BINDINGS = new ArrayList<KeyBinding>();

    @Override
    protected List<KeyBinding> createKeyBindings() {
        return TABPANE_BINDINGS;
    }

    @Override
    protected void callAction(String string) {
        if ("TraverseLeft".equals(string) || "TraverseUp".equals(string)) {
            if (((TabPane)this.getControl()).isFocused()) {
                this.selectPreviousTab();
            }
        } else if ("TraverseRight".equals(string) || "TraverseDown".equals(string)) {
            if (((TabPane)this.getControl()).isFocused()) {
                this.selectNextTab();
            }
        } else if ("TraverseNext".equals(string)) {
            TabPane tabPane = (TabPane)this.getControl();
            TabPaneSkin tabPaneSkin = (TabPaneSkin)tabPane.getSkin();
            if (tabPaneSkin.getSelectedTabContentRegion() != null) {
                tabPaneSkin.getSelectedTabContentRegion().getImpl_traversalEngine().getTopLeftFocusableNode();
                if (tabPaneSkin.getSelectedTabContentRegion().getImpl_traversalEngine().registeredNodes.isEmpty()) {
                    Parent parent = null;
                    parent = TabPaneBehavior.getFirstPopulatedInnerTraversalEngine(tabPaneSkin.getSelectedTabContentRegion().getChildren());
                    if (parent != null) {
                        boolean bl = false;
                        for (Node node : parent.getImpl_traversalEngine().registeredNodes) {
                            if (node.isFocused() || !node.impl_isTreeVisible() || node.isDisabled()) continue;
                            node.requestFocus();
                            bl = true;
                            break;
                        }
                        if (!bl) {
                            super.callAction(string);
                        }
                    } else {
                        super.callAction(string);
                    }
                }
            } else {
                super.callAction(string);
            }
        } else if (CTRL_TAB.equals(string) || CTRL_PAGE_DOWN.equals(string)) {
            TabPane tabPane = (TabPane)this.getControl();
            if (tabPane.getSelectionModel().getSelectedIndex() == tabPane.getTabs().size() - 1) {
                tabPane.getSelectionModel().selectFirst();
            } else {
                this.selectNextTab();
            }
            tabPane.requestFocus();
        } else if (CTRL_SHIFT_TAB.equals(string) || CTRL_PAGE_UP.equals(string)) {
            TabPane tabPane = (TabPane)this.getControl();
            if (tabPane.getSelectionModel().getSelectedIndex() == 0) {
                tabPane.getSelectionModel().selectLast();
            } else {
                this.selectPreviousTab();
            }
            tabPane.requestFocus();
        } else if (HOME.equals(string)) {
            if (((TabPane)this.getControl()).isFocused()) {
                ((TabPane)this.getControl()).getSelectionModel().selectFirst();
            }
        } else if (END.equals(string)) {
            if (((TabPane)this.getControl()).isFocused()) {
                ((TabPane)this.getControl()).getSelectionModel().selectLast();
            }
        } else {
            super.callAction(string);
        }
    }

    public static Parent getFirstPopulatedInnerTraversalEngine(ObservableList<Node> observableList) {
        Parent parent = null;
        for (Node node : observableList) {
            if (!(node instanceof Parent)) continue;
            if (((Parent)node).getImpl_traversalEngine() != null && !((Parent)node).getImpl_traversalEngine().registeredNodes.isEmpty()) {
                parent = (Parent)node;
                break;
            }
            parent = TabPaneBehavior.getFirstPopulatedInnerTraversalEngine(((Parent)node).getChildrenUnmodifiable());
            if (parent == null) continue;
            break;
        }
        return parent;
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        super.mousePressed(mouseEvent);
        TabPane tabPane = (TabPane)this.getControl();
        tabPane.requestFocus();
    }

    public TabPaneBehavior(TabPane tabPane) {
        super(tabPane);
    }

    public void selectTab(Tab tab) {
        ((TabPane)this.getControl()).getSelectionModel().select(tab);
    }

    public void closeTab(Tab tab) {
        TabPane tabPane = (TabPane)this.getControl();
        int n = tabPane.getTabs().indexOf(tab);
        if (tab.isSelected()) {
            if (n == 0) {
                if (tabPane.getTabs().size() > 0) {
                    tabPane.getSelectionModel().selectFirst();
                }
            } else {
                tabPane.getSelectionModel().selectPrevious();
            }
        }
        if (n != -1) {
            tabPane.getTabs().remove(n);
        }
        if (tab.getOnClosed() != null) {
            Event.fireEvent(tab, new Event(Tab.CLOSED_EVENT));
        }
    }

    public void selectNextTab() {
        int n;
        SingleSelectionModel<Tab> singleSelectionModel = ((TabPane)this.getControl()).getSelectionModel();
        for (int i = n = singleSelectionModel.getSelectedIndex(); i < ((TabPane)this.getControl()).getTabs().size(); ++i) {
            singleSelectionModel.selectNext();
            if (((Tab)singleSelectionModel.getSelectedItem()).isDisable()) continue;
            return;
        }
        singleSelectionModel.select(n);
    }

    public void selectPreviousTab() {
        int n;
        SingleSelectionModel<Tab> singleSelectionModel = ((TabPane)this.getControl()).getSelectionModel();
        for (int i = n = singleSelectionModel.getSelectedIndex(); i > 0; --i) {
            singleSelectionModel.selectPrevious();
            if (((Tab)singleSelectionModel.getSelectedItem()).isDisable()) continue;
            return;
        }
        singleSelectionModel.select(n);
    }

    static {
        TABPANE_BINDINGS.addAll(TRAVERSAL_BINDINGS);
        TABPANE_BINDINGS.add(new KeyBinding(KeyCode.HOME, HOME));
        TABPANE_BINDINGS.add(new KeyBinding(KeyCode.END, END));
        TABPANE_BINDINGS.add(new KeyBinding(KeyCode.PAGE_UP, CTRL_PAGE_UP).ctrl());
        TABPANE_BINDINGS.add(new KeyBinding(KeyCode.PAGE_DOWN, CTRL_PAGE_DOWN).ctrl());
        TABPANE_BINDINGS.add(new KeyBinding(KeyCode.TAB, CTRL_TAB).ctrl());
        TABPANE_BINDINGS.add(new KeyBinding(KeyCode.TAB, CTRL_SHIFT_TAB).shift().ctrl());
    }
}

