/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control.skin;

import com.sun.javafx.css.StyleableProperty;
import com.sun.javafx.scene.control.WeakListChangeListener;
import com.sun.javafx.scene.control.behavior.BehaviorBase;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WeakChangeListener;
import javafx.collections.ListChangeListener;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.event.EventType;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Control;
import javafx.scene.control.Skin;
import javafx.scene.input.ContextMenuEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.StackPane;

public abstract class SkinBase<C extends Control, B extends BehaviorBase<C>>
extends StackPane
implements Skin<C> {
    private C control;
    private B behavior;
    private static final EventHandler<MouseEvent> mouseEventConsumer = new EventHandler<MouseEvent>(){

        @Override
        public void handle(MouseEvent mouseEvent) {
            mouseEvent.consume();
        }
    };
    private final ListChangeListener styleClassChangeListener = new ListChangeListener<String>(){

        @Override
        public void onChanged(ListChangeListener.Change<? extends String> change) {
            while (change.next()) {
                if (change.wasRemoved()) {
                    SkinBase.this.getStyleClass().removeAll((Collection<?>)change.getRemoved());
                }
                if (!change.wasAdded()) continue;
                SkinBase.this.getStyleClass().addAll((Collection<String>)change.getAddedSubList());
            }
        }
    };
    private final ChangeListener controlPropertyChangedListener = new ChangeListener(){

        public void changed(ObservableValue observableValue, Object object, Object object2) {
            SkinBase.this.handleControlPropertyChanged((String)SkinBase.this.propertyReferenceMap.get(observableValue));
        }
    };
    private Map<ObservableValue, String> propertyReferenceMap = new HashMap<ObservableValue, String>();
    private static final String STYLE_PROPERTY_REF = "STYLE_PROPERTY_REF";
    private static final String ID_PROPERTY_REF = "ID_PROPERTY_REF";
    private final EventHandler<MouseEvent> mouseHandler = new EventHandler<MouseEvent>(){

        @Override
        public void handle(MouseEvent mouseEvent) {
            EventType<? extends Event> eventType = mouseEvent.getEventType();
            if (eventType == MouseEvent.MOUSE_ENTERED) {
                SkinBase.this.behavior.mouseEntered(mouseEvent);
            } else if (eventType == MouseEvent.MOUSE_EXITED) {
                SkinBase.this.behavior.mouseExited(mouseEvent);
            } else if (eventType == MouseEvent.MOUSE_PRESSED) {
                SkinBase.this.behavior.mousePressed(mouseEvent);
            } else if (eventType == MouseEvent.MOUSE_RELEASED) {
                SkinBase.this.behavior.mouseReleased(mouseEvent);
            } else if (eventType == MouseEvent.MOUSE_DRAGGED) {
                SkinBase.this.behavior.mouseDragged(mouseEvent);
            } else {
                throw new AssertionError((Object)"Unsupported event type received");
            }
        }
    };
    private final EventHandler<ContextMenuEvent> contextMenuHandler = new EventHandler<ContextMenuEvent>(){

        @Override
        public void handle(ContextMenuEvent contextMenuEvent) {
            if (SkinBase.this.showContextMenu(SkinBase.this.getContextMenu(), contextMenuEvent.getScreenX(), contextMenuEvent.getScreenY(), contextMenuEvent.isKeyboardTrigger())) {
                contextMenuEvent.consume();
            }
        }
    };

    protected final void consumeMouseEvents(boolean bl) {
        if (bl) {
            if (this.control != null) {
                ((Node)this.control).addEventHandler(MouseEvent.ANY, mouseEventConsumer);
            }
        } else if (this.control != null) {
            ((Node)this.control).removeEventHandler(MouseEvent.ANY, mouseEventConsumer);
        }
    }

    @Override
    public C getSkinnable() {
        return this.control;
    }

    @Override
    public final Node getNode() {
        return this;
    }

    @Override
    public void dispose() {
        for (ObservableValue observableValue : this.propertyReferenceMap.keySet()) {
            observableValue.removeListener(this.controlPropertyChangedListener);
        }
        this.removeEventHandler(MouseEvent.MOUSE_ENTERED, this.mouseHandler);
        this.removeEventHandler(MouseEvent.MOUSE_EXITED, this.mouseHandler);
        this.removeEventHandler(MouseEvent.MOUSE_PRESSED, this.mouseHandler);
        this.removeEventHandler(MouseEvent.MOUSE_RELEASED, this.mouseHandler);
        this.removeEventHandler(MouseEvent.MOUSE_DRAGGED, this.mouseHandler);
        ((Node)this.control).removeEventHandler(ContextMenuEvent.CONTEXT_MENU_REQUESTED, this.contextMenuHandler);
        this.control = null;
        this.behavior = null;
    }

    public SkinBase(C c, B b) {
        if (c == null || b == null) {
            throw new IllegalArgumentException("Cannot pass null for control or behavior");
        }
        this.control = c;
        this.behavior = b;
        this.getStyleClass().setAll((Collection<String>)((Node)c).getStyleClass());
        this.setStyle(((Node)c).getStyle());
        this.setId(((Node)c).getId());
        ((Node)c).getStyleClass().addListener(new WeakListChangeListener(this.styleClassChangeListener));
        this.registerChangeListener(((Node)c).styleProperty(), STYLE_PROPERTY_REF);
        this.registerChangeListener(((Node)c).idProperty(), ID_PROPERTY_REF);
        this.addEventHandler(MouseEvent.MOUSE_ENTERED, this.mouseHandler);
        this.addEventHandler(MouseEvent.MOUSE_EXITED, this.mouseHandler);
        this.addEventHandler(MouseEvent.MOUSE_PRESSED, this.mouseHandler);
        this.addEventHandler(MouseEvent.MOUSE_RELEASED, this.mouseHandler);
        this.addEventHandler(MouseEvent.MOUSE_DRAGGED, this.mouseHandler);
        ((Node)c).addEventHandler(ContextMenuEvent.CONTEXT_MENU_REQUESTED, this.contextMenuHandler);
        this.consumeMouseEvents(true);
    }

    public B getBehavior() {
        return this.behavior;
    }

    public ContextMenu getContextMenu() {
        return ((Control)this.getSkinnable()).getContextMenu();
    }

    public boolean showContextMenu(ContextMenu contextMenu, double d, double d2, boolean bl) {
        if (contextMenu != null) {
            contextMenu.show((Node)this.control, d, d2);
            return true;
        }
        return false;
    }

    @Override
    @Deprecated
    public long impl_getPseudoClassState() {
        return ((Node)((Object)this.getSkinnable())).impl_getPseudoClassState();
    }

    public static List<StyleableProperty> impl_CSS_STYLEABLES() {
        return StyleableProperties.STYLEABLES;
    }

    @Override
    @Deprecated
    public List<StyleableProperty> impl_getStyleableProperties() {
        return SkinBase.impl_CSS_STYLEABLES();
    }

    protected final void registerChangeListener(ObservableValue observableValue, String string) {
        if (!this.propertyReferenceMap.containsKey(observableValue)) {
            this.propertyReferenceMap.put(observableValue, string);
            observableValue.addListener(new WeakChangeListener(this.controlPropertyChangedListener));
        }
    }

    protected void handleControlPropertyChanged(String string) {
        if (STYLE_PROPERTY_REF.equals(string)) {
            this.setStyle(((Node)((Object)this.getSkinnable())).getStyle());
        } else if (ID_PROPERTY_REF.equals(string)) {
            this.setId(((Node)((Object)this.getSkinnable())).getId());
        }
    }

    private static class StyleableProperties {
        private static final List<StyleableProperty> STYLEABLES;

        private StyleableProperties() {
        }

        static {
            List<StyleableProperty> list = StackPane.impl_CSS_STYLEABLES();
            List<StyleableProperty> list2 = Parent.impl_CSS_STYLEABLES();
            ArrayList<StyleableProperty> arrayList = new ArrayList<StyleableProperty>();
            int n = list2.size();
            int n2 = list.size() - n;
            for (int i = 0; i < n2; ++i) {
                arrayList.add(list.get(i + n));
            }
            STYLEABLES = Collections.unmodifiableList(arrayList);
        }
    }
}

