/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.tk;

import com.sun.javafx.PlatformUtil;
import com.sun.javafx.embed.HostInterface;
import com.sun.javafx.geom.CameraImpl;
import com.sun.javafx.geom.ParallelCameraImpl;
import com.sun.javafx.geom.Path2D;
import com.sun.javafx.geom.PerspectiveCameraImpl;
import com.sun.javafx.geom.Shape;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.javafx.jmx.HighlightRegion;
import com.sun.javafx.logging.PlatformLogger;
import com.sun.javafx.perf.PerformanceTracker;
import com.sun.javafx.runtime.NativeLibLoader;
import com.sun.javafx.runtime.VersionInfo;
import com.sun.javafx.runtime.async.AsyncOperation;
import com.sun.javafx.runtime.async.AsyncOperationListener;
import com.sun.javafx.scene.text.HitInfo;
import com.sun.javafx.sg.PGArc;
import com.sun.javafx.sg.PGCanvas;
import com.sun.javafx.sg.PGCircle;
import com.sun.javafx.sg.PGCubicCurve;
import com.sun.javafx.sg.PGEllipse;
import com.sun.javafx.sg.PGGroup;
import com.sun.javafx.sg.PGImageView;
import com.sun.javafx.sg.PGLine;
import com.sun.javafx.sg.PGMediaView;
import com.sun.javafx.sg.PGNode;
import com.sun.javafx.sg.PGPath;
import com.sun.javafx.sg.PGPolygon;
import com.sun.javafx.sg.PGPolyline;
import com.sun.javafx.sg.PGQuadCurve;
import com.sun.javafx.sg.PGRectangle;
import com.sun.javafx.sg.PGRegion;
import com.sun.javafx.sg.PGSVGPath;
import com.sun.javafx.sg.PGShape;
import com.sun.javafx.sg.PGText;
import com.sun.javafx.tk.FileChooserType;
import com.sun.javafx.tk.FontLoader;
import com.sun.javafx.tk.ImageLoader;
import com.sun.javafx.tk.LocalClipboard;
import com.sun.javafx.tk.PlatformImage;
import com.sun.javafx.tk.ScreenConfigurationAccessor;
import com.sun.javafx.tk.TKClipboard;
import com.sun.javafx.tk.TKDragGestureListener;
import com.sun.javafx.tk.TKDragSourceListener;
import com.sun.javafx.tk.TKDropTargetListener;
import com.sun.javafx.tk.TKListener;
import com.sun.javafx.tk.TKPulseListener;
import com.sun.javafx.tk.TKScene;
import com.sun.javafx.tk.TKScreenConfigurationListener;
import com.sun.javafx.tk.TKStage;
import com.sun.javafx.tk.TKSystemMenu;
import com.sun.scenario.DelayedRunnable;
import com.sun.scenario.ToolkitAccessor;
import com.sun.scenario.animation.AbstractMasterTimer;
import com.sun.scenario.effect.AbstractShadow;
import com.sun.scenario.effect.Color4f;
import com.sun.scenario.effect.FilterContext;
import com.sun.scenario.effect.Filterable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.CountDownLatch;
import javafx.application.ConditionalFeature;
import javafx.geometry.Dimension2D;
import javafx.scene.Scene;
import javafx.scene.effect.BlurType;
import javafx.scene.image.Image;
import javafx.scene.image.WritableImage;
import javafx.scene.input.DragEvent;
import javafx.scene.input.Dragboard;
import javafx.scene.input.InputMethodEvent;
import javafx.scene.input.InputMethodRequests;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.TransferMode;
import javafx.scene.paint.Color;
import javafx.scene.paint.ImagePattern;
import javafx.scene.paint.LinearGradient;
import javafx.scene.paint.Paint;
import javafx.scene.paint.RadialGradient;
import javafx.scene.paint.Stop;
import javafx.scene.shape.PathElement;
import javafx.scene.shape.SVGPath;
import javafx.stage.FileChooser;
import javafx.stage.Modality;
import javafx.stage.StageStyle;
import javafx.stage.Window;

public abstract class Toolkit {
    private static String tk;
    private static Toolkit TOOLKIT;
    private static Thread fxUserThread;
    private static final String QUANTUM_TOOLKIT = "com.sun.javafx.tk.quantum.QuantumToolkit";
    private static final String DEFAULT_TOOLKIT = "com.sun.javafx.tk.quantum.QuantumToolkit";
    protected static Map gradientMap;
    private final Map<TKPulseListener, AccessControlContext> stagePulseListeners = new WeakHashMap<TKPulseListener, AccessControlContext>();
    private final Map<TKPulseListener, AccessControlContext> scenePulseListeners = new WeakHashMap<TKPulseListener, AccessControlContext>();
    private final Map<TKPulseListener, AccessControlContext> postScenePulseListeners = new WeakHashMap<TKPulseListener, AccessControlContext>();
    private final Map<TKListener, AccessControlContext> toolkitListeners = new WeakHashMap<TKListener, AccessControlContext>();
    private final Set<Runnable> shutdownHooks = new HashSet<Runnable>();
    private final Map<TKPulseListener, AccessControlContext> stagePulseList = new WeakHashMap<TKPulseListener, AccessControlContext>();
    private final Map<TKPulseListener, AccessControlContext> scenePulseList = new WeakHashMap<TKPulseListener, AccessControlContext>();
    private final Map<TKPulseListener, AccessControlContext> postScenePulseList = new WeakHashMap<TKPulseListener, AccessControlContext>();
    private TKPulseListener lastTkPulseListener = null;
    private AccessControlContext lastTkPulseAcc = null;
    private CountDownLatch pauseScenesLatch = null;
    private Set<HighlightRegion> highlightRegions;
    private static SceneAccessor sceneAccessor;
    private static WritableImageAccessor writableImageAccessor;

    private static String lookupToolkitClass(String string) {
        if ("prism".equalsIgnoreCase(string)) {
            return "com.sun.javafx.tk.quantum.QuantumToolkit";
        }
        if ("quantum".equalsIgnoreCase(string)) {
            return "com.sun.javafx.tk.quantum.QuantumToolkit";
        }
        return string;
    }

    private static String getDefaultToolkit() {
        if (PlatformUtil.isWindows()) {
            return "com.sun.javafx.tk.quantum.QuantumToolkit";
        }
        if (PlatformUtil.isMac()) {
            return "com.sun.javafx.tk.quantum.QuantumToolkit";
        }
        if (PlatformUtil.isLinux()) {
            return "com.sun.javafx.tk.quantum.QuantumToolkit";
        }
        throw new UnsupportedOperationException(System.getProperty("os.name") + " is not supported");
    }

    public static synchronized Toolkit getToolkit() {
        if (TOOLKIT != null) {
            return TOOLKIT;
        }
        final boolean bl = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return Boolean.getBoolean("javafx.verbose");
            }
        });
        if (PlatformUtil.isWindows()) {
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    block2: {
                        try {
                            NativeLibLoader.loadLibrary("msvcr100");
                        }
                        catch (Throwable throwable) {
                            if (!bl) break block2;
                            System.err.println("Error: failed to load msvcr100.dll : " + throwable);
                        }
                    }
                    return null;
                }
            });
        }
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                VersionInfo.setupSystemProperties();
                return null;
            }
        });
        boolean bl2 = true;
        String string = null;
        try {
            string = System.getProperty("javafx.toolkit");
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        if (string == null) {
            string = tk;
        }
        if (string == null) {
            bl2 = false;
            string = Toolkit.getDefaultToolkit();
        }
        if (string.indexOf(46) == -1) {
            string = Toolkit.lookupToolkitClass(string);
        }
        boolean bl3 = bl || bl2 && !string.endsWith("StubToolkit");
        try {
            Class<?> clazz = Class.forName(string, false, Toolkit.class.getClassLoader());
            if (!Toolkit.class.isAssignableFrom(clazz)) {
                throw new IllegalArgumentException("Unrecognized FX Toolkit class: " + string);
            }
            TOOLKIT = (Toolkit)clazz.newInstance();
            if (TOOLKIT.init()) {
                if (bl3) {
                    System.err.println("JavaFX: using " + string);
                }
                return TOOLKIT;
            }
            TOOLKIT = null;
        }
        catch (Exception exception) {
            TOOLKIT = null;
            exception.printStackTrace();
        }
        throw new RuntimeException("No toolkit found");
    }

    protected static Thread getFxUserThread() {
        return fxUserThread;
    }

    protected static void setFxUserThread(Thread thread) {
        if (fxUserThread != null) {
            throw new IllegalStateException("Error: FX User Thread already initialized");
        }
        fxUserThread = thread;
    }

    public void checkFxUserThread() {
        if (!this.isFxUserThread()) {
            throw new IllegalStateException("Not on FX application thread; currentThread = " + Thread.currentThread().getName());
        }
    }

    public boolean isFxUserThread() {
        return Thread.currentThread() == fxUserThread;
    }

    protected Toolkit() {
        ToolkitAccessor.setInstance(new ToolkitAccessor(){

            @Override
            public Map<Object, Object> getContextMapImpl() {
                return Toolkit.this.getContextMap();
            }

            @Override
            public AbstractMasterTimer getMasterTimerImpl() {
                return Toolkit.this.getMasterTimer();
            }
        });
    }

    public PlatformLogger getLogger(String string) {
        return PlatformLogger.getLogger(string);
    }

    public abstract boolean init();

    public abstract Object enterNestedEventLoop(Object var1);

    public abstract void exitNestedEventLoop(Object var1, Object var2);

    public abstract TKStage createTKStage(StageStyle var1);

    public abstract TKStage createTKStage(boolean var1, StageStyle var2, boolean var3, Modality var4, TKStage var5);

    public abstract TKStage createTKPopupStage(StageStyle var1, Object var2);

    public abstract TKStage createTKEmbeddedStage(HostInterface var1);

    private void runPulse(final TKPulseListener tKPulseListener, AccessControlContext accessControlContext) {
        if (accessControlContext == null) {
            throw new IllegalStateException("Invalid AccessControlContext");
        }
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                tKPulseListener.pulse();
                return null;
            }
        }, accessControlContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void firePulse() {
        try {
            Iterator<Map.Entry<TKPulseListener, AccessControlContext>> iterator = this;
            synchronized (iterator) {
                this.stagePulseList.putAll(this.stagePulseListeners);
                this.scenePulseList.putAll(this.scenePulseListeners);
                this.postScenePulseList.putAll(this.postScenePulseListeners);
            }
            for (Map.Entry<TKPulseListener, AccessControlContext> entry : this.stagePulseList.entrySet()) {
                this.runPulse((TKPulseListener)entry.getKey(), (AccessControlContext)entry.getValue());
            }
            for (Map.Entry<TKPulseListener, AccessControlContext> entry : this.scenePulseList.entrySet()) {
                this.runPulse(entry.getKey(), entry.getValue());
            }
            for (Map.Entry<TKPulseListener, AccessControlContext> entry : this.postScenePulseList.entrySet()) {
                this.runPulse(entry.getKey(), entry.getValue());
            }
            if (this.lastTkPulseListener != null) {
                this.runPulse(this.lastTkPulseListener, this.lastTkPulseAcc);
            }
        }
        finally {
            this.stagePulseList.clear();
            this.scenePulseList.clear();
            this.postScenePulseList.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addStageTkPulseListener(TKPulseListener tKPulseListener) {
        Toolkit toolkit = this;
        synchronized (toolkit) {
            AccessControlContext accessControlContext = AccessController.getContext();
            this.stagePulseListeners.put(tKPulseListener, accessControlContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeStageTkPulseListener(TKPulseListener tKPulseListener) {
        Toolkit toolkit = this;
        synchronized (toolkit) {
            this.stagePulseListeners.remove(tKPulseListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSceneTkPulseListener(TKPulseListener tKPulseListener) {
        Toolkit toolkit = this;
        synchronized (toolkit) {
            AccessControlContext accessControlContext = AccessController.getContext();
            this.scenePulseListeners.put(tKPulseListener, accessControlContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSceneTkPulseListener(TKPulseListener tKPulseListener) {
        Toolkit toolkit = this;
        synchronized (toolkit) {
            this.scenePulseListeners.remove(tKPulseListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPostSceneTkPulseListener(TKPulseListener tKPulseListener) {
        Toolkit toolkit = this;
        synchronized (toolkit) {
            AccessControlContext accessControlContext = AccessController.getContext();
            this.postScenePulseListeners.put(tKPulseListener, accessControlContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePostSceneTkPulseListener(TKPulseListener tKPulseListener) {
        Toolkit toolkit = this;
        synchronized (toolkit) {
            this.postScenePulseListeners.remove(tKPulseListener);
        }
    }

    public void addTkListener(TKListener tKListener) {
        AccessControlContext accessControlContext = AccessController.getContext();
        this.toolkitListeners.put(tKListener, accessControlContext);
    }

    public void removeTkListener(TKListener tKListener) {
        this.toolkitListeners.remove(tKListener);
    }

    public void setLastTkPulseListener(TKPulseListener tKPulseListener) {
        this.lastTkPulseAcc = AccessController.getContext();
        this.lastTkPulseListener = tKPulseListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addShutdownHook(Runnable runnable) {
        Set<Runnable> set = this.shutdownHooks;
        synchronized (set) {
            this.shutdownHooks.add(runnable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeShutdownHook(Runnable runnable) {
        Set<Runnable> set = this.shutdownHooks;
        synchronized (set) {
            this.shutdownHooks.remove(runnable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyShutdownHooks() {
        ArrayList<Runnable> arrayList;
        Set<Runnable> set = this.shutdownHooks;
        synchronized (set) {
            arrayList = new ArrayList<Runnable>(this.shutdownHooks);
            this.shutdownHooks.clear();
        }
        for (Runnable runnable : arrayList) {
            runnable.run();
        }
    }

    public void notifyWindowListeners(final List<TKStage> list) {
        for (Map.Entry<TKListener, AccessControlContext> entry : this.toolkitListeners.entrySet()) {
            final TKListener tKListener = entry.getKey();
            AccessControlContext accessControlContext = entry.getValue();
            if (accessControlContext == null) {
                throw new IllegalStateException("Invalid AccessControlContext");
            }
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    tKListener.changedTopLevelWindows(list);
                    return null;
                }
            }, accessControlContext);
        }
    }

    @Deprecated
    public void triggerNextPulse() {
        this.getMasterTimer().notifyJobsReady();
    }

    public abstract void requestNextPulse();

    public InputStream getInputStream(String string, Class clazz) throws IOException {
        return string.startsWith("http:") || string.startsWith("https:") || string.startsWith("file:") || string.startsWith("jar:") ? new URL(string).openStream() : clazz.getResource(string).openStream();
    }

    public abstract ImageLoader loadImage(String var1, int var2, int var3, boolean var4, boolean var5);

    public abstract ImageLoader loadImage(InputStream var1, int var2, int var3, boolean var4, boolean var5);

    public abstract AsyncOperation loadImageAsync(AsyncOperationListener<? extends ImageLoader> var1, String var2, int var3, int var4, boolean var5, boolean var6);

    public abstract ImageLoader loadPlatformImage(Object var1);

    public abstract PlatformImage createPlatformImage(int var1, int var2);

    public boolean getDefaultImageSmooth() {
        return true;
    }

    public abstract void startup(Runnable var1);

    public abstract void defer(Runnable var1);

    public void exit() {
        fxUserThread = null;
    }

    public abstract Map<Object, Object> getContextMap();

    public abstract int getRefreshRate();

    public abstract void setAnimationRunnable(DelayedRunnable var1);

    public abstract PerformanceTracker getPerformanceTracker();

    public abstract PerformanceTracker createPerformanceTracker();

    public abstract void waitFor(Task var1);

    public abstract PerspectiveCameraImpl createPerspectiveCamera();

    public abstract ParallelCameraImpl createParallelCamera();

    private Object checkSingleColor(List<Stop> list) {
        Color color;
        if (list.size() == 2 && (color = list.get(0).getColor()).equals(list.get(1).getColor())) {
            return color.impl_getPlatformPaint();
        }
        return null;
    }

    private Object getPaint(LinearGradient linearGradient) {
        Object object = gradientMap.get(linearGradient);
        if (object != null) {
            return object;
        }
        object = this.checkSingleColor(linearGradient.getStops());
        if (object == null) {
            object = this.createLinearGradientPaint(linearGradient);
        }
        gradientMap.put(linearGradient, object);
        return object;
    }

    private Object getPaint(RadialGradient radialGradient) {
        Object object = gradientMap.get(radialGradient);
        if (object != null) {
            return object;
        }
        object = this.checkSingleColor(radialGradient.getStops());
        if (object == null) {
            object = this.createRadialGradientPaint(radialGradient);
        }
        gradientMap.put(radialGradient, object);
        return object;
    }

    public Object getPaint(Paint paint) {
        if (paint instanceof Color) {
            return this.createColorPaint((Color)paint);
        }
        if (paint instanceof LinearGradient) {
            return this.getPaint((LinearGradient)paint);
        }
        if (paint instanceof RadialGradient) {
            return this.getPaint((RadialGradient)paint);
        }
        if (paint instanceof ImagePattern) {
            return this.createImagePatternPaint((ImagePattern)paint);
        }
        return null;
    }

    protected static final double clampStopOffset(double d) {
        return d > 1.0 ? 1.0 : (d < 0.0 ? 0.0 : d);
    }

    protected abstract Object createColorPaint(Color var1);

    protected abstract Object createLinearGradientPaint(LinearGradient var1);

    protected abstract Object createRadialGradientPaint(RadialGradient var1);

    protected abstract Object createImagePatternPaint(ImagePattern var1);

    public abstract void accumulateStrokeBounds(Shape var1, float[] var2, PGShape.StrokeType var3, double var4, PGShape.StrokeLineCap var6, PGShape.StrokeLineJoin var7, float var8, BaseTransform var9);

    public abstract boolean strokeContains(Shape var1, double var2, double var4, PGShape.StrokeType var6, double var7, PGShape.StrokeLineCap var9, PGShape.StrokeLineJoin var10, float var11);

    public abstract Shape createStrokedShape(Shape var1, PGShape.StrokeType var2, double var3, PGShape.StrokeLineCap var5, PGShape.StrokeLineJoin var6, float var7, float[] var8, float var9);

    public abstract int getKeyCodeForChar(String var1);

    public abstract MouseEvent convertMouseEventToFX(Object var1);

    public abstract KeyEvent convertKeyEventToFX(Object var1);

    public abstract DragEvent convertDragRecognizedEventToFX(Object var1, Dragboard var2);

    public abstract DragEvent convertDragSourceEventToFX(Object var1, Dragboard var2);

    public abstract DragEvent convertDropTargetEventToFX(Object var1, Dragboard var2);

    public abstract InputMethodEvent convertInputMethodEventToFX(Object var1);

    public abstract Dimension2D getBestCursorSize(int var1, int var2);

    public abstract int getMaximumCursorColors();

    public abstract PathElement[] convertShapeToFXPath(Object var1);

    public abstract HitInfo convertHitInfoToFX(Object var1);

    public abstract Filterable toFilterable(Image var1);

    public abstract FilterContext getFilterContext(Object var1);

    public abstract boolean isForwardTraversalKey(KeyEvent var1);

    public abstract boolean isBackwardTraversalKey(KeyEvent var1);

    public abstract AbstractMasterTimer getMasterTimer();

    public abstract FontLoader getFontLoader();

    public abstract PGArc createPGArc();

    public abstract PGCircle createPGCircle();

    public abstract PGCubicCurve createPGCubicCurve();

    public abstract PGEllipse createPGEllipse();

    public abstract PGLine createPGLine();

    public abstract PGPath createPGPath();

    public abstract PGSVGPath createPGSVGPath();

    public abstract PGPolygon createPGPolygon();

    public abstract PGPolyline createPGPolyline();

    public abstract PGQuadCurve createPGQuadCurve();

    public abstract PGRectangle createPGRectangle();

    public abstract PGImageView createPGImageView();

    public abstract PGMediaView createPGMediaView();

    public abstract PGGroup createPGGroup();

    public abstract PGText createPGText();

    public abstract PGRegion createPGRegion();

    public abstract PGCanvas createPGCanvas();

    public abstract Object createSVGPathObject(SVGPath var1);

    public abstract Path2D createSVGPath2D(SVGPath var1);

    public abstract boolean imageContains(Object var1, float var2, float var3);

    public abstract TKClipboard getSystemClipboard();

    public TKClipboard createLocalClipboard() {
        return new LocalClipboard();
    }

    public abstract TKSystemMenu getSystemMenu();

    public abstract TKClipboard getNamedClipboard(String var1);

    public abstract Dragboard createDragboard();

    public boolean isSupported(ConditionalFeature conditionalFeature) {
        return false;
    }

    public abstract ScreenConfigurationAccessor setScreenConfigurationListener(TKScreenConfigurationListener var1);

    public abstract Object getPrimaryScreen();

    public abstract List<?> getScreens();

    public abstract void registerDragGestureListener(TKScene var1, Set<TransferMode> var2, TKDragGestureListener var3);

    public abstract void startDrag(Object var1, Set<TransferMode> var2, TKDragSourceListener var3, Dragboard var4);

    public void stopDrag(Dragboard dragboard) {
    }

    public abstract void enableDrop(TKScene var1, TKDropTargetListener var2);

    public Color4f toColor4f(Color color) {
        return new Color4f((float)color.getRed(), (float)color.getGreen(), (float)color.getBlue(), (float)color.getOpacity());
    }

    public AbstractShadow.ShadowMode toShadowMode(BlurType blurType) {
        switch (blurType) {
            case ONE_PASS_BOX: {
                return AbstractShadow.ShadowMode.ONE_PASS_BOX;
            }
            case TWO_PASS_BOX: {
                return AbstractShadow.ShadowMode.TWO_PASS_BOX;
            }
            case THREE_PASS_BOX: {
                return AbstractShadow.ShadowMode.THREE_PASS_BOX;
            }
        }
        return AbstractShadow.ShadowMode.GAUSSIAN;
    }

    public abstract void installInputMethodRequests(TKScene var1, InputMethodRequests var2);

    public abstract Object renderToImage(ImageRenderingContext var1);

    public abstract boolean isExternalFormatSupported(Class var1);

    public abstract Object toExternalImage(Object var1, Object var2);

    public abstract KeyCode getPlatformShortcutKey();

    public abstract List<File> showFileChooser(TKStage var1, String var2, File var3, String var4, FileChooserType var5, List<FileChooser.ExtensionFilter> var6);

    public abstract File showDirectoryChooser(TKStage var1, String var2, File var3);

    public abstract long getMultiClickTime();

    public abstract int getMultiClickMaxX();

    public abstract int getMultiClickMaxY();

    public void pauseScenes() {
        this.pauseScenesLatch = new CountDownLatch(1);
        Iterator<Window> iterator = Window.impl_getWindows();
        while (iterator.hasNext()) {
            Window window = iterator.next();
            Scene scene = window.getScene();
            if (scene == null) continue;
            this.removeSceneTkPulseListener(scene.impl_getScenePulseListener());
        }
        this.getMasterTimer().pause();
        if (sceneAccessor != null) {
            sceneAccessor.setPaused(true);
        }
    }

    public void resumeScenes() {
        if (sceneAccessor != null) {
            sceneAccessor.setPaused(false);
        }
        this.getMasterTimer().resume();
        Iterator<Window> iterator = Window.impl_getWindows();
        while (iterator.hasNext()) {
            Window window = iterator.next();
            Scene scene = window.getScene();
            if (scene == null) continue;
            this.addSceneTkPulseListener(scene.impl_getScenePulseListener());
        }
        this.pauseScenesLatch.countDown();
        this.pauseScenesLatch = null;
    }

    public void pauseCurrentThread() {
        CountDownLatch countDownLatch = this.pauseScenesLatch;
        if (countDownLatch == null) {
            return;
        }
        try {
            countDownLatch.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public Set<HighlightRegion> getHighlightedRegions() {
        if (this.highlightRegions == null) {
            this.highlightRegions = new HashSet<HighlightRegion>();
        }
        return this.highlightRegions;
    }

    public static void setSceneAccessor(SceneAccessor sceneAccessor) {
        Toolkit.sceneAccessor = sceneAccessor;
    }

    public static void setWritableImageAccessor(WritableImageAccessor writableImageAccessor) {
        Toolkit.writableImageAccessor = writableImageAccessor;
    }

    public static WritableImageAccessor getWritableImageAccessor() {
        return writableImageAccessor;
    }

    static {
        fxUserThread = null;
        gradientMap = new WeakHashMap();
        sceneAccessor = null;
        writableImageAccessor = null;
    }

    public static class ImageRenderingContext {
        public PGNode root;
        public int x;
        public int y;
        public int width;
        public int height;
        public BaseTransform transform;
        public boolean depthBuffer;
        public Object platformPaint;
        public CameraImpl camera;
        public Object platformImage;
    }

    public static interface SceneAccessor {
        public void setPaused(boolean var1);
    }

    public static interface Task {
        public boolean isFinished();
    }

    public static interface WritableImageAccessor {
        public void loadTkImage(WritableImage var1, Object var2);

        public Object getTkImageLoader(WritableImage var1);
    }
}

