/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.tk.quantum;

import com.sun.glass.ui.Application;
import com.sun.glass.ui.Pixels;
import com.sun.glass.ui.View;
import com.sun.javafx.tk.quantum.PrismPen;
import com.sun.javafx.tk.quantum.ViewPainter;
import com.sun.javafx.tk.quantum.ViewScene;
import com.sun.prism.Graphics;
import com.sun.prism.RTTexture;
import com.sun.prism.impl.Disposer;
import com.sun.prism.impl.PrismSettings;
import com.sun.prism.impl.QueuedPixelSource;
import java.nio.IntBuffer;

public class UploadingPainter
extends ViewPainter
implements Runnable {
    private Application app = Application.GetApplication();
    private RTTexture rttexture;
    private final QueuedPixelSource pixelSource = new QueuedPixelSource(true);

    protected UploadingPainter(ViewScene viewScene, PrismPen prismPen) {
        super(viewScene, prismPen);
    }

    void disposeRTTexture() {
        if (this.rttexture != null) {
            this.rttexture.dispose();
            this.rttexture = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            Graphics graphics;
            boolean bl;
            if (PrismSettings.threadCheck) {
                assert (!renderLock.isHeldByCurrentThread());
                renderLock.lock();
            }
            if (!this.validateStageGraphics()) {
                if (verbose) {
                    System.err.println("UploadingPainter: validateStageGraphics failed");
                }
                return;
            }
            if (this.view != null) {
                this.pen.begin();
            }
            boolean bl2 = bl = this.rttexture == null || this.viewWidth != this.penWidth || this.viewHeight != this.penHeight;
            if (bl) {
                this.context = this.factory.createRenderingContext(null);
            }
            this.context.begin();
            if (bl) {
                this.disposeRTTexture();
                this.rttexture = this.factory.createRTTexture(this.viewWidth, this.viewHeight);
                if (this.rttexture == null) {
                    this.context.end();
                    return;
                }
                this.penWidth = this.viewWidth;
                this.penHeight = this.viewHeight;
            }
            if ((graphics = this.rttexture.createGraphics()) == null) {
                this.disposeRTTexture();
                this.scene.entireSceneNeedsRepaint();
                return;
            }
            this.paintImpl(graphics);
            if (!this.liveRepaint.get()) {
                collector.releaseScene(this.scene);
            }
            int n = this.view.getWidth();
            int n2 = this.view.getHeight();
            Pixels pixels = this.pixelSource.getUnusedPixels(n, n2);
            IntBuffer intBuffer = (IntBuffer)pixels.getPixels();
            int[] nArray = this.rttexture.getPixels();
            if (nArray != null) {
                intBuffer.put(nArray, 0, this.viewWidth * this.viewHeight);
            } else if (!this.rttexture.readPixels(intBuffer)) {
                this.scene.entireSceneNeedsRepaint();
                this.disposeRTTexture();
                pixels = null;
            }
            if (pixels != null) {
                this.pixelSource.enqueuePixels(pixels);
                final View view = this.view;
                Application.postOnEventQueue(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        Pixels pixels;
                        if (!view.isClosed() && (pixels = UploadingPainter.this.pixelSource.getLatestPixels()) != null) {
                            try {
                                view.uploadPixels(pixels);
                            }
                            finally {
                                UploadingPainter.this.pixelSource.doneWithPixels(pixels);
                            }
                        }
                    }
                });
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace(System.err);
        }
        finally {
            if (this.valid && this.context != null) {
                Disposer.cleanUp();
                this.context.end();
            }
            if (this.valid && this.view != null && !this.view.isClosed()) {
                this.pen.end();
            }
            this.pen.getPainting().set(false);
            if (PrismSettings.threadCheck) {
                renderLock.unlock();
            }
        }
    }
}

