/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jfxmedia.locator;

import com.sun.media.jfxmedia.locator.HLSConnectionHolder;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.net.HttpURLConnection;
import java.net.JarURLConnection;
import java.net.URI;
import java.net.URLConnection;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.util.Map;
import sun.nio.ch.DirectBuffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ConnectionHolder {
    private static int DEFAULT_BUFFER_SIZE = 4096;
    ReadableByteChannel channel;
    ByteBuffer buffer = ByteBuffer.allocateDirect(DEFAULT_BUFFER_SIZE);

    static ConnectionHolder createMemoryConnectionHolder(ByteBuffer buffer) {
        return new MemoryConnectionHolder(buffer);
    }

    static ConnectionHolder createURIConnectionHolder(URI uri, Map<String, Object> connectionProperties) throws IOException {
        return new URIConnectionHolder(uri, connectionProperties);
    }

    static ConnectionHolder createFileConnectionHolder(URI uri) throws IOException {
        return new FileConnectionHolder(uri);
    }

    static ConnectionHolder createHLSConnectionHolder(URI uri) throws IOException {
        return new HLSConnectionHolder(uri);
    }

    public int readNextBlock() throws IOException {
        this.buffer.rewind();
        if (this.buffer.limit() < this.buffer.capacity()) {
            this.buffer.limit(this.buffer.capacity());
        }
        if (null == this.channel) {
            throw new ClosedChannelException();
        }
        return this.channel.read(this.buffer);
    }

    public ByteBuffer getBuffer() {
        return this.buffer;
    }

    abstract int readBlock(long var1, int var3) throws IOException;

    abstract boolean needBuffer();

    abstract boolean isSeekable();

    abstract boolean isRandomAccess();

    public abstract long seek(long var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeConnection() {
        try {
            if (this.channel != null) {
                this.channel.close();
            }
        }
        catch (IOException iOException) {
        }
        finally {
            this.channel = null;
        }
    }

    int property(int prop, int value) {
        return 0;
    }

    int getStreamSize() {
        return -1;
    }

    private static class FileConnectionHolder
    extends ConnectionHolder {
        FileConnectionHolder(URI uri) throws IOException {
            this.channel = this.openFile(uri);
        }

        boolean needBuffer() {
            return false;
        }

        boolean isRandomAccess() {
            return true;
        }

        boolean isSeekable() {
            return true;
        }

        public long seek(long position) {
            try {
                ((FileChannel)this.channel).position(position);
                return position;
            }
            catch (IOException ioex) {
                return -1L;
            }
        }

        int readBlock(long position, int size) throws IOException {
            if (null == this.channel) {
                throw new ClosedChannelException();
            }
            if (this.buffer.capacity() < size) {
                this.buffer = ByteBuffer.allocateDirect(size);
            }
            this.buffer.rewind().limit(size);
            return ((FileChannel)this.channel).read(this.buffer, position);
        }

        private ReadableByteChannel openFile(URI uri) throws IOException {
            RandomAccessFile file = new RandomAccessFile(new File(uri), "r");
            return file.getChannel();
        }

        public void closeConnection() {
            super.closeConnection();
            if (this.buffer instanceof DirectBuffer) {
                ((DirectBuffer)((Object)this.buffer)).cleaner().clean();
            }
        }
    }

    private static class MemoryConnectionHolder
    extends ConnectionHolder {
        private final ByteBuffer backingBuffer;

        public MemoryConnectionHolder(ByteBuffer buf) {
            if (null == buf) {
                throw new IllegalArgumentException("Can't connect to null buffer...");
            }
            if (buf.isDirect()) {
                this.backingBuffer = buf.duplicate();
            } else {
                this.backingBuffer = ByteBuffer.allocateDirect(buf.capacity());
                this.backingBuffer.put(buf);
            }
            this.backingBuffer.rewind();
            this.channel = new ReadableByteChannel(){

                public int read(ByteBuffer bb) throws IOException {
                    int actual;
                    if (MemoryConnectionHolder.this.backingBuffer.remaining() <= 0) {
                        return -1;
                    }
                    if (bb.equals(MemoryConnectionHolder.this.buffer)) {
                        actual = Math.min(DEFAULT_BUFFER_SIZE, MemoryConnectionHolder.this.backingBuffer.remaining());
                        if (actual > 0) {
                            MemoryConnectionHolder.this.buffer = MemoryConnectionHolder.this.backingBuffer.slice();
                            MemoryConnectionHolder.this.buffer.limit(actual);
                        }
                    } else {
                        actual = Math.min(bb.remaining(), MemoryConnectionHolder.this.backingBuffer.remaining());
                        if (actual > 0) {
                            MemoryConnectionHolder.this.backingBuffer.limit(MemoryConnectionHolder.this.backingBuffer.position() + actual);
                            bb.put(MemoryConnectionHolder.this.backingBuffer);
                            MemoryConnectionHolder.this.backingBuffer.limit(MemoryConnectionHolder.this.backingBuffer.capacity());
                        }
                    }
                    return actual;
                }

                public boolean isOpen() {
                    return true;
                }

                public void close() throws IOException {
                }
            };
        }

        int readBlock(long position, int size) throws IOException {
            if (null == this.channel) {
                throw new ClosedChannelException();
            }
            if ((int)position > this.backingBuffer.capacity()) {
                return -1;
            }
            this.backingBuffer.position((int)position);
            this.buffer = this.backingBuffer.slice();
            int actual = Math.min(this.backingBuffer.remaining(), size);
            this.buffer.limit(actual);
            this.backingBuffer.position(this.backingBuffer.position() + actual);
            return actual;
        }

        boolean needBuffer() {
            return false;
        }

        boolean isSeekable() {
            return true;
        }

        boolean isRandomAccess() {
            return true;
        }

        public long seek(long position) {
            if ((int)position < this.backingBuffer.capacity()) {
                this.backingBuffer.limit(this.backingBuffer.capacity());
                this.backingBuffer.position((int)position);
                return position;
            }
            return -1L;
        }

        public void closeConnection() {
            this.channel = null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class URIConnectionHolder
    extends ConnectionHolder {
        private URI uri;
        private URLConnection urlConnection;

        URIConnectionHolder(URI uri, Map<String, Object> connectionProperties) throws IOException {
            this.uri = uri;
            this.urlConnection = uri.toURL().openConnection();
            if (connectionProperties != null) {
                for (String key : connectionProperties.keySet()) {
                    Object value = connectionProperties.get(key);
                    if (!(value instanceof String)) continue;
                    this.urlConnection.setRequestProperty(key, (String)value);
                }
            }
            this.channel = this.openChannel(null);
        }

        @Override
        boolean needBuffer() {
            String scheme = this.uri.getScheme().toLowerCase();
            return "http".equals(scheme);
        }

        @Override
        boolean isSeekable() {
            return this.urlConnection instanceof HttpURLConnection || this.urlConnection instanceof JarURLConnection;
        }

        @Override
        boolean isRandomAccess() {
            return false;
        }

        @Override
        int readBlock(long position, int size) throws IOException {
            throw new IOException();
        }

        @Override
        public long seek(long position) {
            if (this.urlConnection instanceof HttpURLConnection) {
                this.closeConnection();
                try {
                    InputStream inputStream = null;
                    this.urlConnection = this.uri.toURL().openConnection();
                    HttpURLConnection httpConnection = (HttpURLConnection)this.urlConnection;
                    httpConnection.setRequestMethod("GET");
                    httpConnection.setUseCaches(false);
                    httpConnection.setRequestProperty("Range", "bytes=" + position + "-");
                    if (httpConnection.getResponseCode() != 206) {
                        long skip;
                        if (httpConnection.getResponseCode() != 200) {
                            httpConnection.disconnect();
                            this.urlConnection = this.uri.toURL().openConnection();
                        }
                        long skip_left = position;
                        inputStream = this.urlConnection.getInputStream();
                        while ((skip_left -= (skip = inputStream.skip(skip_left))) > 0L) {
                        }
                    }
                    this.channel = this.openChannel(inputStream);
                    return position;
                }
                catch (IOException ioex) {
                    return -1L;
                }
            }
            if (this.urlConnection instanceof JarURLConnection) {
                try {
                    long skip;
                    this.closeConnection();
                    this.urlConnection = this.uri.toURL().openConnection();
                    long skip_left = position;
                    InputStream inputStream = this.urlConnection.getInputStream();
                    while ((skip_left -= (skip = inputStream.skip(skip_left))) > 0L) {
                    }
                    this.channel = this.openChannel(inputStream);
                    return position;
                }
                catch (IOException ioex) {
                    return -1L;
                }
            }
            return -1L;
        }

        @Override
        public void closeConnection() {
            super.closeConnection();
            if (this.urlConnection instanceof HttpURLConnection) {
                ((HttpURLConnection)this.urlConnection).disconnect();
            }
            this.urlConnection = null;
        }

        private ReadableByteChannel openChannel(InputStream inputStream) throws IOException {
            return inputStream == null ? Channels.newChannel(this.urlConnection.getInputStream()) : Channels.newChannel(inputStream);
        }
    }
}

