/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.components.ui.tab;

import com.jrockit.mc.common.persistence.LocalizedString;
import com.jrockit.mc.common.persistence.Setting;
import com.jrockit.mc.components.ui.tab.ImageConverter;
import com.jrockit.mc.components.ui.util.ImageDescriptor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public abstract class BaseDescriptor {
    public static final String NAME = "name";
    public static final String DESCRIPTION = "description";
    public static final String IDENTIFIER = "identifier";
    public static final String ICON_NAME = "icon";
    public static final String PLACEMENT_PATH = "placementPath";
    public static final String GUID = "guid";
    private final Setting m_setting;

    protected BaseDescriptor(String defaultName) {
        this.m_setting = new Setting(defaultName);
        this.setIcon(this.createDefault(Display.getCurrent()));
    }

    public abstract Image createDefaultLargeIcon(Device var1);

    public abstract Image createDefaultIcon(Device var1);

    protected final Setting getSetting() {
        return this.m_setting;
    }

    protected final ImageDescriptor createDefault(Display display) {
        Image image = this.createDefaultIcon((Device)display);
        ImageDescriptor s = ImageConverter.createImageDescriptor(image);
        image.dispose();
        return s;
    }

    public final void setName(String name) {
        ((LocalizedString)this.m_setting.getChildObject(NAME, LocalizedString.class)).setText(name);
    }

    public final String getName() {
        return ((LocalizedString)this.m_setting.getChildObject(NAME, LocalizedString.class)).getText();
    }

    public final void setDescription(String name) {
        ((LocalizedString)this.m_setting.getChildObject(DESCRIPTION, LocalizedString.class)).setText(name);
    }

    public final String getDescription() {
        return ((LocalizedString)this.m_setting.getChildObject(DESCRIPTION, LocalizedString.class)).getText();
    }

    public final void setIdentifier(String name) {
        this.m_setting.setChildObject(IDENTIFIER, (Object)name);
    }

    public final String getIdentifier() {
        return (String)this.m_setting.getChildObject(IDENTIFIER, String.class);
    }

    public final void setGUID(String guid) {
        this.m_setting.setChildObject(GUID, (Object)guid);
    }

    public final String getGUID() {
        return (String)this.m_setting.getChildObject(GUID, String.class);
    }

    public final String getPlacementPath() {
        return (String)this.m_setting.getChildObject(PLACEMENT_PATH, String.class);
    }

    public final void setPlacementPath(String placementPath) {
        this.m_setting.setChildObject(PLACEMENT_PATH, (Object)placementPath);
    }

    public final void setIcon(ImageDescriptor imageDescriptor) {
        this.m_setting.setChildObject(ICON_NAME, (Object)imageDescriptor);
    }

    public final ImageDescriptor getIcon() {
        return (ImageDescriptor)this.m_setting.getChildObject(ICON_NAME, ImageDescriptor.class);
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + '[' + this.getName() + ", " + this.getDescription() + ']';
    }
}

