/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.common.util;

import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.ParseException;

public class Toolkit {
    protected static long multiply(Number value, long l) {
        if (value instanceof Long) {
            return value.longValue() * l;
        }
        return Math.round(value.doubleValue() * (double)l);
    }

    protected static boolean isCompatibleUnit(Holder holder, String[] units) {
        String[] stringArray = units;
        int n = units.length;
        int n2 = 0;
        while (n2 < n) {
            String unit = stringArray[n2];
            if (unit.equalsIgnoreCase(holder.unit)) {
                return true;
            }
            if (Toolkit.checkSingularis(unit, holder.unit)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    protected static boolean checkSingularis(String unitToTest, String unit) {
        return unitToTest.endsWith("s") && unitToTest.length() >= 3 && unit.equalsIgnoreCase(unitToTest.substring(0, unitToTest.length() - 1));
    }

    protected static class Holder {
        static final char DECIMAL_SEPARATOR = new DecimalFormatSymbols().getDecimalSeparator();
        final Number value;
        final String unit;

        public Holder(String size) throws ParseException {
            size = size.trim();
            int index = 0;
            StringBuilder valBuilder = new StringBuilder();
            while (index < size.length() && (Character.isDigit(size.charAt(index)) || this.isDecimalComma(size.charAt(index)))) {
                valBuilder.append(size.charAt(index++));
            }
            this.value = NumberFormat.getNumberInstance().parse(valBuilder.toString());
            this.unit = size.substring(index).trim();
        }

        private boolean isDecimalComma(char c) {
            return c == DECIMAL_SEPARATOR;
        }
    }
}

