/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.pljava.internal;

import java.io.File;
import java.io.FilePermission;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.Permission;
import java.sql.SQLException;
import java.util.PropertyPermission;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.postgresql.pljava.internal.Session;
import org.postgresql.pljava.management.Commands;

public class Backend {
    public static final Object THREADLOCK = new Object();
    private static Session s_session;
    private static boolean s_inSetTrusted;
    private static final SecurityManager s_untrustedSecurityManager;
    private static final SecurityManager s_trustedSecurityManager;

    public static synchronized Session getSession() {
        if (s_session == null) {
            s_session = new Session();
        }
        return s_session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getConfigOption(String key) {
        Object object = THREADLOCK;
        synchronized (object) {
            return Backend._getConfigOption(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getStatementCacheSize() {
        Object object = THREADLOCK;
        synchronized (object) {
            return Backend._getStatementCacheSize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void log(int logLevel, String str) {
        Object object = THREADLOCK;
        synchronized (object) {
            Backend._log(logLevel, str);
        }
    }

    public static void addClassImages(int jarId, String urlString) throws SQLException {
        boolean wasTrusted;
        InputStream urlStream = null;
        boolean bl = wasTrusted = System.getSecurityManager() == s_trustedSecurityManager;
        if (wasTrusted) {
            Backend.setTrusted(false);
        }
        try {
            URL url = new URL(urlString);
            urlStream = url.openStream();
            Commands.addClassImages(jarId, urlStream);
        }
        catch (IOException e) {
            throw new SQLException("I/O exception reading jar file: " + e.getMessage());
        }
        finally {
            if (urlStream != null) {
                try {
                    urlStream.close();
                }
                catch (IOException e) {}
            }
            if (wasTrusted) {
                Backend.setTrusted(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearFunctionCache() {
        Object object = THREADLOCK;
        synchronized (object) {
            Backend._clearFunctionCache();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setTrusted(boolean trusted) {
        s_inSetTrusted = true;
        try {
            Logger log = Logger.getAnonymousLogger();
            if (log.isLoggable(Level.FINE)) {
                log.fine("Using SecurityManager for " + (trusted ? "trusted" : "untrusted") + " language");
            }
            System.setSecurityManager(trusted ? s_trustedSecurityManager : s_untrustedSecurityManager);
        }
        finally {
            s_inSetTrusted = false;
        }
    }

    public static native boolean isCallingJava();

    public static native boolean isReleaseLingeringSavepoints();

    private static native String _getConfigOption(String var0);

    private static native int _getStatementCacheSize();

    private static native void _log(int var0, String var1);

    private static native void _clearFunctionCache();

    static {
        s_inSetTrusted = false;
        s_untrustedSecurityManager = new PLJavaSecurityManager();
        s_trustedSecurityManager = new PLJavaSecurityManager(){

            void assertPermission(Permission perm) {
                if (perm instanceof FilePermission) {
                    String actions = perm.getActions();
                    if ("read".equals(actions)) {
                        File javaHome = new File(System.getProperty("java.home"));
                        File accessedFile = new File(perm.getName());
                        for (File fileDir = accessedFile.getParentFile(); fileDir != null; fileDir = fileDir.getParentFile()) {
                            if (!fileDir.equals(javaHome)) continue;
                            return;
                        }
                    }
                    throw new SecurityException(perm.getActions() + " on " + perm.getName());
                }
                super.assertPermission(perm);
            }
        };
    }

    private static class PLJavaSecurityManager
    extends SecurityManager {
        private boolean m_recursion = false;

        private PLJavaSecurityManager() {
        }

        public void checkPermission(Permission perm) {
            this.nonRecursiveCheck(perm);
        }

        public void checkPermission(Permission perm, Object context) {
            this.nonRecursiveCheck(perm);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private synchronized void nonRecursiveCheck(Permission perm) {
            if (this.m_recursion) {
                return;
            }
            this.m_recursion = true;
            try {
                this.assertPermission(perm);
            }
            finally {
                this.m_recursion = false;
            }
        }

        void assertPermission(Permission perm) {
            String propName;
            if (perm instanceof RuntimePermission) {
                String name = perm.getName();
                if ("*".equals(name) || "exitVM".equals(name)) {
                    throw new SecurityException();
                }
                if ("setSecurityManager".equals(name) && !s_inSetTrusted) {
                    throw new SecurityException();
                }
            } else if (perm instanceof PropertyPermission && perm.getActions().indexOf("write") >= 0 && (propName = perm.getName()).equals("java.home")) {
                throw new SecurityException();
            }
        }
    }
}

